/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming;

import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.deploy.SparkHadoopUtil$;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Dataset$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.datasources.BucketSpec;
import org.apache.spark.sql.execution.datasources.CaseInsensitiveMap;
import org.apache.spark.sql.execution.datasources.DataSource;
import org.apache.spark.sql.execution.datasources.DataSource$;
import org.apache.spark.sql.execution.datasources.ListingFileCatalog;
import org.apache.spark.sql.execution.datasources.ListingFileCatalog$;
import org.apache.spark.sql.execution.datasources.LogicalRelation;
import org.apache.spark.sql.execution.datasources.LogicalRelation$;
import org.apache.spark.sql.execution.streaming.FileStreamSource$;
import org.apache.spark.sql.execution.streaming.HDFSMetadataLog;
import org.apache.spark.sql.execution.streaming.LongOffset;
import org.apache.spark.sql.execution.streaming.Offset;
import org.apache.spark.sql.execution.streaming.Source;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.collection.OpenHashSet;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.collection.mutable.WrappedArray;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015g\u0001B\u0001\u0003\u0001=\u0011\u0001CR5mKN#(/Z1n'>,(oY3\u000b\u0005\r!\u0011!C:ue\u0016\fW.\u001b8h\u0015\t)a!A\u0005fq\u0016\u001cW\u000f^5p]*\u0011q\u0001C\u0001\u0004gFd'BA\u0005\u000b\u0003\u0015\u0019\b/\u0019:l\u0015\tYA\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001b\u0005\u0019qN]4\u0004\u0001M!\u0001\u0001\u0005\f\u001b!\t\tB#D\u0001\u0013\u0015\u0005\u0019\u0012!B:dC2\f\u0017BA\u000b\u0013\u0005\u0019\te.\u001f*fMB\u0011q\u0003G\u0007\u0002\u0005%\u0011\u0011D\u0001\u0002\u0007'>,(oY3\u0011\u0005mqR\"\u0001\u000f\u000b\u0005uA\u0011\u0001C5oi\u0016\u0014h.\u00197\n\u0005}a\"a\u0002'pO\u001eLgn\u001a\u0005\tC\u0001\u0011\t\u0011)A\u0005E\u0005a1\u000f]1sWN+7o]5p]B\u00111\u0005J\u0007\u0002\r%\u0011QE\u0002\u0002\r'B\f'o[*fgNLwN\u001c\u0005\tO\u0001\u0011\t\u0011)A\u0005Q\u0005!\u0001/\u0019;i!\tICF\u0004\u0002\u0012U%\u00111FE\u0001\u0007!J,G-\u001a4\n\u00055r#AB*ue&twM\u0003\u0002,%!A\u0001\u0007\u0001B\u0001B\u0003%\u0001&A\ngS2,gi\u001c:nCR\u001cE.Y:t\u001d\u0006lW\r\u0003\u00053\u0001\t\u0015\r\u0011\"\u00114\u0003\u0019\u00198\r[3nCV\tA\u0007\u0005\u00026q5\taG\u0003\u00028\r\u0005)A/\u001f9fg&\u0011\u0011H\u000e\u0002\u000b'R\u0014Xo\u0019;UsB,\u0007\u0002C\u001e\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001b\u0002\u000fM\u001c\u0007.Z7bA!AQ\b\u0001B\u0001B\u0003%\u0001&\u0001\u0007nKR\fG-\u0019;b!\u0006$\b\u000e\u0003\u0005@\u0001\t\u0005\t\u0015!\u0003A\u0003\u001dy\u0007\u000f^5p]N\u0004B!K!)Q%\u0011!I\f\u0002\u0004\u001b\u0006\u0004\b\"\u0002#\u0001\t\u0003)\u0015A\u0002\u001fj]&$h\bF\u0004G\u000f\"K%j\u0013'\u0011\u0005]\u0001\u0001\"B\u0011D\u0001\u0004\u0011\u0003\"B\u0014D\u0001\u0004A\u0003\"\u0002\u0019D\u0001\u0004A\u0003\"\u0002\u001aD\u0001\u0004!\u0004\"B\u001fD\u0001\u0004A\u0003\"B D\u0001\u0004\u0001\u0005b\u0002(\u0001\u0005\u0004%IaT\u0001\u0003MN,\u0012\u0001\u0015\t\u0003#Vk\u0011A\u0015\u0006\u0003\u001dNS!\u0001\u0016\u0006\u0002\r!\fGm\\8q\u0013\t1&K\u0001\u0006GS2,7+_:uK6Da\u0001\u0017\u0001!\u0002\u0013\u0001\u0016a\u00014tA!9!\f\u0001b\u0001\n\u0013Y\u0016!E9vC2Lg-[3e\u0005\u0006\u001cX\rU1uQV\tA\f\u0005\u0002R;&\u0011aL\u0015\u0002\u0005!\u0006$\b\u000e\u0003\u0004a\u0001\u0001\u0006I\u0001X\u0001\u0013cV\fG.\u001b4jK\u0012\u0014\u0015m]3QCRD\u0007\u0005C\u0004c\u0001\t\u0007I\u0011B2\u0002\u00175,G/\u00193bi\u0006dunZ\u000b\u0002IB\u0019q#Z4\n\u0005\u0019\u0014!a\u0004%E\rNkU\r^1eCR\fGj\\4\u0011\u0007!\u0004\bF\u0004\u0002j]:\u0011!.\\\u0007\u0002W*\u0011AND\u0001\u0007yI|w\u000e\u001e \n\u0003MI!a\u001c\n\u0002\u000fA\f7m[1hK&\u0011\u0011O\u001d\u0002\u0004'\u0016\f(BA8\u0013\u0011\u0019!\b\u0001)A\u0005I\u0006aQ.\u001a;bI\u0006$\u0018\rT8hA!9a\u000f\u0001a\u0001\n\u00139\u0018AC7bq\n\u000bGo\u00195JIV\t\u0001\u0010\u0005\u0002\u0012s&\u0011!P\u0005\u0002\u0005\u0019>tw\rC\u0004}\u0001\u0001\u0007I\u0011B?\u0002\u001d5\f\u0007PQ1uG\"LEm\u0018\u0013fcR\u0019a0a\u0001\u0011\u0005Ey\u0018bAA\u0001%\t!QK\\5u\u0011!\t)a_A\u0001\u0002\u0004A\u0018a\u0001=%c!9\u0011\u0011\u0002\u0001!B\u0013A\u0018aC7bq\n\u000bGo\u00195JI\u0002B\u0011\"!\u0004\u0001\u0005\u0004%I!a\u0004\u0002!5\f\u0007PR5mKN\u0004VM\u001d\"bi\u000eDWCAA\t!\u0015\t\u00121CA\f\u0013\r\t)B\u0005\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0007E\tI\"C\u0002\u0002\u001cI\u00111!\u00138u\u0011!\ty\u0002\u0001Q\u0001\n\u0005E\u0011!E7bq\u001aKG.Z:QKJ\u0014\u0015\r^2iA!I\u00111\u0005\u0001C\u0002\u0013%\u0011QE\u0001\ng\u0016,gNR5mKN,\"!a\n\u0011\u000b\u0005%\u00121\u0007\u0015\u000e\u0005\u0005-\"\u0002BA\u0017\u0003_\t!bY8mY\u0016\u001cG/[8o\u0015\r\t\t\u0004C\u0001\u0005kRLG.\u0003\u0003\u00026\u0005-\"aC(qK:D\u0015m\u001d5TKRD\u0001\"!\u000f\u0001A\u0003%\u0011qE\u0001\u000bg\u0016,gNR5mKN\u0004\u0003bBA\u001f\u0001\u0011%\u0011qH\u0001\u000fM\u0016$8\r['bq>3gm]3u)\t\t\t\u0005E\u0002\u0018\u0003\u0007J1!!\u0012\u0003\u0005)auN\\4PM\u001a\u001cX\r\u001e\u0005\b\u0003\u0013\u0002A\u0011AA&\u0003I9\u0018\u000e\u001e5CCR\u001c\u0007.\u001b8h\u0019>\u001c7.\u001a3\u0016\t\u00055\u00131\u000b\u000b\u0005\u0003\u001f\n)\u0007\u0005\u0003\u0002R\u0005MC\u0002\u0001\u0003\t\u0003+\n9E1\u0001\u0002X\t\tA+\u0005\u0003\u0002Z\u0005}\u0003cA\t\u0002\\%\u0019\u0011Q\f\n\u0003\u000f9{G\u000f[5oOB\u0019\u0011#!\u0019\n\u0007\u0005\r$CA\u0002B]fD\u0011\"a\u001a\u0002H\u0011\u0005\r!!\u001b\u0002\t\u0019,hn\u0019\t\u0006#\u0005-\u0014qJ\u0005\u0004\u0003[\u0012\"\u0001\u0003\u001fcs:\fW.\u001a \t\u000f\u0005E\u0004\u0001\"\u0001\u0002t\u0005i1-\u001e:sK:$xJ\u001a4tKR,\"!!\u0011\t\u000f\u0005]\u0004\u0001\"\u0011\u0002z\u0005Aq-\u001a;CCR\u001c\u0007\u000e\u0006\u0004\u0002|\u0005]\u00151\u0015\t\u0005\u0003{\n\tJ\u0004\u0003\u0002\u0000\u0005=e\u0002BAA\u0003\u001bsA!a!\u0002\f:!\u0011QQAE\u001d\rQ\u0017qQ\u0005\u0002\u001b%\u00111\u0002D\u0005\u0003\u0013)I!a\u0002\u0005\n\u0005=4\u0011\u0002BAJ\u0003+\u0013\u0011\u0002R1uC\u001a\u0013\u0018-\\3\u000b\u0005=4\u0001\u0002CAM\u0003k\u0002\r!a'\u0002\u000bM$\u0018M\u001d;\u0011\u000bE\t\u0019\"!(\u0011\u0007]\ty*C\u0002\u0002\"\n\u0011aa\u00144gg\u0016$\b\u0002CAS\u0003k\u0002\r!!(\u0002\u0007\u0015tG\rC\u0004\u0002*\u0002!I!a+\u0002\u001b\u0019,Go\u00195BY24\u0015\u000e\\3t)\u00059\u0007bBAX\u0001\u0011%\u0011\u0011W\u0001\u0014O\u0016$X*\u0019=GS2,7\u000fU3s\u0005\u0006$8\r\u001b\u000b\u0003\u0003#Aq!!.\u0001\t\u0003\n9,A\u0005hKR|eMZ:fiV\u0011\u00111\u0014\u0005\b\u0003w\u0003A\u0011IA_\u0003!!xn\u0015;sS:<G#\u0001\u0015\t\u000f\u0005\u0005\u0007\u0001\"\u0011\u0002D\u0006!1\u000f^8q)\u0005q\b")
public class FileStreamSource
implements Source,
Logging {
    private final SparkSession sparkSession;
    private final String fileFormatClassName;
    private final StructType schema;
    private final Map<String, String> options;
    private final FileSystem fs;
    private final Path qualifiedBasePath;
    private final HDFSMetadataLog<Seq<String>> metadataLog;
    private long org$apache$spark$sql$execution$streaming$FileStreamSource$$maxBatchId;
    private final Option<Object> maxFilesPerBatch;
    private final OpenHashSet<String> org$apache$spark$sql$execution$streaming$FileStreamSource$$seenFiles;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    @Override
    public StructType schema() {
        return this.schema;
    }

    private FileSystem fs() {
        return this.fs;
    }

    private Path qualifiedBasePath() {
        return this.qualifiedBasePath;
    }

    private HDFSMetadataLog<Seq<String>> metadataLog() {
        return this.metadataLog;
    }

    public long org$apache$spark$sql$execution$streaming$FileStreamSource$$maxBatchId() {
        return this.org$apache$spark$sql$execution$streaming$FileStreamSource$$maxBatchId;
    }

    private void org$apache$spark$sql$execution$streaming$FileStreamSource$$maxBatchId_$eq(long x$1) {
        this.org$apache$spark$sql$execution$streaming$FileStreamSource$$maxBatchId = x$1;
    }

    private Option<Object> maxFilesPerBatch() {
        return this.maxFilesPerBatch;
    }

    public OpenHashSet<String> org$apache$spark$sql$execution$streaming$FileStreamSource$$seenFiles() {
        return this.org$apache$spark$sql$execution$streaming$FileStreamSource$$seenFiles;
    }

    private synchronized LongOffset fetchMaxOffset() {
        Seq newFiles = (Seq)this.fetchAllFiles().filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FileStreamSource $outer;

            public final boolean apply(String x$2) {
                return !this.$outer.org$apache$spark$sql$execution$streaming$FileStreamSource$$seenFiles().contains((Object)x$2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Seq batchFiles = this.maxFilesPerBatch().nonEmpty() ? (Seq)newFiles.take(BoxesRunTime.unboxToInt((Object)this.maxFilesPerBatch().get())) : newFiles;
        batchFiles.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FileStreamSource $outer;

            public final void apply(String file) {
                this.$outer.org$apache$spark$sql$execution$streaming$FileStreamSource$$seenFiles().add((Object)file);
                this.$outer.logDebug((Function0<String>)new Serializable(this, file){
                    public static final long serialVersionUID = 0L;
                    private final String file$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"New file: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.file$1}));
                    }
                    {
                        this.file$1 = file$1;
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.logTrace((Function0<String>)new Serializable(this, newFiles){
            public static final long serialVersionUID = 0L;
            private final Seq newFiles$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Number of new files = ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.newFiles$1.size())}));
            }
            {
                this.newFiles$1 = newFiles$1;
            }
        });
        this.logTrace((Function0<String>)new Serializable(this, batchFiles){
            public static final long serialVersionUID = 0L;
            private final Seq batchFiles$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Number of files selected for batch = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.batchFiles$1.size())}));
            }
            {
                this.batchFiles$1 = batchFiles$1;
            }
        });
        this.logTrace((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FileStreamSource $outer;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Number of seen files = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.org$apache$spark$sql$execution$streaming$FileStreamSource$$seenFiles().size())}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        if (batchFiles.nonEmpty()) {
            this.org$apache$spark$sql$execution$streaming$FileStreamSource$$maxBatchId_$eq(this.org$apache$spark$sql$execution$streaming$FileStreamSource$$maxBatchId() + 1L);
            this.metadataLog().add(this.org$apache$spark$sql$execution$streaming$FileStreamSource$$maxBatchId(), (Seq<String>)batchFiles);
            this.logInfo((Function0<String>)new Serializable(this, batchFiles){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ FileStreamSource $outer;
                private final Seq batchFiles$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Max batch id increased to ", " with ", " new files"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.$outer.org$apache$spark$sql$execution$streaming$FileStreamSource$$maxBatchId()), BoxesRunTime.boxToInteger((int)this.batchFiles$1.size())}));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.batchFiles$1 = batchFiles$1;
                }
            });
        }
        return new LongOffset(this.org$apache$spark$sql$execution$streaming$FileStreamSource$$maxBatchId());
    }

    public synchronized <T> T withBatchingLocked(Function0<T> func) {
        return (T)func.apply();
    }

    public synchronized LongOffset currentOffset() {
        return new LongOffset(this.org$apache$spark$sql$execution$streaming$FileStreamSource$$maxBatchId());
    }

    @Override
    public Dataset<Row> getBatch(Option<Offset> start, Offset end) {
        long endId;
        long startId = BoxesRunTime.unboxToLong((Object)start.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(Offset x$3) {
                return ((LongOffset)x$3).offset();
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return -1L;
            }
        }));
        Predef$.MODULE$.assert(startId <= (endId = ((LongOffset)end).offset()));
        String[] files = (String[])Predef$.MODULE$.refArrayOps((Object[])this.metadataLog().get((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)(startId + 1L))), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)endId)))).flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<String> apply(Tuple2<Object, Seq<String>> x$4) {
                return (Seq)x$4._2();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        this.logInfo((Function0<String>)new Serializable(this, startId, endId, files){
            public static final long serialVersionUID = 0L;
            private final long startId$1;
            private final long endId$1;
            private final String[] files$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Processing ", " files from ", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.files$1.length), BoxesRunTime.boxToLong((long)(this.startId$1 + 1L)), BoxesRunTime.boxToLong((long)this.endId$1)}));
            }
            {
                this.startId$1 = startId$1;
                this.endId$1 = endId$1;
                this.files$1 = files$1;
            }
        });
        this.logTrace((Function0<String>)new Serializable(this, files){
            public static final long serialVersionUID = 0L;
            private final String[] files$1;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Files are:\\n\\t"})).s((Seq)Nil$.MODULE$)).append((Object)Predef$.MODULE$.refArrayOps((Object[])this.files$1).mkString("\n\t")).toString();
            }
            {
                this.files$1 = files$1;
            }
        });
        Map<String, String> newOptions = new CaseInsensitiveMap(this.options).filterKeys((Function1<String, Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$5) {
                String string = x$5;
                String string2 = "path";
                return string != null ? !string.equals(string2) : string2 != null;
            }
        });
        SparkSession x$10 = this.sparkSession;
        WrappedArray x$11 = Predef$.MODULE$.wrapRefArray((Object[])files);
        Some x$12 = new Some((Object)this.schema());
        String x$13 = this.fileFormatClassName;
        Map<String, String> x$14 = newOptions;
        Seq<String> x$15 = DataSource$.MODULE$.apply$default$5();
        Option<BucketSpec> x$16 = DataSource$.MODULE$.apply$default$6();
        DataSource newDataSource = new DataSource(x$10, x$13, (Seq<String>)x$11, (Option<StructType>)x$12, x$15, x$16, x$14);
        return Dataset$.MODULE$.ofRows(this.sparkSession, (LogicalPlan)new LogicalRelation(newDataSource.resolveRelation(newDataSource.resolveRelation$default$1()), LogicalRelation$.MODULE$.apply$default$2(), LogicalRelation$.MODULE$.apply$default$3()));
    }

    private Seq<String> fetchAllFiles() {
        long startTime = System.nanoTime();
        Seq globbedPaths = SparkHadoopUtil$.MODULE$.get().globPathIfNecessary(this.qualifiedBasePath());
        ListingFileCatalog catalog = new ListingFileCatalog(this.sparkSession, (Seq<Path>)globbedPaths, this.options, (Option<StructType>)new Some((Object)new StructType()), ListingFileCatalog$.MODULE$.$lessinit$greater$default$5());
        Seq files = (Seq)((TraversableLike)catalog.allFiles().sortBy((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(FileStatus x$6) {
                return x$6.getModificationTime();
            }
        }, (Ordering)Ordering.Long$.MODULE$)).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(FileStatus x$7) {
                return x$7.getPath().toUri().toString();
            }
        }, Seq$.MODULE$.canBuildFrom());
        long endTime = System.nanoTime();
        double listingTimeMs = ((double)endTime - (double)startTime) / (double)1000000;
        if (listingTimeMs > (double)2000) {
            this.logWarning((Function0<String>)new Serializable(this, files, listingTimeMs){
                public static final long serialVersionUID = 0L;
                private final Seq files$2;
                private final double listingTimeMs$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Listed ", " file(s) in ", " ms"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.files$2.size()), BoxesRunTime.boxToDouble((double)this.listingTimeMs$1)}));
                }
                {
                    this.files$2 = files$2;
                    this.listingTimeMs$1 = listingTimeMs$1;
                }
            });
        } else {
            this.logTrace((Function0<String>)new Serializable(this, files, listingTimeMs){
                public static final long serialVersionUID = 0L;
                private final Seq files$2;
                private final double listingTimeMs$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Listed ", " file(s) in ", " ms"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.files$2.size()), BoxesRunTime.boxToDouble((double)this.listingTimeMs$1)}));
                }
                {
                    this.files$2 = files$2;
                    this.listingTimeMs$1 = listingTimeMs$1;
                }
            });
        }
        this.logTrace((Function0<String>)new Serializable(this, files){
            public static final long serialVersionUID = 0L;
            private final Seq files$2;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Files are:\\n\\t"})).s((Seq)Nil$.MODULE$)).append((Object)this.files$2.mkString("\n\t")).toString();
            }
            {
                this.files$2 = files$2;
            }
        });
        return files;
    }

    private Option<Object> getMaxFilesPerBatch() {
        return new CaseInsensitiveMap(this.options).get("maxFilesPerTrigger").map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(String str2) {
                return BoxesRunTime.unboxToInt((Object)Try$.MODULE$.apply((Function0)new Serializable(this, str2){
                    public static final long serialVersionUID = 0L;
                    private final String str$1;

                    public final int apply() {
                        return this.apply$mcI$sp();
                    }

                    public int apply$mcI$sp() {
                        return new StringOps(Predef$.MODULE$.augmentString(this.str$1)).toInt();
                    }
                    {
                        this.str$1 = str$1;
                    }
                }).toOption().filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(int x$8) {
                        return this.apply$mcZI$sp(x$8);
                    }

                    public boolean apply$mcZI$sp(int x$8) {
                        return x$8 > 0;
                    }
                }).getOrElse((Function0)new Serializable(this, str2){
                    public static final long serialVersionUID = 0L;
                    private final String str$1;

                    public final Nothing$ apply() {
                        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid value '", "' for option 'maxFilesPerTrigger', must be a positive integer"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.str$1})));
                    }
                    {
                        this.str$1 = str$1;
                    }
                }));
            }
        });
    }

    @Override
    public Option<Offset> getOffset() {
        return new Some((Object)this.fetchMaxOffset()).filterNot((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(LongOffset x$9) {
                return x$9.offset() == -1L;
            }
        });
    }

    public String toString() {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"FileStreamSource[", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.qualifiedBasePath()}));
    }

    @Override
    public void stop() {
    }

    public FileStreamSource(SparkSession sparkSession, String path, String fileFormatClassName, StructType schema, String metadataPath, Map<String, String> options) {
        this.sparkSession = sparkSession;
        this.fileFormatClassName = fileFormatClassName;
        this.schema = schema;
        this.options = options;
        Logging.class.$init$((Logging)this);
        this.fs = new Path(path).getFileSystem(sparkSession.sessionState().newHadoopConf());
        this.qualifiedBasePath = this.fs().makeQualified(new Path(path));
        this.metadataLog = new HDFSMetadataLog(sparkSession, metadataPath, ClassTag$.MODULE$.apply(Seq.class));
        this.org$apache$spark$sql$execution$streaming$FileStreamSource$$maxBatchId = BoxesRunTime.unboxToLong((Object)this.metadataLog().getLatest().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(Tuple2<Object, Seq<String>> x$1) {
                return x$1._1$mcJ$sp();
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return -1L;
            }
        }));
        this.maxFilesPerBatch = this.getMaxFilesPerBatch();
        this.org$apache$spark$sql$execution$streaming$FileStreamSource$$seenFiles = new OpenHashSet(ClassTag$.MODULE$.apply(String.class));
        Predef$.MODULE$.refArrayOps((Object[])this.metadataLog().get((Option<Object>)None$.MODULE$, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)this.org$apache$spark$sql$execution$streaming$FileStreamSource$$maxBatchId())))).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FileStreamSource $outer;

            public final void apply(Tuple2<Object, Seq<String>> x0$1) {
                Tuple2<Object, Seq<String>> tuple2 = x0$1;
                if (tuple2 != null) {
                    Seq files = (Seq)tuple2._2();
                    files.foreach((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$4 $outer;

                        public final void apply(String k) {
                            this.$outer.org$apache$spark$sql$execution$streaming$FileStreamSource$$anonfun$$$outer().org$apache$spark$sql$execution$streaming$FileStreamSource$$seenFiles().add((Object)k);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }

            public /* synthetic */ FileStreamSource org$apache$spark$sql$execution$streaming$FileStreamSource$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

