/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming;

import org.apache.spark.sql.execution.streaming.SinkFileStatus;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong;

public final class FileStreamSinkLog$ {
    public static final FileStreamSinkLog$ MODULE$;
    private final String VERSION;
    private final String COMPACT_FILE_SUFFIX;
    private final String DELETE_ACTION;
    private final String ADD_ACTION;

    static {
        new FileStreamSinkLog$();
    }

    public String VERSION() {
        return this.VERSION;
    }

    public String COMPACT_FILE_SUFFIX() {
        return this.COMPACT_FILE_SUFFIX;
    }

    public String DELETE_ACTION() {
        return this.DELETE_ACTION;
    }

    public String ADD_ACTION() {
        return this.ADD_ACTION;
    }

    public long getBatchIdFromFileName(String fileName) {
        return new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString(fileName)).stripSuffix(this.COMPACT_FILE_SUFFIX()))).toLong();
    }

    public boolean isCompactionBatch(long batchId, int compactInterval) {
        return (batchId + 1L) % (long)compactInterval == 0L;
    }

    public Seq<Object> getValidBatchesBeforeCompactionBatch(long compactionBatchId, int compactInterval) {
        Predef$.MODULE$.assert(this.isCompactionBatch(compactionBatchId, compactInterval), (Function0)new Serializable(compactionBatchId){
            public static final long serialVersionUID = 0L;
            private final long compactionBatchId$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " is not a compaction batch"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.compactionBatchId$1)}));
            }
            {
                this.compactionBatchId$1 = compactionBatchId$1;
            }
        });
        return new RichLong(Predef$.MODULE$.longWrapper(package$.MODULE$.max(0L, compactionBatchId - (long)compactInterval))).until((Object)BoxesRunTime.boxToLong((long)compactionBatchId));
    }

    public Seq<Object> getAllValidBatches(long batchId, long compactInterval) {
        Predef$.MODULE$.assert(batchId >= 0L);
        long start = package$.MODULE$.max(0L, (batchId + 1L) / compactInterval * compactInterval - 1L);
        return new RichLong(Predef$.MODULE$.longWrapper(start)).to((Object)BoxesRunTime.boxToLong((long)batchId));
    }

    public Seq<SinkFileStatus> compactLogs(Seq<SinkFileStatus> logs) {
        Set deletedFiles = ((TraversableOnce)((TraversableLike)logs.filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(SinkFileStatus x$6) {
                String string = x$6.action();
                String string2 = FileStreamSinkLog$.MODULE$.DELETE_ACTION();
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
        })).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(SinkFileStatus x$7) {
                return x$7.path();
            }
        }, Seq$.MODULE$.canBuildFrom())).toSet();
        return deletedFiles.isEmpty() ? logs : (Seq)logs.filter((Function1)new Serializable(deletedFiles){
            public static final long serialVersionUID = 0L;
            private final Set deletedFiles$1;

            public final boolean apply(SinkFileStatus f) {
                return !this.deletedFiles$1.contains((Object)f.path());
            }
            {
                this.deletedFiles$1 = deletedFiles$1;
            }
        });
    }

    public long nextCompactionBatchId(long batchId, long compactInterval) {
        return (batchId + compactInterval + 1L) / compactInterval * compactInterval - 1L;
    }

    private FileStreamSinkLog$() {
        MODULE$ = this;
        this.VERSION = "v1";
        this.COMPACT_FILE_SUFFIX = ".compact";
        this.DELETE_ACTION = "delete";
        this.ADD_ACTION = "add";
    }
}

