/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.exchange;

import org.apache.spark.SparkException;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.rdd.RDD;
import org.apache.spark.scheduler.SparkListenerEvent;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.catalyst.plans.physical.BroadcastMode;
import org.apache.spark.sql.catalyst.plans.physical.BroadcastPartitioning;
import org.apache.spark.sql.catalyst.plans.physical.Partitioning;
import org.apache.spark.sql.execution.SQLExecution$;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.exchange.BroadcastExchangeExec$;
import org.apache.spark.sql.execution.exchange.Exchange;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.execution.metric.SQLMetrics$;
import org.apache.spark.sql.execution.ui.SparkListenerDriverAccumUpdates;
import org.apache.spark.util.ThreadUtils$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable$;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\t\u001da\u0001B\u0001\u0003\u0001>\u0011QC\u0011:pC\u0012\u001c\u0017m\u001d;Fq\u000eD\u0017M\\4f\u000bb,7M\u0003\u0002\u0004\t\u0005AQ\r_2iC:<WM\u0003\u0002\u0006\r\u0005IQ\r_3dkRLwN\u001c\u0006\u0003\u000f!\t1a]9m\u0015\tI!\"A\u0003ta\u0006\u00148N\u0003\u0002\f\u0019\u00051\u0011\r]1dQ\u0016T\u0011!D\u0001\u0004_J<7\u0001A\n\u0005\u0001A!\"\u0004\u0005\u0002\u0012%5\t!!\u0003\u0002\u0014\u0005\tAQ\t_2iC:<W\r\u0005\u0002\u001615\taCC\u0001\u0018\u0003\u0015\u00198-\u00197b\u0013\tIbCA\u0004Qe>$Wo\u0019;\u0011\u0005UY\u0012B\u0001\u000f\u0017\u00051\u0019VM]5bY&T\u0018M\u00197f\u0011!q\u0002A!f\u0001\n\u0003y\u0012\u0001B7pI\u0016,\u0012\u0001\t\t\u0003C!j\u0011A\t\u0006\u0003G\u0011\n\u0001\u0002\u001d5zg&\u001c\u0017\r\u001c\u0006\u0003K\u0019\nQ\u0001\u001d7b]NT!a\n\u0004\u0002\u0011\r\fG/\u00197zgRL!!\u000b\u0012\u0003\u001b\t\u0013x.\u00193dCN$Xj\u001c3f\u0011!Y\u0003A!E!\u0002\u0013\u0001\u0013!B7pI\u0016\u0004\u0003\u0002C\u0017\u0001\u0005+\u0007I\u0011\u0001\u0018\u0002\u000b\rD\u0017\u000e\u001c3\u0016\u0003=\u0002\"\u0001M\u0019\u000e\u0003\u0011I!A\r\u0003\u0003\u0013M\u0003\u0018M]6QY\u0006t\u0007\u0002\u0003\u001b\u0001\u0005#\u0005\u000b\u0011B\u0018\u0002\r\rD\u0017\u000e\u001c3!\u0011\u00151\u0004\u0001\"\u00018\u0003\u0019a\u0014N\\5u}Q\u0019\u0001(\u000f\u001e\u0011\u0005E\u0001\u0001\"\u0002\u00106\u0001\u0004\u0001\u0003\"B\u00176\u0001\u0004y\u0003\"\u0003\u001f\u0001\u0011\u000b\u0007I\u0011\t\u0004>\u0003\u001diW\r\u001e:jGN,\u0012A\u0010\t\u0005\u007f\u00113e*D\u0001A\u0015\t\t%)A\u0005j[6,H/\u00192mK*\u00111IF\u0001\u000bG>dG.Z2uS>t\u0017BA#A\u0005\ri\u0015\r\u001d\t\u0003\u000f2k\u0011\u0001\u0013\u0006\u0003\u0013*\u000bA\u0001\\1oO*\t1*\u0001\u0003kCZ\f\u0017BA'I\u0005\u0019\u0019FO]5oOB\u0011qJU\u0007\u0002!*\u0011\u0011\u000bB\u0001\u0007[\u0016$(/[2\n\u0005M\u0003&!C*R\u00196+GO]5d\u0011!)\u0006\u0001#A!B\u0013q\u0014\u0001C7fiJL7m\u001d\u0011\t\u000b]\u0003A\u0011\t-\u0002%=,H\u000f];u!\u0006\u0014H/\u001b;j_:LgnZ\u000b\u00023B\u0011\u0011EW\u0005\u00037\n\u0012A\u0002U1si&$\u0018n\u001c8j]\u001eDQ!\u0018\u0001\u0005By\u000b!b]1nKJ+7/\u001e7u)\ty&\r\u0005\u0002\u0016A&\u0011\u0011M\u0006\u0002\b\u0005>|G.Z1o\u0011\u0015\u0019G\f1\u00010\u0003\u0011\u0001H.\u00198\t\u000f\u0015\u0004!\u0019!C\u0005M\u00069A/[7f_V$X#A4\u0011\u0005!lW\"A5\u000b\u0005)\\\u0017\u0001\u00033ve\u0006$\u0018n\u001c8\u000b\u000514\u0012AC2p]\u000e,(O]3oi&\u0011a.\u001b\u0002\t\tV\u0014\u0018\r^5p]\"1\u0001\u000f\u0001Q\u0001\n\u001d\f\u0001\u0002^5nK>,H\u000f\t\u0015\u0003_J\u0004\"!F:\n\u0005Q4\"!\u0003;sC:\u001c\u0018.\u001a8u\u0011!1\b\u0001#b\u0001\n\u00139\u0018A\u0004:fY\u0006$\u0018n\u001c8GkR,(/Z\u000b\u0002qB\u0019\u0011P\u001f?\u000e\u0003-L!a_6\u0003\r\u0019+H/\u001e:f!\u0015i\u0018\u0011AA\u0003\u001b\u0005q(BA@\t\u0003%\u0011'o\\1eG\u0006\u001cH/C\u0002\u0002\u0004y\u0014\u0011B\u0011:pC\u0012\u001c\u0017m\u001d;\u0011\u0007U\t9!C\u0002\u0002\nY\u00111!\u00118z\u0011%\ti\u0001\u0001E\u0001B\u0003&\u00010A\bsK2\fG/[8o\rV$XO]3!Q\r\tYA\u001d\u0005\b\u0003'\u0001A\u0011KA\u000b\u0003%!w\u000e\u0015:fa\u0006\u0014X\r\u0006\u0002\u0002\u0018A\u0019Q#!\u0007\n\u0007\u0005maC\u0001\u0003V]&$\bbBA\u0010\u0001\u0011E\u0013\u0011E\u0001\nI>,\u00050Z2vi\u0016$\"!a\t\u0011\r\u0005\u0015\u00121FA\u0018\u001b\t\t9CC\u0002\u0002*!\t1A\u001d3e\u0013\u0011\ti#a\n\u0003\u0007I#E\t\u0005\u0003\u00022\u0005MR\"\u0001\u0014\n\u0007\u0005UbEA\u0006J]R,'O\\1m%><\b\u0002CA\u001d\u0001\u0011Ec!a\u000f\u0002%\u0011|W\t_3dkR,'I]8bI\u000e\f7\u000f^\u000b\u0005\u0003{\t)\u0005\u0006\u0002\u0002@A)Q0!\u0001\u0002BA!\u00111IA#\u0019\u0001!\u0001\"a\u0012\u00028\t\u0007\u0011\u0011\n\u0002\u0002)F!\u00111JA\u0003!\r)\u0012QJ\u0005\u0004\u0003\u001f2\"a\u0002(pi\"Lgn\u001a\u0005\n\u0003'\u0002\u0011\u0011!C\u0001\u0003+\nAaY8qsR)\u0001(a\u0016\u0002Z!Aa$!\u0015\u0011\u0002\u0003\u0007\u0001\u0005\u0003\u0005.\u0003#\u0002\n\u00111\u00010\u0011%\ti\u0006AI\u0001\n\u0003\ty&\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005\u0005$f\u0001\u0011\u0002d-\u0012\u0011Q\r\t\u0005\u0003O\n\t(\u0004\u0002\u0002j)!\u00111NA7\u0003%)hn\u00195fG.,GMC\u0002\u0002pY\t!\"\u00198o_R\fG/[8o\u0013\u0011\t\u0019(!\u001b\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rC\u0005\u0002x\u0001\t\n\u0011\"\u0001\u0002z\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TCAA>U\ry\u00131\r\u0005\n\u0003\u007f\u0002\u0011\u0011!C!\u0003\u0003\u000bQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DX#\u0001$\t\u0013\u0005\u0015\u0005!!A\u0005\u0002\u0005\u001d\u0015\u0001\u00049s_\u0012,8\r^!sSRLXCAAE!\r)\u00121R\u0005\u0004\u0003\u001b3\"aA%oi\"I\u0011\u0011\u0013\u0001\u0002\u0002\u0013\u0005\u00111S\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\t)!!&\t\u0015\u0005]\u0015qRA\u0001\u0002\u0004\tI)A\u0002yIEB\u0011\"a'\u0001\u0003\u0003%\t%!(\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!a(\u0011\r\u0005\u0005\u00161UA\u0003\u001b\u0005\u0011\u0015bAAS\u0005\nA\u0011\n^3sCR|'\u000fC\u0005\u0002*\u0002\t\t\u0011\"\u0001\u0002,\u0006A1-\u00198FcV\fG\u000eF\u0002`\u0003[C!\"a&\u0002(\u0006\u0005\t\u0019AA\u0003\u0011%\t\t\fAA\u0001\n\u0003\n\u0019,\u0001\u0004fcV\fGn\u001d\u000b\u0004?\u0006U\u0006BCAL\u0003_\u000b\t\u00111\u0001\u0002\u0006\u001d9\u0011\u0011\u0018\u0002\t\u0002\u0005m\u0016!\u0006\"s_\u0006$7-Y:u\u000bb\u001c\u0007.\u00198hK\u0016CXm\u0019\t\u0004#\u0005ufAB\u0001\u0003\u0011\u0003\tylE\u0003\u0002>\u0006\u0005'\u0004E\u0002\u0016\u0003\u0007L1!!2\u0017\u0005\u0019\te.\u001f*fM\"9a'!0\u0005\u0002\u0005%GCAA^\u0011-\ti-!0C\u0002\u0013\u0005A!a4\u0002!\u0015DXmY;uS>t7i\u001c8uKb$XCAAi!\rI\u00181[\u0005\u0004\u0003+\\'aH#yK\u000e,H/[8o\u0007>tG/\u001a=u\u000bb,7-\u001e;peN+'O^5dK\"I\u0011\u0011\\A_A\u0003%\u0011\u0011[\u0001\u0012Kb,7-\u001e;j_:\u001cuN\u001c;fqR\u0004\u0003BCAo\u0003{\u000b\t\u0011\"!\u0002`\u0006)\u0011\r\u001d9msR)\u0001(!9\u0002d\"1a$a7A\u0002\u0001Ba!LAn\u0001\u0004y\u0003BCAt\u0003{\u000b\t\u0011\"!\u0002j\u00069QO\\1qa2LH\u0003BAv\u0003o\u0004R!FAw\u0003cL1!a<\u0017\u0005\u0019y\u0005\u000f^5p]B)Q#a=!_%\u0019\u0011Q\u001f\f\u0003\rQ+\b\u000f\\33\u0011%\tI0!:\u0002\u0002\u0003\u0007\u0001(A\u0002yIAB!\"!@\u0002>\u0006\u0005I\u0011BA\u0000\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\t\u0005\u0001cA$\u0003\u0004%\u0019!Q\u0001%\u0003\r=\u0013'.Z2u\u0001")
public class BroadcastExchangeExec
extends Exchange {
    private final BroadcastMode mode;
    private final SparkPlan child;
    private Map<String, SQLMetric> metrics;
    private final transient Duration timeout;
    private transient Future<Broadcast<Object>> relationFuture;
    private volatile boolean bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    public static Option<Tuple2<BroadcastMode, SparkPlan>> unapply(BroadcastExchangeExec broadcastExchangeExec) {
        return BroadcastExchangeExec$.MODULE$.unapply(broadcastExchangeExec);
    }

    private Map metrics$lzycompute() {
        BroadcastExchangeExec broadcastExchangeExec = this;
        synchronized (broadcastExchangeExec) {
            if (!this.bitmap$0) {
                this.metrics = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dataSize"), (Object)SQLMetrics$.MODULE$.createMetric(this.sparkContext(), "data size (bytes)")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"collectTime"), (Object)SQLMetrics$.MODULE$.createMetric(this.sparkContext(), "time to collect (ms)")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"buildTime"), (Object)SQLMetrics$.MODULE$.createMetric(this.sparkContext(), "time to build (ms)")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"broadcastTime"), (Object)SQLMetrics$.MODULE$.createMetric(this.sparkContext(), "time to broadcast (ms)"))}));
                this.bitmap$0 = true;
            }
            return this.metrics;
        }
    }

    private Future relationFuture$lzycompute() {
        BroadcastExchangeExec broadcastExchangeExec = this;
        synchronized (broadcastExchangeExec) {
            if (!this.bitmap$trans$0) {
                String executionId = this.sparkContext().getLocalProperty(SQLExecution$.MODULE$.EXECUTION_ID_KEY());
                this.relationFuture = Future$.MODULE$.apply((Function0)new Serializable(this, executionId){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ BroadcastExchangeExec $outer;
                    public final String executionId$1;

                    public final Broadcast<Object> apply() {
                        return (Broadcast)SQLExecution$.MODULE$.withExecutionId(this.$outer.sparkContext(), this.executionId$1, new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$relationFuture$1 $outer;

                            public final Broadcast<Object> apply() {
                                long beforeCollect = System.nanoTime();
                                InternalRow[] input = this.$outer.org$apache$spark$sql$execution$exchange$BroadcastExchangeExec$$anonfun$$$outer().child().executeCollect();
                                if (input.length >= 512000000) {
                                    throw new SparkException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot broadcast the table with more than 512 millions rows: ", " rows"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)input.length)})));
                                }
                                long beforeBuild = System.nanoTime();
                                this.$outer.org$apache$spark$sql$execution$exchange$BroadcastExchangeExec$$anonfun$$$outer().longMetric("collectTime").$plus$eq((beforeBuild - beforeCollect) / 1000000L);
                                long dataSize = BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.longArrayOps((long[])Predef$.MODULE$.refArrayOps((Object[])input).map((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final long apply(InternalRow x$1) {
                                        return ((UnsafeRow)x$1).getSizeInBytes();
                                    }
                                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long()))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
                                this.$outer.org$apache$spark$sql$execution$exchange$BroadcastExchangeExec$$anonfun$$$outer().longMetric("dataSize").$plus$eq(dataSize);
                                if (dataSize >= 0x200000000L) {
                                    throw new SparkException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot broadcast the table that is larger than 8GB: ", " GB"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)(dataSize >> 30))})));
                                }
                                Object relation = this.$outer.org$apache$spark$sql$execution$exchange$BroadcastExchangeExec$$anonfun$$$outer().mode().transform(input);
                                long beforeBroadcast = System.nanoTime();
                                this.$outer.org$apache$spark$sql$execution$exchange$BroadcastExchangeExec$$anonfun$$$outer().longMetric("buildTime").$plus$eq((beforeBroadcast - beforeBuild) / 1000000L);
                                Broadcast broadcasted = this.$outer.org$apache$spark$sql$execution$exchange$BroadcastExchangeExec$$anonfun$$$outer().sparkContext().broadcast(relation, ClassTag$.MODULE$.Any());
                                this.$outer.org$apache$spark$sql$execution$exchange$BroadcastExchangeExec$$anonfun$$$outer().longMetric("broadcastTime").$plus$eq((System.nanoTime() - beforeBroadcast) / 1000000L);
                                if (this.$outer.executionId$1 != null) {
                                    this.$outer.org$apache$spark$sql$execution$exchange$BroadcastExchangeExec$$anonfun$$$outer().sparkContext().listenerBus().post((SparkListenerEvent)new SparkListenerDriverAccumUpdates(new StringOps(Predef$.MODULE$.augmentString(this.$outer.executionId$1)).toLong(), (Seq<Tuple2<Object, Object>>)((TraversableOnce)this.$outer.org$apache$spark$sql$execution$exchange$BroadcastExchangeExec$$anonfun$$$outer().metrics().values().map((Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final Tuple2<Object, Object> apply(SQLMetric m) {
                                            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)m.id())), (Object)BoxesRunTime.boxToLong((long)m.value()));
                                        }
                                    }, Iterable$.MODULE$.canBuildFrom())).toSeq()));
                                }
                                return broadcasted;
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        });
                    }

                    public /* synthetic */ BroadcastExchangeExec org$apache$spark$sql$execution$exchange$BroadcastExchangeExec$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionId$1 = executionId$1;
                    }
                }, (ExecutionContext)BroadcastExchangeExec$.MODULE$.executionContext());
                this.bitmap$trans$0 = true;
            }
            return this.relationFuture;
        }
    }

    public BroadcastMode mode() {
        return this.mode;
    }

    @Override
    public SparkPlan child() {
        return this.child;
    }

    @Override
    public Map<String, SQLMetric> metrics() {
        return this.bitmap$0 ? this.metrics : this.metrics$lzycompute();
    }

    @Override
    public Partitioning outputPartitioning() {
        return new BroadcastPartitioning(this.mode());
    }

    public boolean sameResult(SparkPlan plan2) {
        boolean bl;
        SparkPlan sparkPlan = plan2;
        if (sparkPlan instanceof BroadcastExchangeExec) {
            BroadcastExchangeExec broadcastExchangeExec = (BroadcastExchangeExec)sparkPlan;
            bl = this.mode().compatibleWith(broadcastExchangeExec.mode()) && this.child().sameResult(broadcastExchangeExec.child());
        } else {
            bl = false;
        }
        return bl;
    }

    private Duration timeout() {
        return this.timeout;
    }

    private Future<Broadcast<Object>> relationFuture() {
        return this.bitmap$trans$0 ? this.relationFuture : this.relationFuture$lzycompute();
    }

    @Override
    public void doPrepare() {
        this.relationFuture();
    }

    @Override
    public RDD<InternalRow> doExecute() {
        throw new UnsupportedOperationException("BroadcastExchange does not support the execute() code path.");
    }

    @Override
    public <T> Broadcast<T> doExecuteBroadcast() {
        return (Broadcast)ThreadUtils$.MODULE$.awaitResult(this.relationFuture(), this.timeout());
    }

    public BroadcastExchangeExec copy(BroadcastMode mode, SparkPlan child) {
        return new BroadcastExchangeExec(mode, child);
    }

    public BroadcastMode copy$default$1() {
        return this.mode();
    }

    public SparkPlan copy$default$2() {
        return this.child();
    }

    public String productPrefix() {
        return "BroadcastExchangeExec";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        SparkPlan sparkPlan;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 1: {
                sparkPlan = this.child();
                break;
            }
            case 0: {
                sparkPlan = this.mode();
            }
        }
        return sparkPlan;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof BroadcastExchangeExec;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof BroadcastExchangeExec)) return false;
        boolean bl = true;
        if (!bl) return false;
        BroadcastExchangeExec broadcastExchangeExec = (BroadcastExchangeExec)x$1;
        BroadcastMode broadcastMode = this.mode();
        BroadcastMode broadcastMode2 = broadcastExchangeExec.mode();
        if (broadcastMode == null) {
            if (broadcastMode2 != null) {
                return false;
            }
        } else if (!broadcastMode.equals(broadcastMode2)) return false;
        SparkPlan sparkPlan = this.child();
        SparkPlan sparkPlan2 = broadcastExchangeExec.child();
        if (sparkPlan == null) {
            if (sparkPlan2 != null) {
                return false;
            }
        } else if (!((Object)((Object)sparkPlan)).equals((Object)sparkPlan2)) return false;
        if (!broadcastExchangeExec.canEqual(this)) return false;
        return true;
    }

    public BroadcastExchangeExec(BroadcastMode mode, SparkPlan child) {
        this.mode = mode;
        this.child = child;
        int timeoutValue = this.sqlContext().conf().broadcastTimeout();
        this.timeout = timeoutValue < 0 ? Duration$.MODULE$.Inf() : new package.DurationInt(package$.MODULE$.DurationInt(timeoutValue)).seconds();
    }
}

