/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.tree;

import org.apache.hadoop.fs.Path;
import org.apache.spark.ml.param.Param$;
import org.apache.spark.ml.param.Params;
import org.apache.spark.ml.tree.DecisionTreeModel;
import org.apache.spark.ml.tree.DecisionTreeModelReadWrite;
import org.apache.spark.ml.tree.DecisionTreeModelReadWrite$;
import org.apache.spark.ml.tree.EnsembleModelReadWrite;
import org.apache.spark.ml.tree.EnsembleModelReadWrite$;
import org.apache.spark.ml.tree.EnsembleModelReadWrite$EnsembleNodeData$;
import org.apache.spark.ml.tree.Node;
import org.apache.spark.ml.tree.TreeEnsembleModel;
import org.apache.spark.ml.util.DefaultParamsReader;
import org.apache.spark.ml.util.DefaultParamsReader$;
import org.apache.spark.ml.util.DefaultParamsWriter$;
import org.apache.spark.rdd.OrderedRDDFunctions;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.json4s.DefaultFormats$;
import org.json4s.Formats;
import org.json4s.JsonAST;
import org.json4s.jackson.JsonMethods$;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenIterable;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;

public final class EnsembleModelReadWrite$ {
    public static final EnsembleModelReadWrite$ MODULE$;

    static {
        new EnsembleModelReadWrite$();
    }

    public <M extends Params & TreeEnsembleModel<? extends DecisionTreeModel>> void saveImpl(M instance, String path, SparkSession sql, JsonAST.JObject extraMetadata) {
        DefaultParamsWriter$.MODULE$.saveMetadata(instance, path, sql.sparkContext(), (Option<JsonAST.JObject>)new Some((Object)extraMetadata), DefaultParamsWriter$.MODULE$.saveMetadata$default$5());
        Tuple3[] treesMetadataWeights = (Tuple3[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])((TreeEnsembleModel<? extends DecisionTreeModel>)instance).trees()).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).map((Function1)new Serializable(instance, sql){
            public static final long serialVersionUID = 0L;
            private final Params instance$1;
            private final SparkSession sql$1;

            public final Tuple3<Object, String, Object> apply(Tuple2<DecisionTreeModel, Object> x0$4) {
                Tuple2<DecisionTreeModel, Object> tuple2 = x0$4;
                if (tuple2 != null) {
                    DecisionTreeModel tree = (DecisionTreeModel)tuple2._1();
                    int treeID = tuple2._2$mcI$sp();
                    Tuple3 tuple3 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)treeID), (Object)DefaultParamsWriter$.MODULE$.getMetadataToSave((Params)((Object)tree), this.sql$1.sparkContext(), DefaultParamsWriter$.MODULE$.getMetadataToSave$default$3(), DefaultParamsWriter$.MODULE$.getMetadataToSave$default$4()), (Object)BoxesRunTime.boxToDouble((double)((TreeEnsembleModel)((Object)this.instance$1)).treeWeights()[treeID]));
                    return tuple3;
                }
                throw new MatchError(tuple2);
            }
            {
                this.instance$1 = instance$1;
                this.sql$1 = sql$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple3.class)));
        String treesMetadataPath = new Path(path, "treesMetadata").toString();
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_apache_spark_ml_tree_EnsembleModelReadWrite$$typecreator3$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple3"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{$m.staticClass("scala.Int").asType().toTypeConstructor(), $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), $m.staticClass("scala.Double").asType().toTypeConstructor()})));
            }

            public Org_apache_spark_ml_tree_EnsembleModelReadWrite$$typecreator3$1() {
            }
        }
        sql.createDataFrame((Seq)Predef$.MODULE$.wrapRefArray((Object[])treesMetadataWeights), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_tree_EnsembleModelReadWrite$$typecreator3$1())).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"treeID", "metadata", "weights"})).write().parquet(treesMetadataPath);
        String dataPath = new Path(path, "data").toString();
        RDD nodeDataRDD = sql.sparkContext().parallelize((Seq)Predef$.MODULE$.wrapRefArray((Object[])Predef$.MODULE$.refArrayOps((Object[])((TreeEnsembleModel<? extends DecisionTreeModel>)instance).trees()).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))), sql.sparkContext().parallelize$default$2(), ClassTag$.MODULE$.apply(Tuple2.class)).flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Seq<EnsembleModelReadWrite.EnsembleNodeData> apply(Tuple2<DecisionTreeModel, Object> x0$5) {
                Tuple2<DecisionTreeModel, Object> tuple2 = x0$5;
                if (tuple2 != null) {
                    DecisionTreeModel tree = (DecisionTreeModel)tuple2._1();
                    int treeID = tuple2._2$mcI$sp();
                    Seq<EnsembleModelReadWrite.EnsembleNodeData> seq = EnsembleModelReadWrite$EnsembleNodeData$.MODULE$.build(tree, treeID);
                    return seq;
                }
                throw new MatchError(tuple2);
            }
        }, ClassTag$.MODULE$.apply(EnsembleModelReadWrite.EnsembleNodeData.class));
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_apache_spark_ml_tree_EnsembleModelReadWrite$$typecreator4$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.ml.tree.EnsembleModelReadWrite.EnsembleNodeData").asType().toTypeConstructor();
            }

            public Org_apache_spark_ml_tree_EnsembleModelReadWrite$$typecreator4$1() {
            }
        }
        sql.createDataFrame(nodeDataRDD, ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_ml_tree_EnsembleModelReadWrite$$typecreator4$1())).write().parquet(dataPath);
    }

    public Tuple3<DefaultParamsReader.Metadata, Tuple2<DefaultParamsReader.Metadata, Node>[], double[]> loadImpl(String path, SparkSession sql, String className, String treeClassName) {
        DefaultFormats$ format2 = DefaultFormats$.MODULE$;
        DefaultParamsReader.Metadata metadata = DefaultParamsReader$.MODULE$.loadMetadata(path, sql.sparkContext(), className);
        JsonAST.JValue impurityJson = metadata.getParamValue("impurity");
        String impurityType = (String)Param$.MODULE$.jsonDecode(JsonMethods$.MODULE$.compact(JsonMethods$.MODULE$.render(impurityJson, (Formats)format2)));
        String treesMetadataPath = new Path(path, "treesMetadata").toString();
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_apache_spark_ml_tree_EnsembleModelReadWrite$$typecreator6$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple3"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{$m.staticClass("scala.Int").asType().toTypeConstructor(), $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), $m.staticClass("scala.Double").asType().toTypeConstructor()})));
            }

            public Org_apache_spark_ml_tree_EnsembleModelReadWrite$$typecreator6$1() {
            }
        }
        RDD treesMetadataRDD = sql.read().parquet(treesMetadataPath).select("treeID", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"metadata", "weights"})).as(sql.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_tree_EnsembleModelReadWrite$$typecreator6$1()))).rdd().map((Function1)new Serializable(treeClassName){
            public static final long serialVersionUID = 0L;
            private final String treeClassName$1;

            public final Tuple2<Object, Tuple2<DefaultParamsReader.Metadata, Object>> apply(Tuple3<Object, String, Object> x0$6) {
                Tuple3<Object, String, Object> tuple3 = x0$6;
                if (tuple3 != null) {
                    int treeID = BoxesRunTime.unboxToInt((Object)tuple3._1());
                    String json = (String)tuple3._2();
                    double weights = BoxesRunTime.unboxToDouble((Object)tuple3._3());
                    int n = treeID;
                    if (json != null) {
                        String string = json;
                        double d = weights;
                        Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)n)), (Object)new Tuple2((Object)DefaultParamsReader$.MODULE$.parseMetadata(string, this.treeClassName$1), (Object)BoxesRunTime.boxToDouble((double)d)));
                        return tuple2;
                    }
                }
                throw new MatchError(tuple3);
            }
            {
                this.treeClassName$1 = treeClassName$1;
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        OrderedRDDFunctions qual$1 = RDD$.MODULE$.rddToOrderedRDDFunctions(treesMetadataRDD, (Ordering)Ordering.Int$.MODULE$, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(Tuple2.class));
        boolean x$19 = qual$1.sortByKey$default$1();
        int x$20 = qual$1.sortByKey$default$2();
        Tuple2[] treesMetadataWeights = (Tuple2[])RDD$.MODULE$.rddToPairRDDFunctions(qual$1.sortByKey(x$19, x$20), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(Tuple2.class), (Ordering)Ordering.Int$.MODULE$).values().collect();
        DefaultParamsReader.Metadata[] treesMetadata = (DefaultParamsReader.Metadata[])Predef$.MODULE$.refArrayOps((Object[])treesMetadataWeights).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final DefaultParamsReader.Metadata apply(Tuple2<DefaultParamsReader.Metadata, Object> x$17) {
                return (DefaultParamsReader.Metadata)x$17._1();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(DefaultParamsReader.Metadata.class)));
        double[] treesWeights = (double[])Predef$.MODULE$.refArrayOps((Object[])treesMetadataWeights).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(Tuple2<DefaultParamsReader.Metadata, Object> x$18) {
                return x$18._2$mcD$sp();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        String dataPath = new Path(path, "data").toString();
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_apache_spark_ml_tree_EnsembleModelReadWrite$$typecreator7$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.ml.tree.EnsembleModelReadWrite.EnsembleNodeData").asType().toTypeConstructor();
            }

            public Org_apache_spark_ml_tree_EnsembleModelReadWrite$$typecreator7$1() {
            }
        }
        Dataset nodeData = sql.read().parquet(dataPath).as(sql.implicits().newProductEncoder(((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_ml_tree_EnsembleModelReadWrite$$typecreator7$1())));
        RDD rootNodesRDD = RDD$.MODULE$.rddToPairRDDFunctions(nodeData.rdd().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, DecisionTreeModelReadWrite.NodeData> apply(EnsembleModelReadWrite.EnsembleNodeData d) {
                return new Tuple2((Object)BoxesRunTime.boxToInteger((int)d.treeID()), (Object)d.nodeData());
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(DecisionTreeModelReadWrite.NodeData.class), (Ordering)Ordering.Int$.MODULE$).groupByKey().map((Function1)new Serializable(impurityType){
            public static final long serialVersionUID = 0L;
            private final String impurityType$2;

            public final Tuple2<Object, Node> apply(Tuple2<Object, Iterable<DecisionTreeModelReadWrite.NodeData>> x0$7) {
                Tuple2<Object, Iterable<DecisionTreeModelReadWrite.NodeData>> tuple2 = x0$7;
                if (tuple2 != null) {
                    int treeID = tuple2._1$mcI$sp();
                    Iterable nodeData = (Iterable)tuple2._2();
                    int n = treeID;
                    if (nodeData != null) {
                        Iterable iterable = nodeData;
                        Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)n)), (Object)DecisionTreeModelReadWrite$.MODULE$.buildTreeFromNodes((DecisionTreeModelReadWrite.NodeData[])iterable.toArray(ClassTag$.MODULE$.apply(DecisionTreeModelReadWrite.NodeData.class)), this.impurityType$2));
                        return tuple22;
                    }
                }
                throw new MatchError(tuple2);
            }
            {
                this.impurityType$2 = impurityType$2;
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        OrderedRDDFunctions qual$2 = RDD$.MODULE$.rddToOrderedRDDFunctions(rootNodesRDD, (Ordering)Ordering.Int$.MODULE$, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(Node.class));
        boolean x$21 = qual$2.sortByKey$default$1();
        int x$22 = qual$2.sortByKey$default$2();
        Node[] rootNodes = (Node[])RDD$.MODULE$.rddToPairRDDFunctions(qual$2.sortByKey(x$21, x$22), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(Node.class), (Ordering)Ordering.Int$.MODULE$).values().collect();
        return new Tuple3((Object)metadata, Predef$.MODULE$.refArrayOps((Object[])treesMetadata).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])rootNodes), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))), (Object)treesWeights);
    }

    private EnsembleModelReadWrite$() {
        MODULE$ = this;
    }
}

