/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.graphx;

import java.io.Serializable;
import org.apache.spark.SparkException;
import org.apache.spark.graphx.Edge;
import org.apache.spark.graphx.EdgeContext;
import org.apache.spark.graphx.EdgeDirection;
import org.apache.spark.graphx.EdgeDirection$;
import org.apache.spark.graphx.EdgeTriplet;
import org.apache.spark.graphx.Graph;
import org.apache.spark.graphx.Graph$;
import org.apache.spark.graphx.Pregel$;
import org.apache.spark.graphx.TripletFields;
import org.apache.spark.graphx.VertexRDD;
import org.apache.spark.graphx.lib.ConnectedComponents$;
import org.apache.spark.graphx.lib.PageRank$;
import org.apache.spark.graphx.lib.StronglyConnectedComponents$;
import org.apache.spark.graphx.lib.TriangleCount$;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction2;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0001\teg\u0001B\u0014)\u0001EB\u0001\u0002\u0010\u0001\u0003\u0002\u0003\u0006I!\u0010\u0005\t\u001f\u0002\u0011\u0019\u0011)A\u0006!\"Aa\u000b\u0001B\u0002B\u0003-q\u000bC\u0003Y\u0001\u0011\u0005\u0011\f\u0003\u0005`\u0001!\u0015\r\u0011\"\u0001a\u0011!A\u0007\u0001#b\u0001\n\u0003\u0001\u0007\u0002\u00036\u0001\u0011\u000b\u0007I\u0011A6\t\u0011M\u0004\u0001R1A\u0005\u0002-D\u0001\"\u001e\u0001\t\u0006\u0004%\ta\u001b\u0005\u0006o\u0002!I\u0001\u001f\u0005\u0006}\u0002!\ta \u0005\b\u00033\u0001A\u0011AA\u000e\u0011\u001d\tI\u0003\u0001C\u0001\u0003WAq!!\u000f\u0001\t\u0003\tY\u0004C\u0004\u0002>\u0001!\t!a\u0010\t\u000f\u0005=\u0004\u0001\"\u0001\u0002r!I\u0011q\u0017\u0001\u0012\u0002\u0013\u0005\u0011\u0011\u0018\u0005\n\u0003;\u0004\u0011\u0013!C\u0001\u0003?Dq!!<\u0001\t\u0003\ty\u000fC\u0004\u0002r\u0002!\t!a=\t\u0013\u0005m\b!%A\u0005\u0002\u0005u\bb\u0002B\u0001\u0001\u0011\u0005!1\u0001\u0005\n\u0005\u001f\u0002\u0011\u0013!C\u0001\u0005#B\u0011B!\u0017\u0001#\u0003%\tAa\u0017\t\u000f\t\r\u0004\u0001\"\u0001\u0003f!I!q\u000f\u0001\u0012\u0002\u0013\u0005!\u0011\u0010\u0005\b\u0005{\u0002A\u0011\u0001B@\u0011%\u0011I\tAI\u0001\n\u0003\u0011I\bC\u0004\u0003\f\u0002!\tA!$\t\u0013\t-\u0006!%A\u0005\u0002\te\u0004b\u0002BW\u0001\u0011\u0005!q\u0016\u0005\n\u0005o\u0003\u0011\u0013!C\u0001\u0005sBqA!/\u0001\t\u0003\u0011Y\fC\u0005\u0003B\u0002\t\n\u0011\"\u0001\u0003z!9!1\u0019\u0001\u0005\u0002\t\u0015\u0007b\u0002Bb\u0001\u0011\u0005!\u0011\u001a\u0005\b\u0005\u001b\u0004A\u0011\u0001Bh\u0011\u001d\u0011\u0019\u000e\u0001C\u0001\u0005+\u0014\u0001b\u0012:ba\"|\u0005o\u001d\u0006\u0003S)\naa\u001a:ba\"D(BA\u0016-\u0003\u0015\u0019\b/\u0019:l\u0015\tic&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002_\u0005\u0019qN]4\u0004\u0001U\u0019!gQ'\u0014\u0007\u0001\u0019\u0014\b\u0005\u00025o5\tQGC\u00017\u0003\u0015\u00198-\u00197b\u0013\tATG\u0001\u0004B]f\u0014VM\u001a\t\u0003iiJ!aO\u001b\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\u000b\u001d\u0014\u0018\r\u001d5\u0011\tyz\u0014\tT\u0007\u0002Q%\u0011\u0001\t\u000b\u0002\u0006\u000fJ\f\u0007\u000f\u001b\t\u0003\u0005\u000ec\u0001\u0001B\u0003E\u0001\t\u0007QI\u0001\u0002W\tF\u0011a)\u0013\t\u0003i\u001dK!\u0001S\u001b\u0003\u000f9{G\u000f[5oOB\u0011AGS\u0005\u0003\u0017V\u00121!\u00118z!\t\u0011U\nB\u0003O\u0001\t\u0007QI\u0001\u0002F\t\u0006QQM^5eK:\u001cW\rJ\u0019\u0011\u0007E#\u0016)D\u0001S\u0015\t\u0019V'A\u0004sK\u001adWm\u0019;\n\u0005U\u0013&\u0001C\"mCN\u001cH+Y4\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$#\u0007E\u0002R)2\u000ba\u0001P5oSRtDC\u0001._)\rYF,\u0018\t\u0005}\u0001\tE\nC\u0003P\t\u0001\u000f\u0001\u000bC\u0003W\t\u0001\u000fq\u000bC\u0003=\t\u0001\u0007Q(\u0001\u0005ok6,EmZ3t+\u0005\t\u0007C\u0001\u001bc\u0013\t\u0019WG\u0001\u0003M_:<\u0007FA\u0003f!\t!d-\u0003\u0002hk\tIAO]1og&,g\u000e^\u0001\f]Vlg+\u001a:uS\u000e,7\u000f\u000b\u0002\u0007K\u0006I\u0011N\u001c#fOJ,Wm]\u000b\u0002YB\u0019a(\\8\n\u00059D#!\u0003,feR,\u0007P\u0015#E!\t!\u0004/\u0003\u0002rk\t\u0019\u0011J\u001c;)\u0005\u001d)\u0017AC8vi\u0012+wM]3fg\"\u0012\u0001\"Z\u0001\bI\u0016<'/Z3tQ\tIQ-\u0001\u0006eK\u001e\u0014X-Z:S\t\u0012#\"\u0001\\=\t\u000biT\u0001\u0019A>\u0002\u001b\u0015$w-\u001a#je\u0016\u001cG/[8o!\tqD0\u0003\u0002~Q\tiQ\tZ4f\t&\u0014Xm\u0019;j_:\f!cY8mY\u0016\u001cGOT3jO\"\u0014wN]%egR!\u0011\u0011AA\f!\u0011qT.a\u0001\u0011\u000bQ\n)!!\u0003\n\u0007\u0005\u001dQGA\u0003BeJ\f\u0017\u0010\u0005\u0003\u0002\f\u0005Eab\u0001 \u0002\u000e%\u0019\u0011q\u0002\u0015\u0002\u000fA\f7m[1hK&!\u00111CA\u000b\u0005!1VM\u001d;fq&#'bAA\bQ!)!p\u0003a\u0001w\u0006\u00012m\u001c7mK\u000e$h*Z5hQ\n|'o\u001d\u000b\u0005\u0003;\t9\u0003\u0005\u0003?[\u0006}\u0001#\u0002\u001b\u0002\u0006\u0005\u0005\u0002C\u0002\u001b\u0002$\u0005%\u0011)C\u0002\u0002&U\u0012a\u0001V;qY\u0016\u0014\u0004\"\u0002>\r\u0001\u0004Y\u0018\u0001D2pY2,7\r^#eO\u0016\u001cH\u0003BA\u0017\u0003o\u0001BAP7\u00020A)A'!\u0002\u00022A!a(a\rM\u0013\r\t)\u0004\u000b\u0002\u0005\u000b\u0012<W\rC\u0003{\u001b\u0001\u000710A\bsK6|g/Z*fY\u001a,EmZ3t)\u0005i\u0014\u0001\u00046pS:4VM\u001d;jG\u0016\u001cX\u0003BA!\u0003\u001f\"B!a\u0011\u0002^Q!\u0011QIA*)\ri\u0014q\t\u0005\n\u0003\u0013z\u0011\u0011!a\u0002\u0003\u0017\n!\"\u001a<jI\u0016t7-\u001a\u00134!\u0011\tF+!\u0014\u0011\u0007\t\u000by\u0005\u0002\u0004\u0002R=\u0011\r!\u0012\u0002\u0002+\"9\u0011QK\bA\u0002\u0005]\u0013aB7ba\u001a+hn\u0019\t\ni\u0005e\u0013\u0011B!\u0002N\u0005K1!a\u00176\u0005%1UO\\2uS>t7\u0007C\u0004\u0002`=\u0001\r!!\u0019\u0002\u000bQ\f'\r\\3\u0011\r\u0005\r\u0014\u0011NA7\u001b\t\t)GC\u0002\u0002h)\n1A\u001d3e\u0013\u0011\tY'!\u001a\u0003\u0007I#E\tE\u00045\u0003G\tI!!\u0014\u0002\r\u0019LG\u000e^3s+\u0019\t\u0019(a \u0002\fRA\u0011QOAH\u00037\u000bi\u000bF\u0003>\u0003o\n\u0019\tC\u0005\u0002zA\t\t\u0011q\u0001\u0002|\u0005QQM^5eK:\u001cW\r\n\u001b\u0011\tE#\u0016Q\u0010\t\u0004\u0005\u0006}DABAA!\t\u0007QIA\u0002W\tJB\u0011\"!\"\u0011\u0003\u0003\u0005\u001d!a\"\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$S\u0007\u0005\u0003R)\u0006%\u0005c\u0001\"\u0002\f\u00121\u0011Q\u0012\tC\u0002\u0015\u00131!\u0012#3\u0011\u001d\t\t\n\u0005a\u0001\u0003'\u000b!\u0002\u001d:faJ|7-Z:t!\u0019!\u0014QS\u001f\u0002\u001a&\u0019\u0011qS\u001b\u0003\u0013\u0019+hn\u0019;j_:\f\u0004C\u0002 @\u0003{\nI\tC\u0005\u0002\u001eB\u0001\n\u00111\u0001\u0002 \u0006)Q\r\u001d:fIB9A'!&\u0002\"\u0006\u001d\u0006c\u0002 \u0002$\u0006u\u0014\u0011R\u0005\u0004\u0003KC#aC#eO\u0016$&/\u001b9mKR\u00042\u0001NAU\u0013\r\tY+\u000e\u0002\b\u0005>|G.Z1o\u0011%\ty\u000b\u0005I\u0001\u0002\u0004\t\t,A\u0003waJ,G\rE\u00055\u0003g\u000bI!! \u0002(&\u0019\u0011QW\u001b\u0003\u0013\u0019+hn\u0019;j_:\u0014\u0014\u0001\u00054jYR,'\u000f\n3fM\u0006,H\u000e\u001e\u00133+\u0019\tY,!2\u0002JV\u0011\u0011Q\u0018\u0016\u0005\u0003\u007f\u000bY\rE\u00045\u0003+\u000b\t-a*\u0011\u000fy\n\u0019+a1\u0002HB\u0019!)!2\u0005\r\u0005\u0005\u0015C1\u0001F!\r\u0011\u0015\u0011\u001a\u0003\u0007\u0003\u001b\u000b\"\u0019A#,\u0005\u00055\u0007\u0003BAh\u00033l!!!5\u000b\t\u0005M\u0017Q[\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a66\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u00037\f\tNA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f\u0001CZ5mi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001a\u0016\r\u0005\u0005\u0018\u0011^Av+\t\t\u0019O\u000b\u0003\u0002f\u0006-\u0007#\u0003\u001b\u00024\u0006%\u0011q]AT!\r\u0011\u0015\u0011\u001e\u0003\u0007\u0003\u0003\u0013\"\u0019A#\u0005\r\u00055%C1\u0001F\u0003A\u0001\u0018nY6SC:$w.\u001c,feR,\u0007\u0010\u0006\u0002\u0002\n\u000592m\u001c8wKJ$Hk\\\"b]>t\u0017nY1m\u000b\u0012<Wm\u001d\u000b\u0004{\u0005U\b\"CA|)A\u0005\t\u0019AA}\u0003%iWM]4f\rVt7\r\u0005\u00045\u0003gcE\nT\u0001\"G>tg/\u001a:u)>\u001c\u0015M\\8oS\u000e\fG.\u00123hKN$C-\u001a4bk2$H%M\u000b\u0003\u0003\u007fTC!!?\u0002L\u00061\u0001O]3hK2,BA!\u0002\u0003\u0014QA!q\u0001B\"\u0005\u000f\u0012Y\u0005\u0006\u0005\u0003\n\t]!Q\u0004B\u001f)\ri$1\u0002\u0005\n\u0005\u001b1\u0012\u0011!a\u0002\u0005\u001f\t!\"\u001a<jI\u0016t7-\u001a\u00137!\u0011\tFK!\u0005\u0011\u0007\t\u0013\u0019\u0002\u0002\u0004\u0003\u0016Y\u0011\r!\u0012\u0002\u0002\u0003\"9!\u0011\u0004\fA\u0002\tm\u0011!\u0002<qe><\u0007#\u0003\u001b\u0002Z\u0005%\u0011I!\u0005B\u0011\u001d\u0011yB\u0006a\u0001\u0005C\tqa]3oI6\u001bx\rE\u00045\u0003+\u0013\u0019C!\n\u0011\u000by\n\u0019+\u0011'\u0011\r\t\u001d\"Q\u0007B\u001e\u001d\u0011\u0011ICa\r\u000f\t\t-\"\u0011G\u0007\u0003\u0005[Q1Aa\f1\u0003\u0019a$o\\8u}%\ta'C\u0002\u0002\u0010UJAAa\u000e\u0003:\tA\u0011\n^3sCR|'OC\u0002\u0002\u0010U\u0002r\u0001NA\u0012\u0003\u0013\u0011\t\u0002C\u0004\u0003@Y\u0001\rA!\u0011\u0002\u00115,'oZ3Ng\u001e\u0004\u0012\u0002NAZ\u0005#\u0011\tB!\u0005\t\u000f\t\u0015c\u00031\u0001\u0003\u0012\u0005Q\u0011N\\5uS\u0006dWj]4\t\u0011\t%c\u0003%AA\u0002=\fQ\"\\1y\u0013R,'/\u0019;j_:\u001c\b\u0002\u0003B'-A\u0005\t\u0019A>\u0002\u001f\u0005\u001cG/\u001b<f\t&\u0014Xm\u0019;j_:\f\u0001\u0003\u001d:fO\u0016dG\u0005Z3gCVdG\u000f\n\u001a\u0016\t\tM#qK\u000b\u0003\u0005+R3a\\Af\t\u0019\u0011)b\u0006b\u0001\u000b\u0006\u0001\u0002O]3hK2$C-\u001a4bk2$HeM\u000b\u0005\u0005;\u0012\t'\u0006\u0002\u0003`)\u001a10a3\u0005\r\tU\u0001D1\u0001F\u0003!\u0001\u0018mZ3SC:\\GC\u0002B4\u0005_\u0012\u0019\b\u0005\u0004?\u007f\t%$\u0011\u000e\t\u0004i\t-\u0014b\u0001B7k\t1Ai\\;cY\u0016DqA!\u001d\u001a\u0001\u0004\u0011I'A\u0002u_2D\u0011B!\u001e\u001a!\u0003\u0005\rA!\u001b\u0002\u0013I,7/\u001a;Qe>\u0014\u0017A\u00059bO\u0016\u0014\u0016M\\6%I\u00164\u0017-\u001e7uII*\"Aa\u001f+\t\t%\u00141Z\u0001\u0015a\u0016\u00148o\u001c8bY&TX\r\u001a)bO\u0016\u0014\u0016M\\6\u0015\u0011\t\u001d$\u0011\u0011BC\u0005\u000fCqAa!\u001c\u0001\u0004\tI!A\u0002te\u000eDqA!\u001d\u001c\u0001\u0004\u0011I\u0007C\u0005\u0003vm\u0001\n\u00111\u0001\u0003j\u0005q\u0002/\u001a:t_:\fG.\u001b>fIB\u000bw-\u001a*b].$C-\u001a4bk2$HeM\u0001#gR\fG/[2QCJ\fG\u000e\\3m!\u0016\u00148o\u001c8bY&TX\r\u001a)bO\u0016\u0014\u0016M\\6\u0015\u0011\t=%\u0011\u0015BS\u0005S\u0003bAP \u0003\u0012\n%\u0004\u0003\u0002BJ\u0005;k!A!&\u000b\t\t]%\u0011T\u0001\u0007Y&t\u0017\r\\4\u000b\u0007\tm%&\u0001\u0002nY&!!q\u0014BK\u0005\u00191Vm\u0019;pe\"9!1U\u000fA\u0002\u0005\r\u0011aB:pkJ\u001cWm\u001d\u0005\u0007\u0005Ok\u0002\u0019A8\u0002\u000f9,X.\u0013;fe\"I!QO\u000f\u0011\u0002\u0003\u0007!\u0011N\u0001-gR\fG/[2QCJ\fG\u000e\\3m!\u0016\u00148o\u001c8bY&TX\r\u001a)bO\u0016\u0014\u0016M\\6%I\u00164\u0017-\u001e7uIM\n!d\u001d;bi&\u001c\u0007+\u001a:t_:\fG.\u001b>fIB\u000bw-\u001a*b].$\u0002Ba\u001a\u00032\nM&Q\u0017\u0005\b\u0005\u0007{\u0002\u0019AA\u0005\u0011\u0019\u00119k\ba\u0001_\"I!QO\u0010\u0011\u0002\u0003\u0007!\u0011N\u0001%gR\fG/[2QKJ\u001cxN\\1mSj,G\rU1hKJ\u000bgn\u001b\u0013eK\u001a\fW\u000f\u001c;%g\u0005q1\u000f^1uS\u000e\u0004\u0016mZ3SC:\\GC\u0002B4\u0005{\u0013y\f\u0003\u0004\u0003(\u0006\u0002\ra\u001c\u0005\n\u0005k\n\u0003\u0013!a\u0001\u0005S\n\u0001d\u001d;bi&\u001c\u0007+Y4f%\u0006t7\u000e\n3fM\u0006,H\u000e\u001e\u00133\u0003M\u0019wN\u001c8fGR,GmQ8na>tWM\u001c;t)\t\u00119\rE\u0003?\u007f\u0005%A\n\u0006\u0003\u0003H\n-\u0007B\u0002B%I\u0001\u0007q.A\u0007ue&\fgn\u001a7f\u0007>,h\u000e\u001e\u000b\u0003\u0005#\u0004BAP p\u0019\u0006Y2\u000f\u001e:p]\u001ed\u0017pQ8o]\u0016\u001cG/\u001a3D_6\u0004xN\\3oiN$BAa2\u0003X\"1!q\u0015\u0014A\u0002=\u0004")
public class GraphOps<VD, ED>
implements scala.Serializable {
    private transient long numEdges;
    private transient long numVertices;
    private transient VertexRDD<Object> inDegrees;
    private transient VertexRDD<Object> outDegrees;
    private transient VertexRDD<Object> degrees;
    private final Graph<VD, ED> graph;
    private final ClassTag<VD> evidence$1;
    private final ClassTag<ED> evidence$2;
    private volatile transient byte bitmap$trans$0;

    private long numEdges$lzycompute() {
        GraphOps graphOps = this;
        synchronized (graphOps) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.numEdges = this.graph.edges().count();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.numEdges;
    }

    public long numEdges() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.numEdges$lzycompute() : this.numEdges;
    }

    private long numVertices$lzycompute() {
        GraphOps graphOps = this;
        synchronized (graphOps) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.numVertices = this.graph.vertices().count();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.numVertices;
    }

    public long numVertices() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.numVertices$lzycompute() : this.numVertices;
    }

    private VertexRDD<Object> inDegrees$lzycompute() {
        GraphOps graphOps = this;
        synchronized (graphOps) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                this.inDegrees = (VertexRDD)this.degreesRDD(EdgeDirection$.MODULE$.In()).setName("GraphOps.inDegrees");
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
        }
        return this.inDegrees;
    }

    public VertexRDD<Object> inDegrees() {
        return (byte)(this.bitmap$trans$0 & 4) == 0 ? this.inDegrees$lzycompute() : this.inDegrees;
    }

    private VertexRDD<Object> outDegrees$lzycompute() {
        GraphOps graphOps = this;
        synchronized (graphOps) {
            if ((byte)(this.bitmap$trans$0 & 8) == 0) {
                this.outDegrees = (VertexRDD)this.degreesRDD(EdgeDirection$.MODULE$.Out()).setName("GraphOps.outDegrees");
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 8);
            }
        }
        return this.outDegrees;
    }

    public VertexRDD<Object> outDegrees() {
        return (byte)(this.bitmap$trans$0 & 8) == 0 ? this.outDegrees$lzycompute() : this.outDegrees;
    }

    private VertexRDD<Object> degrees$lzycompute() {
        GraphOps graphOps = this;
        synchronized (graphOps) {
            if ((byte)(this.bitmap$trans$0 & 0x10) == 0) {
                this.degrees = (VertexRDD)this.degreesRDD(EdgeDirection$.MODULE$.Either()).setName("GraphOps.degrees");
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 0x10);
            }
        }
        return this.degrees;
    }

    public VertexRDD<Object> degrees() {
        return (byte)(this.bitmap$trans$0 & 0x10) == 0 ? this.degrees$lzycompute() : this.degrees;
    }

    private VertexRDD<Object> degreesRDD(EdgeDirection edgeDirection) {
        VertexRDD<Object> vertexRDD;
        EdgeDirection edgeDirection2 = edgeDirection;
        EdgeDirection edgeDirection3 = EdgeDirection$.MODULE$.In();
        if (!(edgeDirection2 != null ? !((Object)edgeDirection2).equals(edgeDirection3) : edgeDirection3 != null)) {
            vertexRDD = this.graph.aggregateMessages((Function1 & Serializable & scala.Serializable)x$1 -> {
                x$1.sendToDst(BoxesRunTime.boxToInteger((int)1));
                return BoxedUnit.UNIT;
            }, (JFunction2.mcIII.sp & Serializable & scala.Serializable)(x$2, x$3) -> x$2 + x$3, TripletFields.None, ClassTag$.MODULE$.Int());
        } else {
            EdgeDirection edgeDirection4 = edgeDirection;
            EdgeDirection edgeDirection5 = EdgeDirection$.MODULE$.Out();
            vertexRDD = !(edgeDirection4 != null ? !((Object)edgeDirection4).equals(edgeDirection5) : edgeDirection5 != null) ? this.graph.aggregateMessages((Function1 & Serializable & scala.Serializable)x$4 -> {
                x$4.sendToSrc(BoxesRunTime.boxToInteger((int)1));
                return BoxedUnit.UNIT;
            }, (JFunction2.mcIII.sp & Serializable & scala.Serializable)(x$5, x$6) -> x$5 + x$6, TripletFields.None, ClassTag$.MODULE$.Int()) : this.graph.aggregateMessages((Function1 & Serializable & scala.Serializable)ctx -> {
                GraphOps.$anonfun$degreesRDD$5(ctx);
                return BoxedUnit.UNIT;
            }, (JFunction2.mcIII.sp & Serializable & scala.Serializable)(x$7, x$8) -> x$7 + x$8, TripletFields.None, ClassTag$.MODULE$.Int());
        }
        return vertexRDD;
    }

    public VertexRDD<long[]> collectNeighborIds(EdgeDirection edgeDirection) {
        VertexRDD vertexRDD;
        EdgeDirection edgeDirection2 = edgeDirection;
        EdgeDirection edgeDirection3 = EdgeDirection$.MODULE$.Either();
        if (!(edgeDirection2 != null ? !((Object)edgeDirection2).equals(edgeDirection3) : edgeDirection3 != null)) {
            vertexRDD = this.graph.aggregateMessages((Function1 & Serializable & scala.Serializable)ctx -> {
                GraphOps.$anonfun$collectNeighborIds$1(ctx);
                return BoxedUnit.UNIT;
            }, (Function2 & Serializable & scala.Serializable)(x$9, x$10) -> (long[])new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(x$9)).$plus$plus((GenTraversableOnce)new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(x$10)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Long.TYPE))), TripletFields.None, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Long.TYPE)));
        } else {
            EdgeDirection edgeDirection4 = edgeDirection;
            EdgeDirection edgeDirection5 = EdgeDirection$.MODULE$.Out();
            if (!(edgeDirection4 != null ? !((Object)edgeDirection4).equals(edgeDirection5) : edgeDirection5 != null)) {
                vertexRDD = this.graph.aggregateMessages((Function1 & Serializable & scala.Serializable)ctx -> {
                    ctx.sendToSrc(new long[]{ctx.dstId()});
                    return BoxedUnit.UNIT;
                }, (Function2 & Serializable & scala.Serializable)(x$11, x$12) -> (long[])new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(x$11)).$plus$plus((GenTraversableOnce)new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(x$12)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Long.TYPE))), TripletFields.None, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Long.TYPE)));
            } else {
                EdgeDirection edgeDirection6 = edgeDirection;
                EdgeDirection edgeDirection7 = EdgeDirection$.MODULE$.In();
                if (!(edgeDirection6 != null ? !((Object)edgeDirection6).equals(edgeDirection7) : edgeDirection7 != null)) {
                    vertexRDD = this.graph.aggregateMessages((Function1 & Serializable & scala.Serializable)ctx -> {
                        ctx.sendToDst(new long[]{ctx.srcId()});
                        return BoxedUnit.UNIT;
                    }, (Function2 & Serializable & scala.Serializable)(x$13, x$14) -> (long[])new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(x$13)).$plus$plus((GenTraversableOnce)new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(x$14)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Long.TYPE))), TripletFields.None, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Long.TYPE)));
                } else {
                    throw new SparkException("It doesn't make sense to collect neighbor ids without a direction. (EdgeDirection.Both is not supported; use EdgeDirection.Either instead.)");
                }
            }
        }
        VertexRDD nbrs = vertexRDD;
        return this.graph.vertices().leftZipJoin(nbrs, (Function3 & Serializable & scala.Serializable)(vid, vdata, nbrsOpt) -> GraphOps.$anonfun$collectNeighborIds$7(BoxesRunTime.unboxToLong((Object)vid), vdata, nbrsOpt), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Long.TYPE)), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Long.TYPE)));
    }

    public VertexRDD<Tuple2<Object, VD>[]> collectNeighbors(EdgeDirection edgeDirection) {
        VertexRDD vertexRDD;
        EdgeDirection edgeDirection2 = edgeDirection;
        EdgeDirection edgeDirection3 = EdgeDirection$.MODULE$.Either();
        EdgeDirection edgeDirection4 = edgeDirection2;
        if (!(edgeDirection3 != null ? !((Object)edgeDirection3).equals(edgeDirection4) : edgeDirection4 != null)) {
            vertexRDD = this.graph.aggregateMessages((Function1 & Serializable & scala.Serializable)ctx -> {
                GraphOps.$anonfun$collectNeighbors$1(ctx);
                return BoxedUnit.UNIT;
            }, (Function2 & Serializable & scala.Serializable)(a, b) -> (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])a)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])b)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))), TripletFields.All, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Tuple2.class)));
        } else {
            EdgeDirection edgeDirection5 = EdgeDirection$.MODULE$.In();
            EdgeDirection edgeDirection6 = edgeDirection2;
            if (!(edgeDirection5 != null ? !((Object)edgeDirection5).equals(edgeDirection6) : edgeDirection6 != null)) {
                vertexRDD = this.graph.aggregateMessages((Function1 & Serializable & scala.Serializable)ctx -> {
                    ctx.sendToDst((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToLong((long)ctx.srcId()), ctx.srcAttr())});
                    return BoxedUnit.UNIT;
                }, (Function2 & Serializable & scala.Serializable)(a, b) -> (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])a)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])b)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))), TripletFields.Src, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Tuple2.class)));
            } else {
                EdgeDirection edgeDirection7 = EdgeDirection$.MODULE$.Out();
                EdgeDirection edgeDirection8 = edgeDirection2;
                if (!(edgeDirection7 != null ? !((Object)edgeDirection7).equals(edgeDirection8) : edgeDirection8 != null)) {
                    vertexRDD = this.graph.aggregateMessages((Function1 & Serializable & scala.Serializable)ctx -> {
                        ctx.sendToSrc((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToLong((long)ctx.dstId()), ctx.dstAttr())});
                        return BoxedUnit.UNIT;
                    }, (Function2 & Serializable & scala.Serializable)(a, b) -> (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])a)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])b)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))), TripletFields.Dst, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Tuple2.class)));
                } else {
                    EdgeDirection edgeDirection9 = EdgeDirection$.MODULE$.Both();
                    EdgeDirection edgeDirection10 = edgeDirection2;
                    if (!(edgeDirection9 != null ? !((Object)edgeDirection9).equals(edgeDirection10) : edgeDirection10 != null)) {
                        throw new SparkException("collectEdges does not support EdgeDirection.Both. UseEdgeDirection.Either instead.");
                    }
                    throw new MatchError((Object)edgeDirection2);
                }
            }
        }
        VertexRDD nbrs = vertexRDD;
        return this.graph.vertices().leftJoin(nbrs, (Function3 & Serializable & scala.Serializable)(vid, vdata, nbrsOpt) -> GraphOps.$anonfun$collectNeighbors$7(BoxesRunTime.unboxToLong((Object)vid), vdata, nbrsOpt), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Tuple2.class)), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Tuple2.class)));
    }

    public VertexRDD<Edge<ED>[]> collectEdges(EdgeDirection edgeDirection) {
        VertexRDD<Object> vertexRDD;
        EdgeDirection edgeDirection2 = edgeDirection;
        EdgeDirection edgeDirection3 = EdgeDirection$.MODULE$.Either();
        EdgeDirection edgeDirection4 = edgeDirection2;
        if (!(edgeDirection3 != null ? !((Object)edgeDirection3).equals(edgeDirection4) : edgeDirection4 != null)) {
            vertexRDD = this.graph.aggregateMessages((Function1 & Serializable & scala.Serializable)ctx -> {
                GraphOps.$anonfun$collectEdges$1(ctx);
                return BoxedUnit.UNIT;
            }, (Function2 & Serializable & scala.Serializable)(a, b) -> (Edge[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])a)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])b)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Edge.class))), TripletFields.EdgeOnly, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Edge.class)));
        } else {
            EdgeDirection edgeDirection5 = EdgeDirection$.MODULE$.In();
            EdgeDirection edgeDirection6 = edgeDirection2;
            if (!(edgeDirection5 != null ? !((Object)edgeDirection5).equals(edgeDirection6) : edgeDirection6 != null)) {
                vertexRDD = this.graph.aggregateMessages((Function1 & Serializable & scala.Serializable)ctx -> {
                    ctx.sendToDst((Object[])new Edge[]{new Edge(ctx.srcId(), ctx.dstId(), ctx.attr())});
                    return BoxedUnit.UNIT;
                }, (Function2 & Serializable & scala.Serializable)(a, b) -> (Edge[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])a)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])b)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Edge.class))), TripletFields.EdgeOnly, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Edge.class)));
            } else {
                EdgeDirection edgeDirection7 = EdgeDirection$.MODULE$.Out();
                EdgeDirection edgeDirection8 = edgeDirection2;
                if (!(edgeDirection7 != null ? !((Object)edgeDirection7).equals(edgeDirection8) : edgeDirection8 != null)) {
                    vertexRDD = this.graph.aggregateMessages((Function1 & Serializable & scala.Serializable)ctx -> {
                        ctx.sendToSrc((Object[])new Edge[]{new Edge(ctx.srcId(), ctx.dstId(), ctx.attr())});
                        return BoxedUnit.UNIT;
                    }, (Function2 & Serializable & scala.Serializable)(a, b) -> (Edge[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])a)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])b)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Edge.class))), TripletFields.EdgeOnly, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Edge.class)));
                } else {
                    EdgeDirection edgeDirection9 = EdgeDirection$.MODULE$.Both();
                    EdgeDirection edgeDirection10 = edgeDirection2;
                    if (!(edgeDirection9 != null ? !((Object)edgeDirection9).equals(edgeDirection10) : edgeDirection10 != null)) {
                        throw new SparkException("collectEdges does not support EdgeDirection.Both. UseEdgeDirection.Either instead.");
                    }
                    throw new MatchError((Object)edgeDirection2);
                }
            }
        }
        return vertexRDD;
    }

    public Graph<VD, ED> removeSelfEdges() {
        return this.graph.subgraph((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToBoolean((boolean)GraphOps.$anonfun$removeSelfEdges$1(e)), this.graph.subgraph$default$2());
    }

    public <U> Graph<VD, ED> joinVertices(RDD<Tuple2<Object, U>> table, Function3<Object, VD, U, VD> mapFunc, ClassTag<U> evidence$3) {
        Function3 & Serializable & scala.Serializable uf = (Function3 & Serializable & scala.Serializable)(id, data, o) -> GraphOps.$anonfun$joinVertices$1(mapFunc, BoxesRunTime.unboxToLong((Object)id), data, o);
        return this.graph.outerJoinVertices(table, uf, evidence$3, this.evidence$1, Predef.$eq$colon$eq$.MODULE$.tpEquals());
    }

    public <VD2, ED2> Graph<VD, ED> filter(Function1<Graph<VD, ED>, Graph<VD2, ED2>> preprocess, Function1<EdgeTriplet<VD2, ED2>, Object> epred, Function2<Object, VD2, Object> vpred, ClassTag<VD2> evidence$4, ClassTag<ED2> evidence$5) {
        return this.graph.mask(((Graph)preprocess.apply(this.graph)).subgraph(epred, vpred), evidence$4, evidence$5);
    }

    public <VD2, ED2> Function1<EdgeTriplet<VD2, ED2>, Object> filter$default$2() {
        return (Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)GraphOps.$anonfun$filter$default$2$1(x));
    }

    public <VD2, ED2> Function2<Object, VD2, Object> filter$default$3() {
        return (Function2 & Serializable & scala.Serializable)(v, d) -> BoxesRunTime.boxToBoolean((boolean)GraphOps.$anonfun$filter$default$3$1(BoxesRunTime.unboxToLong((Object)v), d));
    }

    public long pickRandomVertex() {
        double probability = 50.0 / (double)Graph$.MODULE$.graphToGraphOps(this.graph, this.evidence$1, this.evidence$2).numVertices();
        boolean found = false;
        long retVal = BoxesRunTime.unboxToLong(null);
        while (!found) {
            RDD selectedVertices = this.graph.vertices().flatMap((Function1 & Serializable & scala.Serializable)vidVvals -> Random$.MODULE$.nextDouble() < probability ? Option$.MODULE$.option2Iterable((Option)new Some((Object)BoxesRunTime.boxToLong((long)vidVvals._1$mcJ$sp()))) : Option$.MODULE$.option2Iterable((Option)None$.MODULE$), ClassTag$.MODULE$.apply(Long.TYPE));
            if (selectedVertices.count() <= 0L) continue;
            found = true;
            long[] collectedVertices = (long[])selectedVertices.collect();
            retVal = collectedVertices[Random$.MODULE$.nextInt(collectedVertices.length)];
        }
        return retVal;
    }

    public Graph<VD, ED> convertToCanonicalEdges(Function2<ED, ED, ED> mergeFunc) {
        RDD newEdges = RDD$.MODULE$.rddToPairRDDFunctions(this.graph.edges().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Edge edge = x0$1;
            Tuple2 tuple2 = edge.srcId() < edge.dstId() ? new Tuple2((Object)new Tuple2.mcJJ.sp(edge.srcId(), edge.dstId()), edge.attr()) : new Tuple2((Object)new Tuple2.mcJJ.sp(edge.dstId(), edge.srcId()), edge.attr());
            return tuple2;
        }, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(Tuple2.class), this.evidence$2, Ordering$.MODULE$.Tuple2((Ordering)Ordering.Long$.MODULE$, (Ordering)Ordering.Long$.MODULE$)).reduceByKey(mergeFunc).map((Function1 & Serializable & scala.Serializable)e -> new Edge<Object>(((Tuple2)e._1())._1$mcJ$sp(), ((Tuple2)e._1())._2$mcJ$sp(), e._2()), ClassTag$.MODULE$.apply(Edge.class));
        return Graph$.MODULE$.apply(this.graph.vertices(), newEdges, Graph$.MODULE$.apply$default$3(), Graph$.MODULE$.apply$default$4(), Graph$.MODULE$.apply$default$5(), this.evidence$1, this.evidence$2);
    }

    public Function2<ED, ED, ED> convertToCanonicalEdges$default$1() {
        return (Function2 & Serializable & scala.Serializable)(e1, e2) -> e1;
    }

    public <A> Graph<VD, ED> pregel(A initialMsg, int maxIterations, EdgeDirection activeDirection, Function3<Object, VD, A, VD> vprog, Function1<EdgeTriplet<VD, ED>, Iterator<Tuple2<Object, A>>> sendMsg, Function2<A, A, A> mergeMsg, ClassTag<A> evidence$6) {
        return Pregel$.MODULE$.apply(this.graph, initialMsg, maxIterations, activeDirection, vprog, sendMsg, mergeMsg, this.evidence$1, this.evidence$2, evidence$6);
    }

    public <A> int pregel$default$2() {
        return Integer.MAX_VALUE;
    }

    public <A> EdgeDirection pregel$default$3() {
        return EdgeDirection$.MODULE$.Either();
    }

    public Graph<Object, Object> pageRank(double tol, double resetProb) {
        return PageRank$.MODULE$.runUntilConvergence(this.graph, tol, resetProb, this.evidence$1, this.evidence$2);
    }

    public double pageRank$default$2() {
        return 0.15;
    }

    public Graph<Object, Object> personalizedPageRank(long src, double tol, double resetProb) {
        return PageRank$.MODULE$.runUntilConvergenceWithOptions(this.graph, tol, resetProb, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)src)), this.evidence$1, this.evidence$2);
    }

    public double personalizedPageRank$default$3() {
        return 0.15;
    }

    public Graph<Vector, Object> staticParallelPersonalizedPageRank(long[] sources, int numIter, double resetProb) {
        return PageRank$.MODULE$.runParallelPersonalizedPageRank(this.graph, numIter, resetProb, sources, this.evidence$1, this.evidence$2);
    }

    public double staticParallelPersonalizedPageRank$default$3() {
        return 0.15;
    }

    public Graph<Object, Object> staticPersonalizedPageRank(long src, int numIter, double resetProb) {
        return PageRank$.MODULE$.runWithOptions(this.graph, numIter, resetProb, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)src)), this.evidence$1, this.evidence$2);
    }

    public double staticPersonalizedPageRank$default$3() {
        return 0.15;
    }

    public Graph<Object, Object> staticPageRank(int numIter, double resetProb) {
        return PageRank$.MODULE$.run(this.graph, numIter, resetProb, this.evidence$1, this.evidence$2);
    }

    public double staticPageRank$default$2() {
        return 0.15;
    }

    public Graph<Object, ED> connectedComponents() {
        return ConnectedComponents$.MODULE$.run(this.graph, this.evidence$1, this.evidence$2);
    }

    public Graph<Object, ED> connectedComponents(int maxIterations) {
        return ConnectedComponents$.MODULE$.run(this.graph, maxIterations, this.evidence$1, this.evidence$2);
    }

    public Graph<Object, ED> triangleCount() {
        return TriangleCount$.MODULE$.run(this.graph, this.evidence$1, this.evidence$2);
    }

    public Graph<Object, ED> stronglyConnectedComponents(int numIter) {
        return StronglyConnectedComponents$.MODULE$.run(this.graph, numIter, this.evidence$1, this.evidence$2);
    }

    public static final /* synthetic */ void $anonfun$degreesRDD$5(EdgeContext ctx) {
        ctx.sendToSrc(BoxesRunTime.boxToInteger((int)1));
        ctx.sendToDst(BoxesRunTime.boxToInteger((int)1));
    }

    public static final /* synthetic */ void $anonfun$collectNeighborIds$1(EdgeContext ctx) {
        ctx.sendToSrc(new long[]{ctx.dstId()});
        ctx.sendToDst(new long[]{ctx.srcId()});
    }

    public static final /* synthetic */ long[] $anonfun$collectNeighborIds$7(long vid, Object vdata, Option nbrsOpt) {
        return (long[])nbrsOpt.getOrElse((Function0 & Serializable & scala.Serializable)() -> (long[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Long.TYPE)));
    }

    public static final /* synthetic */ void $anonfun$collectNeighbors$1(EdgeContext ctx) {
        ctx.sendToSrc((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToLong((long)ctx.dstId()), ctx.dstAttr())});
        ctx.sendToDst((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToLong((long)ctx.srcId()), ctx.srcAttr())});
    }

    public static final /* synthetic */ Tuple2[] $anonfun$collectNeighbors$7(long vid, Object vdata, Option nbrsOpt) {
        return (Tuple2[])nbrsOpt.getOrElse((Function0 & Serializable & scala.Serializable)() -> (Tuple2[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Tuple2.class)));
    }

    public static final /* synthetic */ void $anonfun$collectEdges$1(EdgeContext ctx) {
        ctx.sendToSrc((Object[])new Edge[]{new Edge(ctx.srcId(), ctx.dstId(), ctx.attr())});
        ctx.sendToDst((Object[])new Edge[]{new Edge(ctx.srcId(), ctx.dstId(), ctx.attr())});
    }

    public static final /* synthetic */ boolean $anonfun$removeSelfEdges$1(EdgeTriplet e) {
        return e.srcId() != e.dstId();
    }

    public static final /* synthetic */ Object $anonfun$joinVertices$1(Function3 mapFunc$1, long id, Object data, Option o) {
        Object object;
        Option option = o;
        if (option instanceof Some) {
            Some some = (Some)option;
            Object u = some.value();
            object = mapFunc$1.apply((Object)BoxesRunTime.boxToLong((long)id), data, u);
        } else if (None$.MODULE$.equals(option)) {
            object = data;
        } else {
            throw new MatchError((Object)option);
        }
        return object;
    }

    public static final /* synthetic */ boolean $anonfun$filter$default$2$1(EdgeTriplet x) {
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$filter$default$3$1(long v, Object d) {
        return true;
    }

    public GraphOps(Graph<VD, ED> graph, ClassTag<VD> evidence$1, ClassTag<ED> evidence$2) {
        this.graph = graph;
        this.evidence$1 = evidence$1;
        this.evidence$2 = evidence$2;
    }
}

