/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.types;

import java.io.File;
import java.io.Serializable;
import java.time.ZoneId;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.catalyst.plans.SQLHelper;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001=2A\u0001C\u0005\u0001)!)\u0011\u0005\u0001C\u0001E!9Q\u0005\u0001b\u0001\n\u00131\u0003B\u0002\u0016\u0001A\u0003%q\u0005C\u0004,\u0001\t\u0007I\u0011\u0002\u0014\t\r1\u0002\u0001\u0015!\u0003(\u0011\u001di\u0003A1A\u0005\n\u0019BaA\f\u0001!\u0002\u00139#aD*ueV\u001cG\u000fV=qKN+\u0018\u000e^3\u000b\u0005)Y\u0011!\u0002;za\u0016\u001c(B\u0001\u0007\u000e\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u001d=\tQa\u001d9be.T!\u0001E\t\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0011\u0012aA8sO\u000e\u00011c\u0001\u0001\u00163A\u0011acF\u0007\u0002\u001b%\u0011\u0001$\u0004\u0002\u000e'B\f'o\u001b$v]N+\u0018\u000e^3\u0011\u0005iyR\"A\u000e\u000b\u0005qi\u0012!\u00029mC:\u001c(B\u0001\u0010\f\u0003!\u0019\u0017\r^1msN$\u0018B\u0001\u0011\u001c\u0005%\u0019\u0016\u000b\u0014%fYB,'/\u0001\u0004=S:LGO\u0010\u000b\u0002GA\u0011A\u0005A\u0007\u0002\u0013\u0005\t1/F\u0001(!\t!\u0003&\u0003\u0002*\u0013\tQ1\u000b\u001e:vGR$\u0016\u0010]3\u0002\u0005M\u0004\u0013\u0001\u00048fgR,Gm\u0015;sk\u000e$\u0018!\u00048fgR,Gm\u0015;sk\u000e$\b%A\u000btiJ,8\r^,ji\",U\u000e\u001d;z'R\u0014\u0018N\\4\u0002-M$(/^2u/&$\b.R7qif\u001cFO]5oO\u0002\u0002")
public class StructTypeSuite
extends SparkFunSuite
implements SQLHelper {
    private final StructType s;
    private final StructType nestedStruct;
    private final StructType structWithEmptyString;
    private String sparkHome;
    private volatile boolean bitmap$0;

    @Override
    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        SQLHelper.withSQLConf$(this, pairs, f);
    }

    @Override
    public void withTempPath(Function1<File, BoxedUnit> f) {
        SQLHelper.withTempPath$(this, f);
    }

    @Override
    public <T> void testSpecialDatetimeValues(Function1<ZoneId, T> test) {
        SQLHelper.testSpecialDatetimeValues$(this, test);
    }

    private String sparkHome$lzycompute() {
        StructTypeSuite structTypeSuite = this;
        synchronized (structTypeSuite) {
            if (!this.bitmap$0) {
                this.sparkHome = SQLHelper.sparkHome$(this);
                this.bitmap$0 = true;
            }
        }
        return this.sparkHome;
    }

    @Override
    public String sparkHome() {
        return !this.bitmap$0 ? this.sparkHome$lzycompute() : this.sparkHome;
    }

    private StructType s() {
        return this.s;
    }

    private StructType nestedStruct() {
        return this.nestedStruct;
    }

    private StructType structWithEmptyString() {
        return this.structWithEmptyString;
    }

    public StructTypeSuite() {
        SQLHelper.$init$(this);
        this.s = StructType$.MODULE$.fromDDL("a INT, b STRING");
        this.test("lookup a single missing field should output existing fields", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            String e;
            String $org_scalatest_assert_macro_left = e = ((Throwable)this.intercept((Function0 & Serializable & scala.Serializable)() -> this.s().apply("c"), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 30))).getMessage();
            String $org_scalatest_assert_macro_right = "Available: a, b";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 31));
        }, new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 29));
        this.test("lookup a set of missing fields should output existing fields", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            String e;
            String $org_scalatest_assert_macro_left = e = ((Throwable)this.intercept((Function0 & Serializable & scala.Serializable)() -> this.s().apply((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "c"}))), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 35))).getMessage();
            String $org_scalatest_assert_macro_right = "Available: a, b";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 36));
        }, new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 34));
        this.test("lookup fieldIndex for missing field should output existing fields", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            String e;
            String $org_scalatest_assert_macro_left = e = ((Throwable)this.intercept((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> this.s().fieldIndex("c"), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 40))).getMessage();
            String $org_scalatest_assert_macro_right = "Available: a, b";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 41));
        }, new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 39));
        this.test("SPARK-24849: toDDL - simple struct", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            StructType struct = StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("a", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())})));
            String $org_scalatest_assert_macro_left = struct.toDDL();
            String $org_scalatest_assert_macro_right = "`a` INT";
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 47));
        }, new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 44));
        this.test("SPARK-24849: round trip toDDL - fromDDL", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            StructType struct = new StructType().add("a", (DataType)IntegerType$.MODULE$).add("b", (DataType)StringType$.MODULE$);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(StructType$.MODULE$.fromDDL(struct.toDDL()));
            StructType $org_scalatest_assert_macro_right = struct;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 53));
        }, new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 50));
        this.test("SPARK-24849: round trip fromDDL - toDDL", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            String struct = "`a` MAP<INT, STRING>,`b` INT";
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(StructType$.MODULE$.fromDDL(struct).toDDL());
            String $org_scalatest_assert_macro_right = struct;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 59));
        }, new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 56));
        this.test("SPARK-24849: toDDL must take into account case of fields.", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            StructType struct = new StructType().add("metaData", (DataType)new StructType().add("eventId", (DataType)StringType$.MODULE$));
            String $org_scalatest_assert_macro_left = struct.toDDL();
            String $org_scalatest_assert_macro_right = "`metaData` STRUCT<`eventId`: STRING>";
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 66));
        }, new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 62));
        this.test("SPARK-24849: toDDL should output field's comment", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            StructType struct = StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("b", (DataType)BooleanType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()).withComment("Field's comment")})));
            String $org_scalatest_assert_macro_left = struct.toDDL();
            String $org_scalatest_assert_macro_right = "`b` BOOLEAN COMMENT 'Field\\'s comment'";
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 73));
        }, new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 69));
        this.nestedStruct = new StructType().add(new StructField("a", (DataType)new StructType().add(new StructField("b", (DataType)new StructType().add(new StructField("c", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()).withComment("Deep Nested comment")), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()).withComment("Nested comment")), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()).withComment("comment"));
        this.test("SPARK-33846: toDDL should output nested field's comment", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            String ddl = "`a` STRUCT<`b`: STRUCT<`c`: STRING COMMENT 'Deep Nested comment'> COMMENT 'Nested comment'> COMMENT 'comment'";
            String $org_scalatest_assert_macro_left = this.nestedStruct().toDDL();
            String $org_scalatest_assert_macro_right = ddl;
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 87));
        }, new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 84));
        this.test("SPARK-33846: fromDDL should parse nested field's comment", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            String ddl = "`a` STRUCT<`b`: STRUCT<`c`: STRING COMMENT 'Deep Nested comment'> COMMENT 'Nested comment'> COMMENT 'comment'";
            StructType $org_scalatest_assert_macro_left = StructType$.MODULE$.fromDDL(ddl);
            StructType $org_scalatest_assert_macro_right = this.nestedStruct();
            StructType structType = $org_scalatest_assert_macro_left;
            StructType structType2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 93));
        }, new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 90));
        this.test("SPARK-33846: round trip toDDL -> fromDDL - nested struct", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            StructType $org_scalatest_assert_macro_left = StructType$.MODULE$.fromDDL(this.nestedStruct().toDDL());
            StructType $org_scalatest_assert_macro_right = this.nestedStruct();
            StructType structType = $org_scalatest_assert_macro_left;
            StructType structType2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 97));
        }, new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 96));
        this.structWithEmptyString = new StructType().add(new StructField("a b", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()).withComment("comment"));
        this.test("SPARK-33846: empty string in a column's name should be respected by toDDL", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            String ddl = "`a b` STRING COMMENT 'comment'";
            String $org_scalatest_assert_macro_left = this.structWithEmptyString().toDDL();
            String $org_scalatest_assert_macro_right = ddl;
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 106));
        }, new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 103));
        this.test("SPARK-33846: empty string in a column's name should be respected by fromDDL", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            String ddl = "`a b` STRING COMMENT 'comment'";
            StructType $org_scalatest_assert_macro_left = StructType$.MODULE$.fromDDL(ddl);
            StructType $org_scalatest_assert_macro_right = this.structWithEmptyString();
            StructType structType = $org_scalatest_assert_macro_left;
            StructType structType2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 112));
        }, new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 109));
        this.test("Print up to the given level", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            StructType schema = StructType$.MODULE$.fromDDL("c1 INT, c2 STRUCT<c3: INT, c4: STRUCT<c5: INT, c6: INT>>");
            int $org_scalatest_assert_macro_left = 5;
            int $org_scalatest_assert_macro_right = schema.treeString(2).split("\n").length;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 119));
            int $org_scalatest_assert_macro_left2 = 3;
            int $org_scalatest_assert_macro_right2 = schema.treeString(1).split("\n").length;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 120));
            int $org_scalatest_assert_macro_left3 = 7;
            int $org_scalatest_assert_macro_right3 = schema.treeString().split("\n").length;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 == $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 121));
            int $org_scalatest_assert_macro_left4 = 7;
            int $org_scalatest_assert_macro_right4 = schema.treeString(0).split("\n").length;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4 == $org_scalatest_assert_macro_right4, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 122));
            int $org_scalatest_assert_macro_left5 = 7;
            int $org_scalatest_assert_macro_right5 = schema.treeString(-1).split("\n").length;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left5), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5 == $org_scalatest_assert_macro_right5, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 123));
            StructType schema2 = StructType$.MODULE$.fromDDL("c1 INT, c2 ARRAY<STRUCT<c3: INT>>, c4 STRUCT<c5: INT, c6: ARRAY<ARRAY<INT>>>");
            int $org_scalatest_assert_macro_left6 = 4;
            int $org_scalatest_assert_macro_right6 = schema2.treeString(1).split("\n").length;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left6), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6 == $org_scalatest_assert_macro_right6, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 127));
            int $org_scalatest_assert_macro_left7 = 7;
            int $org_scalatest_assert_macro_right7 = schema2.treeString(2).split("\n").length;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left7), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left7 == $org_scalatest_assert_macro_right7, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 128));
            int $org_scalatest_assert_macro_left8 = 9;
            int $org_scalatest_assert_macro_right8 = schema2.treeString(3).split("\n").length;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left8), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right8), $org_scalatest_assert_macro_left8 == $org_scalatest_assert_macro_right8, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 129));
            int $org_scalatest_assert_macro_left9 = 10;
            int $org_scalatest_assert_macro_right9 = schema2.treeString(4).split("\n").length;
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left9), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right9), $org_scalatest_assert_macro_left9 == $org_scalatest_assert_macro_right9, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 130));
            int $org_scalatest_assert_macro_left10 = 10;
            int $org_scalatest_assert_macro_right10 = schema2.treeString(0).split("\n").length;
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left10), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right10), $org_scalatest_assert_macro_left10 == $org_scalatest_assert_macro_right10, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 131));
            StructType schema3 = StructType$.MODULE$.fromDDL("c1 MAP<INT, STRUCT<c2: MAP<INT, INT>>>, c3 STRUCT<c4: MAP<INT, MAP<INT, INT>>>");
            int $org_scalatest_assert_macro_left11 = 3;
            int $org_scalatest_assert_macro_right11 = schema3.treeString(1).split("\n").length;
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left11), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right11), $org_scalatest_assert_macro_left11 == $org_scalatest_assert_macro_right11, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 135));
            int $org_scalatest_assert_macro_left12 = 6;
            int $org_scalatest_assert_macro_right12 = schema3.treeString(2).split("\n").length;
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left12), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right12), $org_scalatest_assert_macro_left12 == $org_scalatest_assert_macro_right12, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 136));
            int $org_scalatest_assert_macro_left13 = 9;
            int $org_scalatest_assert_macro_right13 = schema3.treeString(3).split("\n").length;
            Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left13), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right13), $org_scalatest_assert_macro_left13 == $org_scalatest_assert_macro_right13, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 137));
            int $org_scalatest_assert_macro_left14 = 13;
            int $org_scalatest_assert_macro_right14 = schema3.treeString(4).split("\n").length;
            Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left14), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right14), $org_scalatest_assert_macro_left14 == $org_scalatest_assert_macro_right14, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 138));
            int $org_scalatest_assert_macro_left15 = 13;
            int $org_scalatest_assert_macro_right15 = schema3.treeString(0).split("\n").length;
            Bool $org_scalatest_assert_macro_expr15 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left15), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right15), $org_scalatest_assert_macro_left15 == $org_scalatest_assert_macro_right15, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr15, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 139));
        }, new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 115));
        this.test("interval keyword in schema string", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            String interval = "`a` INTERVAL";
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(StructType$.MODULE$.fromDDL(interval).toDDL());
            String $org_scalatest_assert_macro_right = interval;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 144));
        }, new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 142));
        this.test("find missing (nested) fields", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            StructType schema = StructType$.MODULE$.fromDDL("c1 INT, c2 STRUCT<c3: INT, c4: STRUCT<c5: INT, c6: INT>>");
            Function2 resolver = SQLConf$.MODULE$.get().resolver();
            StructType source1 = StructType$.MODULE$.fromDDL("c1 INT");
            StructType missing1 = StructType$.MODULE$.fromDDL("c2 STRUCT<c3: INT, c4: STRUCT<c5: INT, c6: INT>>");
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(StructType$.MODULE$.findMissingFields(source1, schema, resolver).exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.sameType((DataType)missing1))), "StructType.findMissingFields(source1, schema, resolver).exists(((x$1: org.apache.spark.sql.types.StructType) => x$1.sameType(missing1)))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 153));
            StructType source2 = StructType$.MODULE$.fromDDL("c1 INT, c3 STRING");
            StructType missing2 = StructType$.MODULE$.fromDDL("c2 STRUCT<c3: INT, c4: STRUCT<c5: INT, c6: INT>>");
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(StructType$.MODULE$.findMissingFields(source2, schema, resolver).exists((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.sameType((DataType)missing2))), "StructType.findMissingFields(source2, schema, resolver).exists(((x$2: org.apache.spark.sql.types.StructType) => x$2.sameType(missing2)))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 158));
            StructType source3 = StructType$.MODULE$.fromDDL("c1 INT, c2 STRUCT<c3: INT>");
            StructType missing3 = StructType$.MODULE$.fromDDL("c2 STRUCT<c4: STRUCT<c5: INT, c6: INT>>");
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(StructType$.MODULE$.findMissingFields(source3, schema, resolver).exists((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.sameType((DataType)missing3))), "StructType.findMissingFields(source3, schema, resolver).exists(((x$3: org.apache.spark.sql.types.StructType) => x$3.sameType(missing3)))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 163));
            StructType source4 = StructType$.MODULE$.fromDDL("c1 INT, c2 STRUCT<c3: INT, c4: STRUCT<c6: INT>>");
            StructType missing4 = StructType$.MODULE$.fromDDL("c2 STRUCT<c4: STRUCT<c5: INT>>");
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(StructType$.MODULE$.findMissingFields(source4, schema, resolver).exists((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.sameType((DataType)missing4))), "StructType.findMissingFields(source4, schema, resolver).exists(((x$4: org.apache.spark.sql.types.StructType) => x$4.sameType(missing4)))", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 168));
        }, new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 147));
        this.test("find missing (nested) fields: array and map", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Function2 resolver = SQLConf$.MODULE$.get().resolver();
            StructType schemaWithArray = StructType$.MODULE$.fromDDL("c1 INT, c2 ARRAY<STRUCT<c3: INT, c4: LONG>>");
            StructType source5 = StructType$.MODULE$.fromDDL("c1 INT");
            StructType missing5 = StructType$.MODULE$.fromDDL("c2 ARRAY<STRUCT<c3: INT, c4: LONG>>");
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(StructType$.MODULE$.findMissingFields(source5, schemaWithArray, resolver).exists((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.sameType((DataType)missing5))), "StructType.findMissingFields(source5, schemaWithArray, resolver).exists(((x$5: org.apache.spark.sql.types.StructType) => x$5.sameType(missing5)))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 178));
            StructType schemaWithMap1 = StructType$.MODULE$.fromDDL("c1 INT, c2 MAP<STRUCT<c3: INT, c4: LONG>, STRING>, c3 LONG");
            StructType source6 = StructType$.MODULE$.fromDDL("c1 INT, c3 LONG");
            StructType missing6 = StructType$.MODULE$.fromDDL("c2 MAP<STRUCT<c3: INT, c4: LONG>, STRING>");
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(StructType$.MODULE$.findMissingFields(source6, schemaWithMap1, resolver).exists((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)x$6.sameType((DataType)missing6))), "StructType.findMissingFields(source6, schemaWithMap1, resolver).exists(((x$6: org.apache.spark.sql.types.StructType) => x$6.sameType(missing6)))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 186));
            StructType schemaWithMap2 = StructType$.MODULE$.fromDDL("c1 INT, c2 MAP<STRING, STRUCT<c3: INT, c4: LONG>>, c3 STRING");
            StructType source7 = StructType$.MODULE$.fromDDL("c1 INT, c3 STRING");
            StructType missing7 = StructType$.MODULE$.fromDDL("c2 MAP<STRING, STRUCT<c3: INT, c4: LONG>>");
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(StructType$.MODULE$.findMissingFields(source7, schemaWithMap2, resolver).exists((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)x$7.sameType((DataType)missing7))), "StructType.findMissingFields(source7, schemaWithMap2, resolver).exists(((x$7: org.apache.spark.sql.types.StructType) => x$7.sameType(missing7)))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 194));
            StructType source8 = StructType$.MODULE$.fromDDL("c1 INT, c2 ARRAY<STRUCT<c3: INT>>");
            Option $org_scalatest_assert_macro_left = StructType$.MODULE$.findMissingFields(source8, schemaWithArray, resolver);
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 201));
            StructType source9 = StructType$.MODULE$.fromDDL("c1 INT, c2 MAP<STRUCT<c3: INT>, STRING>, c3 LONG");
            Option $org_scalatest_assert_macro_left2 = StructType$.MODULE$.findMissingFields(source9, schemaWithMap1, resolver);
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left2, "isEmpty", $org_scalatest_assert_macro_left2.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 205));
            StructType source10 = StructType$.MODULE$.fromDDL("c1 INT, c2 MAP<STRING, STRUCT<c3: INT>>, c3 STRING");
            Option $org_scalatest_assert_macro_left3 = StructType$.MODULE$.findMissingFields(source10, schemaWithMap2, resolver);
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left3, "isEmpty", $org_scalatest_assert_macro_left3.isEmpty(), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 209));
        }, new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 172));
        this.test("find missing (nested) fields: case sensitive cases", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.CASE_SENSITIVE().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            StructType schema = StructType$.MODULE$.fromDDL("c1 INT, c2 STRUCT<c3: INT, C4: STRUCT<C5: INT, c6: INT>>");
            Function2 resolver = SQLConf$.MODULE$.get().resolver();
            StructType source1 = StructType$.MODULE$.fromDDL("c1 INT, C2 LONG");
            StructType missing1 = StructType$.MODULE$.fromDDL("c2 STRUCT<c3: INT, C4: STRUCT<C5: INT, c6: INT>>");
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(StructType$.MODULE$.findMissingFields(source1, schema, resolver).exists((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)x$8.sameType((DataType)missing1))), "StructType.findMissingFields(source1, schema, resolver).exists(((x$8: org.apache.spark.sql.types.StructType) => x$8.sameType(missing1)))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 219));
            StructType source2 = StructType$.MODULE$.fromDDL("c2 LONG");
            StructType missing2 = StructType$.MODULE$.fromDDL("c1 INT");
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(StructType$.MODULE$.findMissingFields(source2, schema, resolver).exists((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)x$9.sameType((DataType)missing2))), "StructType.findMissingFields(source2, schema, resolver).exists(((x$9: org.apache.spark.sql.types.StructType) => x$9.sameType(missing2)))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 224));
            StructType source3 = StructType$.MODULE$.fromDDL("c1 INT, c2 STRUCT<c3: INT, C4: STRUCT<c5: INT>>");
            StructType missing3 = StructType$.MODULE$.fromDDL("c2 STRUCT<C4: STRUCT<C5: INT, c6: INT>>");
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(StructType$.MODULE$.findMissingFields(source3, schema, resolver).exists((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)x$10.sameType((DataType)missing3))), "StructType.findMissingFields(source3, schema, resolver).exists(((x$10: org.apache.spark.sql.types.StructType) => x$10.sameType(missing3)))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 229));
            StructType source4 = StructType$.MODULE$.fromDDL("c1 INT, c2 STRUCT<c3: INT, C4: STRUCT<C5: Int>>");
            StructType missing4 = StructType$.MODULE$.fromDDL("c2 STRUCT<C4: STRUCT<c6: INT>>");
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(StructType$.MODULE$.findMissingFields(source4, schema, resolver).exists((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)x$11.sameType((DataType)missing4))), "StructType.findMissingFields(source4, schema, resolver).exists(((x$11: org.apache.spark.sql.types.StructType) => x$11.sameType(missing4)))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 234));
        }), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 212));
    }
}

