/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connector.catalog;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.connector.InMemoryPartitionTable;
import org.apache.spark.sql.connector.InMemoryPartitionTableCatalog;
import org.apache.spark.sql.connector.InMemoryTableCatalog;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.SupportsPartitionManagement;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.expressions.LogicalExpressions$;
import org.apache.spark.sql.connector.expressions.NamedReference;
import org.apache.spark.sql.connector.expressions.Transform;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001M3A!\u0003\u0006\u0001/!)A\u0004\u0001C\u0001;!9\u0001\u0005\u0001b\u0001\n\u0013\t\u0003BB\u0013\u0001A\u0003%!\u0005C\u0003'\u0001\u0011\u0005q\u0005C\u0004\f\u0001\t\u0007I\u0011B\u001f\t\r\t\u0003\u0001\u0015!\u0003?\u0011\u0015\u0019\u0005\u0001\"\u0003E\u0011\u0015q\u0005\u0001\"\u0003P\u0005\u0001\u001aV\u000f\u001d9peR\u001c\b+\u0019:uSRLwN\\'b]\u0006<W-\\3oiN+\u0018\u000e^3\u000b\u0005-a\u0011aB2bi\u0006dwn\u001a\u0006\u0003\u001b9\t\u0011bY8o]\u0016\u001cGo\u001c:\u000b\u0005=\u0001\u0012aA:rY*\u0011\u0011CE\u0001\u0006gB\f'o\u001b\u0006\u0003'Q\ta!\u00199bG\",'\"A\u000b\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001A\u0002CA\r\u001b\u001b\u0005\u0001\u0012BA\u000e\u0011\u00055\u0019\u0006/\u0019:l\rVt7+^5uK\u00061A(\u001b8jiz\"\u0012A\b\t\u0003?\u0001i\u0011AC\u0001\u0006S\u0012,g\u000e^\u000b\u0002EA\u0011qdI\u0005\u0003I)\u0011!\"\u00133f]RLg-[3s\u0003\u0019IG-\u001a8uA\u0005\u0019!/\u001a4\u0015\u0005!r\u0003CA\u0015-\u001b\u0005Q#BA\u0016\r\u0003-)\u0007\u0010\u001d:fgNLwN\\:\n\u00055R#A\u0004(b[\u0016$'+\u001a4fe\u0016t7-\u001a\u0005\u0006_\u0011\u0001\r\u0001M\u0001\u0005]\u0006lW\r\u0005\u00022u9\u0011!\u0007\u000f\t\u0003gYj\u0011\u0001\u000e\u0006\u0003kY\ta\u0001\u0010:p_Rt$\"A\u001c\u0002\u000bM\u001c\u0017\r\\1\n\u0005e2\u0014A\u0002)sK\u0012,g-\u0003\u0002<y\t11\u000b\u001e:j]\u001eT!!\u000f\u001c\u0016\u0003y\u0002\"a\u0010!\u000e\u00031I!!\u0011\u0007\u0003)%sW*Z7pef$\u0016M\u00197f\u0007\u0006$\u0018\r\\8h\u0003!\u0019\u0017\r^1m_\u001e\u0004\u0013!\u00045bgB\u000b'\u000f^5uS>t7\u000f\u0006\u0002F\u0013B\u0011aiR\u0007\u0002m%\u0011\u0001J\u000e\u0002\b\u0005>|G.Z1o\u0011\u0015Qu\u00011\u0001L\u0003\u0015!\u0018M\u00197f!\tyB*\u0003\u0002N\u0015\tY2+\u001e9q_J$8\u000fU1si&$\u0018n\u001c8NC:\fw-Z7f]R\fAc\u0019:fCR,W*\u001e7uSB\u000b'\u000f\u001e+bE2,G#\u0001)\u0011\u0005}\n\u0016B\u0001*\r\u0005YIe.T3n_JL\b+\u0019:uSRLwN\u001c+bE2,\u0007")
public class SupportsPartitionManagementSuite
extends SparkFunSuite {
    private final Identifier ident = Identifier.of((String[])((String[])((Object[])new String[]{"ns"})), (String)"test_table");
    private final InMemoryTableCatalog catalog;

    private Identifier ident() {
        return this.ident;
    }

    public NamedReference ref(String name) {
        return LogicalExpressions$.MODULE$.parseReference(name);
    }

    private InMemoryTableCatalog catalog() {
        return this.catalog;
    }

    private boolean hasPartitions(SupportsPartitionManagement table) {
        return !new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])table.listPartitionIdentifiers((String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)), InternalRow$.MODULE$.empty()))).isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    private InMemoryPartitionTable createMultiPartTable() {
        void var3_3;
        InMemoryPartitionTableCatalog partCatalog = new InMemoryPartitionTableCatalog();
        partCatalog.initialize("test", CaseInsensitiveStringMap.empty());
        Table table = partCatalog.createTable(this.ident(), new StructType().add("col0", (DataType)IntegerType$.MODULE$).add("part0", (DataType)IntegerType$.MODULE$).add("part1", (DataType)StringType$.MODULE$), (Transform[])((Object[])new Transform[]{LogicalExpressions$.MODULE$.identity(this.ref("part0")), LogicalExpressions$.MODULE$.identity(this.ref("part1"))}), Collections.emptyMap());
        InMemoryPartitionTable partTable = (InMemoryPartitionTable)table;
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new InternalRow[]{InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)0), "abc"})), InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)0), "def"})), InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "abc"}))}))).foreach((Function1 & Serializable & scala.Serializable)partIdent -> {
            partTable.createPartition(partIdent, new HashMap<String, String>());
            return BoxedUnit.UNIT;
        });
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public SupportsPartitionManagementSuite() {
        void var1_1;
        InMemoryTableCatalog newCatalog = new InMemoryTableCatalog();
        newCatalog.initialize("test", CaseInsensitiveStringMap.empty());
        newCatalog.createTable(this.ident(), new StructType().add("id", (DataType)IntegerType$.MODULE$).add("data", (DataType)StringType$.MODULE$).add("dt", (DataType)StringType$.MODULE$), (Transform[])((Object[])new Transform[]{LogicalExpressions$.MODULE$.identity(this.ref("dt"))}), Collections.emptyMap());
        this.catalog = var1_1;
        this.test("createPartition", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Table table = this.catalog().loadTable(this.ident());
            InMemoryPartitionTable partTable = new InMemoryPartitionTable(table.name(), table.schema(), table.partitioning(), table.properties());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.hasPartitions(partTable), "SupportsPartitionManagementSuite.this.hasPartitions(partTable)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SupportsPartitionManagementSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 59));
            InternalRow partIdent = InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"3"}));
            partTable.createPartition(partIdent, new HashMap<String, String>());
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(this.hasPartitions(partTable), "SupportsPartitionManagementSuite.this.hasPartitions(partTable)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SupportsPartitionManagementSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 63));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(partTable.partitionExists(partIdent), "partTable.partitionExists(partIdent)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SupportsPartitionManagementSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 64));
            partTable.dropPartition(partIdent);
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.hasPartitions(partTable), "SupportsPartitionManagementSuite.this.hasPartitions(partTable)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SupportsPartitionManagementSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 67));
        }, new Position("SupportsPartitionManagementSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 55));
        this.test("dropPartition", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Table table = this.catalog().loadTable(this.ident());
            InMemoryPartitionTable partTable = new InMemoryPartitionTable(table.name(), table.schema(), table.partitioning(), table.properties());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.hasPartitions(partTable), "SupportsPartitionManagementSuite.this.hasPartitions(partTable)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SupportsPartitionManagementSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 74));
            InternalRow partIdent = InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"3"}));
            InternalRow partIdent1 = InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"4"}));
            partTable.createPartition(partIdent, new HashMap<String, String>());
            partTable.createPartition(partIdent1, new HashMap<String, String>());
            InternalRow[] $org_scalatest_assert_macro_left = partTable.listPartitionIdentifiers((String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)), InternalRow$.MODULE$.empty());
            int $org_scalatest_assert_macro_right = 2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SupportsPartitionManagementSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 80));
            partTable.dropPartition(partIdent);
            InternalRow[] $org_scalatest_assert_macro_left2 = partTable.listPartitionIdentifiers((String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)), InternalRow$.MODULE$.empty());
            int $org_scalatest_assert_macro_right2 = 1;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left2, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SupportsPartitionManagementSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 83));
            partTable.dropPartition(partIdent1);
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.hasPartitions(partTable), "SupportsPartitionManagementSuite.this.hasPartitions(partTable)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SupportsPartitionManagementSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 85));
        }, new Position("SupportsPartitionManagementSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 70));
        this.test("replacePartitionMetadata", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Table table = this.catalog().loadTable(this.ident());
            InMemoryPartitionTable partTable = new InMemoryPartitionTable(table.name(), table.schema(), table.partitioning(), table.properties());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.hasPartitions(partTable), "SupportsPartitionManagementSuite.this.hasPartitions(partTable)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SupportsPartitionManagementSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 92));
            InternalRow partIdent = InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"3"}));
            partTable.createPartition(partIdent, new HashMap<String, String>());
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(this.hasPartitions(partTable), "SupportsPartitionManagementSuite.this.hasPartitions(partTable)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SupportsPartitionManagementSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 96));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(partTable.partitionExists(partIdent), "partTable.partitionExists(partIdent)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SupportsPartitionManagementSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 97));
            java.util.Map<String, String> $org_scalatest_assert_macro_left = partTable.loadPartitionMetadata(partIdent);
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.unaryMacroBool($org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SupportsPartitionManagementSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 98));
            partTable.replacePartitionMetadata(partIdent, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paramKey"), (Object)"paramValue")}))).asJava());
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(this.hasPartitions(partTable), "SupportsPartitionManagementSuite.this.hasPartitions(partTable)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SupportsPartitionManagementSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 101));
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.simpleMacroBool(partTable.partitionExists(partIdent), "partTable.partitionExists(partIdent)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SupportsPartitionManagementSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 102));
            java.util.Map<String, String> $org_scalatest_assert_macro_left2 = partTable.loadPartitionMetadata(partIdent);
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.notBool(Bool$.MODULE$.unaryMacroBool($org_scalatest_assert_macro_left2, "isEmpty", $org_scalatest_assert_macro_left2.isEmpty(), Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SupportsPartitionManagementSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 103));
            String $org_scalatest_assert_macro_left3 = partTable.loadPartitionMetadata(partIdent).get("paramKey");
            String $org_scalatest_assert_macro_right = "paramValue";
            String string = $org_scalatest_assert_macro_left3;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("SupportsPartitionManagementSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 104));
            partTable.dropPartition(partIdent);
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.hasPartitions(partTable), "SupportsPartitionManagementSuite.this.hasPartitions(partTable)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("SupportsPartitionManagementSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 107));
        }, new Position("SupportsPartitionManagementSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 88));
        this.test("loadPartitionMetadata", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Table table = this.catalog().loadTable(this.ident());
            InMemoryPartitionTable partTable = new InMemoryPartitionTable(table.name(), table.schema(), table.partitioning(), table.properties());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.hasPartitions(partTable), "SupportsPartitionManagementSuite.this.hasPartitions(partTable)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SupportsPartitionManagementSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 114));
            InternalRow partIdent = InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"3"}));
            partTable.createPartition(partIdent, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paramKey"), (Object)"paramValue")}))).asJava());
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(this.hasPartitions(partTable), "SupportsPartitionManagementSuite.this.hasPartitions(partTable)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SupportsPartitionManagementSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 118));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(partTable.partitionExists(partIdent), "partTable.partitionExists(partIdent)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SupportsPartitionManagementSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 119));
            java.util.Map<String, String> $org_scalatest_assert_macro_left = partTable.loadPartitionMetadata(partIdent);
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.notBool(Bool$.MODULE$.unaryMacroBool($org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SupportsPartitionManagementSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 120));
            String $org_scalatest_assert_macro_left2 = partTable.loadPartitionMetadata(partIdent).get("paramKey");
            String $org_scalatest_assert_macro_right = "paramValue";
            String string = $org_scalatest_assert_macro_left2;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SupportsPartitionManagementSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 121));
            partTable.dropPartition(partIdent);
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.hasPartitions(partTable), "SupportsPartitionManagementSuite.this.hasPartitions(partTable)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SupportsPartitionManagementSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 124));
        }, new Position("SupportsPartitionManagementSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 110));
        this.test("listPartitionIdentifiers", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Table table = this.catalog().loadTable(this.ident());
            InMemoryPartitionTable partTable = new InMemoryPartitionTable(table.name(), table.schema(), table.partitioning(), table.properties());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.hasPartitions(partTable), "SupportsPartitionManagementSuite.this.hasPartitions(partTable)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SupportsPartitionManagementSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 131));
            InternalRow partIdent = InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"3"}));
            partTable.createPartition(partIdent, new HashMap<String, String>());
            InternalRow[] $org_scalatest_assert_macro_left = partTable.listPartitionIdentifiers((String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)), InternalRow$.MODULE$.empty());
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SupportsPartitionManagementSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 135));
            InternalRow partIdent1 = InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"4"}));
            partTable.createPartition(partIdent1, new HashMap<String, String>());
            InternalRow[] $org_scalatest_assert_macro_left2 = partTable.listPartitionIdentifiers((String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)), InternalRow$.MODULE$.empty());
            int $org_scalatest_assert_macro_right2 = 2;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left2, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SupportsPartitionManagementSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 139));
            InternalRow[] $org_scalatest_assert_macro_left3 = partTable.listPartitionIdentifiers((String[])((Object[])new String[]{"dt"}), partIdent1);
            int $org_scalatest_assert_macro_right3 = 1;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left3, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SupportsPartitionManagementSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 140));
            partTable.dropPartition(partIdent);
            InternalRow[] $org_scalatest_assert_macro_left4 = partTable.listPartitionIdentifiers((String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)), InternalRow$.MODULE$.empty());
            int $org_scalatest_assert_macro_right4 = 1;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left4, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SupportsPartitionManagementSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 143));
            partTable.dropPartition(partIdent1);
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.hasPartitions(partTable), "SupportsPartitionManagementSuite.this.hasPartitions(partTable)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SupportsPartitionManagementSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 145));
        }, new Position("SupportsPartitionManagementSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 127));
        this.test("listPartitionByNames", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            InMemoryPartitionTable partTable = this.createMultiPartTable();
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)new String[]{"part0", "part1"}, (Object)InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)0), "abc"})))), (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new InternalRow[]{InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)0), "abc"}))}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)new String[]{"part0"}, (Object)InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)0)})))), (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new InternalRow[]{InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)0), "abc"})), InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)0), "def"}))}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)new String[]{"part1"}, (Object)InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"abc"})))), (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new InternalRow[]{InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)0), "abc"})), InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "abc"}))}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2(Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)), (Object)InternalRow$.MODULE$.empty())), (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new InternalRow[]{InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)0), "abc"})), InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)0), "def"})), InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "abc"}))}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)new String[]{"part0", "part1"}, (Object)InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "xyz"})))), (Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)new String[]{"part1"}, (Object)InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToFloat((float)3.14f)})))), (Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$))}))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Set expected;
                Tuple2 tuple2;
                block3: {
                    Tuple2 tuple22;
                    block2: {
                        tuple22 = x0$1;
                        if (tuple22 == null) break block2;
                        tuple2 = (Tuple2)tuple22._1();
                        expected = (Set)tuple22._2();
                        if (tuple2 != null) break block3;
                    }
                    throw new MatchError((Object)tuple22);
                }
                String[] names = (String[])tuple2._1();
                InternalRow idents = (InternalRow)tuple2._2();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partTable.listPartitionIdentifiers(names, idents))).toSet());
                Set $org_scalatest_assert_macro_right = expected;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertion assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SupportsPartitionManagementSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 183));
                return assertion;
            });
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)new String[]{"part0", "part1"}, (Object)InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)0)}))), new Tuple2((Object)new String[]{"col0", "part1"}, (Object)InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)0), BoxesRunTime.boxToInteger((int)1)}))), new Tuple2((Object)new String[]{"wrong"}, (Object)InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"invalid"})))}))).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String[] names = (String[])tuple2._1();
                InternalRow idents = (InternalRow)tuple2._2();
                AssertionError assertionError = (AssertionError)this.intercept((Function0 & Serializable & scala.Serializable)() -> partTable.listPartitionIdentifiers(names, idents), ClassTag$.MODULE$.apply(AssertionError.class), new Position("SupportsPartitionManagementSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 191));
                return assertionError;
            });
        }, new Position("SupportsPartitionManagementSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 171));
        this.test("partitionExists", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            String errMsg;
            InMemoryPartitionTable partTable = this.createMultiPartTable();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(partTable.partitionExists(InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)0), "def"}))), "partTable.partitionExists(org.apache.spark.sql.catalyst.InternalRow.apply(0, \"def\"))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SupportsPartitionManagementSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 198));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(partTable.partitionExists(InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)-1), "def"}))), "partTable.partitionExists(org.apache.spark.sql.catalyst.InternalRow.apply(-1, \"def\"))", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SupportsPartitionManagementSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 199));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(partTable.partitionExists(InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"abc", "def"}))), "partTable.partitionExists(org.apache.spark.sql.catalyst.InternalRow.apply(\"abc\", \"def\"))", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SupportsPartitionManagementSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 200));
            String $org_scalatest_assert_macro_left = errMsg = ((Throwable)this.intercept((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> partTable.partitionExists(InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)0)}))), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("SupportsPartitionManagementSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 202))).getMessage();
            String $org_scalatest_assert_macro_right = "The identifier might not refer to one partition";
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SupportsPartitionManagementSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 205));
        }, new Position("SupportsPartitionManagementSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 195));
    }
}

