/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connector.catalog;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.analysis.PartitionsAlreadyExistException;
import org.apache.spark.sql.connector.InMemoryAtomicPartitionTable;
import org.apache.spark.sql.connector.InMemoryTableCatalog;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.SupportsPartitionManagement;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.expressions.LogicalExpressions$;
import org.apache.spark.sql.connector.expressions.NamedReference;
import org.apache.spark.sql.connector.expressions.Transform;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Array$;
import scala.Function0;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u000153A\u0001C\u0005\u0001-!)1\u0004\u0001C\u00019!9q\u0004\u0001b\u0001\n\u0013\u0001\u0003B\u0002\u0013\u0001A\u0003%\u0011\u0005C\u0003&\u0001\u0011\u0005a\u0005C\u0004\u000b\u0001\t\u0007I\u0011\u0002\u001f\t\r\u0005\u0003\u0001\u0015!\u0003>\u0011\u0015\u0011\u0005\u0001\"\u0003D\u0005\u0019\u001aV\u000f\u001d9peR\u001c\u0018\t^8nS\u000e\u0004\u0016M\u001d;ji&|g.T1oC\u001e,W.\u001a8u'VLG/\u001a\u0006\u0003\u0015-\tqaY1uC2|wM\u0003\u0002\r\u001b\u0005I1m\u001c8oK\u000e$xN\u001d\u0006\u0003\u001d=\t1a]9m\u0015\t\u0001\u0012#A\u0003ta\u0006\u00148N\u0003\u0002\u0013'\u00051\u0011\r]1dQ\u0016T\u0011\u0001F\u0001\u0004_J<7\u0001A\n\u0003\u0001]\u0001\"\u0001G\r\u000e\u0003=I!AG\b\u0003\u001bM\u0003\u0018M]6Gk:\u001cV/\u001b;f\u0003\u0019a\u0014N\\5u}Q\tQ\u0004\u0005\u0002\u001f\u00015\t\u0011\"A\u0003jI\u0016tG/F\u0001\"!\tq\"%\u0003\u0002$\u0013\tQ\u0011\nZ3oi&4\u0017.\u001a:\u0002\r%$WM\u001c;!\u0003\r\u0011XM\u001a\u000b\u0003O5\u0002\"\u0001K\u0016\u000e\u0003%R!AK\u0006\u0002\u0017\u0015D\bO]3tg&|gn]\u0005\u0003Y%\u0012aBT1nK\u0012\u0014VMZ3sK:\u001cW\rC\u0003/\t\u0001\u0007q&\u0001\u0003oC6,\u0007C\u0001\u0019:\u001d\t\tt\u0007\u0005\u00023k5\t1G\u0003\u00025+\u00051AH]8pizR\u0011AN\u0001\u0006g\u000e\fG.Y\u0005\u0003qU\na\u0001\u0015:fI\u00164\u0017B\u0001\u001e<\u0005\u0019\u0019FO]5oO*\u0011\u0001(N\u000b\u0002{A\u0011ahP\u0007\u0002\u0017%\u0011\u0001i\u0003\u0002\u0015\u0013:lU-\\8ssR\u000b'\r\\3DCR\fGn\\4\u0002\u0011\r\fG/\u00197pO\u0002\nQ\u0002[1t!\u0006\u0014H/\u001b;j_:\u001cHC\u0001#I!\t)e)D\u00016\u0013\t9UGA\u0004C_>dW-\u00198\t\u000b%;\u0001\u0019\u0001&\u0002\u000bQ\f'\r\\3\u0011\u0005yY\u0015B\u0001'\n\u0005m\u0019V\u000f\u001d9peR\u001c\b+\u0019:uSRLwN\\'b]\u0006<W-\\3oi\u0002")
public class SupportsAtomicPartitionManagementSuite
extends SparkFunSuite {
    private final Identifier ident = Identifier.of((String[])((String[])((Object[])new String[]{"ns"})), (String)"test_table");
    private final InMemoryTableCatalog catalog;

    private Identifier ident() {
        return this.ident;
    }

    public NamedReference ref(String name) {
        return LogicalExpressions$.MODULE$.parseReference(name);
    }

    private InMemoryTableCatalog catalog() {
        return this.catalog;
    }

    private boolean hasPartitions(SupportsPartitionManagement table) {
        return !new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])table.listPartitionIdentifiers((String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)), InternalRow$.MODULE$.empty()))).isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    public SupportsAtomicPartitionManagementSuite() {
        void var1_1;
        InMemoryTableCatalog newCatalog = new InMemoryTableCatalog();
        newCatalog.initialize("test", CaseInsensitiveStringMap.empty());
        newCatalog.createTable(this.ident(), new StructType().add("id", (DataType)IntegerType$.MODULE$).add("data", (DataType)StringType$.MODULE$).add("dt", (DataType)StringType$.MODULE$), (Transform[])((Object[])new Transform[]{LogicalExpressions$.MODULE$.identity(this.ref("dt"))}), Collections.emptyMap());
        this.catalog = var1_1;
        this.test("createPartitions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Table table = this.catalog().loadTable(this.ident());
            InMemoryAtomicPartitionTable partTable = new InMemoryAtomicPartitionTable(table.name(), table.schema(), table.partitioning(), table.properties());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.hasPartitions(partTable), "SupportsAtomicPartitionManagementSuite.this.hasPartitions(partTable)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SupportsAtomicPartitionManagementSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 58));
            InternalRow[] partIdents = (InternalRow[])((Object[])new InternalRow[]{InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"3"})), InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"4"}))});
            partTable.createPartitions(partIdents, (Map[])((Object[])new Map[]{new HashMap(), new HashMap()}));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(this.hasPartitions(partTable), "SupportsAtomicPartitionManagementSuite.this.hasPartitions(partTable)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SupportsAtomicPartitionManagementSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 64));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(partTable.partitionExists(InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"3"}))), "partTable.partitionExists(org.apache.spark.sql.catalyst.InternalRow.apply(\"3\"))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SupportsAtomicPartitionManagementSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 65));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(partTable.partitionExists(InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"4"}))), "partTable.partitionExists(org.apache.spark.sql.catalyst.InternalRow.apply(\"4\"))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SupportsAtomicPartitionManagementSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 66));
            partTable.dropPartition(InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"3"})));
            partTable.dropPartition(InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"4"})));
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.hasPartitions(partTable), "SupportsAtomicPartitionManagementSuite.this.hasPartitions(partTable)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SupportsAtomicPartitionManagementSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 70));
        }, new Position("SupportsAtomicPartitionManagementSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 54));
        this.test("createPartitions failed if partition already exists", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Table table = this.catalog().loadTable(this.ident());
            InMemoryAtomicPartitionTable partTable = new InMemoryAtomicPartitionTable(table.name(), table.schema(), table.partitioning(), table.properties());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.hasPartitions(partTable), "SupportsAtomicPartitionManagementSuite.this.hasPartitions(partTable)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SupportsAtomicPartitionManagementSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 77));
            InternalRow partIdent = InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"4"}));
            partTable.createPartition(partIdent, new HashMap<String, String>());
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(this.hasPartitions(partTable), "SupportsAtomicPartitionManagementSuite.this.hasPartitions(partTable)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SupportsAtomicPartitionManagementSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 81));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(partTable.partitionExists(partIdent), "partTable.partitionExists(partIdent)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SupportsAtomicPartitionManagementSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 82));
            InternalRow[] partIdents = (InternalRow[])((Object[])new InternalRow[]{InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"3"})), InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"4"}))});
            this.assertThrows((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> partTable.createPartitions(partIdents, (Map[])((Object[])new Map[]{new HashMap(), new HashMap()})), ClassTag$.MODULE$.apply(PartitionsAlreadyExistException.class), new Position("SupportsAtomicPartitionManagementSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 85));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(partTable.partitionExists(InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"3"}))), "partTable.partitionExists(org.apache.spark.sql.catalyst.InternalRow.apply(\"3\"))", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SupportsAtomicPartitionManagementSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 89));
            partTable.dropPartition(partIdent);
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.hasPartitions(partTable), "SupportsAtomicPartitionManagementSuite.this.hasPartitions(partTable)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SupportsAtomicPartitionManagementSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 92));
        }, new Position("SupportsAtomicPartitionManagementSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 73));
        this.test("dropPartitions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Table table = this.catalog().loadTable(this.ident());
            InMemoryAtomicPartitionTable partTable = new InMemoryAtomicPartitionTable(table.name(), table.schema(), table.partitioning(), table.properties());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.hasPartitions(partTable), "SupportsAtomicPartitionManagementSuite.this.hasPartitions(partTable)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SupportsAtomicPartitionManagementSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 99));
            InternalRow[] partIdents = (InternalRow[])((Object[])new InternalRow[]{InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"3"})), InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"4"}))});
            partTable.createPartitions(partIdents, (Map[])((Object[])new Map[]{new HashMap(), new HashMap()}));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(this.hasPartitions(partTable), "SupportsAtomicPartitionManagementSuite.this.hasPartitions(partTable)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SupportsAtomicPartitionManagementSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 105));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(partTable.partitionExists(InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"3"}))), "partTable.partitionExists(org.apache.spark.sql.catalyst.InternalRow.apply(\"3\"))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SupportsAtomicPartitionManagementSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 106));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(partTable.partitionExists(InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"4"}))), "partTable.partitionExists(org.apache.spark.sql.catalyst.InternalRow.apply(\"4\"))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SupportsAtomicPartitionManagementSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 107));
            partTable.dropPartitions(partIdents);
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.hasPartitions(partTable), "SupportsAtomicPartitionManagementSuite.this.hasPartitions(partTable)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SupportsAtomicPartitionManagementSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 110));
        }, new Position("SupportsAtomicPartitionManagementSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 95));
        this.test("dropPartitions failed if partition not exists", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Table table = this.catalog().loadTable(this.ident());
            InMemoryAtomicPartitionTable partTable = new InMemoryAtomicPartitionTable(table.name(), table.schema(), table.partitioning(), table.properties());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.hasPartitions(partTable), "SupportsAtomicPartitionManagementSuite.this.hasPartitions(partTable)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SupportsAtomicPartitionManagementSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 117));
            InternalRow partIdent = InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"4"}));
            partTable.createPartition(partIdent, new HashMap<String, String>());
            InternalRow[] $org_scalatest_assert_macro_left = partTable.listPartitionIdentifiers((String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)), InternalRow$.MODULE$.empty());
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SupportsAtomicPartitionManagementSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 121));
            InternalRow[] partIdents = (InternalRow[])((Object[])new InternalRow[]{InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"3"})), InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"4"}))});
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(partTable.dropPartitions(partIdents), "partTable.dropPartitions(partIdents)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SupportsAtomicPartitionManagementSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 124));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(partTable.partitionExists(partIdent), "partTable.partitionExists(partIdent)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SupportsAtomicPartitionManagementSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 125));
            partTable.dropPartition(partIdent);
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.hasPartitions(partTable), "SupportsAtomicPartitionManagementSuite.this.hasPartitions(partTable)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SupportsAtomicPartitionManagementSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 128));
        }, new Position("SupportsAtomicPartitionManagementSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 113));
    }
}

