/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connector.catalog;

import java.io.File;
import java.io.Serializable;
import java.net.URI;
import java.time.ZoneId;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.catalyst.analysis.EmptyFunctionRegistry$;
import org.apache.spark.sql.catalyst.analysis.FakeV2SessionCatalog$;
import org.apache.spark.sql.catalyst.analysis.FunctionRegistry;
import org.apache.spark.sql.catalyst.analysis.NoSuchNamespaceException;
import org.apache.spark.sql.catalyst.catalog.CatalogDatabase;
import org.apache.spark.sql.catalyst.catalog.ExternalCatalog;
import org.apache.spark.sql.catalyst.catalog.InMemoryCatalog;
import org.apache.spark.sql.catalyst.catalog.InMemoryCatalog$;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog$;
import org.apache.spark.sql.catalyst.plans.SQLHelper;
import org.apache.spark.sql.connector.InMemoryTableCatalog;
import org.apache.spark.sql.connector.catalog.CatalogManager;
import org.apache.spark.sql.connector.catalog.CatalogManager$;
import org.apache.spark.sql.connector.catalog.CatalogPlugin;
import org.apache.spark.sql.connector.catalog.DummyCatalog;
import org.apache.spark.sql.internal.SQLConf$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001%2Aa\u0001\u0003\u0001#!)a\u0004\u0001C\u0001?!)!\u0005\u0001C\u0005G\t\u00192)\u0019;bY><W*\u00198bO\u0016\u00148+^5uK*\u0011QAB\u0001\bG\u0006$\u0018\r\\8h\u0015\t9\u0001\"A\u0005d_:tWm\u0019;pe*\u0011\u0011BC\u0001\u0004gFd'BA\u0006\r\u0003\u0015\u0019\b/\u0019:l\u0015\tia\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001f\u0005\u0019qN]4\u0004\u0001M\u0019\u0001A\u0005\f\u0011\u0005M!R\"\u0001\u0006\n\u0005UQ!!D*qCJ\\g)\u001e8Tk&$X\r\u0005\u0002\u001895\t\u0001D\u0003\u0002\u001a5\u0005)\u0001\u000f\\1og*\u00111\u0004C\u0001\tG\u0006$\u0018\r\\=ti&\u0011Q\u0004\u0007\u0002\n'Fc\u0005*\u001a7qKJ\fa\u0001P5oSRtD#\u0001\u0011\u0011\u0005\u0005\u0002Q\"\u0001\u0003\u0002)\r\u0014X-\u0019;f'\u0016\u001c8/[8o\u0007\u0006$\u0018\r\\8h)\u0005!\u0003CA\u0013(\u001b\u00051#BA\u0003\u001b\u0013\tAcE\u0001\bTKN\u001c\u0018n\u001c8DCR\fGn\\4")
public class CatalogManagerSuite
extends SparkFunSuite
implements SQLHelper {
    private String sparkHome;
    private volatile boolean bitmap$0;

    @Override
    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        SQLHelper.withSQLConf$(this, pairs, f);
    }

    @Override
    public void withTempPath(Function1<File, BoxedUnit> f) {
        SQLHelper.withTempPath$(this, f);
    }

    @Override
    public <T> void testSpecialDatetimeValues(Function1<ZoneId, T> test) {
        SQLHelper.testSpecialDatetimeValues$(this, test);
    }

    private String sparkHome$lzycompute() {
        CatalogManagerSuite catalogManagerSuite = this;
        synchronized (catalogManagerSuite) {
            if (!this.bitmap$0) {
                this.sparkHome = SQLHelper.sparkHome$(this);
                this.bitmap$0 = true;
            }
        }
        return this.sparkHome;
    }

    @Override
    public String sparkHome() {
        return !this.bitmap$0 ? this.sparkHome$lzycompute() : this.sparkHome;
    }

    private SessionCatalog createSessionCatalog() {
        InMemoryCatalog catalog = new InMemoryCatalog(InMemoryCatalog$.MODULE$.$lessinit$greater$default$1(), InMemoryCatalog$.MODULE$.$lessinit$greater$default$2());
        catalog.createDatabase(new CatalogDatabase(SessionCatalog$.MODULE$.DEFAULT_DATABASE(), "", new URI("fake"), Predef$.MODULE$.Map().empty()), true);
        return new SessionCatalog((ExternalCatalog)catalog, (FunctionRegistry)EmptyFunctionRegistry$.MODULE$);
    }

    public CatalogManagerSuite() {
        SQLHelper.$init$(this);
        this.test("CatalogManager should reflect the changes of default catalog", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            CatalogManager catalogManager = new CatalogManager((CatalogPlugin)FakeV2SessionCatalog$.MODULE$, this.createSessionCatalog());
            String $org_scalatest_assert_macro_left = catalogManager.currentCatalog().name();
            String $org_scalatest_assert_macro_right = CatalogManager$.MODULE$.SESSION_CATALOG_NAME();
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 44));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])catalogManager.currentNamespace())).sameElements((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"default"})), "scala.Predef.refArrayOps[String](catalogManager.currentNamespace).sameElements[String](scala.Predef.wrapRefArray[String](scala.Array.apply[String](\"default\")((ClassTag.apply[String](classOf[java.lang.String]): scala.reflect.ClassTag[String]))))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 45));
            this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.sql.catalog.dummy"), (Object)DummyCatalog.class.getName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.DEFAULT_CATALOG().key()), (Object)"dummy")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                String $org_scalatest_assert_macro_left = catalogManager.currentCatalog().name();
                String $org_scalatest_assert_macro_right = "dummy";
                String string = $org_scalatest_assert_macro_left;
                String string2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 50));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])catalogManager.currentNamespace())).sameElements((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b"})), "scala.Predef.refArrayOps[String](catalogManager.currentNamespace).sameElements[String](scala.Predef.wrapRefArray[String](scala.Array.apply[String](\"a\", \"b\")((ClassTag.apply[String](classOf[java.lang.String]): scala.reflect.ClassTag[String]))))", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 51));
            });
        }, new Position("CatalogManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 42));
        this.test("CatalogManager should keep the current catalog once set", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            CatalogManager catalogManager = new CatalogManager((CatalogPlugin)FakeV2SessionCatalog$.MODULE$, this.createSessionCatalog());
            String $org_scalatest_assert_macro_left = catalogManager.currentCatalog().name();
            String $org_scalatest_assert_macro_right = CatalogManager$.MODULE$.SESSION_CATALOG_NAME();
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 57));
            this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.sql.catalog.dummy"), (Object)DummyCatalog.class.getName())}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                catalogManager.setCurrentCatalog("dummy");
                String $org_scalatest_assert_macro_left = catalogManager.currentCatalog().name();
                String $org_scalatest_assert_macro_right = "dummy";
                String string = $org_scalatest_assert_macro_left;
                String string2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 60));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])catalogManager.currentNamespace())).sameElements((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b"})), "scala.Predef.refArrayOps[String](catalogManager.currentNamespace).sameElements[String](scala.Predef.wrapRefArray[String](scala.Array.apply[String](\"a\", \"b\")((ClassTag.apply[String](classOf[java.lang.String]): scala.reflect.ClassTag[String]))))", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 61));
                this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.sql.catalog.dummy2"), (Object)DummyCatalog.class.getName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.DEFAULT_CATALOG().key()), (Object)"dummy2")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    String $org_scalatest_assert_macro_left = catalogManager.currentCatalog().name();
                    String $org_scalatest_assert_macro_right = "dummy";
                    String string = $org_scalatest_assert_macro_left;
                    String string2 = $org_scalatest_assert_macro_right;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 66));
                });
            });
        }, new Position("CatalogManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 55));
        this.test("current namespace should be updated when switching current catalog", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            CatalogManager catalogManager = new CatalogManager((CatalogPlugin)FakeV2SessionCatalog$.MODULE$, this.createSessionCatalog());
            this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.sql.catalog.dummy"), (Object)DummyCatalog.class.getName())}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                catalogManager.setCurrentCatalog("dummy");
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])catalogManager.currentNamespace())).sameElements((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b"})), "scala.Predef.refArrayOps[String](catalogManager.currentNamespace).sameElements[String](scala.Predef.wrapRefArray[String](scala.Array.apply[String](\"a\", \"b\")((ClassTag.apply[String](classOf[java.lang.String]): scala.reflect.ClassTag[String]))))", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 75));
                catalogManager.setCurrentNamespace((String[])((Object[])new String[]{"a"}));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])catalogManager.currentNamespace())).sameElements((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"})), "scala.Predef.refArrayOps[String](catalogManager.currentNamespace).sameElements[String](scala.Predef.wrapRefArray[String](scala.Array.apply[String](\"a\")((ClassTag.apply[String](classOf[java.lang.String]): scala.reflect.ClassTag[String]))))", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 77));
                catalogManager.setCurrentCatalog("dummy");
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])catalogManager.currentNamespace())).sameElements((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"})), "scala.Predef.refArrayOps[String](catalogManager.currentNamespace).sameElements[String](scala.Predef.wrapRefArray[String](scala.Array.apply[String](\"a\")((ClassTag.apply[String](classOf[java.lang.String]): scala.reflect.ClassTag[String]))))", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 81));
                this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.sql.catalog.dummy2"), (Object)DummyCatalog.class.getName())}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    catalogManager.setCurrentCatalog("dummy2");
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])catalogManager.currentNamespace())).sameElements((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b"})), "scala.Predef.refArrayOps[String](catalogManager.currentNamespace).sameElements[String](scala.Predef.wrapRefArray[String](scala.Array.apply[String](\"a\", \"b\")((ClassTag.apply[String](classOf[java.lang.String]): scala.reflect.ClassTag[String]))))", Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 86));
                });
            });
        }, new Position("CatalogManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 71));
        this.test("set current namespace", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            SessionCatalog v1SessionCatalog = this.createSessionCatalog();
            v1SessionCatalog.createDatabase(new CatalogDatabase("test", "", v1SessionCatalog.getDefaultDBPath("test"), Predef$.MODULE$.Map().empty()), false);
            CatalogManager catalogManager = new CatalogManager((CatalogPlugin)FakeV2SessionCatalog$.MODULE$, v1SessionCatalog);
            catalogManager.setCurrentNamespace((String[])((Object[])new String[]{"test"}));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])catalogManager.currentNamespace())).sameElements((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test"})), "scala.Predef.refArrayOps[String](catalogManager.currentNamespace).sameElements[String](scala.Predef.wrapRefArray[String](scala.Array.apply[String](\"test\")((ClassTag.apply[String](classOf[java.lang.String]): scala.reflect.ClassTag[String]))))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 102));
            String $org_scalatest_assert_macro_left = v1SessionCatalog.getCurrentDatabase();
            String $org_scalatest_assert_macro_right = "test";
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 103));
            this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> catalogManager.setCurrentNamespace((String[])((Object[])new String[]{"ns1", "ns2"})), ClassTag$.MODULE$.apply(NoSuchNamespaceException.class), new Position("CatalogManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 105));
            this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.sql.catalog.dummy"), (Object)DummyCatalog.class.getName())}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                catalogManager.setCurrentCatalog("dummy");
                String $org_scalatest_assert_macro_left = v1SessionCatalog.getCurrentDatabase();
                String $org_scalatest_assert_macro_right = "default";
                String string = $org_scalatest_assert_macro_left;
                String string2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 112));
                catalogManager.setCurrentNamespace((String[])((Object[])new String[]{"test2"}));
                String $org_scalatest_assert_macro_left2 = v1SessionCatalog.getCurrentDatabase();
                String $org_scalatest_assert_macro_right2 = "default";
                String string3 = $org_scalatest_assert_macro_left2;
                String string4 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 114));
                this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.sql.catalog.testCatalog"), (Object)InMemoryTableCatalog.class.getName())}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    catalogManager.setCurrentCatalog("testCatalog");
                    ((InMemoryTableCatalog)catalogManager.currentCatalog()).createNamespace((String[])((Object[])new String[]{"test3"}), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().empty()).asJava());
                    String $org_scalatest_assert_macro_left = v1SessionCatalog.getCurrentDatabase();
                    String $org_scalatest_assert_macro_right = "default";
                    String string = $org_scalatest_assert_macro_left;
                    String string2 = $org_scalatest_assert_macro_right;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 121));
                    catalogManager.setCurrentNamespace((String[])((Object[])new String[]{"test3"}));
                    String $org_scalatest_assert_macro_left2 = v1SessionCatalog.getCurrentDatabase();
                    String $org_scalatest_assert_macro_right2 = "default";
                    String string3 = $org_scalatest_assert_macro_left2;
                    String string4 = $org_scalatest_assert_macro_right2;
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 123));
                    this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> catalogManager.setCurrentNamespace((String[])((Object[])new String[]{"ns1", "ns2"})), ClassTag$.MODULE$.apply(NoSuchNamespaceException.class), new Position("CatalogManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 125));
                });
            });
        }, new Position("CatalogManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 91));
    }
}

