/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connector.catalog;

import java.util.concurrent.Callable;
import org.apache.spark.SparkException;
import org.apache.spark.sql.connector.catalog.AccessErrorCatalogPlugin;
import org.apache.spark.sql.connector.catalog.CatalogNotFoundException;
import org.apache.spark.sql.connector.catalog.CatalogPlugin;
import org.apache.spark.sql.connector.catalog.Catalogs;
import org.apache.spark.sql.connector.catalog.ConstructorFailureCatalogPlugin;
import org.apache.spark.sql.connector.catalog.InvalidCatalogPlugin;
import org.apache.spark.sql.connector.catalog.TestCatalogPlugin;
import org.apache.spark.sql.internal.SQLConf;
import org.junit.Assert;
import org.junit.Test;

public class CatalogLoadingSuite {
    @Test
    public void testLoad() throws SparkException {
        SQLConf conf = new SQLConf();
        conf.setConfString("spark.sql.catalog.test-name", TestCatalogPlugin.class.getCanonicalName());
        CatalogPlugin plugin = Catalogs.load((String)"test-name", (SQLConf)conf);
        Assert.assertNotNull((String)"Should instantiate a non-null plugin", (Object)plugin);
        Assert.assertEquals((String)"Plugin should have correct implementation", TestCatalogPlugin.class, plugin.getClass());
        TestCatalogPlugin testPlugin = (TestCatalogPlugin)plugin;
        Assert.assertEquals((String)"Options should contain no keys", (long)0L, (long)testPlugin.options.size());
        Assert.assertEquals((String)"Catalog should have correct name", (Object)"test-name", (Object)testPlugin.name());
    }

    @Test
    public void testInitializationOptions() throws SparkException {
        SQLConf conf = new SQLConf();
        conf.setConfString("spark.sql.catalog.test-name", TestCatalogPlugin.class.getCanonicalName());
        conf.setConfString("spark.sql.catalog.test-name.name", "not-catalog-name");
        conf.setConfString("spark.sql.catalog.test-name.kEy", "valUE");
        CatalogPlugin plugin = Catalogs.load((String)"test-name", (SQLConf)conf);
        Assert.assertNotNull((String)"Should instantiate a non-null plugin", (Object)plugin);
        Assert.assertEquals((String)"Plugin should have correct implementation", TestCatalogPlugin.class, plugin.getClass());
        TestCatalogPlugin testPlugin = (TestCatalogPlugin)plugin;
        Assert.assertEquals((String)"Options should contain only two keys", (long)2L, (long)testPlugin.options.size());
        Assert.assertEquals((String)"Options should contain correct value for name (not overwritten)", (Object)"not-catalog-name", (Object)testPlugin.options.get((Object)"name"));
        Assert.assertEquals((String)"Options should contain correct value for key", (Object)"valUE", (Object)testPlugin.options.get((Object)"key"));
    }

    @Test
    public void testLoadWithoutConfig() {
        SQLConf conf = new SQLConf();
        SparkException exc = (SparkException)CatalogLoadingSuite.intercept(CatalogNotFoundException.class, () -> Catalogs.load((String)"missing", (SQLConf)conf));
        Assert.assertTrue((String)"Should complain that implementation is not configured", (boolean)exc.getMessage().contains("plugin class not found: spark.sql.catalog.missing is not defined"));
        Assert.assertTrue((String)"Should identify the catalog by name", (boolean)exc.getMessage().contains("missing"));
    }

    @Test
    public void testLoadMissingClass() {
        SQLConf conf = new SQLConf();
        conf.setConfString("spark.sql.catalog.missing", "com.example.NoSuchCatalogPlugin");
        SparkException exc = CatalogLoadingSuite.intercept(SparkException.class, () -> Catalogs.load((String)"missing", (SQLConf)conf));
        Assert.assertTrue((String)"Should complain that the class is not found", (boolean)exc.getMessage().contains("Cannot find catalog plugin class"));
        Assert.assertTrue((String)"Should identify the catalog by name", (boolean)exc.getMessage().contains("missing"));
        Assert.assertTrue((String)"Should identify the missing class", (boolean)exc.getMessage().contains("com.example.NoSuchCatalogPlugin"));
    }

    @Test
    public void testLoadNonCatalogPlugin() {
        SQLConf conf = new SQLConf();
        String invalidClassName = InvalidCatalogPlugin.class.getCanonicalName();
        conf.setConfString("spark.sql.catalog.invalid", invalidClassName);
        SparkException exc = CatalogLoadingSuite.intercept(SparkException.class, () -> Catalogs.load((String)"invalid", (SQLConf)conf));
        Assert.assertTrue((String)"Should complain that class does not implement CatalogPlugin", (boolean)exc.getMessage().contains("does not implement CatalogPlugin"));
        Assert.assertTrue((String)"Should identify the catalog by name", (boolean)exc.getMessage().contains("invalid"));
        Assert.assertTrue((String)"Should identify the class", (boolean)exc.getMessage().contains(invalidClassName));
    }

    @Test
    public void testLoadConstructorFailureCatalogPlugin() {
        SQLConf conf = new SQLConf();
        String invalidClassName = ConstructorFailureCatalogPlugin.class.getCanonicalName();
        conf.setConfString("spark.sql.catalog.invalid", invalidClassName);
        SparkException exc = CatalogLoadingSuite.intercept(SparkException.class, () -> Catalogs.load((String)"invalid", (SQLConf)conf));
        Assert.assertTrue((String)"Should identify the constructor error", (boolean)exc.getMessage().contains("Failed during instantiating constructor for catalog"));
        Assert.assertTrue((String)"Should have expected error message", (boolean)exc.getCause().getMessage().contains("Expected failure"));
    }

    @Test
    public void testLoadAccessErrorCatalogPlugin() {
        SQLConf conf = new SQLConf();
        String invalidClassName = AccessErrorCatalogPlugin.class.getCanonicalName();
        conf.setConfString("spark.sql.catalog.invalid", invalidClassName);
        SparkException exc = CatalogLoadingSuite.intercept(SparkException.class, () -> Catalogs.load((String)"invalid", (SQLConf)conf));
        Assert.assertTrue((String)"Should complain that no public constructor is provided", (boolean)exc.getMessage().contains("Failed to call public no-arg constructor for catalog"));
        Assert.assertTrue((String)"Should identify the catalog by name", (boolean)exc.getMessage().contains("invalid"));
        Assert.assertTrue((String)"Should identify the class", (boolean)exc.getMessage().contains(invalidClassName));
    }

    public static <E extends Exception> E intercept(Class<E> expected, Callable<?> callable) {
        try {
            callable.call();
            Assert.fail((String)("No exception was thrown, expected: " + expected.getName()));
        }
        catch (Exception actual) {
            try {
                Assert.assertEquals(expected, actual.getClass());
                return (E)actual;
            }
            catch (AssertionError e) {
                ((Throwable)((Object)e)).addSuppressed(actual);
                throw e;
            }
        }
        throw new UnsupportedOperationException("[BUG] Should not reach this statement");
    }
}

