/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.parser;

import java.io.File;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.concurrent.TimeUnit;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.catalyst.FunctionIdentifier;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.catalyst.analysis.AnalysisTest;
import org.apache.spark.sql.catalyst.analysis.Analyzer;
import org.apache.spark.sql.catalyst.analysis.MultiAlias;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAttribute;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAttribute$;
import org.apache.spark.sql.catalyst.analysis.UnresolvedFunction;
import org.apache.spark.sql.catalyst.analysis.UnresolvedFunction$;
import org.apache.spark.sql.catalyst.analysis.UnresolvedStar;
import org.apache.spark.sql.catalyst.dsl.package;
import org.apache.spark.sql.catalyst.expressions.Add;
import org.apache.spark.sql.catalyst.expressions.Add$;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.AliasHelper;
import org.apache.spark.sql.catalyst.expressions.And;
import org.apache.spark.sql.catalyst.expressions.AttributeMap;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.expressions.CaseKeyWhen$;
import org.apache.spark.sql.catalyst.expressions.CaseWhen$;
import org.apache.spark.sql.catalyst.expressions.CreateStruct$;
import org.apache.spark.sql.catalyst.expressions.CurrentDate;
import org.apache.spark.sql.catalyst.expressions.CurrentDate$;
import org.apache.spark.sql.catalyst.expressions.CurrentRow$;
import org.apache.spark.sql.catalyst.expressions.CurrentTimestamp;
import org.apache.spark.sql.catalyst.expressions.EqualTo;
import org.apache.spark.sql.catalyst.expressions.Exists;
import org.apache.spark.sql.catalyst.expressions.Exists$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.FrameType;
import org.apache.spark.sql.catalyst.expressions.GreaterThan;
import org.apache.spark.sql.catalyst.expressions.InSubquery;
import org.apache.spark.sql.catalyst.expressions.LambdaFunction;
import org.apache.spark.sql.catalyst.expressions.LambdaFunction$;
import org.apache.spark.sql.catalyst.expressions.LeafExpression;
import org.apache.spark.sql.catalyst.expressions.ListQuery;
import org.apache.spark.sql.catalyst.expressions.ListQuery$;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.Not;
import org.apache.spark.sql.catalyst.expressions.Or;
import org.apache.spark.sql.catalyst.expressions.PredicateHelper;
import org.apache.spark.sql.catalyst.expressions.RangeFrame$;
import org.apache.spark.sql.catalyst.expressions.RowFrame$;
import org.apache.spark.sql.catalyst.expressions.ScalarSubquery;
import org.apache.spark.sql.catalyst.expressions.ScalarSubquery$;
import org.apache.spark.sql.catalyst.expressions.SortOrder;
import org.apache.spark.sql.catalyst.expressions.SpecifiedWindowFrame;
import org.apache.spark.sql.catalyst.expressions.UnaryMinus;
import org.apache.spark.sql.catalyst.expressions.UnaryMinus$;
import org.apache.spark.sql.catalyst.expressions.UnboundedFollowing$;
import org.apache.spark.sql.catalyst.expressions.UnboundedPreceding$;
import org.apache.spark.sql.catalyst.expressions.UnresolvedNamedLambdaVariable;
import org.apache.spark.sql.catalyst.expressions.UnresolvedWindowExpression;
import org.apache.spark.sql.catalyst.expressions.UnspecifiedFrame$;
import org.apache.spark.sql.catalyst.expressions.WindowExpression;
import org.apache.spark.sql.catalyst.expressions.WindowFrame;
import org.apache.spark.sql.catalyst.expressions.WindowSpecDefinition;
import org.apache.spark.sql.catalyst.expressions.WindowSpecReference;
import org.apache.spark.sql.catalyst.expressions.aggregate.First;
import org.apache.spark.sql.catalyst.expressions.aggregate.Last;
import org.apache.spark.sql.catalyst.parser.CatalystSqlParser;
import org.apache.spark.sql.catalyst.parser.CatalystSqlParser$;
import org.apache.spark.sql.catalyst.parser.ParseException;
import org.apache.spark.sql.catalyst.parser.ParserInterface;
import org.apache.spark.sql.catalyst.plans.PlanTestBase;
import org.apache.spark.sql.catalyst.plans.SQLHelper;
import org.apache.spark.sql.catalyst.plans.logical.Aggregate;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.catalyst.rules.Rule;
import org.apache.spark.sql.catalyst.util.DateTimeTestUtils$;
import org.apache.spark.sql.catalyst.util.IntervalUtils;
import org.apache.spark.sql.catalyst.util.IntervalUtils$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.unsafe.types.CalendarInterval;
import org.apache.spark.unsafe.types.UTF8String;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Symbol;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005-d\u0001\u0002\b\u0010\u0001qAQa\n\u0001\u0005\u0002!BQa\u000b\u0001\u0005\u00041Bq\u0001\u0012\u0001C\u0002\u0013\u0005Q\t\u0003\u0004J\u0001\u0001\u0006IA\u0012\u0005\u0006\u0015\u0002!\ta\u0013\u0005\b=\u0002\t\n\u0011\"\u0001`\u0011\u0015Q\u0007\u0001\"\u0003l\u0011\u0015\u0011\b\u0001\"\u0001t\u0011\u001dY\b!%A\u0005\u0002}CQ\u0001 \u0001\u0005\nuD\u0011\"!\u0004\u0001\u0005\u0004%\t!a\u0004\t\u0011\u0005E\u0003\u0001)A\u0005\u0003#Aq!a\u0015\u0001\t\u0003\t)FA\u000bFqB\u0014Xm]:j_:\u0004\u0016M]:feN+\u0018\u000e^3\u000b\u0005A\t\u0012A\u00029beN,'O\u0003\u0002\u0013'\u0005A1-\u0019;bYf\u001cHO\u0003\u0002\u0015+\u0005\u00191/\u001d7\u000b\u0005Y9\u0012!B:qCJ\\'B\u0001\r\u001a\u0003\u0019\t\u0007/Y2iK*\t!$A\u0002pe\u001e\u001c\u0001aE\u0002\u0001;\u0005\u0002\"AH\u0010\u000e\u0003UI!\u0001I\u000b\u0003\u001bM\u0003\u0018M]6Gk:\u001cV/\u001b;f!\t\u0011S%D\u0001$\u0015\t!\u0013#\u0001\u0005b]\u0006d\u0017p]5t\u0013\t13E\u0001\u0007B]\u0006d\u0017p]5t)\u0016\u001cH/\u0001\u0004=S:LGO\u0010\u000b\u0002SA\u0011!\u0006A\u0007\u0002\u001f\u0005y1\u000f\u001e:j]\u001e$v.\u0016+GqM#(\u000f\u0006\u0002.kA\u0011afM\u0007\u0002_)\u0011\u0001'M\u0001\u0006if\u0004Xm\u001d\u0006\u0003eU\ta!\u001e8tC\u001a,\u0017B\u0001\u001b0\u0005))FK\u0012\u001dTiJLgn\u001a\u0005\u0006m\t\u0001\raN\u0001\u0004gR\u0014\bC\u0001\u001dB\u001d\tIt\b\u0005\u0002;{5\t1H\u0003\u0002=7\u00051AH]8pizR\u0011AP\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0001v\na\u0001\u0015:fI\u00164\u0017B\u0001\"D\u0005\u0019\u0019FO]5oO*\u0011\u0001)P\u0001\u000eI\u00164\u0017-\u001e7u!\u0006\u00148/\u001a:\u0016\u0003\u0019s!AK$\n\u0005!{\u0011!E\"bi\u0006d\u0017p\u001d;Tc2\u0004\u0016M]:fe\u0006qA-\u001a4bk2$\b+\u0019:tKJ\u0004\u0013aC1tg\u0016\u0014H/R9vC2$B\u0001\u0014)S5B\u0011QJT\u0007\u0002{%\u0011q*\u0010\u0002\u0005+:LG\u000fC\u0003R\u000b\u0001\u0007q'\u0001\u0006tc2\u001cu.\\7b]\u0012DQaU\u0003A\u0002Q\u000b\u0011!\u001a\t\u0003+bk\u0011A\u0016\u0006\u0003/F\t1\"\u001a=qe\u0016\u001c8/[8og&\u0011\u0011L\u0016\u0002\u000b\u000bb\u0004(/Z:tS>t\u0007b\u0002\t\u0006!\u0003\u0005\ra\u0017\t\u0003UqK!!X\b\u0003\u001fA\u000b'o]3s\u0013:$XM\u001d4bG\u0016\fQ#Y:tKJ$X)];bY\u0012\"WMZ1vYR$3'F\u0001aU\tY\u0016mK\u0001c!\t\u0019\u0007.D\u0001e\u0015\t)g-A\u0005v]\u000eDWmY6fI*\u0011q-P\u0001\u000bC:tw\u000e^1uS>t\u0017BA5e\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\nS:$XM]2faR$2\u0001\u00147n\u0011\u0015\tv\u00011\u00018\u0011\u0015qw\u00011\u0001p\u0003!iWm]:bO\u0016\u001c\bcA'qo%\u0011\u0011/\u0010\u0002\u000byI,\u0007/Z1uK\u0012t\u0014AC1tg\u0016\u0014H/\u0012<bYR!A\n^;{\u0011\u0015\t\u0006\u00021\u00018\u0011\u00151\b\u00021\u0001x\u0003\u0019)\u0007\u0010]3diB\u0011Q\n_\u0005\u0003sv\u00121!\u00118z\u0011\u001d\u0001\u0002\u0002%AA\u0002m\u000bA#Y:tKJ$XI^1mI\u0011,g-Y;mi\u0012\u001a\u0014A\u00017w)\rq\u00181\u0001\t\u0003+~L1!!\u0001W\u0005u)fN]3t_24X\r\u001a(b[\u0016$G*Y7cI\u00064\u0016M]5bE2,\u0007bBA\u0003\u0015\u0001\u0007\u0011qA\u0001\u0002gB\u0019Q*!\u0003\n\u0007\u0005-QH\u0001\u0004Ts6\u0014w\u000e\\\u0001\u000eS:$XM\u001d<bYVs\u0017\u000e^:\u0016\u0005\u0005E\u0001CBA\n\u00033\ti\"\u0004\u0002\u0002\u0016)\u0019\u0011qC\u001f\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002\u001c\u0005U!aA*fcB!\u0011qDA%\u001d\u0011\t\t#a\u0011\u000f\t\u0005\r\u0012Q\b\b\u0005\u0003K\tID\u0004\u0003\u0002(\u0005]b\u0002BA\u0015\u0003kqA!a\u000b\u000249!\u0011QFA\u0019\u001d\rQ\u0014qF\u0005\u00025%\u0011\u0001$G\u0005\u0003-]I!\u0001F\u000b\n\u0005I\u0019\u0012bAA\u001e#\u0005!Q\u000f^5m\u0013\u0011\ty$!\u0011\u0002\u001b%sG/\u001a:wC2,F/\u001b7t\u0015\r\tY$E\u0005\u0005\u0003\u000b\n9%\u0001\u0007J]R,'O^1m+:LGO\u0003\u0003\u0002@\u0005\u0005\u0013\u0002BA&\u0003\u001b\u0012QAV1mk\u0016L1!a\u0014>\u0005-)e.^7fe\u0006$\u0018n\u001c8\u0002\u001d%tG/\u001a:wC2,f.\u001b;tA\u0005y\u0011N\u001c;feZ\fG\u000eT5uKJ\fG\u000e\u0006\u0004\u0002X\u0005u\u0013\u0011\u000e\t\u0004+\u0006e\u0013bAA.-\n9A*\u001b;fe\u0006d\u0007bBA0\u001b\u0001\u0007\u0011\u0011M\u0001\u0002kB!\u0011qDA2\u0013\u0011\t)'a\u001a\u0003\u0019%sG/\u001a:wC2,f.\u001b;\u000b\t\u0005\u0015\u0013q\t\u0005\u0007\u0003\u000bi\u0001\u0019A\u001c")
public class ExpressionParserSuite
extends SparkFunSuite
implements AnalysisTest {
    private final CatalystSqlParser$ defaultParser;
    private final Seq<Enumeration.Value> intervalUnits;
    private String sparkHome;
    private volatile boolean bitmap$0;

    @Override
    public /* synthetic */ void org$apache$spark$sql$catalyst$analysis$AnalysisTest$$super$comparePlans(LogicalPlan plan1, LogicalPlan plan2, boolean checkAnalysis) {
        PlanTestBase.comparePlans$(this, plan1, plan2, checkAnalysis);
    }

    @Override
    public Seq<Rule<LogicalPlan>> extendedAnalysisRules() {
        return AnalysisTest.extendedAnalysisRules$(this);
    }

    @Override
    public Analyzer getAnalyzer() {
        return AnalysisTest.getAnalyzer$(this);
    }

    @Override
    public void checkAnalysis(LogicalPlan inputPlan, LogicalPlan expectedPlan, boolean caseSensitive) {
        AnalysisTest.checkAnalysis$(this, inputPlan, expectedPlan, caseSensitive);
    }

    @Override
    public boolean checkAnalysis$default$3() {
        return AnalysisTest.checkAnalysis$default$3$(this);
    }

    @Override
    public void comparePlans(LogicalPlan plan1, LogicalPlan plan2, boolean checkAnalysis) {
        AnalysisTest.comparePlans$(this, plan1, plan2, checkAnalysis);
    }

    @Override
    public boolean comparePlans$default$3() {
        return AnalysisTest.comparePlans$default$3$(this);
    }

    @Override
    public void assertAnalysisSuccess(LogicalPlan inputPlan, boolean caseSensitive) {
        AnalysisTest.assertAnalysisSuccess$(this, inputPlan, caseSensitive);
    }

    @Override
    public boolean assertAnalysisSuccess$default$2() {
        return AnalysisTest.assertAnalysisSuccess$default$2$(this);
    }

    @Override
    public void assertAnalysisError(LogicalPlan inputPlan, Seq<String> expectedErrors, boolean caseSensitive) {
        AnalysisTest.assertAnalysisError$(this, inputPlan, expectedErrors, caseSensitive);
    }

    @Override
    public boolean assertAnalysisError$default$3() {
        return AnalysisTest.assertAnalysisError$default$3$(this);
    }

    @Override
    public void interceptParseException(Function1<String, Object> parser, String sqlCommand, Seq<String> messages) {
        AnalysisTest.interceptParseException$(this, parser, sqlCommand, messages);
    }

    @Override
    public LogicalPlan normalizeExprIds(LogicalPlan plan) {
        return PlanTestBase.normalizeExprIds$(this, plan);
    }

    @Override
    public LogicalPlan rewriteNameFromAttrNullability(LogicalPlan plan) {
        return PlanTestBase.rewriteNameFromAttrNullability$(this, plan);
    }

    @Override
    public LogicalPlan normalizePlan(LogicalPlan plan) {
        return PlanTestBase.normalizePlan$(this, plan);
    }

    @Override
    public void compareExpressions(Expression e1, Expression e2) {
        PlanTestBase.compareExpressions$(this, e1, e2);
    }

    public SQLConf conf() {
        return SQLConfHelper.conf$((SQLConfHelper)this);
    }

    @Override
    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        SQLHelper.withSQLConf$(this, pairs, f);
    }

    @Override
    public void withTempPath(Function1<File, BoxedUnit> f) {
        SQLHelper.withTempPath$(this, f);
    }

    @Override
    public <T> void testSpecialDatetimeValues(Function1<ZoneId, T> test) {
        SQLHelper.testSpecialDatetimeValues$(this, test);
    }

    public Seq<Expression> splitConjunctivePredicates(Expression condition) {
        return PredicateHelper.splitConjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Option<Tuple2<Expression, LogicalPlan>> findExpressionAndTrackLineageDown(Expression exp, LogicalPlan plan) {
        return PredicateHelper.findExpressionAndTrackLineageDown$((PredicateHelper)this, (Expression)exp, (LogicalPlan)plan);
    }

    public Seq<Expression> splitDisjunctivePredicates(Expression condition) {
        return PredicateHelper.splitDisjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public boolean canEvaluate(Expression expr, LogicalPlan plan) {
        return PredicateHelper.canEvaluate$((PredicateHelper)this, (Expression)expr, (LogicalPlan)plan);
    }

    public boolean canEvaluateWithinJoin(Expression expr) {
        return PredicateHelper.canEvaluateWithinJoin$((PredicateHelper)this, (Expression)expr);
    }

    public Option<Expression> extractPredicatesWithinOutputSet(Expression condition, AttributeSet outputSet) {
        return PredicateHelper.extractPredicatesWithinOutputSet$((PredicateHelper)this, (Expression)condition, (AttributeSet)outputSet);
    }

    public AttributeMap<Alias> getAliasMap(Project plan) {
        return AliasHelper.getAliasMap$((AliasHelper)this, (Project)plan);
    }

    public AttributeMap<Alias> getAliasMap(Aggregate plan) {
        return AliasHelper.getAliasMap$((AliasHelper)this, (Aggregate)plan);
    }

    public AttributeMap<Alias> getAliasMap(Seq<NamedExpression> exprs) {
        return AliasHelper.getAliasMap$((AliasHelper)this, exprs);
    }

    public Expression replaceAlias(Expression expr, AttributeMap<Alias> aliasMap) {
        return AliasHelper.replaceAlias$((AliasHelper)this, (Expression)expr, aliasMap);
    }

    public NamedExpression replaceAliasButKeepName(NamedExpression expr, AttributeMap<Alias> aliasMap) {
        return AliasHelper.replaceAliasButKeepName$((AliasHelper)this, (NamedExpression)expr, aliasMap);
    }

    public Expression trimAliases(Expression e) {
        return AliasHelper.trimAliases$((AliasHelper)this, (Expression)e);
    }

    public <T extends Expression> T trimNonTopLevelAliases(T e) {
        return (T)AliasHelper.trimNonTopLevelAliases$((AliasHelper)this, e);
    }

    private String sparkHome$lzycompute() {
        ExpressionParserSuite expressionParserSuite = this;
        synchronized (expressionParserSuite) {
            if (!this.bitmap$0) {
                this.sparkHome = SQLHelper.sparkHome$(this);
                this.bitmap$0 = true;
            }
        }
        return this.sparkHome;
    }

    @Override
    public String sparkHome() {
        return !this.bitmap$0 ? this.sparkHome$lzycompute() : this.sparkHome;
    }

    public UTF8String stringToUTF8Str(String str) {
        return UTF8String.fromString((String)str);
    }

    public CatalystSqlParser$ defaultParser() {
        return this.defaultParser;
    }

    public void assertEqual(String sqlCommand, Expression e, ParserInterface parser) {
        this.compareExpressions(parser.parseExpression(sqlCommand), e);
    }

    public ParserInterface assertEqual$default$3() {
        return this.defaultParser();
    }

    private void intercept(String sqlCommand, Seq<String> messages) {
        this.interceptParseException((Function1<String, Object>)(Function1 & Serializable & scala.Serializable)sqlText -> this.defaultParser().parseExpression(sqlText), sqlCommand, messages);
    }

    public void assertEval(String sqlCommand, Object expect, ParserInterface parser) {
        Expression qual$1 = parser.parseExpression(sqlCommand);
        InternalRow x$1 = qual$1.eval$default$1();
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(qual$1.eval(x$1));
        Object $org_scalatest_assert_macro_right = expect;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", $org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 65));
    }

    public ParserInterface assertEval$default$3() {
        return this.defaultParser();
    }

    private UnresolvedNamedLambdaVariable lv(Symbol s) {
        return new UnresolvedNamedLambdaVariable((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{s.name()})));
    }

    public Seq<Enumeration.Value> intervalUnits() {
        return this.intervalUnits;
    }

    public Literal intervalLiteral(Enumeration.Value u, String s) {
        return Literal$.MODULE$.apply((Object)IntervalUtils$.MODULE$.stringToInterval(this.stringToUTF8Str(new StringBuilder(1).append(s).append(" ").append(u.toString()).toString())));
    }

    public static final /* synthetic */ String $anonfun$new$5(int x) {
        return new StringBuilder(4).append(x).append(" == ").append(x).toString();
    }

    private final void testVeryBinaryExpression$1(String op, Class clazz) {
        String sql = ((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 1000).map((Function1 & Serializable & scala.Serializable)x -> ExpressionParserSuite.$anonfun$new$5(BoxesRunTime.unboxToInt((Object)x)), IndexedSeq$.MODULE$.canBuildFrom())).mkString(op);
        Expression e = this.defaultParser().parseExpression(sql);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)e.collect((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Expression, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                Object object = A1 instanceof EqualTo ? BoxesRunTime.boxToBoolean((boolean)true) : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Expression x1) {
                Expression expression = x1;
                boolean bl = expression instanceof EqualTo;
                return bl;
            }
        }).size()));
        int $org_scalatest_assert_macro_right = 1000;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 120));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)e.collect((PartialFunction)new scala.Serializable(null, clazz){
            public static final long serialVersionUID = 0L;
            private final Class clazz$1;

            public final <A1 extends Expression, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                A1 A1 = x2;
                Object object = this.clazz$1.isInstance(A1) ? BoxesRunTime.boxToBoolean((boolean)true) : function1.apply(x2);
                return (B1)object;
            }

            public final boolean isDefinedAt(Expression x2) {
                Expression expression = x2;
                boolean bl = this.clazz$1.isInstance(expression);
                return bl;
            }
            {
                this.clazz$1 = clazz$1;
            }
        }).size()));
        int $org_scalatest_assert_macro_right2 = 999;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 121));
    }

    public static final /* synthetic */ void $anonfun$new$17(ExpressionParserSuite $this, String quantifier) {
        $this.assertEqual(new StringBuilder(22).append("a like ").append(quantifier).append(" ('foo%', 'b%')").toString(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).likeAny((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.stringToLiteral("foo%"), package.expressions$.MODULE$.stringToLiteral("b%")})), $this.assertEqual$default$3());
        $this.assertEqual(new StringBuilder(26).append("a not like ").append(quantifier).append(" ('foo%', 'b%')").toString(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).notLikeAny((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.stringToLiteral("foo%"), package.expressions$.MODULE$.stringToLiteral("b%")})), $this.assertEqual$default$3());
        $this.assertEqual(new StringBuilder(28).append("not (a like ").append(quantifier).append(" ('foo%', 'b%'))").toString(), (Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).likeAny((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.stringToLiteral("foo%"), package.expressions$.MODULE$.stringToLiteral("b%")}))).unary_$bang(), $this.assertEqual$default$3());
    }

    private static final Expression windowed$1(Seq partitioning, Seq ordering, WindowFrame frame, UnresolvedFunction func$1) {
        return new WindowExpression((Expression)func$1, new WindowSpecDefinition(partitioning, ordering, frame));
    }

    private static final Seq windowed$default$1$1() {
        return (Seq)Seq$.MODULE$.empty();
    }

    private static final Seq windowed$default$2$1() {
        return (Seq)Seq$.MODULE$.empty();
    }

    private static final WindowFrame windowed$default$3$1() {
        return UnspecifiedFrame$.MODULE$;
    }

    private static final Expression windowed$2(Seq partitioning, Seq ordering, WindowFrame frame, UnresolvedFunction func$2) {
        return new WindowExpression((Expression)func$2, new WindowSpecDefinition(partitioning, ordering, frame));
    }

    private static final Seq windowed$default$1$2() {
        return (Seq)Seq$.MODULE$.empty();
    }

    private static final Seq windowed$default$2$2() {
        return (Seq)Seq$.MODULE$.empty();
    }

    private static final WindowFrame windowed$default$3$2() {
        return UnspecifiedFrame$.MODULE$;
    }

    public static final /* synthetic */ void $anonfun$new$29(ExpressionParserSuite $this, String frameTypeSql$1, Product frameType$1, UnresolvedFunction func$2, Tuple3 x0$2) {
        Tuple3 tuple3 = x0$2;
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        String boundarySql = (String)tuple3._1();
        Expression begin = (Expression)tuple3._2();
        Expression end = (Expression)tuple3._3();
        String query = new StringBuilder(41).append("foo(*) over (partition by a order by b ").append(frameTypeSql$1).append(" ").append(boundarySql).append(")").toString();
        Expression expr = ExpressionParserSuite.windowed$2((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UnresolvedAttribute[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a"))})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).asc()})), (WindowFrame)new SpecifiedWindowFrame((FrameType)frameType$1, begin, end), func$2);
        $this.assertEqual(query, expr, $this.assertEqual$default$3());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$new$28(ExpressionParserSuite $this, Seq boundaries$1, UnresolvedFunction func$2, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String frameTypeSql = (String)tuple2._1();
        Product frameType = (Product)tuple2._2();
        boundaries$1.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            ExpressionParserSuite.$anonfun$new$29($this, frameTypeSql, frameType, func$2, x0$2);
            return BoxedUnit.UNIT;
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ byte $anonfun$new$38(int x$1) {
        return (byte)x$1;
    }

    public static final /* synthetic */ byte $anonfun$new$39(int x$2) {
        return (byte)x$2;
    }

    private final void testDecimal$1(String value) {
        this.assertEqual(value, (Expression)Literal$.MODULE$.apply((Object)package$.MODULE$.BigDecimal().apply(value).underlying()), this.assertEqual$default$3());
    }

    private final void testDecimal$2(String value, ParserInterface parser) {
        this.assertEqual(value, (Expression)Literal$.MODULE$.apply((Object)package$.MODULE$.BigDecimal().apply(value).underlying()), parser);
    }

    public static final /* synthetic */ void $anonfun$new$49(ExpressionParserSuite $this, String intervalValue$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String sign = (String)tuple2._1();
        Expression expectedLiteral = (Expression)tuple2._2();
        $this.assertEqual(new StringBuilder(9).append(sign).append("interval ").append(intervalValue$1).toString(), expectedLiteral, $this.assertEqual$default$3());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private final void checkIntervals$1(String intervalValue, Literal expected) {
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)""), (Object)expected), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"-"), (Object)new UnaryMinus((Expression)expected, UnaryMinus$.MODULE$.apply$default$2()))}))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ExpressionParserSuite.$anonfun$new$49(this, intervalValue, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$52(ExpressionParserSuite $this, Enumeration.Value unit$1, String form$1, String value) {
        Literal expected = $this.intervalLiteral(unit$1, value);
        $this.checkIntervals$1(new StringBuilder(1).append(value).append(" ").append(unit$1).append(form$1).toString(), expected);
        $this.checkIntervals$1(new StringBuilder(3).append("'").append(value).append("' ").append(unit$1).append(form$1).toString(), expected);
    }

    public static final /* synthetic */ void $anonfun$new$53(ExpressionParserSuite $this, String value) {
        Literal result = Literal$.MODULE$.apply((Object)IntervalUtils$.MODULE$.fromYearMonthString(value));
        $this.checkIntervals$1(new StringBuilder(16).append("'").append(value).append("' year to month").toString(), result);
    }

    public static final /* synthetic */ void $anonfun$new$54(ExpressionParserSuite $this, String value) {
        Literal result = Literal$.MODULE$.apply((Object)IntervalUtils$.MODULE$.fromDayTimeString(value));
        $this.checkIntervals$1(new StringBuilder(16).append("'").append(value).append("' day to second").toString(), result);
    }

    public static final /* synthetic */ void $anonfun$new$55(ExpressionParserSuite $this, String value) {
        Literal result = Literal$.MODULE$.apply((Object)IntervalUtils$.MODULE$.fromDayTimeString(value, IntervalUtils.IntervalUnit$.MODULE$.HOUR(), IntervalUtils.IntervalUnit$.MODULE$.SECOND()));
        $this.checkIntervals$1(new StringBuilder(17).append("'").append(value).append("' hour to second").toString(), result);
    }

    private static final long toMicros$1(LocalDateTime time, ZoneId zid$1) {
        long seconds = time.atZone(zid$1).toInstant().getEpochSecond();
        return TimeUnit.SECONDS.toMicros(seconds);
    }

    public ExpressionParserSuite() {
        AliasHelper.$init$((AliasHelper)this);
        PredicateHelper.$init$((PredicateHelper)this);
        SQLHelper.$init$(this);
        SQLConfHelper.$init$((SQLConfHelper)this);
        PlanTestBase.$init$(this);
        AnalysisTest.$init$(this);
        this.defaultParser = CatalystSqlParser$.MODULE$;
        this.test("star expressions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertEqual("*", (Expression)new UnresolvedStar((Option)None$.MODULE$), this.assertEqual$default$3());
            this.assertEqual("a.b.*", (Expression)new UnresolvedStar(Option$.MODULE$.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b"})))), this.assertEqual$default$3());
        }, new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 68));
        this.test("named expressions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            CallSite r0 = SymbolLiteral.bootstrap("apply", "a");
            this.assertEqual("a", (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)r0), this.assertEqual$default$3());
            NamedExpression r1 = package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).as("b");
            this.assertEqual("a as b", (Expression)r1, this.assertEqual$default$3());
            this.assertEqual("a b", (Expression)r1, this.assertEqual$default$3());
            this.assertEqual("a as (b, c)", (Expression)new MultiAlias((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b", "c"}))), this.assertEqual$default$3());
            this.assertEqual("a() (b, c)", (Expression)new MultiAlias((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).function((Seq)Nil$.MODULE$), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b", "c"}))), this.assertEqual$default$3());
            this.assertEqual("1SL", (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "1SL")), this.assertEqual$default$3());
            this.assertEqual("a.* b", (Expression)package.expressions$.MODULE$.DslExpression((Expression)new UnresolvedStar(Option$.MODULE$.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))))).as((Symbol)SymbolLiteral.bootstrap("apply", "b")), this.assertEqual$default$3());
        }, new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 77));
        this.test("binary logical expressions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertEqual("a and b", (Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$amp$amp((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))), this.assertEqual$default$3());
            this.assertEqual("a or b", (Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$bar$bar((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))), this.assertEqual$default$3());
            this.assertEqual("a and b or c and d", (Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$amp$amp((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b")))).$bar$bar((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "c")).$amp$amp((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "d")))), this.assertEqual$default$3());
            this.assertEqual("a or b or c and d", (Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$bar$bar((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b")))).$bar$bar((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "c")).$amp$amp((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "d")))), this.assertEqual$default$3());
            this.assertEqual("a or b or c or d or e or f", (Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$bar$bar((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b")))).$bar$bar((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "c")))).$bar$bar((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "d")).$bar$bar((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "e")))).$bar$bar((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "f")))), this.assertEqual$default$3());
            this.assertEqual("a and b and c and d and e and f", (Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$amp$amp((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b")))).$amp$amp((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "c")))).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "d")).$amp$amp((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "e")))).$amp$amp((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "f")))), this.assertEqual$default$3());
        }, new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 100));
        this.test("long binary logical expressions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.testVeryBinaryExpression$1(" AND ", And.class);
            this.testVeryBinaryExpression$1(" OR ", Or.class);
        }, new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 116));
        this.test("not expressions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertEqual("not a", (Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).unary_$bang(), this.assertEqual$default$3());
            this.assertEqual("!a", (Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).unary_$bang(), this.assertEqual$default$3());
            this.assertEqual("not true > true", (Expression)new Not((Expression)new GreaterThan((Expression)package.expressions$.MODULE$.booleanToLiteral(true), (Expression)package.expressions$.MODULE$.booleanToLiteral(true))), this.assertEqual$default$3());
        }, new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 127));
        this.test("exists expression", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.assertEqual("exists (select 1 from b where b.x = a.x)", (Expression)new Exists(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).where((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b.x")).$eq$eq$eq((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a.x"))))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.intToLiteral(1)})), Exists$.MODULE$.apply$default$2(), Exists$.MODULE$.apply$default$3()), this.assertEqual$default$3()), new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 133));
        this.test("comparison expressions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertEqual("a = b", (Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$eq$eq$eq((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))), this.assertEqual$default$3());
            this.assertEqual("a == b", (Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$eq$eq$eq((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))), this.assertEqual$default$3());
            this.assertEqual("a <=> b", (Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$less$eq$greater((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))), this.assertEqual$default$3());
            this.assertEqual("a <> b", (Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$eq$bang$eq((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))), this.assertEqual$default$3());
            this.assertEqual("a != b", (Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$eq$bang$eq((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))), this.assertEqual$default$3());
            this.assertEqual("a < b", (Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$less((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))), this.assertEqual$default$3());
            this.assertEqual("a <= b", (Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$less$eq((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))), this.assertEqual$default$3());
            this.assertEqual("a !> b", (Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$less$eq((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))), this.assertEqual$default$3());
            this.assertEqual("a > b", (Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$greater((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))), this.assertEqual$default$3());
            this.assertEqual("a >= b", (Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$greater$eq((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))), this.assertEqual$default$3());
            this.assertEqual("a !< b", (Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$greater$eq((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))), this.assertEqual$default$3());
        }, new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 139));
        this.test("between expressions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertEqual("a between b and c", (Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$greater$eq((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b")))).$amp$amp((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$less$eq((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "c")))), this.assertEqual$default$3());
            this.assertEqual("a not between b and c", (Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$greater$eq((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b")))).$amp$amp((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$less$eq((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "c"))))).unary_$bang(), this.assertEqual$default$3());
        }, new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 153));
        this.test("in expressions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertEqual("a in (b, c, d)", package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).in((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "c")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "d"))})), this.assertEqual$default$3());
            this.assertEqual("a not in (b, c, d)", (Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).in((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "c")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "d"))}))).unary_$bang(), this.assertEqual$default$3());
        }, new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 158));
        this.test("in sub-query", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertEqual("a in (select b from c)", (Expression)new InSubquery((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UnresolvedAttribute[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a"))})), new ListQuery(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))})), ListQuery$.MODULE$.apply$default$2(), ListQuery$.MODULE$.apply$default$3(), ListQuery$.MODULE$.apply$default$4())), this.assertEqual$default$3());
            this.assertEqual("(a, b, c) in (select d, e, f from g)", (Expression)new InSubquery((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UnresolvedAttribute[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "c"))})), new ListQuery(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"g"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "d")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "e")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "f"))})), ListQuery$.MODULE$.apply$default$2(), ListQuery$.MODULE$.apply$default$3(), ListQuery$.MODULE$.apply$default$4())), this.assertEqual$default$3());
            this.assertEqual("(a, b) in (select c from d)", (Expression)new InSubquery((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UnresolvedAttribute[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))})), new ListQuery(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"d"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "c"))})), ListQuery$.MODULE$.apply$default$2(), ListQuery$.MODULE$.apply$default$3(), ListQuery$.MODULE$.apply$default$4())), this.assertEqual$default$3());
            this.assertEqual("(a) in (select b from c)", (Expression)new InSubquery((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UnresolvedAttribute[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a"))})), new ListQuery(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))})), ListQuery$.MODULE$.apply$default$2(), ListQuery$.MODULE$.apply$default$3(), ListQuery$.MODULE$.apply$default$4())), this.assertEqual$default$3());
        }, new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 163));
        this.test("like expressions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            package.ExpressionConversions.DslSymbol qual$1 = package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a"));
            Literal x$1 = package.expressions$.MODULE$.stringToLiteral("pattern%");
            char x$2 = qual$1.like$default$2();
            this.assertEqual("a like 'pattern%'", qual$1.like((Expression)x$1, x$2), this.assertEqual$default$3());
            package.ExpressionConversions.DslSymbol qual$2 = package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a"));
            Literal x$3 = package.expressions$.MODULE$.stringToLiteral("pattern%");
            char x$4 = qual$2.like$default$2();
            this.assertEqual("a not like 'pattern%'", (Expression)package.expressions$.MODULE$.DslExpression(qual$2.like((Expression)x$3, x$4)).unary_$bang(), this.assertEqual$default$3());
            this.assertEqual("a rlike 'pattern%'", package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).rlike((Expression)package.expressions$.MODULE$.stringToLiteral("pattern%")), this.assertEqual$default$3());
            this.assertEqual("a not rlike 'pattern%'", (Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).rlike((Expression)package.expressions$.MODULE$.stringToLiteral("pattern%"))).unary_$bang(), this.assertEqual$default$3());
            this.assertEqual("a regexp 'pattern%'", package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).rlike((Expression)package.expressions$.MODULE$.stringToLiteral("pattern%")), this.assertEqual$default$3());
            this.assertEqual("a not regexp 'pattern%'", (Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).rlike((Expression)package.expressions$.MODULE$.stringToLiteral("pattern%"))).unary_$bang(), this.assertEqual$default$3());
        }, new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 181));
        this.test("like escape expressions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String message = "Escape string must contain only one character.";
            this.assertEqual("a like 'pattern%' escape '#'", package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).like((Expression)package.expressions$.MODULE$.stringToLiteral("pattern%"), '#'), this.assertEqual$default$3());
            this.assertEqual("a like 'pattern%' escape '\"'", package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).like((Expression)package.expressions$.MODULE$.stringToLiteral("pattern%"), '\"'), this.assertEqual$default$3());
            this.intercept("a like 'pattern%' escape '##'", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{message}));
            this.intercept("a like 'pattern%' escape ''", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{message}));
            this.assertEqual("a not like 'pattern%' escape '#'", (Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).like((Expression)package.expressions$.MODULE$.stringToLiteral("pattern%"), '#')).unary_$bang(), this.assertEqual$default$3());
            this.assertEqual("a not like 'pattern%' escape '\"'", (Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).like((Expression)package.expressions$.MODULE$.stringToLiteral("pattern%"), '\"')).unary_$bang(), this.assertEqual$default$3());
            this.intercept("a not like 'pattern%' escape '\"/'", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{message}));
            this.intercept("a not like 'pattern%' escape ''", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{message}));
        }, new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 190));
        this.test("like expressions with ESCAPED_STRING_LITERALS = true", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ESCAPED_STRING_LITERALS().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            CatalystSqlParser parser = new CatalystSqlParser();
            this.assertEqual("a rlike '^\\x20[\\x20-\\x23]+$'", package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).rlike((Expression)package.expressions$.MODULE$.stringToLiteral("^\\x20[\\x20-\\x23]+$")), (ParserInterface)parser);
            this.assertEqual("a rlike 'pattern\\\\'", package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).rlike((Expression)package.expressions$.MODULE$.stringToLiteral("pattern\\\\")), (ParserInterface)parser);
            this.assertEqual("a rlike 'pattern\\t\\n'", package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).rlike((Expression)package.expressions$.MODULE$.stringToLiteral("pattern\\t\\n")), (ParserInterface)parser);
        }), new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 202));
        this.test("(NOT) LIKE (ANY | SOME | ALL) expressions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"any", "some"}))).foreach((Function1 & Serializable & scala.Serializable)quantifier -> {
                ExpressionParserSuite.$anonfun$new$17(this, quantifier);
                return BoxedUnit.UNIT;
            });
            this.assertEqual("a like all ('foo%', 'b%')", package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).likeAll((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.stringToLiteral("foo%"), package.expressions$.MODULE$.stringToLiteral("b%")})), this.assertEqual$default$3());
            this.assertEqual("a not like all ('foo%', 'b%')", package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).notLikeAll((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.stringToLiteral("foo%"), package.expressions$.MODULE$.stringToLiteral("b%")})), this.assertEqual$default$3());
            this.assertEqual("not (a like all ('foo%', 'b%'))", (Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).likeAll((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.stringToLiteral("foo%"), package.expressions$.MODULE$.stringToLiteral("b%")}))).unary_$bang(), this.assertEqual$default$3());
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"any", "some", "all"}))).foreach((Function1 & Serializable & scala.Serializable)quantifier -> {
                this.intercept(new StringBuilder(9).append("a like ").append(quantifier).append("()").toString(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected something between '(' and ')'"}));
                return BoxedUnit.UNIT;
            });
        }, new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 211));
        this.test("is null expressions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertEqual("a is null", (Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).isNull(), this.assertEqual$default$3());
            this.assertEqual("a is not null", (Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).isNotNull(), this.assertEqual$default$3());
            this.assertEqual("a = b is null", (Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$eq$eq$eq((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b")))).isNull(), this.assertEqual$default$3());
            this.assertEqual("a = b is not null", (Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$eq$eq$eq((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b")))).isNotNull(), this.assertEqual$default$3());
        }, new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 226));
        this.test("is distinct expressions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertEqual("a is distinct from b", (Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$less$eq$greater((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b")))).unary_$bang(), this.assertEqual$default$3());
            this.assertEqual("a is not distinct from b", (Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$less$eq$greater((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))), this.assertEqual$default$3());
        }, new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 233));
        this.test("binary arithmetic expressions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertEqual("a * b", package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$times((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))), this.assertEqual$default$3());
            this.assertEqual("a / b", package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$div((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))), this.assertEqual$default$3());
            this.assertEqual("a DIV b", package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).div((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))), this.assertEqual$default$3());
            this.assertEqual("a % b", package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$percent((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))), this.assertEqual$default$3());
            this.assertEqual("a + b", package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$plus((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))), this.assertEqual$default$3());
            this.assertEqual("a - b", package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$minus((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))), this.assertEqual$default$3());
            this.assertEqual("a & b", package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$amp((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))), this.assertEqual$default$3());
            this.assertEqual("a ^ b", package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$up((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))), this.assertEqual$default$3());
            this.assertEqual("a | b", package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$bar((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))), this.assertEqual$default$3());
            this.assertEqual("a * t | b ^ c & d - e + f % g DIV h / i * k", package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$times((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "t")))).$bar(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).$up(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "c")).$amp(package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "d")).$minus((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "e")))).$plus(package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "f")).$percent((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "g")))).div((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "h")))).$div((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "i")))).$times((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "k"))))))), this.assertEqual$default$3());
        }, new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 238));
        this.test("unary arithmetic expressions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertEqual("+a", package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).unary_$plus(), this.assertEqual$default$3());
            this.assertEqual("-a", package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).unary_$minus(), this.assertEqual$default$3());
            this.assertEqual("~a", package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).unary_$tilde(), this.assertEqual$default$3());
            this.assertEqual("-+~~a", package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).unary_$tilde()).unary_$tilde()).unary_$plus()).unary_$minus(), this.assertEqual$default$3());
        }, new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 256));
        this.test("cast expressions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertEqual("cast(a as int)", package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).cast((DataType)IntegerType$.MODULE$), this.assertEqual$default$3());
            this.assertEqual("cast(a as timestamp)", package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).cast((DataType)TimestampType$.MODULE$), this.assertEqual$default$3());
            this.assertEqual("cast(a as array<int>)", package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).cast((DataType)ArrayType$.MODULE$.apply((DataType)IntegerType$.MODULE$)), this.assertEqual$default$3());
            this.assertEqual("cast(cast(a as int) as long)", package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).cast((DataType)IntegerType$.MODULE$)).cast((DataType)LongType$.MODULE$), this.assertEqual$default$3());
        }, new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 263));
        this.test("function expressions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertEqual("foo()", (Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "foo")).function((Seq)Nil$.MODULE$), this.assertEqual$default$3());
            this.assertEqual("foo.bar()", (Expression)new UnresolvedFunction(new FunctionIdentifier("bar", (Option)new Some((Object)"foo")), (Seq)Seq$.MODULE$.empty(), false, UnresolvedFunction$.MODULE$.apply$default$4()), this.assertEqual$default$3());
            this.assertEqual("foo(*)", (Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "foo")).function((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)})), this.assertEqual$default$3());
            this.assertEqual("count(*)", (Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "count")).function((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.intToLiteral(1)})), this.assertEqual$default$3());
            this.assertEqual("foo(a, b)", (Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "foo")).function((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))})), this.assertEqual$default$3());
            this.assertEqual("foo(all a, b)", (Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "foo")).function((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))})), this.assertEqual$default$3());
            this.assertEqual("foo(distinct a, b)", (Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "foo")).distinctFunction((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))})), this.assertEqual$default$3());
            this.assertEqual("grouping(distinct a, b)", (Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "grouping")).distinctFunction((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))})), this.assertEqual$default$3());
            this.assertEqual("`select`(all a, b)", (Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "select")).function((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))})), this.assertEqual$default$3());
            this.intercept("foo(a x)", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"extraneous input 'x'"}));
        }, new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 271));
        this.test("lambda functions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertEqual("x -> x + 1", (Expression)new LambdaFunction(package.expressions$.MODULE$.DslExpression((Expression)this.lv((Symbol)SymbolLiteral.bootstrap("apply", "x"))).$plus((Expression)package.expressions$.MODULE$.intToLiteral(1)), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UnresolvedNamedLambdaVariable[]{this.lv((Symbol)SymbolLiteral.bootstrap("apply", "x"))})), LambdaFunction$.MODULE$.apply$default$3()), this.assertEqual$default$3());
            this.assertEqual("(x, y) -> x + y", (Expression)new LambdaFunction(package.expressions$.MODULE$.DslExpression((Expression)this.lv((Symbol)SymbolLiteral.bootstrap("apply", "x"))).$plus((Expression)this.lv((Symbol)SymbolLiteral.bootstrap("apply", "y"))), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UnresolvedNamedLambdaVariable[]{this.lv((Symbol)SymbolLiteral.bootstrap("apply", "x")), this.lv((Symbol)SymbolLiteral.bootstrap("apply", "y"))})), LambdaFunction$.MODULE$.apply$default$3()), this.assertEqual$default$3());
        }, new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 287));
        this.test("window function expressions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            UnresolvedFunction func = package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "foo")).function((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}));
            this.assertEqual("foo(*) over w1", (Expression)new UnresolvedWindowExpression((Expression)func, new WindowSpecReference("w1")), this.assertEqual$default$3());
            this.assertEqual("foo(*) over ()", ExpressionParserSuite.windowed$1(ExpressionParserSuite.windowed$default$1$1(), ExpressionParserSuite.windowed$default$2$1(), ExpressionParserSuite.windowed$default$3$1(), func), this.assertEqual$default$3());
            this.assertEqual("foo(*) over (partition by a, b)", ExpressionParserSuite.windowed$1((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UnresolvedAttribute[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))})), ExpressionParserSuite.windowed$default$2$1(), ExpressionParserSuite.windowed$default$3$1(), func), this.assertEqual$default$3());
            this.assertEqual("foo(*) over (distribute by a, b)", ExpressionParserSuite.windowed$1((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UnresolvedAttribute[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))})), ExpressionParserSuite.windowed$default$2$1(), ExpressionParserSuite.windowed$default$3$1(), func), this.assertEqual$default$3());
            this.assertEqual("foo(*) over (cluster by a, b)", ExpressionParserSuite.windowed$1((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UnresolvedAttribute[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))})), ExpressionParserSuite.windowed$default$2$1(), ExpressionParserSuite.windowed$default$3$1(), func), this.assertEqual$default$3());
            this.assertEqual("foo(*) over (order by a desc, b asc)", ExpressionParserSuite.windowed$1((Seq)Seq$.MODULE$.empty(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).desc(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).asc()})), ExpressionParserSuite.windowed$default$3$1(), func), this.assertEqual$default$3());
            this.assertEqual("foo(*) over (sort by a desc, b asc)", ExpressionParserSuite.windowed$1((Seq)Seq$.MODULE$.empty(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).desc(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).asc()})), ExpressionParserSuite.windowed$default$3$1(), func), this.assertEqual$default$3());
            this.assertEqual("foo(*) over (partition by a, b order by c)", ExpressionParserSuite.windowed$1((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UnresolvedAttribute[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "c")).asc()})), ExpressionParserSuite.windowed$default$3$1(), func), this.assertEqual$default$3());
            this.assertEqual("foo(*) over (distribute by a, b sort by c)", ExpressionParserSuite.windowed$1((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UnresolvedAttribute[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "c")).asc()})), ExpressionParserSuite.windowed$default$3$1(), func), this.assertEqual$default$3());
            this.assertEqual("sum(product + 1) over (partition by ((product) + (1)) order by 2)", (Expression)new WindowExpression((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "sum")).function((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "product")).$plus((Expression)package.expressions$.MODULE$.intToLiteral(1))})), new WindowSpecDefinition((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "product")).$plus((Expression)package.expressions$.MODULE$.intToLiteral(1))})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)2))).asc()})), (WindowFrame)UnspecifiedFrame$.MODULE$)), this.assertEqual$default$3());
            this.assertEqual("sum(product + 1) over (partition by ((product / 2) + 1) order by 2)", (Expression)new WindowExpression((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "sum")).function((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "product")).$plus((Expression)package.expressions$.MODULE$.intToLiteral(1))})), new WindowSpecDefinition((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "product")).$div((Expression)package.expressions$.MODULE$.intToLiteral(2))).$plus((Expression)package.expressions$.MODULE$.intToLiteral(1))})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)2))).asc()})), (WindowFrame)UnspecifiedFrame$.MODULE$)), this.assertEqual$default$3());
        }, new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 292));
        this.test("range/rows window function expressions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            UnresolvedFunction func = package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "foo")).function((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}));
            Seq frameTypes = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"rows", (Object)RowFrame$.MODULE$), new Tuple2((Object)"range", (Object)RangeFrame$.MODULE$)}));
            Seq boundaries = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)"unbounded preceding", (Object)UnboundedPreceding$.MODULE$, (Object)CurrentRow$.MODULE$), new Tuple3((Object)"2147483648 preceding", (Object)package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)0x80000000L))).unary_$minus(), (Object)CurrentRow$.MODULE$), new Tuple3((Object)"10 preceding", (Object)package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)10))).unary_$minus(), (Object)CurrentRow$.MODULE$), new Tuple3((Object)"3 + 1 preceding", (Object)package.expressions$.MODULE$.DslExpression((Expression)new Add((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)3)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1)), Add$.MODULE$.apply$default$3())).unary_$minus(), (Object)CurrentRow$.MODULE$), new Tuple3((Object)"0 preceding", (Object)package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)0))).unary_$minus(), (Object)CurrentRow$.MODULE$), new Tuple3((Object)"current row", (Object)CurrentRow$.MODULE$, (Object)CurrentRow$.MODULE$), new Tuple3((Object)"0 following", (Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)0)), (Object)CurrentRow$.MODULE$), new Tuple3((Object)"3 + 1 following", (Object)new Add((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)3)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1)), Add$.MODULE$.apply$default$3()), (Object)CurrentRow$.MODULE$), new Tuple3((Object)"10 following", (Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)10)), (Object)CurrentRow$.MODULE$), new Tuple3((Object)"2147483649 following", (Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)0x80000001L)), (Object)CurrentRow$.MODULE$), new Tuple3((Object)"unbounded following", (Object)UnboundedFollowing$.MODULE$, (Object)CurrentRow$.MODULE$), new Tuple3((Object)"between unbounded preceding and 5 following", (Object)UnboundedPreceding$.MODULE$, (Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)5))), new Tuple3((Object)"between unbounded preceding and 3 + 1 following", (Object)UnboundedPreceding$.MODULE$, (Object)new Add((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)3)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1)), Add$.MODULE$.apply$default$3())), new Tuple3((Object)"between unbounded preceding and 2147483649 following", (Object)UnboundedPreceding$.MODULE$, (Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)0x80000001L))), new Tuple3((Object)"between unbounded preceding and current row", (Object)UnboundedPreceding$.MODULE$, (Object)CurrentRow$.MODULE$), new Tuple3((Object)"between 2147483648 preceding and current row", (Object)package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)0x80000000L))).unary_$minus(), (Object)CurrentRow$.MODULE$), new Tuple3((Object)"between 10 preceding and current row", (Object)package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)10))).unary_$minus(), (Object)CurrentRow$.MODULE$), new Tuple3((Object)"between 3 + 1 preceding and current row", (Object)package.expressions$.MODULE$.DslExpression((Expression)new Add((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)3)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1)), Add$.MODULE$.apply$default$3())).unary_$minus(), (Object)CurrentRow$.MODULE$), new Tuple3((Object)"between 0 preceding and current row", (Object)package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)0))).unary_$minus(), (Object)CurrentRow$.MODULE$), new Tuple3((Object)"between current row and current row", (Object)CurrentRow$.MODULE$, (Object)CurrentRow$.MODULE$), new Tuple3((Object)"between current row and 0 following", (Object)CurrentRow$.MODULE$, (Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)0))), new Tuple3((Object)"between current row and 5 following", (Object)CurrentRow$.MODULE$, (Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)5))), new Tuple3((Object)"between current row and 3 + 1 following", (Object)CurrentRow$.MODULE$, (Object)new Add((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)3)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1)), Add$.MODULE$.apply$default$3())), new Tuple3((Object)"between current row and 2147483649 following", (Object)CurrentRow$.MODULE$, (Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)0x80000001L))), new Tuple3((Object)"between current row and unbounded following", (Object)CurrentRow$.MODULE$, (Object)UnboundedFollowing$.MODULE$), new Tuple3((Object)"between 2147483648 preceding and unbounded following", (Object)package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)0x80000000L))).unary_$minus(), (Object)UnboundedFollowing$.MODULE$), new Tuple3((Object)"between 10 preceding and unbounded following", (Object)package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)10))).unary_$minus(), (Object)UnboundedFollowing$.MODULE$), new Tuple3((Object)"between 3 + 1 preceding and unbounded following", (Object)package.expressions$.MODULE$.DslExpression((Expression)new Add((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)3)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1)), Add$.MODULE$.apply$default$3())).unary_$minus(), (Object)UnboundedFollowing$.MODULE$), new Tuple3((Object)"between 0 preceding and unbounded following", (Object)package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)0))).unary_$minus(), (Object)UnboundedFollowing$.MODULE$), new Tuple3((Object)"between 10 preceding and 5 following", (Object)package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)10))).unary_$minus(), (Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)5))), new Tuple3((Object)"between unbounded preceding and unbounded following", (Object)UnboundedPreceding$.MODULE$, (Object)UnboundedFollowing$.MODULE$)}));
            frameTypes.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                ExpressionParserSuite.$anonfun$new$28(this, boundaries, func, x0$1);
                return BoxedUnit.UNIT;
            });
            this.intercept("foo(*) over (partition by a order by b rows exp(b) preceding)", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Frame bound value must be a literal."}));
        }, new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 323));
        this.test("row constructor", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertEqual("(a, b)", (Expression)CreateStruct$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UnresolvedAttribute[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))}))), this.assertEqual$default$3());
            this.assertEqual("(a, b, c)", (Expression)CreateStruct$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UnresolvedAttribute[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "c"))}))), this.assertEqual$default$3());
            this.assertEqual("(a as b, b as c)", (Expression)CreateStruct$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NamedExpression[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).as((Symbol)SymbolLiteral.bootstrap("apply", "b")), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).as((Symbol)SymbolLiteral.bootstrap("apply", "c"))}))), this.assertEqual$default$3());
        }, new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 393));
        this.test("scalar sub-query", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertEqual("(select max(val) from tbl) > current", (Expression)package.expressions$.MODULE$.DslExpression((Expression)new ScalarSubquery(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tbl"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "max")).function((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "val"))}))})), ScalarSubquery$.MODULE$.apply$default$2(), ScalarSubquery$.MODULE$.apply$default$3())).$greater((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "current"))), this.assertEqual$default$3());
            this.assertEqual("a = (select b from s)", (Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$eq$eq$eq((Expression)new ScalarSubquery(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"s"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))})), ScalarSubquery$.MODULE$.apply$default$2(), ScalarSubquery$.MODULE$.apply$default$3())), this.assertEqual$default$3());
        }, new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 400));
        this.test("case when", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertEqual("case a when 1 then b when 2 then c else d end", (Expression)CaseKeyWhen$.MODULE$.apply((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LeafExpression[]{package.expressions$.MODULE$.intToLiteral(1), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b")), package.expressions$.MODULE$.intToLiteral(2), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "c")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "d"))}))), this.assertEqual$default$3());
            this.assertEqual("case (a or b) when true then c when false then d else e end", (Expression)CaseKeyWhen$.MODULE$.apply((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$bar$bar((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LeafExpression[]{package.expressions$.MODULE$.booleanToLiteral(true), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "c")), package.expressions$.MODULE$.booleanToLiteral(false), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "d")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "e"))}))), this.assertEqual$default$3());
            this.assertEqual("case 'a'='a' when true then 1 end", (Expression)CaseKeyWhen$.MODULE$.apply((Expression)package.expressions$.MODULE$.DslString("a").$eq$eq$eq((Expression)package.expressions$.MODULE$.stringToLiteral("a")), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Literal[]{package.expressions$.MODULE$.booleanToLiteral(true), package.expressions$.MODULE$.intToLiteral(1)}))), this.assertEqual$default$3());
            this.assertEqual("case when a = 1 then b when a = 2 then c else d end", (Expression)CaseWhen$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(1)), (Object)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).expr()), new Tuple2((Object)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(2)), (Object)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "c")).expr())})), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "d"))), this.assertEqual$default$3());
            this.assertEqual("case when (1) + case when a > b then c else d end then f else g end", (Expression)CaseWhen$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1))).$plus((Expression)CaseWhen$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$greater((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))), (Object)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "c")).expr())})), (Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "d")).expr())), (Object)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "f")).expr())})), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "g"))), this.assertEqual$default$3());
        }, new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 409));
        this.test("dereference", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertEqual("a.b", (Expression)UnresolvedAttribute$.MODULE$.apply("a.b"), this.assertEqual$default$3());
            this.assertEqual("`select`.b", (Expression)UnresolvedAttribute$.MODULE$.apply("select.b"), this.assertEqual$default$3());
            this.assertEqual("(a + b).b", (Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$plus((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b")))).getField("b"), this.assertEqual$default$3());
            this.assertEqual("struct(a, b).b", (Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.namedStruct((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{Literal$.MODULE$.apply((Object)"a"), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), Literal$.MODULE$.apply((Object)"b"), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))}))).getField("b"), this.assertEqual$default$3());
        }, new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 422));
        this.test("reference", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertEqual("a", (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), this.assertEqual$default$3());
            this.assertEqual("1a", (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "1a")), this.assertEqual$default$3());
            this.assertEqual("`select`", (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "select")), this.assertEqual$default$3());
            this.assertEqual("columns", (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "columns")), this.assertEqual$default$3());
        }, new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 431));
        this.test("subscript", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertEqual("a[b]", (Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).getItem((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))), this.assertEqual$default$3());
            this.assertEqual("a[1 + 1]", (Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).getItem(package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1))).$plus((Expression)package.expressions$.MODULE$.intToLiteral(1))), this.assertEqual$default$3());
            this.assertEqual("`c`.a[b]", (Expression)package.expressions$.MODULE$.DslExpression((Expression)UnresolvedAttribute$.MODULE$.apply("c.a")).getItem((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))), this.assertEqual$default$3());
        }, new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 445));
        this.test("parenthesis", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertEqual("(a)", (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), this.assertEqual$default$3());
            this.assertEqual("r * (a + b)", package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "r")).$times(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$plus((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b")))), this.assertEqual$default$3());
        }, new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 451));
        this.test("type constructors", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertEqual("dAte '2016-03-11'", (Expression)Literal$.MODULE$.apply((Object)Date.valueOf("2016-03-11")), this.assertEqual$default$3());
            this.intercept("DAtE 'mar 11 2016'", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot parse the DATE value"}));
            this.assertEqual("tImEstAmp '2016-03-11 20:54:00.000'", (Expression)Literal$.MODULE$.apply((Object)Timestamp.valueOf("2016-03-11 20:54:00.000")), this.assertEqual$default$3());
            this.intercept("timestamP '2016-33-11 20:54:00.000'", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot parse the TIMESTAMP value"}));
            Literal intervalLiteral = Literal$.MODULE$.apply((Object)IntervalUtils$.MODULE$.stringToInterval(this.stringToUTF8Str("interval 3 month 1 hour")));
            this.assertEqual("InterVal 'interval 3 month 1 hour'", (Expression)intervalLiteral, this.assertEqual$default$3());
            this.assertEqual("INTERVAL '3 month 1 hour'", (Expression)intervalLiteral, this.assertEqual$default$3());
            this.intercept("Interval 'interval 3 monthsss 1 hoursss'", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot parse the INTERVAL value"}));
            this.assertEqual("-interval '3 month 1 hour'", (Expression)new UnaryMinus((Expression)Literal$.MODULE$.apply((Object)IntervalUtils$.MODULE$.stringToInterval(this.stringToUTF8Str("interval 3 month 1 hour"))), UnaryMinus$.MODULE$.apply$default$2()), this.assertEqual$default$3());
            String intervalStrWithAllUnits = "1 year 3 months 2 weeks 2 days 1 hour 3 minutes 2 seconds 100 millisecond 200 microseconds";
            this.assertEqual(new StringBuilder(11).append("interval '").append(intervalStrWithAllUnits).append("'").toString(), (Expression)Literal$.MODULE$.apply((Object)IntervalUtils$.MODULE$.stringToInterval(this.stringToUTF8Str(intervalStrWithAllUnits))), this.assertEqual$default$3());
            this.assertEqual("X'A'", (Expression)Literal$.MODULE$.apply(new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(new int[]{10})).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToByte((byte)ExpressionParserSuite.$anonfun$new$38(BoxesRunTime.unboxToInt((Object)x$1))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Byte()))), this.assertEqual$default$3());
            this.assertEqual("x'A10C'", (Expression)Literal$.MODULE$.apply(new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(new int[]{161, 12})).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToByte((byte)ExpressionParserSuite.$anonfun$new$39(BoxesRunTime.unboxToInt((Object)x$2))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Byte()))), this.assertEqual$default$3());
            this.intercept("x'A1OC'", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
            this.intercept("GEO '(10,-6)'", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Literals of type 'GEO' are currently not supported."}));
        }, new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 456));
        this.test("literals", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertEqual("null", (Expression)Literal$.MODULE$.apply(null), this.assertEqual$default$3());
            this.assertEqual("trUe", (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)true)), this.assertEqual$default$3());
            this.assertEqual("False", (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)false)), this.assertEqual$default$3());
            this.assertEqual("787324", (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)787324)), this.assertEqual$default$3());
            this.assertEqual("7873247234798249234", (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)7873247234798249234L)), this.assertEqual$default$3());
            this.testDecimal$1("78732472347982492793712334");
            this.testDecimal$1("7873247234798249279371.2334");
            this.assertEqual("9.0e1", (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)90)), this.assertEqual$default$3());
            this.assertEqual(".9e+2", (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)90)), this.assertEqual$default$3());
            this.assertEqual("0.9e+2", (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)90)), this.assertEqual$default$3());
            this.assertEqual("900e-1BD", (Expression)Literal$.MODULE$.apply((Object)package$.MODULE$.BigDecimal().apply("900e-1").underlying()), this.assertEqual$default$3());
            this.assertEqual("900.0E-1BD", (Expression)Literal$.MODULE$.apply((Object)package$.MODULE$.BigDecimal().apply("900.0E-1").underlying()), this.assertEqual$default$3());
            this.assertEqual("9.e+1BD", (Expression)Literal$.MODULE$.apply((Object)package$.MODULE$.BigDecimal().apply("9.e+1").underlying()), this.assertEqual$default$3());
            this.intercept(".e3", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
            this.assertEqual("10Y", (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToByte((byte)((byte)10))), this.assertEqual$default$3());
            this.intercept("-1000Y", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(26).append("does not fit in range [").append(-128).append(", ").append(127).append("]").toString()}));
            this.assertEqual("10S", (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToShort((short)((short)10))), this.assertEqual$default$3());
            this.intercept("40000S", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(26).append("does not fit in range [").append(Short.MIN_VALUE).append(", ").append(Short.MAX_VALUE).append("]").toString()}));
            this.assertEqual("10L", (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)10L)), this.assertEqual$default$3());
            this.intercept("78732472347982492793712334L", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(26).append("does not fit in range [").append(Long.MIN_VALUE).append(", ").append(Long.MAX_VALUE).append("]").toString()}));
            this.assertEqual("10.0D", (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)10.0)), this.assertEqual$default$3());
            this.intercept("-1.8E308D", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"does not fit in range"}));
            this.intercept("1.8E308D", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"does not fit in range"}));
            this.assertEqual("90912830918230182310293801923652346786BD", (Expression)Literal$.MODULE$.apply((Object)package$.MODULE$.BigDecimal().apply("90912830918230182310293801923652346786").underlying()), this.assertEqual$default$3());
            this.assertEqual("123.0E-28BD", (Expression)Literal$.MODULE$.apply((Object)package$.MODULE$.BigDecimal().apply("123.0E-28").underlying()), this.assertEqual$default$3());
            this.assertEqual("123.08BD", (Expression)Literal$.MODULE$.apply((Object)package$.MODULE$.BigDecimal().apply("123.08").underlying()), this.assertEqual$default$3());
            this.intercept("1.20E-38BD", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"decimal can only support precision up to 38"}));
        }, new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 489));
        this.test("SPARK-30252: Decimal should set zero scale rather than negative scale by default", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertEqual("123.0BD", (Expression)new Literal((Object)Decimal$.MODULE$.apply(package$.MODULE$.BigDecimal().apply("123.0")), (DataType)new DecimalType(4, 1)), this.assertEqual$default$3());
            this.assertEqual("123BD", (Expression)new Literal((Object)Decimal$.MODULE$.apply(package$.MODULE$.BigDecimal().apply("123")), (DataType)new DecimalType(3, 0)), this.assertEqual$default$3());
            this.assertEqual("123E10BD", (Expression)new Literal((Object)Decimal$.MODULE$.apply(package$.MODULE$.BigDecimal().apply("123E10")), (DataType)new DecimalType(13, 0)), this.assertEqual$default$3());
            this.assertEqual("123E+10BD", (Expression)new Literal((Object)Decimal$.MODULE$.apply(package$.MODULE$.BigDecimal().apply("123E+10")), (DataType)new DecimalType(13, 0)), this.assertEqual$default$3());
            this.assertEqual("123E-10BD", (Expression)new Literal((Object)Decimal$.MODULE$.apply(package$.MODULE$.BigDecimal().apply("123E-10")), (DataType)new DecimalType(10, 10)), this.assertEqual$default$3());
            this.assertEqual("1.23E10BD", (Expression)new Literal((Object)Decimal$.MODULE$.apply(package$.MODULE$.BigDecimal().apply("1.23E10")), (DataType)new DecimalType(11, 0)), this.assertEqual$default$3());
            this.assertEqual("-1.23E10BD", (Expression)new Literal((Object)Decimal$.MODULE$.apply(package$.MODULE$.BigDecimal().apply("-1.23E10")), (DataType)new DecimalType(11, 0)), this.assertEqual$default$3());
        }, new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 546));
        this.test("SPARK-29956: scientific decimal should be parsed as Decimal in legacy mode", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.LEGACY_EXPONENT_LITERAL_AS_DECIMAL_ENABLED().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            CatalystSqlParser parser = new CatalystSqlParser();
            this.testDecimal$2("9e1", (ParserInterface)parser);
            this.testDecimal$2("9e-1", (ParserInterface)parser);
            this.testDecimal$2("-9e1", (ParserInterface)parser);
            this.testDecimal$2("9.0e1", (ParserInterface)parser);
            this.testDecimal$2(".9e+2", (ParserInterface)parser);
            this.testDecimal$2("0.9e+2", (ParserInterface)parser);
        }), new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 556));
        this.test("strings", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{true, false}))).foreach((Function1 & Serializable & scala.Serializable)escape -> {
            this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ESCAPED_STRING_LITERALS().key()), (Object)((Object)BoxesRunTime.boxToBoolean((boolean)BoxesRunTime.unboxToBoolean((Object)escape))).toString())}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                CatalystSqlParser parser = new CatalystSqlParser();
                $this.assertEqual("\"hello\"", (Expression)package.expressions$.MODULE$.stringToLiteral("hello"), (ParserInterface)parser);
                $this.assertEqual("'hello'", (Expression)package.expressions$.MODULE$.stringToLiteral("hello"), (ParserInterface)parser);
                $this.assertEqual("\"hello\" 'world'", (Expression)package.expressions$.MODULE$.stringToLiteral("helloworld"), (ParserInterface)parser);
                $this.assertEqual("'hello' \" \" 'world'", (Expression)package.expressions$.MODULE$.stringToLiteral("hello world"), (ParserInterface)parser);
                $this.assertEqual("'pattern%'", (Expression)package.expressions$.MODULE$.stringToLiteral("pattern%"), (ParserInterface)parser);
                $this.assertEqual("'no-pattern\\%'", (Expression)package.expressions$.MODULE$.stringToLiteral("no-pattern\\%"), (ParserInterface)parser);
                if (escape) {
                    $this.assertEqual("'pattern\\\\%'", (Expression)package.expressions$.MODULE$.stringToLiteral("pattern\\\\%"), (ParserInterface)parser);
                    $this.assertEqual("'pattern\\\\\\%'", (Expression)package.expressions$.MODULE$.stringToLiteral("pattern\\\\\\%"), (ParserInterface)parser);
                    $this.assertEqual("'\\0'", (Expression)package.expressions$.MODULE$.stringToLiteral("\\0"), (ParserInterface)parser);
                    ParseException e = (ParseException)$this.intercept((Function0 & Serializable & scala.Serializable)() -> parser.parseExpression("'''"), ClassTag$.MODULE$.apply(ParseException.class), new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 608));
                    String $org_scalatest_assert_macro_left = e.message();
                    String $org_scalatest_assert_macro_right = "extraneous input '''";
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 609));
                    $this.assertEqual("'\\\"'", (Expression)package.expressions$.MODULE$.stringToLiteral("\\\""), (ParserInterface)parser);
                    $this.assertEqual("'\\b'", (Expression)package.expressions$.MODULE$.stringToLiteral("\\b"), (ParserInterface)parser);
                    $this.assertEqual("'\\n'", (Expression)package.expressions$.MODULE$.stringToLiteral("\\n"), (ParserInterface)parser);
                    $this.assertEqual("'\\r'", (Expression)package.expressions$.MODULE$.stringToLiteral("\\r"), (ParserInterface)parser);
                    $this.assertEqual("'\\t'", (Expression)package.expressions$.MODULE$.stringToLiteral("\\t"), (ParserInterface)parser);
                    $this.assertEqual("'\\110\\145\\154\\154\\157\\041'", (Expression)package.expressions$.MODULE$.stringToLiteral("\\110\\145\\154\\154\\157\\041"), (ParserInterface)parser);
                    $this.assertEqual("'\\u0057\\u006F\\u0072\\u006C\\u0064\\u0020\\u003A\\u0029'", (Expression)package.expressions$.MODULE$.stringToLiteral("\\u0057\\u006F\\u0072\\u006C\\u0064\\u0020\\u003A\\u0029"), (ParserInterface)parser);
                } else {
                    $this.assertEqual("'pattern\\\\%'", (Expression)package.expressions$.MODULE$.stringToLiteral("pattern\\%"), (ParserInterface)parser);
                    $this.assertEqual("'pattern\\\\\\%'", (Expression)package.expressions$.MODULE$.stringToLiteral("pattern\\\\%"), (ParserInterface)parser);
                    $this.assertEqual("'\\0'", (Expression)package.expressions$.MODULE$.stringToLiteral("\u0000"), (ParserInterface)parser);
                    $this.assertEqual("'\\''", (Expression)package.expressions$.MODULE$.stringToLiteral("'"), (ParserInterface)parser);
                    $this.assertEqual("'\\\"'", (Expression)package.expressions$.MODULE$.stringToLiteral("\""), (ParserInterface)parser);
                    $this.assertEqual("'\\b'", (Expression)package.expressions$.MODULE$.stringToLiteral("\b"), (ParserInterface)parser);
                    $this.assertEqual("'\\n'", (Expression)package.expressions$.MODULE$.stringToLiteral("\n"), (ParserInterface)parser);
                    $this.assertEqual("'\\r'", (Expression)package.expressions$.MODULE$.stringToLiteral("\r"), (ParserInterface)parser);
                    $this.assertEqual("'\\t'", (Expression)package.expressions$.MODULE$.stringToLiteral("\t"), (ParserInterface)parser);
                    $this.assertEqual("'\\Z'", (Expression)package.expressions$.MODULE$.stringToLiteral("\u001a"), (ParserInterface)parser);
                    $this.assertEqual("'\\110\\145\\154\\154\\157\\041'", (Expression)package.expressions$.MODULE$.stringToLiteral("Hello!"), (ParserInterface)parser);
                    $this.assertEqual("'\\u0057\\u006F\\u0072\\u006C\\u0064\\u0020\\u003A\\u0029'", (Expression)package.expressions$.MODULE$.stringToLiteral("World :)"), (ParserInterface)parser);
                }
            });
            return BoxedUnit.UNIT;
        }), new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 571));
        this.intervalUnits = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Enumeration.Value[]{IntervalUtils.IntervalUnit$.MODULE$.YEAR(), IntervalUtils.IntervalUnit$.MODULE$.MONTH(), IntervalUtils.IntervalUnit$.MODULE$.WEEK(), IntervalUtils.IntervalUnit$.MODULE$.DAY(), IntervalUtils.IntervalUnit$.MODULE$.HOUR(), IntervalUtils.IntervalUnit$.MODULE$.MINUTE(), IntervalUtils.IntervalUnit$.MODULE$.SECOND(), IntervalUtils.IntervalUnit$.MODULE$.MILLISECOND(), IntervalUtils.IntervalUnit$.MODULE$.MICROSECOND()}));
        this.test("intervals", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.intercept("interval", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"at least one time unit should be given for interval literal"}));
            Seq forms = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "s"}));
            Seq values = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0", "10", "-7", "21"}));
            this.intervalUnits().foreach((Function1 & Serializable & scala.Serializable)unit -> {
                forms.foreach((Function1 & Serializable & scala.Serializable)form -> {
                    values$1.foreach((Function1 & Serializable & scala.Serializable)value -> {
                        ExpressionParserSuite.$anonfun$new$52($this, unit$1, form, value);
                        return BoxedUnit.UNIT;
                    });
                    return BoxedUnit.UNIT;
                });
                return BoxedUnit.UNIT;
            });
            this.checkIntervals$1("13.123456789 seconds", this.intervalLiteral(IntervalUtils.IntervalUnit$.MODULE$.SECOND(), "13.123456789"));
            this.checkIntervals$1("-13.123456789 second", Literal$.MODULE$.apply((Object)new CalendarInterval(0, 0, DateTimeTestUtils$.MODULE$.secFrac(-13, -123, -456))));
            this.checkIntervals$1("13.123456 second", Literal$.MODULE$.apply((Object)new CalendarInterval(0, 0, DateTimeTestUtils$.MODULE$.secFrac(13, 123, 456))));
            this.checkIntervals$1("1.001 second", Literal$.MODULE$.apply((Object)IntervalUtils$.MODULE$.stringToInterval(this.stringToUTF8Str("1 second 1 millisecond"))));
            this.intercept("interval 10 nanoseconds", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"invalid unit 'nanoseconds'"}));
            Seq yearMonthValues = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"123-10", "496-0", "-2-3", "-123-0", "\t -1-2\t"}));
            yearMonthValues.foreach((Function1 & Serializable & scala.Serializable)value -> {
                ExpressionParserSuite.$anonfun$new$53(this, value);
                return BoxedUnit.UNIT;
            });
            Seq datTimeValues = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"99 11:22:33.123456789", "-99 11:22:33.123456789", "10 9:8:7.123456789", "1 0:0:0", "-1 0:0:0", "1 0:0:1", "\t 1 0:0:1 "}));
            datTimeValues.foreach((Function1 & Serializable & scala.Serializable)value -> {
                ExpressionParserSuite.$anonfun$new$54(this, value);
                return BoxedUnit.UNIT;
            });
            Seq hourTimeValues = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"11:22:33.123456789", "9:8:7.123456789", "-19:18:17.123456789", "0:0:0", "0:0:1"}));
            hourTimeValues.foreach((Function1 & Serializable & scala.Serializable)value -> {
                ExpressionParserSuite.$anonfun$new$55(this, value);
                return BoxedUnit.UNIT;
            });
            this.intercept("interval '10' month to second", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Intervals FROM month TO second are not supported."}));
            this.checkIntervals$1("3 months 4 days 22 seconds 1 millisecond", Literal$.MODULE$.apply((Object)new CalendarInterval(3, 4, 22001000L)));
        }, new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 671));
        this.test("composed expressions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertEqual("1 + r.r As q", (Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1))).$plus((Expression)UnresolvedAttribute$.MODULE$.apply("r.r"))).as("q"), this.assertEqual$default$3());
            this.assertEqual("1 - f('o', o(bar))", package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1))).$minus((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "f")).function((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.stringToLiteral("o"), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "o")).function((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "bar"))}))}))), this.assertEqual$default$3());
            this.intercept("1 - f('o', o(bar)) hello * world", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mismatched input '*'"}));
        }, new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 760));
        this.test("SPARK-17364, fully qualified column name which starts with number", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertEqual("123_", (Expression)UnresolvedAttribute$.MODULE$.apply("123_"), this.assertEqual$default$3());
            this.assertEqual("1a.123_", (Expression)UnresolvedAttribute$.MODULE$.apply("1a.123_"), this.assertEqual$default$3());
            this.assertEqual("a.123A", (Expression)UnresolvedAttribute$.MODULE$.apply("a.123A"), this.assertEqual$default$3());
            this.assertEqual("a.123E3_column", (Expression)UnresolvedAttribute$.MODULE$.apply("a.123E3_column"), this.assertEqual$default$3());
            this.assertEqual("a.123D_column", (Expression)UnresolvedAttribute$.MODULE$.apply("a.123D_column"), this.assertEqual$default$3());
            this.assertEqual("a.123BD_column", (Expression)UnresolvedAttribute$.MODULE$.apply("a.123BD_column"), this.assertEqual$default$3());
        }, new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 766));
        this.test("SPARK-17832 function identifier contains backtick", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            FunctionIdentifier complexName = new FunctionIdentifier("`ba`r", (Option)new Some((Object)"`fo`o"));
            this.assertEqual(complexName.quotedString(), (Expression)UnresolvedAttribute$.MODULE$.apply("`fo`o.`ba`r"), this.assertEqual$default$3());
            this.intercept(complexName.unquotedString(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mismatched input"}));
            FunctionIdentifier complexName2 = new FunctionIdentifier("ba``r", (Option)new Some((Object)"fo``o"));
            this.assertEqual(complexName2.quotedString(), (Expression)UnresolvedAttribute$.MODULE$.apply("fo``o.ba``r"), this.assertEqual$default$3());
        }, new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 779));
        this.test("SPARK-19526 Support ignore nulls keywords for first and last", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertEqual("first(a ignore nulls)", (Expression)new First((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), true).toAggregateExpression(), this.assertEqual$default$3());
            this.assertEqual("first(a)", (Expression)new First((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), false).toAggregateExpression(), this.assertEqual$default$3());
            this.assertEqual("last(a ignore nulls)", (Expression)new Last((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), true).toAggregateExpression(), this.assertEqual$default$3());
            this.assertEqual("last(a)", (Expression)new Last((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), false).toAggregateExpression(), this.assertEqual$default$3());
        }, new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 788));
        this.test("timestamp literals", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> DateTimeTestUtils$.MODULE$.outstandingZoneIds().foreach((Function1 & Serializable & scala.Serializable)zid -> {
            this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.SESSION_LOCAL_TIMEZONE().key()), (Object)zid.getId())}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.assertEval("TIMESTAMP '2019-01-14 20:54:00.000'", BoxesRunTime.boxToLong((long)ExpressionParserSuite.toMicros$1(LocalDateTime.of(2019, 1, 14, 20, 54), zid)), $this.assertEval$default$3());
                $this.assertEval("Timestamp '2000-01-01T00:55:00'", BoxesRunTime.boxToLong((long)ExpressionParserSuite.toMicros$1(LocalDateTime.of(2000, 1, 1, 0, 55), zid)), $this.assertEval$default$3());
                $this.assertEval("TIMESTAMP '2019-01-16 20:50:00.567000+01:00'", BoxesRunTime.boxToLong((long)1547668200567000L), $this.assertEval$default$3());
            });
            return BoxedUnit.UNIT;
        }), new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 795));
        this.test("date literals", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> DateTimeTestUtils$.MODULE$.outstandingTimezonesIds().foreach((Function1 & Serializable & scala.Serializable)timeZone -> {
            this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.SESSION_LOCAL_TIMEZONE().key()), (Object)timeZone)}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.assertEval("DATE '2019-01-14'", BoxesRunTime.boxToInteger((int)17910), $this.assertEval$default$3());
                $this.assertEval("DATE '2019-01'", BoxesRunTime.boxToInteger((int)17897), $this.assertEval$default$3());
                $this.assertEval("DATE '2019'", BoxesRunTime.boxToInteger((int)17897), $this.assertEval$default$3());
            });
            return BoxedUnit.UNIT;
        }), new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 817));
        this.test("current date/timestamp braceless expressions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ANSI_ENABLED().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.assertEqual("current_date", (Expression)new CurrentDate(CurrentDate$.MODULE$.apply$default$1()), this.assertEqual$default$3());
                this.assertEqual("current_timestamp", (Expression)new CurrentTimestamp(), this.assertEqual$default$3());
            });
            this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ANSI_ENABLED().key()), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.assertEqual("current_date", (Expression)UnresolvedAttribute$.MODULE$.quoted("current_date"), this.assertEqual$default$3());
                this.assertEqual("current_timestamp", (Expression)UnresolvedAttribute$.MODULE$.quoted("current_timestamp"), this.assertEqual$default$3());
            });
        }, new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 827));
    }
}

