/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.optimizer;

import java.io.File;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.time.ZoneId;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.api.python.PythonEvalType$;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.catalyst.analysis.AnalysisTest;
import org.apache.spark.sql.catalyst.analysis.Analyzer;
import org.apache.spark.sql.catalyst.dsl.package;
import org.apache.spark.sql.catalyst.encoders.ExpressionEncoder$;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.AliasHelper;
import org.apache.spark.sql.catalyst.expressions.Ascending$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeMap;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.expressions.CurrentDate;
import org.apache.spark.sql.catalyst.expressions.CurrentDate$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.PredicateHelper;
import org.apache.spark.sql.catalyst.expressions.PythonUDF;
import org.apache.spark.sql.catalyst.expressions.PythonUDF$;
import org.apache.spark.sql.catalyst.expressions.ScalaUDF;
import org.apache.spark.sql.catalyst.expressions.ScalaUDF$;
import org.apache.spark.sql.catalyst.expressions.SortDirection;
import org.apache.spark.sql.catalyst.expressions.SortOrder;
import org.apache.spark.sql.catalyst.expressions.SortOrder$;
import org.apache.spark.sql.catalyst.expressions.Year;
import org.apache.spark.sql.catalyst.optimizer.EliminateSortsSuite$Optimize$;
import org.apache.spark.sql.catalyst.optimizer.EliminateSortsSuite$PushDownOptimizer$;
import org.apache.spark.sql.catalyst.plans.JoinType;
import org.apache.spark.sql.catalyst.plans.LeftOuter$;
import org.apache.spark.sql.catalyst.plans.PlanTestBase;
import org.apache.spark.sql.catalyst.plans.RightOuter$;
import org.apache.spark.sql.catalyst.plans.SQLHelper;
import org.apache.spark.sql.catalyst.plans.logical.Aggregate;
import org.apache.spark.sql.catalyst.plans.logical.LocalRelation;
import org.apache.spark.sql.catalyst.plans.logical.LocalRelation$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.catalyst.plans.logical.Range;
import org.apache.spark.sql.catalyst.plans.logical.Range$;
import org.apache.spark.sql.catalyst.rules.Rule;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.TypeTags;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001-4AAE\n\u0001A!)1\u0006\u0001C\u0001Y!9q\u0006\u0001b\u0001\n\u0003\u0001\u0004B\u0002\u001b\u0001A\u0003%\u0011gB\u00036\u0001!\u0005aGB\u00039\u0001!\u0005\u0011\bC\u0003,\u000b\u0011\u0005\u0001\nC\u0004J\u000b\t\u0007I\u0011\u0001&\t\re+\u0001\u0015!\u0003L\u000f\u0015Q\u0006\u0001#\u0001\\\r\u0015a\u0006\u0001#\u0001^\u0011\u0015Y#\u0002\"\u0001_\u0011\u001dI%B1A\u0005\u0002}Ca!\u0017\u0006!\u0002\u0013\u0001\u0007bB2\u0001\u0005\u0004%\t\u0001\u001a\u0005\u0007Q\u0002\u0001\u000b\u0011B3\t\u000f%\u0004!\u0019!C\u0001I\"1!\u000e\u0001Q\u0001\n\u0015\u00141#\u00127j[&t\u0017\r^3T_J$8oU;ji\u0016T!\u0001F\u000b\u0002\u0013=\u0004H/[7ju\u0016\u0014(B\u0001\f\u0018\u0003!\u0019\u0017\r^1msN$(B\u0001\r\u001a\u0003\r\u0019\u0018\u000f\u001c\u0006\u00035m\tQa\u001d9be.T!\u0001H\u000f\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005q\u0012aA8sO\u000e\u00011c\u0001\u0001\"KA\u0011!eI\u0007\u00023%\u0011A%\u0007\u0002\u000e'B\f'o\u001b$v]N+\u0018\u000e^3\u0011\u0005\u0019JS\"A\u0014\u000b\u0005!*\u0012\u0001C1oC2L8/[:\n\u0005):#\u0001D!oC2L8/[:UKN$\u0018A\u0002\u001fj]&$h\bF\u0001.!\tq\u0003!D\u0001\u0014\u0003!\tg.\u00197zu\u0016\u0014X#A\u0019\u0011\u0005\u0019\u0012\u0014BA\u001a(\u0005!\te.\u00197zu\u0016\u0014\u0018!C1oC2L(0\u001a:!\u0003!y\u0005\u000f^5nSj,\u0007CA\u001c\u0006\u001b\u0005\u0001!\u0001C(qi&l\u0017N_3\u0014\u0005\u0015Q\u0004cA\u001e?\u00016\tAH\u0003\u0002>+\u0005)!/\u001e7fg&\u0011q\b\u0010\u0002\r%VdW-\u0012=fGV$xN\u001d\t\u0003\u0003\u001ak\u0011A\u0011\u0006\u0003\u0007\u0012\u000bq\u0001\\8hS\u000e\fGN\u0003\u0002F+\u0005)\u0001\u000f\\1og&\u0011qI\u0011\u0002\f\u0019><\u0017nY1m!2\fg\u000eF\u00017\u0003\u001d\u0011\u0017\r^2iKN,\u0012a\u0013\t\u0004\u0019N+V\"A'\u000b\u00059{\u0015!C5n[V$\u0018M\u00197f\u0015\t\u0001\u0016+\u0001\u0006d_2dWm\u0019;j_:T\u0011AU\u0001\u0006g\u000e\fG.Y\u0005\u0003)6\u0013A\u0001T5tiB\u0011akV\u0007\u0002\u000b%\u0011\u0001L\u0010\u0002\u0006\u0005\u0006$8\r[\u0001\tE\u0006$8\r[3tA\u0005\t\u0002+^:i\t><hn\u00149uS6L'0\u001a:\u0011\u0005]R!!\u0005)vg\"$un\u001e8PaRLW.\u001b>feN\u0011!B\u000f\u000b\u00027V\t\u0001\rE\u0002M'\u0006\u0004\"AY,\u000e\u0003)\tA\u0002^3tiJ+G.\u0019;j_:,\u0012!\u001a\t\u0003\u0003\u001aL!a\u001a\"\u0003\u001b1{7-\u00197SK2\fG/[8o\u00035!Xm\u001d;SK2\fG/[8oA\u0005iA/Z:u%\u0016d\u0017\r^5p]\n\u000ba\u0002^3tiJ+G.\u0019;j_:\u0014\u0005\u0005")
public class EliminateSortsSuite
extends SparkFunSuite
implements AnalysisTest {
    private volatile EliminateSortsSuite$Optimize$ Optimize$module;
    private volatile EliminateSortsSuite$PushDownOptimizer$ PushDownOptimizer$module;
    private final Analyzer analyzer;
    private final LocalRelation testRelation;
    private final LocalRelation testRelationB;
    private String sparkHome;
    private volatile boolean bitmap$0;

    @Override
    public /* synthetic */ void org$apache$spark$sql$catalyst$analysis$AnalysisTest$$super$comparePlans(LogicalPlan plan1, LogicalPlan plan2, boolean checkAnalysis) {
        PlanTestBase.comparePlans$(this, plan1, plan2, checkAnalysis);
    }

    @Override
    public Seq<Rule<LogicalPlan>> extendedAnalysisRules() {
        return AnalysisTest.extendedAnalysisRules$(this);
    }

    @Override
    public Analyzer getAnalyzer() {
        return AnalysisTest.getAnalyzer$(this);
    }

    @Override
    public void checkAnalysis(LogicalPlan inputPlan, LogicalPlan expectedPlan, boolean caseSensitive) {
        AnalysisTest.checkAnalysis$(this, inputPlan, expectedPlan, caseSensitive);
    }

    @Override
    public boolean checkAnalysis$default$3() {
        return AnalysisTest.checkAnalysis$default$3$(this);
    }

    @Override
    public void comparePlans(LogicalPlan plan1, LogicalPlan plan2, boolean checkAnalysis) {
        AnalysisTest.comparePlans$(this, plan1, plan2, checkAnalysis);
    }

    @Override
    public boolean comparePlans$default$3() {
        return AnalysisTest.comparePlans$default$3$(this);
    }

    @Override
    public void assertAnalysisSuccess(LogicalPlan inputPlan, boolean caseSensitive) {
        AnalysisTest.assertAnalysisSuccess$(this, inputPlan, caseSensitive);
    }

    @Override
    public boolean assertAnalysisSuccess$default$2() {
        return AnalysisTest.assertAnalysisSuccess$default$2$(this);
    }

    @Override
    public void assertAnalysisError(LogicalPlan inputPlan, Seq<String> expectedErrors, boolean caseSensitive) {
        AnalysisTest.assertAnalysisError$(this, inputPlan, expectedErrors, caseSensitive);
    }

    @Override
    public boolean assertAnalysisError$default$3() {
        return AnalysisTest.assertAnalysisError$default$3$(this);
    }

    @Override
    public void interceptParseException(Function1<String, Object> parser, String sqlCommand, Seq<String> messages) {
        AnalysisTest.interceptParseException$(this, parser, sqlCommand, messages);
    }

    @Override
    public LogicalPlan normalizeExprIds(LogicalPlan plan) {
        return PlanTestBase.normalizeExprIds$(this, plan);
    }

    @Override
    public LogicalPlan rewriteNameFromAttrNullability(LogicalPlan plan) {
        return PlanTestBase.rewriteNameFromAttrNullability$(this, plan);
    }

    @Override
    public LogicalPlan normalizePlan(LogicalPlan plan) {
        return PlanTestBase.normalizePlan$(this, plan);
    }

    @Override
    public void compareExpressions(Expression e1, Expression e2) {
        PlanTestBase.compareExpressions$(this, e1, e2);
    }

    public SQLConf conf() {
        return SQLConfHelper.conf$((SQLConfHelper)this);
    }

    @Override
    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        SQLHelper.withSQLConf$(this, pairs, f);
    }

    @Override
    public void withTempPath(Function1<File, BoxedUnit> f) {
        SQLHelper.withTempPath$(this, f);
    }

    @Override
    public <T> void testSpecialDatetimeValues(Function1<ZoneId, T> test) {
        SQLHelper.testSpecialDatetimeValues$(this, test);
    }

    public Seq<Expression> splitConjunctivePredicates(Expression condition) {
        return PredicateHelper.splitConjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Option<Tuple2<Expression, LogicalPlan>> findExpressionAndTrackLineageDown(Expression exp, LogicalPlan plan) {
        return PredicateHelper.findExpressionAndTrackLineageDown$((PredicateHelper)this, (Expression)exp, (LogicalPlan)plan);
    }

    public Seq<Expression> splitDisjunctivePredicates(Expression condition) {
        return PredicateHelper.splitDisjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public boolean canEvaluate(Expression expr, LogicalPlan plan) {
        return PredicateHelper.canEvaluate$((PredicateHelper)this, (Expression)expr, (LogicalPlan)plan);
    }

    public boolean canEvaluateWithinJoin(Expression expr) {
        return PredicateHelper.canEvaluateWithinJoin$((PredicateHelper)this, (Expression)expr);
    }

    public Option<Expression> extractPredicatesWithinOutputSet(Expression condition, AttributeSet outputSet) {
        return PredicateHelper.extractPredicatesWithinOutputSet$((PredicateHelper)this, (Expression)condition, (AttributeSet)outputSet);
    }

    public AttributeMap<Alias> getAliasMap(Project plan) {
        return AliasHelper.getAliasMap$((AliasHelper)this, (Project)plan);
    }

    public AttributeMap<Alias> getAliasMap(Aggregate plan) {
        return AliasHelper.getAliasMap$((AliasHelper)this, (Aggregate)plan);
    }

    public AttributeMap<Alias> getAliasMap(Seq<NamedExpression> exprs) {
        return AliasHelper.getAliasMap$((AliasHelper)this, exprs);
    }

    public Expression replaceAlias(Expression expr, AttributeMap<Alias> aliasMap) {
        return AliasHelper.replaceAlias$((AliasHelper)this, (Expression)expr, aliasMap);
    }

    public NamedExpression replaceAliasButKeepName(NamedExpression expr, AttributeMap<Alias> aliasMap) {
        return AliasHelper.replaceAliasButKeepName$((AliasHelper)this, (NamedExpression)expr, aliasMap);
    }

    public Expression trimAliases(Expression e) {
        return AliasHelper.trimAliases$((AliasHelper)this, (Expression)e);
    }

    public <T extends Expression> T trimNonTopLevelAliases(T e) {
        return (T)AliasHelper.trimNonTopLevelAliases$((AliasHelper)this, e);
    }

    public EliminateSortsSuite$Optimize$ Optimize() {
        if (this.Optimize$module == null) {
            this.Optimize$lzycompute$1();
        }
        return this.Optimize$module;
    }

    public EliminateSortsSuite$PushDownOptimizer$ PushDownOptimizer() {
        if (this.PushDownOptimizer$module == null) {
            this.PushDownOptimizer$lzycompute$1();
        }
        return this.PushDownOptimizer$module;
    }

    private String sparkHome$lzycompute() {
        EliminateSortsSuite eliminateSortsSuite = this;
        synchronized (eliminateSortsSuite) {
            if (!this.bitmap$0) {
                this.sparkHome = SQLHelper.sparkHome$(this);
                this.bitmap$0 = true;
            }
        }
        return this.sparkHome;
    }

    @Override
    public String sparkHome() {
        return !this.bitmap$0 ? this.sparkHome$lzycompute() : this.sparkHome;
    }

    public Analyzer analyzer() {
        return this.analyzer;
    }

    public LocalRelation testRelation() {
        return this.testRelation;
    }

    public LocalRelation testRelationB() {
        return this.testRelationB;
    }

    private final void Optimize$lzycompute$1() {
        EliminateSortsSuite eliminateSortsSuite = this;
        synchronized (eliminateSortsSuite) {
            if (this.Optimize$module == null) {
                this.Optimize$module = new EliminateSortsSuite$Optimize$(this);
            }
        }
    }

    private final void PushDownOptimizer$lzycompute$1() {
        EliminateSortsSuite eliminateSortsSuite = this;
        synchronized (eliminateSortsSuite) {
            if (this.PushDownOptimizer$module == null) {
                this.PushDownOptimizer$module = new EliminateSortsSuite$PushDownOptimizer$(this);
            }
        }
    }

    public static final /* synthetic */ void $anonfun$new$32(EliminateSortsSuite $this, Function1 agg) {
        LogicalPlan projectPlan = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)$this.testRelation()).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))}));
        LogicalPlan unnecessaryOrderByPlan = package.plans$.MODULE$.DslLogicalPlan(projectPlan).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).asc(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).desc()}));
        LogicalPlan groupByPlan = package.plans$.MODULE$.DslLogicalPlan(unnecessaryOrderByPlan).groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a"))}), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{(Expression)agg.apply((Object)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b")))}));
        LogicalPlan optimized = (LogicalPlan)$this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(groupByPlan).analyze());
        LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(projectPlan).groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a"))}), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{(Expression)agg.apply((Object)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b")))}))).analyze();
        $this.comparePlans(optimized, correctAnswer, $this.comparePlans$default$3());
    }

    public static final /* synthetic */ void $anonfun$new$46(EliminateSortsSuite $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        LogicalPlan ordered = (LogicalPlan)tuple2._1();
        LogicalPlan answer = (LogicalPlan)tuple2._2();
        LogicalPlan optimized = (LogicalPlan)$this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(ordered).analyze());
        $this.comparePlans(optimized, package.plans$.MODULE$.DslLogicalPlan(answer).analyze(), $this.comparePlans$default$3());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$new$50(EliminateSortsSuite $this, LogicalPlan correctAnswer$1, LogicalPlan ordered) {
        LogicalPlan optimized = (LogicalPlan)$this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(ordered).analyze());
        $this.comparePlans(optimized, correctAnswer$1, $this.comparePlans$default$3());
    }

    public EliminateSortsSuite() {
        AliasHelper.$init$((AliasHelper)this);
        PredicateHelper.$init$((PredicateHelper)this);
        SQLHelper.$init$(this);
        SQLConfHelper.$init$((SQLConfHelper)this);
        PlanTestBase.$init$(this);
        AnalysisTest.$init$(this);
        this.analyzer = this.getAnalyzer();
        this.testRelation = LocalRelation$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Attribute[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).int(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).int(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "c")).int()}));
        this.testRelationB = LocalRelation$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Attribute[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "d")).int()}));
        this.test("Empty order by clause", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LocalRelation x = this.testRelation();
            LogicalPlan query = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)x).orderBy((Seq)Nil$.MODULE$);
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(query).analyze());
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)x).analyze();
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("EliminateSortsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 54));
        this.test("All the SortOrder are no-op", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.CASE_SENSITIVE().key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORDER_BY_ORDINAL().key()), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LocalRelation x = this.testRelation();
            Analyzer analyzer = this.getAnalyzer();
            LogicalPlan query = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)x).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{SortOrder$.MODULE$.apply((Expression)package.expressions$.MODULE$.intToLiteral(3), (SortDirection)Ascending$.MODULE$, SortOrder$.MODULE$.apply$default$3()), SortOrder$.MODULE$.apply((Expression)package.expressions$.MODULE$.intToLiteral(-1), (SortDirection)Ascending$.MODULE$, SortOrder$.MODULE$.apply$default$3())}));
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)analyzer.execute(query));
            LogicalPlan correctAnswer = analyzer.execute((LogicalPlan)x);
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }), new Position("EliminateSortsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 64));
        this.test("Partial order-by clauses contain no-op SortOrder", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.CASE_SENSITIVE().key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORDER_BY_ORDINAL().key()), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LocalRelation x = this.testRelation();
            Analyzer analyzer = this.getAnalyzer();
            LogicalPlan query = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)x).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{SortOrder$.MODULE$.apply((Expression)package.expressions$.MODULE$.intToLiteral(3), (SortDirection)Ascending$.MODULE$, SortOrder$.MODULE$.apply$default$3()), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).asc()}));
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)analyzer.execute(query));
            LogicalPlan correctAnswer = analyzer.execute(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)x).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).asc()})));
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }), new Position("EliminateSortsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 77));
        this.test("Remove no-op alias", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LocalRelation x = this.testRelation();
            LogicalPlan query = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)x).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{(Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).as((Symbol)SymbolLiteral.bootstrap("apply", "x")), (Expression)package.expressions$.MODULE$.DslExpression((Expression)new Year((Expression)new CurrentDate(CurrentDate$.MODULE$.apply$default$1()))).as((Symbol)SymbolLiteral.bootstrap("apply", "y")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))}))).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "x")).asc(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "y")).asc(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).desc()}));
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)this.analyzer().execute(query));
            LogicalPlan correctAnswer = this.analyzer().execute(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)x).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{(Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).as((Symbol)SymbolLiteral.bootstrap("apply", "x")), (Expression)package.expressions$.MODULE$.DslExpression((Expression)new Year((Expression)new CurrentDate(CurrentDate$.MODULE$.apply$default$1()))).as((Symbol)SymbolLiteral.bootstrap("apply", "y")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))}))).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "x")).asc(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).desc()})));
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("EliminateSortsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 90));
        this.test("SPARK-33183: remove consecutive no-op sorts", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LogicalPlan plan = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).orderBy((Seq)Nil$.MODULE$)).orderBy((Seq)Nil$.MODULE$)).orderBy((Seq)Nil$.MODULE$);
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(plan).analyze());
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).analyze();
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("EliminateSortsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 102));
        this.test("SPARK-33183: remove redundant sort by", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LogicalPlan orderedPlan = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))}))).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).asc(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).desc_nullsFirst()}));
            LogicalPlan unnecessaryReordered = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(orderedPlan).limit((Expression)package.expressions$.MODULE$.intToLiteral(2))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a"))}))).sortBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).asc(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).desc_nullsFirst()}));
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(unnecessaryReordered).analyze());
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(orderedPlan).limit((Expression)package.expressions$.MODULE$.intToLiteral(2))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a"))}))).analyze();
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("EliminateSortsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 109));
        this.test("SPARK-33183: remove all redundant local sorts", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LogicalPlan orderedPlan = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).sortBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).asc()}))).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).asc()}))).sortBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).asc()}));
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(orderedPlan).analyze());
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).asc()}))).analyze();
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("EliminateSortsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 117));
        this.test("SPARK-33183: should not remove global sort", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LogicalPlan orderedPlan = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))}))).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).asc(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).desc_nullsFirst()}));
            LogicalPlan reordered = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(orderedPlan).limit((Expression)package.expressions$.MODULE$.intToLiteral(2))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a"))}))).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).asc(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).desc_nullsFirst()}));
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(reordered).analyze());
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(reordered).analyze();
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("EliminateSortsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 124));
        this.test("do not remove sort if the order is different", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LogicalPlan orderedPlan = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))}))).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).asc(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).desc_nullsFirst()}));
            LogicalPlan reorderedDifferently = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(orderedPlan).limit((Expression)package.expressions$.MODULE$.intToLiteral(2))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a"))}))).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).asc(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).desc()}));
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(reorderedDifferently).analyze());
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(reorderedDifferently).analyze();
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("EliminateSortsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 132));
        this.test("SPARK-33183: remove top level local sort with filter operators", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LogicalPlan orderedPlan = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))}))).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).asc(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).desc()}));
            LogicalPlan filteredAndReordered = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(orderedPlan).where((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$greater((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)10))))).sortBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).asc(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).desc()}));
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(filteredAndReordered).analyze());
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(orderedPlan).where((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$greater((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)10))))).analyze();
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("EliminateSortsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 140));
        this.test("SPARK-33183: keep top level global sort with filter operators", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LogicalPlan projectPlan = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))}));
            LogicalPlan orderedPlan = package.plans$.MODULE$.DslLogicalPlan(projectPlan).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).asc(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).desc()}));
            LogicalPlan filteredAndReordered = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(orderedPlan).where((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$greater((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)10))))).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).asc(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).desc()}));
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(filteredAndReordered).analyze());
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(projectPlan).where((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$greater((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)10))))).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).asc(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).desc()}))).analyze();
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("EliminateSortsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 148));
        this.test("SPARK-33183: limits should not affect order for local sort", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LogicalPlan orderedPlan = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))}))).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).asc(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).desc()}));
            LogicalPlan filteredAndReordered = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(orderedPlan).limit((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)10)))).sortBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).asc(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).desc()}));
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(filteredAndReordered).analyze());
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(orderedPlan).limit((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)10)))).analyze();
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("EliminateSortsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 157));
        this.test("SPARK-33183: should not remove global sort with limit operators", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LogicalPlan orderedPlan = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))}))).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).asc(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).desc()}));
            LogicalPlan filteredAndReordered = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(orderedPlan).limit((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)10)))).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).asc(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).desc()}));
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(filteredAndReordered).analyze());
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(filteredAndReordered).analyze();
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("EliminateSortsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 165));
        this.test("different sorts are not simplified if limit is in between", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LogicalPlan orderedPlan = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))}))).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).desc()}))).limit((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)10)))).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).asc()}));
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(orderedPlan).analyze());
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(orderedPlan).analyze();
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("EliminateSortsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 173));
        this.test("SPARK-33183: should not remove global sort with range operator", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Range inputPlan = Range$.MODULE$.apply(1L, 1000L, 1L, 10);
            LogicalPlan orderedPlan = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)inputPlan).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "id")).asc()}));
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(orderedPlan).analyze());
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(orderedPlan).analyze();
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
            LogicalPlan reversedPlan = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)inputPlan).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "id")).desc()}));
            LogicalPlan reversedOptimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(reversedPlan).analyze());
            LogicalPlan reversedCorrectAnswer = package.plans$.MODULE$.DslLogicalPlan(reversedPlan).analyze();
            this.comparePlans(reversedOptimized, reversedCorrectAnswer, this.comparePlans$default$3());
            Range negativeStepInputPlan = Range$.MODULE$.apply(10L, 1L, -1L, 10);
            LogicalPlan negativeStepOrderedPlan = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)negativeStepInputPlan).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "id")).desc()}));
            LogicalPlan negativeStepOptimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(negativeStepOrderedPlan).analyze());
            LogicalPlan negativeStepCorrectAnswer = package.plans$.MODULE$.DslLogicalPlan(negativeStepOrderedPlan).analyze();
            this.comparePlans(negativeStepOptimized, negativeStepCorrectAnswer, this.comparePlans$default$3());
        }, new Position("EliminateSortsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 181));
        this.test("SPARK-33183: remove local sort with range operator", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Range inputPlan = Range$.MODULE$.apply(1L, 1000L, 1L, 10);
            LogicalPlan orderedPlan = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)inputPlan).sortBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "id")).asc()}));
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(orderedPlan).analyze());
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)inputPlan).analyze();
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("EliminateSortsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 200));
        this.test("sort should not be removed when there is a node which doesn't guarantee any order", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LogicalPlan orderedPlan = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))}));
            LogicalPlan groupedAndResorted = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(orderedPlan).groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a"))}), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.sum((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), package.expressions$.MODULE$.sum$default$2())}))).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).asc()}));
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(groupedAndResorted).analyze());
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(groupedAndResorted).analyze();
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("EliminateSortsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 208));
        this.test("remove two consecutive sorts", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LogicalPlan orderedTwice = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).asc()}))).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).desc()}));
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(orderedTwice).analyze());
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).desc()}))).analyze();
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("EliminateSortsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 216));
        this.test("remove sorts separated by Filter/Project operators", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LogicalPlan orderedTwiceWithProject = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).asc()}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))}))).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).desc()}));
            LogicalPlan optimizedWithProject = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(orderedTwiceWithProject).analyze());
            LogicalPlan correctAnswerWithProject = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))}))).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).desc()}))).analyze();
            this.comparePlans(optimizedWithProject, correctAnswerWithProject, this.comparePlans$default$3());
            LogicalPlan orderedTwiceWithFilter = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).asc()}))).where((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).$greater((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)0))))).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).desc()}));
            LogicalPlan optimizedWithFilter = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(orderedTwiceWithFilter).analyze());
            LogicalPlan correctAnswerWithFilter = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).where((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).$greater((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)0))))).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).desc()}))).analyze();
            this.comparePlans(optimizedWithFilter, correctAnswerWithFilter, this.comparePlans$default$3());
            LogicalPlan orderedTwiceWithBoth = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).asc()}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))}))).where((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).$greater((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)0))))).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).desc()}));
            LogicalPlan optimizedWithBoth = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(orderedTwiceWithBoth).analyze());
            LogicalPlan correctAnswerWithBoth = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))}))).where((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).$greater((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)0))))).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).desc()}))).analyze();
            this.comparePlans(optimizedWithBoth, correctAnswerWithBoth, this.comparePlans$default$3());
            LogicalPlan orderedThrice = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(orderedTwiceWithBoth).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{(Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).$plus((Expression)package.expressions$.MODULE$.intToLiteral(1))).as((Symbol)SymbolLiteral.bootstrap("apply", "c"))}))).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "c")).asc()}));
            LogicalPlan optimizedThrice = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(orderedThrice).analyze());
            LogicalPlan correctAnswerThrice = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))}))).where((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).$greater((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)0))))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{(Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).$plus((Expression)package.expressions$.MODULE$.intToLiteral(1))).as((Symbol)SymbolLiteral.bootstrap("apply", "c"))}))).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "c")).asc()}))).analyze();
            this.comparePlans(optimizedThrice, correctAnswerThrice, this.comparePlans$default$3());
        }, new Position("EliminateSortsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 223));
        this.test("remove orderBy in groupBy clause with order irrelevant aggs", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{(Function1 & Serializable & scala.Serializable)e -> package.expressions$.MODULE$.min(e, package.expressions$.MODULE$.min$default$2()), (Function1 & Serializable & scala.Serializable)e -> package.expressions$.MODULE$.minDistinct(e, package.expressions$.MODULE$.minDistinct$default$2()), (Function1 & Serializable & scala.Serializable)e -> package.expressions$.MODULE$.max(e, package.expressions$.MODULE$.max$default$2()), (Function1 & Serializable & scala.Serializable)e -> package.expressions$.MODULE$.maxDistinct(e, package.expressions$.MODULE$.maxDistinct$default$2()), (Function1 & Serializable & scala.Serializable)e -> package.expressions$.MODULE$.count(e, package.expressions$.MODULE$.count$default$2()), (Function1 & Serializable & scala.Serializable)e -> package.expressions$.MODULE$.countDistinct((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{e})), (Function1 & Serializable & scala.Serializable)e -> package.expressions$.MODULE$.bitAnd(e, package.expressions$.MODULE$.bitAnd$default$2()), (Function1 & Serializable & scala.Serializable)e -> package.expressions$.MODULE$.bitOr(e, package.expressions$.MODULE$.bitOr$default$2()), (Function1 & Serializable & scala.Serializable)e -> package.expressions$.MODULE$.bitXor(e, package.expressions$.MODULE$.bitXor$default$2())}))).foreach((Function1 & Serializable & scala.Serializable)agg -> {
            EliminateSortsSuite.$anonfun$new$32(this, agg);
            return BoxedUnit.UNIT;
        }), new Position("EliminateSortsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 249));
        this.test("remove orderBy in groupBy clause with sum aggs", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LogicalPlan projectPlan = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))}));
            LogicalPlan unnecessaryOrderByPlan = package.plans$.MODULE$.DslLogicalPlan(projectPlan).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).asc(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).desc()}));
            LogicalPlan groupByPlan = package.plans$.MODULE$.DslLogicalPlan(unnecessaryOrderByPlan).groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a"))}), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{(Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.sum((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), package.expressions$.MODULE$.sum$default$2())).$plus((Expression)package.expressions$.MODULE$.intToLiteral(10))).as("sum")}));
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(groupByPlan).analyze());
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(projectPlan).groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a"))}), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{(Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.sum((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), package.expressions$.MODULE$.sum$default$2())).$plus((Expression)package.expressions$.MODULE$.intToLiteral(10))).as("sum")}))).analyze();
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("EliminateSortsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 270));
        this.test("should not remove orderBy in groupBy clause with first aggs", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LogicalPlan projectPlan = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))}));
            LogicalPlan orderByPlan = package.plans$.MODULE$.DslLogicalPlan(projectPlan).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).asc(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).desc()}));
            LogicalPlan groupByPlan = package.plans$.MODULE$.DslLogicalPlan(orderByPlan).groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a"))}), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.first((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), package.expressions$.MODULE$.first$default$2())}));
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(groupByPlan).analyze());
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(groupByPlan).analyze();
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("EliminateSortsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 279));
        this.test("should not remove orderBy in groupBy clause with first and count aggs", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LogicalPlan projectPlan = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))}));
            LogicalPlan orderByPlan = package.plans$.MODULE$.DslLogicalPlan(projectPlan).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).asc(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).desc()}));
            LogicalPlan groupByPlan = package.plans$.MODULE$.DslLogicalPlan(orderByPlan).groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a"))}), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.first((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), package.expressions$.MODULE$.first$default$2()), package.expressions$.MODULE$.count((Expression)package.expressions$.MODULE$.intToLiteral(1), package.expressions$.MODULE$.count$default$2())}));
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(groupByPlan).analyze());
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(groupByPlan).analyze();
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("EliminateSortsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 288));
        this.test("should not remove orderBy in groupBy clause with PythonUDF as aggs", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            PythonUDF pythonUdf = new PythonUDF("pyUDF", null, (DataType)IntegerType$.MODULE$, (Seq)Seq$.MODULE$.empty(), PythonEvalType$.MODULE$.SQL_BATCHED_UDF(), true, PythonUDF$.MODULE$.apply$default$7());
            LogicalPlan projectPlan = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))}));
            LogicalPlan orderByPlan = package.plans$.MODULE$.DslLogicalPlan(projectPlan).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).asc(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).desc()}));
            LogicalPlan groupByPlan = package.plans$.MODULE$.DslLogicalPlan(orderByPlan).groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a"))}), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{pythonUdf}));
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(groupByPlan).analyze());
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(groupByPlan).analyze();
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("EliminateSortsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 297));
        this.test("should not remove orderBy in groupBy clause with ScalaUDF as aggs", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            CallSite callSite = SymbolLiteral.bootstrap("apply", "a");
            Option option = Option$.MODULE$.apply((Object)ExpressionEncoder$.MODULE$.apply(((TypeTags)package$.MODULE$.universe()).TypeTag().Int()));
            ScalaUDF scalaUdf = new ScalaUDF((JFunction1.mcII.sp & Serializable & scala.Serializable)s -> s, (DataType)IntegerType$.MODULE$, (Seq)Nil$.MODULE$.$colon$colon((Object)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)callSite)), (Seq)Nil$.MODULE$.$colon$colon((Object)option), ScalaUDF$.MODULE$.apply$default$5(), ScalaUDF$.MODULE$.apply$default$6(), ScalaUDF$.MODULE$.apply$default$7(), ScalaUDF$.MODULE$.apply$default$8());
            LogicalPlan projectPlan = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))}));
            LogicalPlan orderByPlan = package.plans$.MODULE$.DslLogicalPlan(projectPlan).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).asc(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).desc()}));
            LogicalPlan groupByPlan = package.plans$.MODULE$.DslLogicalPlan(orderByPlan).groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a"))}), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{scalaUdf}));
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(groupByPlan).analyze());
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(groupByPlan).analyze();
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("EliminateSortsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 308));
        this.test("should not remove orderBy with limit in groupBy clause", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LogicalPlan projectPlan = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))}));
            LogicalPlan orderByPlan = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(projectPlan).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).asc(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).desc()}))).limit((Expression)package.expressions$.MODULE$.intToLiteral(10));
            LogicalPlan groupByPlan = package.plans$.MODULE$.DslLogicalPlan(orderByPlan).groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a"))}), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.count((Expression)package.expressions$.MODULE$.intToLiteral(1), package.expressions$.MODULE$.count$default$2())}));
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(groupByPlan).analyze());
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(groupByPlan).analyze();
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("EliminateSortsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 319));
        this.test("remove orderBy in join clause", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LogicalPlan projectPlan = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))}));
            LogicalPlan unnecessaryOrderByPlan = package.plans$.MODULE$.DslLogicalPlan(projectPlan).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).asc(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).desc()}));
            LogicalPlan projectPlanB = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelationB()).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "d"))}));
            package.plans$.DslLogicalPlan qual$1 = package.plans$.MODULE$.DslLogicalPlan(unnecessaryOrderByPlan);
            LogicalPlan x$1 = projectPlanB;
            JoinType x$2 = qual$1.join$default$2();
            Option x$3 = qual$1.join$default$3();
            LogicalPlan joinPlan = package.plans$.MODULE$.DslLogicalPlan(qual$1.join(x$1, x$2, x$3)).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "d"))}));
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(joinPlan).analyze());
            package.plans$.DslLogicalPlan qual$2 = package.plans$.MODULE$.DslLogicalPlan(projectPlan);
            LogicalPlan x$4 = projectPlanB;
            JoinType x$5 = qual$2.join$default$2();
            Option x$6 = qual$2.join$default$3();
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(qual$2.join(x$4, x$5, x$6)).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "d"))}))).analyze();
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("EliminateSortsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 328));
        this.test("should not remove orderBy with limit in join clause", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LogicalPlan projectPlan = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))}));
            LogicalPlan orderByPlan = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(projectPlan).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).asc(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).desc()}))).limit((Expression)package.expressions$.MODULE$.intToLiteral(10));
            LogicalPlan projectPlanB = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelationB()).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "d"))}));
            package.plans$.DslLogicalPlan qual$3 = package.plans$.MODULE$.DslLogicalPlan(orderByPlan);
            LogicalPlan x$7 = projectPlanB;
            JoinType x$8 = qual$3.join$default$2();
            Option x$9 = qual$3.join$default$3();
            LogicalPlan joinPlan = package.plans$.MODULE$.DslLogicalPlan(qual$3.join(x$7, x$8, x$9)).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "d"))}));
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(joinPlan).analyze());
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(joinPlan).analyze();
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("EliminateSortsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 338));
        this.test("SPARK-32318: should not remove orderBy in distribute statement", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LogicalPlan projectPlan = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))}));
            LogicalPlan orderByPlan = package.plans$.MODULE$.DslLogicalPlan(projectPlan).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).desc()}));
            LogicalPlan distributedPlan = package.plans$.MODULE$.DslLogicalPlan(orderByPlan).distribute((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a"))}), 1);
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(distributedPlan).analyze());
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(distributedPlan).analyze();
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("EliminateSortsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 348));
        this.test("should not remove orderBy in left join clause if there is an outer limit", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LogicalPlan projectPlan = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))}));
            LogicalPlan orderByPlan = package.plans$.MODULE$.DslLogicalPlan(projectPlan).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).asc(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).desc()}));
            LogicalPlan projectPlanB = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelationB()).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "d"))}));
            package.plans$.DslLogicalPlan qual$4 = package.plans$.MODULE$.DslLogicalPlan(orderByPlan);
            LogicalPlan x$10 = projectPlanB;
            LeftOuter$ x$11 = LeftOuter$.MODULE$;
            Option x$12 = qual$4.join$default$3();
            LogicalPlan joinPlan = package.plans$.MODULE$.DslLogicalPlan(qual$4.join(x$10, (JoinType)x$11, x$12)).limit((Expression)package.expressions$.MODULE$.intToLiteral(10));
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(joinPlan).analyze());
            LogicalPlan correctAnswer = (LogicalPlan)this.PushDownOptimizer().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(joinPlan).analyze());
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("EliminateSortsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 357));
        this.test("remove orderBy in right join clause event if there is an outer limit", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LogicalPlan projectPlan = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))}));
            LogicalPlan orderByPlan = package.plans$.MODULE$.DslLogicalPlan(projectPlan).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).asc(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).desc()}));
            LogicalPlan projectPlanB = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelationB()).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "d"))}));
            package.plans$.DslLogicalPlan qual$5 = package.plans$.MODULE$.DslLogicalPlan(orderByPlan);
            LogicalPlan x$13 = projectPlanB;
            RightOuter$ x$14 = RightOuter$.MODULE$;
            Option x$15 = qual$5.join$default$3();
            LogicalPlan joinPlan = package.plans$.MODULE$.DslLogicalPlan(qual$5.join(x$13, (JoinType)x$14, x$15)).limit((Expression)package.expressions$.MODULE$.intToLiteral(10));
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(joinPlan).analyze());
            package.plans$.DslLogicalPlan qual$6 = package.plans$.MODULE$.DslLogicalPlan(projectPlan);
            LogicalPlan x$16 = projectPlanB;
            RightOuter$ x$17 = RightOuter$.MODULE$;
            Option x$18 = qual$6.join$default$3();
            LogicalPlan noOrderByPlan = package.plans$.MODULE$.DslLogicalPlan(qual$6.join(x$16, (JoinType)x$17, x$18)).limit((Expression)package.expressions$.MODULE$.intToLiteral(10));
            LogicalPlan correctAnswer = (LogicalPlan)this.PushDownOptimizer().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(noOrderByPlan).analyze());
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("EliminateSortsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 369));
        this.test("SPARK-33183: remove consecutive global sorts with the same ordering", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).asc()}))).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).asc()})), (Object)package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).asc()}))), new Tuple2((Object)package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).asc(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).desc()}))).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).asc()})), (Object)package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).asc()})))}))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            EliminateSortsSuite.$anonfun$new$46(this, x0$1);
            return BoxedUnit.UNIT;
        }), new Position("EliminateSortsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 384));
        this.test("SPARK-33183: remove consecutive local sorts with the same ordering", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LogicalPlan orderedPlan = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).sortBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).asc()}))).sortBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).asc()}))).sortBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).asc()}));
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(orderedPlan).analyze());
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).sortBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).asc()}))).analyze();
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("EliminateSortsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 394));
        this.test("SPARK-33183: remove consecutive local sorts with different ordering", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LogicalPlan orderedPlan = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).sortBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).asc()}))).sortBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).desc()}))).sortBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).asc()}));
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(orderedPlan).analyze());
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).sortBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).asc()}))).analyze();
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("EliminateSortsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 401));
        this.test("SPARK-33183: should keep global sort when child is a local sort with the same ordering", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).asc()}))).analyze();
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LogicalPlan[]{package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).sortBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).asc()}))).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).asc()})), package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).asc()}))).sortBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).asc()}))).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).asc()}))}))).foreach((Function1 & Serializable & scala.Serializable)ordered -> {
                EliminateSortsSuite.$anonfun$new$50(this, correctAnswer, ordered);
                return BoxedUnit.UNIT;
            });
        }, new Position("EliminateSortsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 408));
    }
}

