/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.analysis;

import java.io.File;
import java.io.Serializable;
import java.time.ZoneId;
import org.apache.log4j.Appender;
import org.apache.log4j.Level;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.catalyst.analysis.AnalysisTest;
import org.apache.spark.sql.catalyst.analysis.Analyzer;
import org.apache.spark.sql.catalyst.analysis.TestRelations$;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAttribute;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAttribute$;
import org.apache.spark.sql.catalyst.dsl.package;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.AliasHelper;
import org.apache.spark.sql.catalyst.expressions.Ascending$;
import org.apache.spark.sql.catalyst.expressions.AttributeMap;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeReference$;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.LeafExpression;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.PredicateHelper;
import org.apache.spark.sql.catalyst.expressions.SortDirection;
import org.apache.spark.sql.catalyst.expressions.SortOrder;
import org.apache.spark.sql.catalyst.expressions.SortOrder$;
import org.apache.spark.sql.catalyst.parser.CatalystSqlParser$;
import org.apache.spark.sql.catalyst.plans.Inner$;
import org.apache.spark.sql.catalyst.plans.JoinType;
import org.apache.spark.sql.catalyst.plans.PlanTestBase;
import org.apache.spark.sql.catalyst.plans.SQLHelper;
import org.apache.spark.sql.catalyst.plans.logical.Aggregate;
import org.apache.spark.sql.catalyst.plans.logical.BROADCAST$;
import org.apache.spark.sql.catalyst.plans.logical.HintInfo;
import org.apache.spark.sql.catalyst.plans.logical.Join;
import org.apache.spark.sql.catalyst.plans.logical.JoinHint$;
import org.apache.spark.sql.catalyst.plans.logical.JoinStrategyHint;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.catalyst.plans.logical.Repartition;
import org.apache.spark.sql.catalyst.plans.logical.RepartitionByExpression;
import org.apache.spark.sql.catalyst.plans.logical.RepartitionByExpression$;
import org.apache.spark.sql.catalyst.plans.logical.ResolvedHint;
import org.apache.spark.sql.catalyst.plans.logical.SHUFFLE_HASH$;
import org.apache.spark.sql.catalyst.plans.logical.SHUFFLE_MERGE$;
import org.apache.spark.sql.catalyst.plans.logical.SHUFFLE_REPLICATE_NL$;
import org.apache.spark.sql.catalyst.plans.logical.UnresolvedHint;
import org.apache.spark.sql.catalyst.rules.Rule;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.Metadata;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Symbol;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001q1AAA\u0002\u0001!!)\u0011\u0004\u0001C\u00015\t\t\"+Z:pYZ,\u0007*\u001b8ugN+\u0018\u000e^3\u000b\u0005\u0011)\u0011\u0001C1oC2L8/[:\u000b\u0005\u00199\u0011\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005!I\u0011aA:rY*\u0011!bC\u0001\u0006gB\f'o\u001b\u0006\u0003\u00195\ta!\u00199bG\",'\"\u0001\b\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001\tR\u0003\u0005\u0002\u0013'5\t\u0011\"\u0003\u0002\u0015\u0013\ti1\u000b]1sW\u001a+hnU;ji\u0016\u0004\"AF\f\u000e\u0003\rI!\u0001G\u0002\u0003\u0019\u0005s\u0017\r\\=tSN$Vm\u001d;\u0002\rqJg.\u001b;?)\u0005Y\u0002C\u0001\f\u0001\u0001")
public class ResolveHintsSuite
extends SparkFunSuite
implements AnalysisTest {
    private String sparkHome;
    private volatile boolean bitmap$0;

    @Override
    public /* synthetic */ void org$apache$spark$sql$catalyst$analysis$AnalysisTest$$super$comparePlans(LogicalPlan plan1, LogicalPlan plan2, boolean checkAnalysis) {
        PlanTestBase.comparePlans$(this, plan1, plan2, checkAnalysis);
    }

    @Override
    public Seq<Rule<LogicalPlan>> extendedAnalysisRules() {
        return AnalysisTest.extendedAnalysisRules$(this);
    }

    @Override
    public Analyzer getAnalyzer() {
        return AnalysisTest.getAnalyzer$(this);
    }

    @Override
    public void checkAnalysis(LogicalPlan inputPlan, LogicalPlan expectedPlan, boolean caseSensitive) {
        AnalysisTest.checkAnalysis$(this, inputPlan, expectedPlan, caseSensitive);
    }

    @Override
    public boolean checkAnalysis$default$3() {
        return AnalysisTest.checkAnalysis$default$3$(this);
    }

    @Override
    public void comparePlans(LogicalPlan plan1, LogicalPlan plan2, boolean checkAnalysis) {
        AnalysisTest.comparePlans$(this, plan1, plan2, checkAnalysis);
    }

    @Override
    public boolean comparePlans$default$3() {
        return AnalysisTest.comparePlans$default$3$(this);
    }

    @Override
    public void assertAnalysisSuccess(LogicalPlan inputPlan, boolean caseSensitive) {
        AnalysisTest.assertAnalysisSuccess$(this, inputPlan, caseSensitive);
    }

    @Override
    public boolean assertAnalysisSuccess$default$2() {
        return AnalysisTest.assertAnalysisSuccess$default$2$(this);
    }

    @Override
    public void assertAnalysisError(LogicalPlan inputPlan, Seq<String> expectedErrors, boolean caseSensitive) {
        AnalysisTest.assertAnalysisError$(this, inputPlan, expectedErrors, caseSensitive);
    }

    @Override
    public boolean assertAnalysisError$default$3() {
        return AnalysisTest.assertAnalysisError$default$3$(this);
    }

    @Override
    public void interceptParseException(Function1<String, Object> parser, String sqlCommand, Seq<String> messages) {
        AnalysisTest.interceptParseException$(this, parser, sqlCommand, messages);
    }

    @Override
    public LogicalPlan normalizeExprIds(LogicalPlan plan) {
        return PlanTestBase.normalizeExprIds$(this, plan);
    }

    @Override
    public LogicalPlan rewriteNameFromAttrNullability(LogicalPlan plan) {
        return PlanTestBase.rewriteNameFromAttrNullability$(this, plan);
    }

    @Override
    public LogicalPlan normalizePlan(LogicalPlan plan) {
        return PlanTestBase.normalizePlan$(this, plan);
    }

    @Override
    public void compareExpressions(Expression e1, Expression e2) {
        PlanTestBase.compareExpressions$(this, e1, e2);
    }

    public SQLConf conf() {
        return SQLConfHelper.conf$((SQLConfHelper)this);
    }

    @Override
    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        SQLHelper.withSQLConf$(this, pairs, f);
    }

    @Override
    public void withTempPath(Function1<File, BoxedUnit> f) {
        SQLHelper.withTempPath$(this, f);
    }

    @Override
    public <T> void testSpecialDatetimeValues(Function1<ZoneId, T> test) {
        SQLHelper.testSpecialDatetimeValues$(this, test);
    }

    public Seq<Expression> splitConjunctivePredicates(Expression condition) {
        return PredicateHelper.splitConjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Option<Tuple2<Expression, LogicalPlan>> findExpressionAndTrackLineageDown(Expression exp, LogicalPlan plan) {
        return PredicateHelper.findExpressionAndTrackLineageDown$((PredicateHelper)this, (Expression)exp, (LogicalPlan)plan);
    }

    public Seq<Expression> splitDisjunctivePredicates(Expression condition) {
        return PredicateHelper.splitDisjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public boolean canEvaluate(Expression expr, LogicalPlan plan) {
        return PredicateHelper.canEvaluate$((PredicateHelper)this, (Expression)expr, (LogicalPlan)plan);
    }

    public boolean canEvaluateWithinJoin(Expression expr) {
        return PredicateHelper.canEvaluateWithinJoin$((PredicateHelper)this, (Expression)expr);
    }

    public Option<Expression> extractPredicatesWithinOutputSet(Expression condition, AttributeSet outputSet) {
        return PredicateHelper.extractPredicatesWithinOutputSet$((PredicateHelper)this, (Expression)condition, (AttributeSet)outputSet);
    }

    public AttributeMap<Alias> getAliasMap(Project plan) {
        return AliasHelper.getAliasMap$((AliasHelper)this, (Project)plan);
    }

    public AttributeMap<Alias> getAliasMap(Aggregate plan) {
        return AliasHelper.getAliasMap$((AliasHelper)this, (Aggregate)plan);
    }

    public AttributeMap<Alias> getAliasMap(Seq<NamedExpression> exprs) {
        return AliasHelper.getAliasMap$((AliasHelper)this, exprs);
    }

    public Expression replaceAlias(Expression expr, AttributeMap<Alias> aliasMap) {
        return AliasHelper.replaceAlias$((AliasHelper)this, (Expression)expr, aliasMap);
    }

    public NamedExpression replaceAliasButKeepName(NamedExpression expr, AttributeMap<Alias> aliasMap) {
        return AliasHelper.replaceAliasButKeepName$((AliasHelper)this, (NamedExpression)expr, aliasMap);
    }

    public Expression trimAliases(Expression e) {
        return AliasHelper.trimAliases$((AliasHelper)this, (Expression)e);
    }

    public <T extends Expression> T trimNonTopLevelAliases(T e) {
        return (T)AliasHelper.trimNonTopLevelAliases$((AliasHelper)this, e);
    }

    private String sparkHome$lzycompute() {
        ResolveHintsSuite resolveHintsSuite = this;
        synchronized (resolveHintsSuite) {
            if (!this.bitmap$0) {
                this.sparkHome = SQLHelper.sparkHome$(this);
                this.bitmap$0 = true;
            }
        }
        return this.sparkHome;
    }

    @Override
    public String sparkHome() {
        return !this.bitmap$0 ? this.sparkHome$lzycompute() : this.sparkHome;
    }

    public static final /* synthetic */ boolean $anonfun$new$13(LoggingEvent e) {
        Level level = e.getLevel();
        Level level2 = Level.WARN;
        return !(level != null ? !level.equals(level2) : level2 != null) && e.getRenderedMessage().contains("Unrecognized hint: unknown_hint");
    }

    public static final /* synthetic */ void $anonfun$new$16(ResolveHintsSuite $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String hintName = (String)tuple2._1();
        JoinStrategyHint st = (JoinStrategyHint)tuple2._2();
        package.plans$.DslLogicalPlan qual$2 = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TaBlE"})));
        LogicalPlan x$58 = package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TaBlE2"}));
        JoinType x$59 = qual$2.join$default$2();
        Option x$60 = qual$2.join$default$3();
        $this.checkAnalysis((LogicalPlan)new UnresolvedHint(hintName, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"table", "table2"})), qual$2.join(x$58, x$59, x$60)), (LogicalPlan)new Join((LogicalPlan)new ResolvedHint((LogicalPlan)TestRelations$.MODULE$.testRelation(), new HintInfo((Option)new Some((Object)st))), (LogicalPlan)new ResolvedHint((LogicalPlan)TestRelations$.MODULE$.testRelation2(), new HintInfo((Option)new Some((Object)st))), (JoinType)Inner$.MODULE$, (Option)None$.MODULE$, JoinHint$.MODULE$.NONE()), false);
        package.plans$.DslLogicalPlan qual$3 = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TaBlE"})));
        LogicalPlan x$61 = package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TaBlE2"}));
        JoinType x$62 = qual$3.join$default$2();
        Option x$63 = qual$3.join$default$3();
        $this.checkAnalysis((LogicalPlan)new UnresolvedHint(hintName, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TaBlE", "table2"})), qual$3.join(x$61, x$62, x$63)), (LogicalPlan)new Join((LogicalPlan)new ResolvedHint((LogicalPlan)TestRelations$.MODULE$.testRelation(), new HintInfo((Option)new Some((Object)st))), (LogicalPlan)TestRelations$.MODULE$.testRelation2(), (JoinType)Inner$.MODULE$, (Option)None$.MODULE$, JoinHint$.MODULE$.NONE()), true);
        package.plans$.DslLogicalPlan qual$4 = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"global_temp", "table4"})));
        LogicalPlan x$64 = package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"global_temp", "table5"}));
        JoinType x$65 = qual$4.join$default$2();
        Option x$66 = qual$4.join$default$3();
        $this.checkAnalysis((LogicalPlan)new UnresolvedHint(hintName, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"GlOBal_TeMP.table4", "table5"})), qual$4.join(x$64, x$65, x$66)), (LogicalPlan)new Join((LogicalPlan)new ResolvedHint((LogicalPlan)TestRelations$.MODULE$.testRelation4(), new HintInfo((Option)new Some((Object)st))), (LogicalPlan)new ResolvedHint((LogicalPlan)TestRelations$.MODULE$.testRelation5(), new HintInfo((Option)new Some((Object)st))), (JoinType)Inner$.MODULE$, (Option)None$.MODULE$, JoinHint$.MODULE$.NONE()), false);
        package.plans$.DslLogicalPlan qual$5 = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"global_temp", "TaBlE4"})));
        LogicalPlan x$67 = package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"global_temp", "TaBlE5"}));
        JoinType x$68 = qual$5.join$default$2();
        Option x$69 = qual$5.join$default$3();
        $this.checkAnalysis((LogicalPlan)new UnresolvedHint(hintName, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"global_temp.TaBlE4", "table5"})), qual$5.join(x$67, x$68, x$69)), (LogicalPlan)new Join((LogicalPlan)new ResolvedHint((LogicalPlan)TestRelations$.MODULE$.testRelation4(), new HintInfo((Option)new Some((Object)st))), (LogicalPlan)TestRelations$.MODULE$.testRelation5(), (JoinType)Inner$.MODULE$, (Option)None$.MODULE$, JoinHint$.MODULE$.NONE()), true);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public ResolveHintsSuite() {
        AliasHelper.$init$((AliasHelper)this);
        PredicateHelper.$init$((PredicateHelper)this);
        SQLHelper.$init$(this);
        SQLConfHelper.$init$((SQLConfHelper)this);
        PlanTestBase.$init$(this);
        AnalysisTest.$init$(this);
        this.test("invalid hints should be ignored", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.checkAnalysis((LogicalPlan)new UnresolvedHint("some_random_hint_that_does_not_exist", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TaBlE"})), package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TaBlE"}))), (LogicalPlan)TestRelations$.MODULE$.testRelation(), false), new Position("ResolveHintsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 33));
        this.test("case-sensitive or insensitive parameters", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.checkAnalysis((LogicalPlan)new UnresolvedHint("MAPJOIN", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TaBlE"})), package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TaBlE"}))), (LogicalPlan)new ResolvedHint((LogicalPlan)TestRelations$.MODULE$.testRelation(), new HintInfo((Option)new Some((Object)BROADCAST$.MODULE$))), false);
            this.checkAnalysis((LogicalPlan)new UnresolvedHint("MAPJOIN", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"table"})), package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TaBlE"}))), (LogicalPlan)new ResolvedHint((LogicalPlan)TestRelations$.MODULE$.testRelation(), new HintInfo((Option)new Some((Object)BROADCAST$.MODULE$))), false);
            this.checkAnalysis((LogicalPlan)new UnresolvedHint("MAPJOIN", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TaBlE"})), package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TaBlE"}))), (LogicalPlan)new ResolvedHint((LogicalPlan)TestRelations$.MODULE$.testRelation(), new HintInfo((Option)new Some((Object)BROADCAST$.MODULE$))), true);
            this.checkAnalysis((LogicalPlan)new UnresolvedHint("MAPJOIN", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"table"})), package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TaBlE"}))), (LogicalPlan)TestRelations$.MODULE$.testRelation(), true);
        }, new Position("ResolveHintsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 40));
        this.test("multiple broadcast hint aliases", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            package.plans$.DslLogicalPlan qual$1 = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"table"})));
            LogicalPlan x$1 = package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"table2"}));
            JoinType x$2 = qual$1.join$default$2();
            Option x$3 = qual$1.join$default$3();
            this.checkAnalysis((LogicalPlan)new UnresolvedHint("MAPJOIN", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"table", "table2"})), qual$1.join(x$1, x$2, x$3)), (LogicalPlan)new Join((LogicalPlan)new ResolvedHint((LogicalPlan)TestRelations$.MODULE$.testRelation(), new HintInfo((Option)new Some((Object)BROADCAST$.MODULE$))), (LogicalPlan)new ResolvedHint((LogicalPlan)TestRelations$.MODULE$.testRelation2(), new HintInfo((Option)new Some((Object)BROADCAST$.MODULE$))), (JoinType)Inner$.MODULE$, (Option)None$.MODULE$, JoinHint$.MODULE$.NONE()), false);
        }, new Position("ResolveHintsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 62));
        this.test("do not traverse past existing broadcast hints", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.checkAnalysis((LogicalPlan)new UnresolvedHint("MAPJOIN", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"table"})), (LogicalPlan)new ResolvedHint(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"table"}))).where((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$greater((Expression)package.expressions$.MODULE$.intToLiteral(1))), new HintInfo((Option)new Some((Object)BROADCAST$.MODULE$)))), package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)new ResolvedHint(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)TestRelations$.MODULE$.testRelation()).where((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$greater((Expression)package.expressions$.MODULE$.intToLiteral(1))), new HintInfo((Option)new Some((Object)BROADCAST$.MODULE$)))).analyze(), false), new Position("ResolveHintsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 71));
        this.test("should work for subqueries", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.checkAnalysis((LogicalPlan)new UnresolvedHint("MAPJOIN", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tableAlias"})), package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"table"}))).as("tableAlias")), (LogicalPlan)new ResolvedHint((LogicalPlan)TestRelations$.MODULE$.testRelation(), new HintInfo((Option)new Some((Object)BROADCAST$.MODULE$))), false);
            this.checkAnalysis((LogicalPlan)new UnresolvedHint("MAPJOIN", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tableAlias"})), package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"table"}))).subquery((Symbol)SymbolLiteral.bootstrap("apply", "tableAlias"))), (LogicalPlan)new ResolvedHint((LogicalPlan)TestRelations$.MODULE$.testRelation(), new HintInfo((Option)new Some((Object)BROADCAST$.MODULE$))), false);
            this.checkAnalysis((LogicalPlan)new UnresolvedHint("MAPJOIN", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"table"})), package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"table"}))).as("tableAlias")), (LogicalPlan)TestRelations$.MODULE$.testRelation(), false);
        }, new Position("ResolveHintsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 79));
        this.test("do not traverse past subquery alias", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.checkAnalysis((LogicalPlan)new UnresolvedHint("MAPJOIN", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"table"})), package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"table"}))).where((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$greater((Expression)package.expressions$.MODULE$.intToLiteral(1)))).subquery((Symbol)SymbolLiteral.bootstrap("apply", "tableAlias"))), package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)TestRelations$.MODULE$.testRelation()).where((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$greater((Expression)package.expressions$.MODULE$.intToLiteral(1)))).analyze(), false), new Position("ResolveHintsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 97));
        this.test("should work for CTE", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.checkAnalysis(CatalystSqlParser$.MODULE$.parsePlan(new StringOps(Predef$.MODULE$.augmentString("\n          |WITH ctetable AS (SELECT * FROM table WHERE a > 1)\n          |SELECT /*+ BROADCAST(ctetable) */ * FROM ctetable\n        ")).stripMargin()), package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)new ResolvedHint(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)TestRelations$.MODULE$.testRelation()).where((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$greater((Expression)package.expressions$.MODULE$.intToLiteral(1)))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a"))})), new HintInfo((Option)new Some((Object)BROADCAST$.MODULE$)))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a"))}))).analyze(), false), new Position("ResolveHintsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 104));
        this.test("should not traverse down CTE", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.checkAnalysis(CatalystSqlParser$.MODULE$.parsePlan(new StringOps(Predef$.MODULE$.augmentString("\n          |WITH ctetable AS (SELECT * FROM table WHERE a > 1)\n          |SELECT /*+ BROADCAST(table) */ * FROM ctetable\n        ")).stripMargin()), package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)TestRelations$.MODULE$.testRelation()).where((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$greater((Expression)package.expressions$.MODULE$.intToLiteral(1)))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a"))}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a"))}))).analyze(), false), new Position("ResolveHintsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 117));
        this.test("coalesce and repartition hint", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.checkAnalysis((LogicalPlan)new UnresolvedHint("COALESCE", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Literal[]{Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)10))})), package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TaBlE"}))), (LogicalPlan)new Repartition(10, false, (LogicalPlan)TestRelations$.MODULE$.testRelation()), this.checkAnalysis$default$3());
            this.checkAnalysis((LogicalPlan)new UnresolvedHint("coalesce", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Literal[]{Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)20))})), package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TaBlE"}))), (LogicalPlan)new Repartition(20, false, (LogicalPlan)TestRelations$.MODULE$.testRelation()), this.checkAnalysis$default$3());
            this.checkAnalysis((LogicalPlan)new UnresolvedHint("REPARTITION", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Literal[]{Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)100))})), package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TaBlE"}))), (LogicalPlan)new Repartition(100, true, (LogicalPlan)TestRelations$.MODULE$.testRelation()), this.checkAnalysis$default$3());
            this.checkAnalysis((LogicalPlan)new UnresolvedHint("RePARTITion", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Literal[]{Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)200))})), package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TaBlE"}))), (LogicalPlan)new Repartition(200, true, (LogicalPlan)TestRelations$.MODULE$.testRelation()), this.checkAnalysis$default$3());
            String errMsg = "COALESCE Hint expects a partition number as a parameter";
            this.assertAnalysisError((LogicalPlan)new UnresolvedHint("COALESCE", (Seq)Seq$.MODULE$.empty(), package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TaBlE"}))), (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{errMsg}))), this.assertAnalysisError$default$3());
            this.assertAnalysisError((LogicalPlan)new UnresolvedHint("COALESCE", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Literal[]{Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)10)), Literal$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)false))})), package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TaBlE"}))), (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{errMsg}))), this.assertAnalysisError$default$3());
            this.assertAnalysisError((LogicalPlan)new UnresolvedHint("COALESCE", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Literal[]{Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)1.0))})), package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TaBlE"}))), (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{errMsg}))), this.assertAnalysisError$default$3());
            AttributeReference[] attributeReferenceArray = new AttributeReference[1];
            String x$4 = "a";
            IntegerType$ x$5 = IntegerType$.MODULE$;
            boolean x$6 = AttributeReference$.MODULE$.apply$default$3();
            Metadata x$7 = AttributeReference$.MODULE$.apply$default$4();
            ExprId x$8 = AttributeReference$.MODULE$.apply$default$5(x$4, (DataType)x$5, x$6, x$7);
            Seq x$9 = AttributeReference$.MODULE$.apply$default$6(x$4, (DataType)x$5, x$6, x$7);
            attributeReferenceArray[0] = new AttributeReference(x$4, (DataType)x$5, x$6, x$7, x$8, x$9);
            this.checkAnalysis((LogicalPlan)new UnresolvedHint("RePartition", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LeafExpression[]{Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)10)), UnresolvedAttribute$.MODULE$.apply("a")})), package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TaBlE"}))), (LogicalPlan)RepartitionByExpression$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])attributeReferenceArray)), (LogicalPlan)TestRelations$.MODULE$.testRelation(), 10), this.checkAnalysis$default$3());
            AttributeReference[] attributeReferenceArray2 = new AttributeReference[1];
            String x$10 = "a";
            IntegerType$ x$11 = IntegerType$.MODULE$;
            boolean x$12 = AttributeReference$.MODULE$.apply$default$3();
            Metadata x$13 = AttributeReference$.MODULE$.apply$default$4();
            ExprId x$14 = AttributeReference$.MODULE$.apply$default$5(x$10, (DataType)x$11, x$12, x$13);
            Seq x$15 = AttributeReference$.MODULE$.apply$default$6(x$10, (DataType)x$11, x$12, x$13);
            attributeReferenceArray2[0] = new AttributeReference(x$10, (DataType)x$11, x$12, x$13, x$14, x$15);
            this.checkAnalysis((LogicalPlan)new UnresolvedHint("REPARTITION", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LeafExpression[]{Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)10)), UnresolvedAttribute$.MODULE$.apply("a")})), package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TaBlE"}))), (LogicalPlan)RepartitionByExpression$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])attributeReferenceArray2)), (LogicalPlan)TestRelations$.MODULE$.testRelation(), 10), this.checkAnalysis$default$3());
            AttributeReference[] attributeReferenceArray3 = new AttributeReference[1];
            String x$16 = "a";
            IntegerType$ x$17 = IntegerType$.MODULE$;
            boolean x$18 = AttributeReference$.MODULE$.apply$default$3();
            Metadata x$19 = AttributeReference$.MODULE$.apply$default$4();
            ExprId x$20 = AttributeReference$.MODULE$.apply$default$5(x$16, (DataType)x$17, x$18, x$19);
            Seq x$21 = AttributeReference$.MODULE$.apply$default$6(x$16, (DataType)x$17, x$18, x$19);
            attributeReferenceArray3[0] = new AttributeReference(x$16, (DataType)x$17, x$18, x$19, x$20, x$21);
            this.checkAnalysis((LogicalPlan)new UnresolvedHint("REPARTITION", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UnresolvedAttribute[]{UnresolvedAttribute$.MODULE$.apply("a")})), package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TaBlE"}))), (LogicalPlan)new RepartitionByExpression((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])attributeReferenceArray3)), (LogicalPlan)TestRelations$.MODULE$.testRelation(), (Option)None$.MODULE$), this.checkAnalysis$default$3());
            IllegalArgumentException e = (IllegalArgumentException)this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                SortOrder[] sortOrderArray = new SortOrder[1];
                String x$22 = "a";
                IntegerType$ x$23 = IntegerType$.MODULE$;
                boolean x$24 = AttributeReference$.MODULE$.apply$default$3();
                Metadata x$25 = AttributeReference$.MODULE$.apply$default$4();
                ExprId x$26 = AttributeReference$.MODULE$.apply$default$5(x$22, (DataType)x$23, x$24, x$25);
                Seq x$27 = AttributeReference$.MODULE$.apply$default$6(x$22, (DataType)x$23, x$24, x$25);
                sortOrderArray[0] = SortOrder$.MODULE$.apply((Expression)new AttributeReference(x$22, (DataType)x$23, x$24, x$25, x$26, x$27), (SortDirection)Ascending$.MODULE$, SortOrder$.MODULE$.apply$default$3());
                SortOrder[] sortOrderArray2 = new SortOrder[1];
                String x$28 = "a";
                IntegerType$ x$29 = IntegerType$.MODULE$;
                boolean x$30 = AttributeReference$.MODULE$.apply$default$3();
                Metadata x$31 = AttributeReference$.MODULE$.apply$default$4();
                ExprId x$32 = AttributeReference$.MODULE$.apply$default$5(x$28, (DataType)x$29, x$30, x$31);
                Seq x$33 = AttributeReference$.MODULE$.apply$default$6(x$28, (DataType)x$29, x$30, x$31);
                sortOrderArray2[0] = SortOrder$.MODULE$.apply((Expression)new AttributeReference(x$28, (DataType)x$29, x$30, x$31, x$32, x$33), (SortDirection)Ascending$.MODULE$, SortOrder$.MODULE$.apply$default$3());
                this.checkAnalysis((LogicalPlan)new UnresolvedHint("REPARTITION", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])sortOrderArray)), package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TaBlE"}))), (LogicalPlan)RepartitionByExpression$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])sortOrderArray2)), (LogicalPlan)TestRelations$.MODULE$.testRelation(), 10), this.checkAnalysis$default$3());
            }, ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("ResolveHintsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 168));
            e.getMessage().contains("For range partitioning use REPARTITION_BY_RANGE instead");
            SortOrder[] sortOrderArray = new SortOrder[1];
            String x$34 = "a";
            IntegerType$ x$35 = IntegerType$.MODULE$;
            boolean x$36 = AttributeReference$.MODULE$.apply$default$3();
            Metadata x$37 = AttributeReference$.MODULE$.apply$default$4();
            ExprId x$38 = AttributeReference$.MODULE$.apply$default$5(x$34, (DataType)x$35, x$36, x$37);
            Seq x$39 = AttributeReference$.MODULE$.apply$default$6(x$34, (DataType)x$35, x$36, x$37);
            sortOrderArray[0] = SortOrder$.MODULE$.apply((Expression)new AttributeReference(x$34, (DataType)x$35, x$36, x$37, x$38, x$39), (SortDirection)Ascending$.MODULE$, SortOrder$.MODULE$.apply$default$3());
            this.checkAnalysis((LogicalPlan)new UnresolvedHint("REPARTITION_BY_RANGE", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LeafExpression[]{Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)10)), UnresolvedAttribute$.MODULE$.apply("a")})), package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TaBlE"}))), (LogicalPlan)RepartitionByExpression$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])sortOrderArray)), (LogicalPlan)TestRelations$.MODULE$.testRelation(), 10), this.checkAnalysis$default$3());
            SortOrder[] sortOrderArray2 = new SortOrder[1];
            String x$40 = "a";
            IntegerType$ x$41 = IntegerType$.MODULE$;
            boolean x$42 = AttributeReference$.MODULE$.apply$default$3();
            Metadata x$43 = AttributeReference$.MODULE$.apply$default$4();
            ExprId x$44 = AttributeReference$.MODULE$.apply$default$5(x$40, (DataType)x$41, x$42, x$43);
            Seq x$45 = AttributeReference$.MODULE$.apply$default$6(x$40, (DataType)x$41, x$42, x$43);
            sortOrderArray2[0] = SortOrder$.MODULE$.apply((Expression)new AttributeReference(x$40, (DataType)x$41, x$42, x$43, x$44, x$45), (SortDirection)Ascending$.MODULE$, SortOrder$.MODULE$.apply$default$3());
            this.checkAnalysis((LogicalPlan)new UnresolvedHint("REPARTITION_BY_RANGE", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UnresolvedAttribute[]{UnresolvedAttribute$.MODULE$.apply("a")})), package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TaBlE"}))), (LogicalPlan)new RepartitionByExpression((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])sortOrderArray2)), (LogicalPlan)TestRelations$.MODULE$.testRelation(), (Option)None$.MODULE$), this.checkAnalysis$default$3());
            String errMsg2 = "REPARTITION Hint parameter should include columns, but";
            this.assertAnalysisError((LogicalPlan)new UnresolvedHint("REPARTITION", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Literal[]{Literal$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)true))})), package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TaBlE"}))), (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{errMsg2}))), this.assertAnalysisError$default$3());
            LeafExpression[] leafExpressionArray = new LeafExpression[2];
            leafExpressionArray[0] = Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)1.0));
            String x$46 = "a";
            IntegerType$ x$47 = IntegerType$.MODULE$;
            boolean x$48 = AttributeReference$.MODULE$.apply$default$3();
            Metadata x$49 = AttributeReference$.MODULE$.apply$default$4();
            ExprId x$50 = AttributeReference$.MODULE$.apply$default$5(x$46, (DataType)x$47, x$48, x$49);
            Seq x$51 = AttributeReference$.MODULE$.apply$default$6(x$46, (DataType)x$47, x$48, x$49);
            leafExpressionArray[1] = new AttributeReference(x$46, (DataType)x$47, x$48, x$49, x$50, x$51);
            this.assertAnalysisError((LogicalPlan)new UnresolvedHint("REPARTITION", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])leafExpressionArray)), package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TaBlE"}))), (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{errMsg2}))), this.assertAnalysisError$default$3());
            String errMsg3 = "REPARTITION_BY_RANGE Hint parameter should include columns, but";
            LeafExpression[] leafExpressionArray2 = new LeafExpression[2];
            leafExpressionArray2[0] = Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)1.0));
            String x$52 = "a";
            IntegerType$ x$53 = IntegerType$.MODULE$;
            boolean x$54 = AttributeReference$.MODULE$.apply$default$3();
            Metadata x$55 = AttributeReference$.MODULE$.apply$default$4();
            ExprId x$56 = AttributeReference$.MODULE$.apply$default$5(x$52, (DataType)x$53, x$54, x$55);
            Seq x$57 = AttributeReference$.MODULE$.apply$default$6(x$52, (DataType)x$53, x$54, x$55);
            leafExpressionArray2[1] = new AttributeReference(x$52, (DataType)x$53, x$54, x$55, x$56, x$57);
            this.assertAnalysisError((LogicalPlan)new UnresolvedHint("REPARTITION_BY_RANGE", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])leafExpressionArray2)), package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TaBlE"}))), (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{errMsg3}))), this.assertAnalysisError$default$3());
            this.assertAnalysisError((LogicalPlan)new UnresolvedHint("REPARTITION_BY_RANGE", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Literal[]{Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)10)), Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)10))})), package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TaBlE"}))), (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{errMsg3}))), this.assertAnalysisError$default$3());
            this.assertAnalysisError((LogicalPlan)new UnresolvedHint("REPARTITION_BY_RANGE", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LeafExpression[]{Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)10)), Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)10)), UnresolvedAttribute$.MODULE$.apply("a")})), package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TaBlE"}))), (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{errMsg3}))), this.assertAnalysisError$default$3());
        }, new Position("ResolveHintsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 129));
        this.test("log warnings for invalid hints", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            SparkFunSuite.LogAppender logAppender = new SparkFunSuite.LogAppender((SparkFunSuite)this, "invalid hints", this.LogAppender().$lessinit$greater$default$2());
            this.withLogAppender((Appender)logAppender, this.withLogAppender$default$2(), this.withLogAppender$default$3(), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.checkAnalysis((LogicalPlan)new UnresolvedHint("unknown_hint", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TaBlE"})), package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TaBlE"}))), (LogicalPlan)TestRelations$.MODULE$.testRelation(), false));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(logAppender.loggingEvents().exists((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToBoolean((boolean)ResolveHintsSuite.$anonfun$new$13(e))), "logAppender.loggingEvents.exists(((e: org.apache.log4j.spi.LoggingEvent) => e.getLevel().==(org.apache.log4j.Level.WARN).&&(e.getRenderedMessage().contains(\"Unrecognized hint: unknown_hint\"))))", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ResolveHintsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 233));
        }, new Position("ResolveHintsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 225));
        this.test("SPARK-30003: Do not throw stack overflow exception in non-root unknown hint resolution", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.checkAnalysis((LogicalPlan)new Project(TestRelations$.MODULE$.testRelation().output(), (LogicalPlan)new UnresolvedHint("unknown_hint", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TaBlE"})), package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TaBlE"})))), (LogicalPlan)new Project(TestRelations$.MODULE$.testRelation().output(), (LogicalPlan)TestRelations$.MODULE$.testRelation()), false), new Position("ResolveHintsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 238));
        this.test("Supports multi-part table names for join strategy hint resolution", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"MAPJOIN", (Object)BROADCAST$.MODULE$), new Tuple2((Object)"MERGEJOIN", (Object)SHUFFLE_MERGE$.MODULE$), new Tuple2((Object)"SHUFFLE_HASH", (Object)SHUFFLE_HASH$.MODULE$), new Tuple2((Object)"SHUFFLE_REPLICATE_NL", (Object)SHUFFLE_REPLICATE_NL$.MODULE$)}))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ResolveHintsSuite.$anonfun$new$16(this, x0$1);
            return BoxedUnit.UNIT;
        }), new Position("ResolveHintsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 245));
    }
}

