/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.analysis;

import java.io.File;
import java.io.Serializable;
import java.net.URI;
import java.time.ZoneId;
import java.util.Locale;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.catalyst.analysis.AnalysisTest;
import org.apache.spark.sql.catalyst.analysis.Analyzer;
import org.apache.spark.sql.catalyst.analysis.EliminateSubqueryAliases$;
import org.apache.spark.sql.catalyst.analysis.FunctionRegistry;
import org.apache.spark.sql.catalyst.analysis.FunctionRegistry$;
import org.apache.spark.sql.catalyst.analysis.NamedRelation;
import org.apache.spark.sql.catalyst.analysis.TestRelation;
import org.apache.spark.sql.catalyst.analysis.TestRelationAcceptAnySchema;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAttribute;
import org.apache.spark.sql.catalyst.analysis.UnresolvedRelation;
import org.apache.spark.sql.catalyst.analysis.UnresolvedRelation$;
import org.apache.spark.sql.catalyst.catalog.CatalogDatabase;
import org.apache.spark.sql.catalyst.catalog.ExternalCatalog;
import org.apache.spark.sql.catalyst.catalog.InMemoryCatalog;
import org.apache.spark.sql.catalyst.catalog.InMemoryCatalog$;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.Alias$;
import org.apache.spark.sql.catalyst.expressions.AliasHelper;
import org.apache.spark.sql.catalyst.expressions.AttributeMap;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeReference$;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.LessThanOrEqual;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.PredicateHelper;
import org.apache.spark.sql.catalyst.plans.PlanTestBase;
import org.apache.spark.sql.catalyst.plans.SQLHelper;
import org.apache.spark.sql.catalyst.plans.logical.Aggregate;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.OverwriteByExpression;
import org.apache.spark.sql.catalyst.plans.logical.OverwriteByExpression$;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.catalyst.rules.Rule;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u001d4Q\u0001E\t\u0002\u0002yAQa\n\u0001\u0005\u0002!BQA\u000b\u0001\u0005B-Bqa\f\u0001C\u0002\u0013\u0005\u0001\u0007\u0003\u00045\u0001\u0001\u0006I!\r\u0005\bk\u0001\u0011\r\u0011\"\u00011\u0011\u00191\u0004\u0001)A\u0005c!9q\u0007\u0001b\u0001\n\u0003\u0001\u0004B\u0002\u001d\u0001A\u0003%\u0011\u0007C\u0003:\u0001\u0019\u0005!\bC\u0003J\u0001\u0019\u0005!\nC\u0003N\u0001\u0011\u0005a\nC\u0003X\u0001\u0011\u0005\u0001\fC\u0003[\u0001\u0011\u00051\fC\u0003e\u0001\u0011EQ\rC\u0003g\u0001\u0011EQMA\u000fECR\f7k\\;sG\u00164&'\u00118bYf\u001c\u0018n\u001d\"bg\u0016\u001cV/\u001b;f\u0015\t\u00112#\u0001\u0005b]\u0006d\u0017p]5t\u0015\t!R#\u0001\u0005dCR\fG._:u\u0015\t1r#A\u0002tc2T!\u0001G\r\u0002\u000bM\u0004\u0018M]6\u000b\u0005iY\u0012AB1qC\u000eDWMC\u0001\u001d\u0003\ry'oZ\u0002\u0001'\r\u0001qd\t\t\u0003A\u0005j\u0011aF\u0005\u0003E]\u0011Qb\u00159be.4UO\\*vSR,\u0007C\u0001\u0013&\u001b\u0005\t\u0012B\u0001\u0014\u0012\u00051\te.\u00197zg&\u001cH+Z:u\u0003\u0019a\u0014N\\5u}Q\t\u0011\u0006\u0005\u0002%\u0001\u0005Yq-\u001a;B]\u0006d\u0017P_3s+\u0005a\u0003C\u0001\u0013.\u0013\tq\u0013C\u0001\u0005B]\u0006d\u0017P_3s\u0003\u0015!\u0018M\u00197f+\u0005\t\u0004C\u0001\u00133\u0013\t\u0019\u0014C\u0001\u0007UKN$(+\u001a7bi&|g.\u0001\u0004uC\ndW\rI\u0001\u000ee\u0016\fX/\u001b:fIR\u000b'\r\\3\u0002\u001dI,\u0017/^5sK\u0012$\u0016M\u00197fA\u0005Qq/\u001b3feR\u000b'\r\\3\u0002\u0017]LG-\u001a:UC\ndW\rI\u0001\u0007Eft\u0015-\\3\u0015\u0007m\u001au\t\u0005\u0002=\u00036\tQH\u0003\u0002?\u007f\u00059An\\4jG\u0006d'B\u0001!\u0014\u0003\u0015\u0001H.\u00198t\u0013\t\u0011UHA\u0006M_\u001eL7-\u00197QY\u0006t\u0007\"B\u0018\n\u0001\u0004!\u0005C\u0001\u0013F\u0013\t1\u0015CA\u0007OC6,GMU3mCRLwN\u001c\u0005\u0006\u0011&\u0001\raO\u0001\u0006cV,'/_\u0001\u000bEf\u0004vn]5uS>tGcA\u001eL\u0019\")qF\u0003a\u0001\t\")\u0001J\u0003a\u0001w\u0005\t\u0012m]:feRtu\u000e\u001e*fg>dg/\u001a3\u0015\u0005=+\u0006C\u0001)T\u001b\u0005\t&\"\u0001*\u0002\u000bM\u001c\u0017\r\\1\n\u0005Q\u000b&\u0001B+oSRDQAV\u0006A\u0002m\n1\u0002\\8hS\u000e\fG\u000e\u00157b]\u0006q\u0011m]:feR\u0014Vm]8mm\u0016$GCA(Z\u0011\u00151F\u00021\u0001<\u0003\u001d!x\u000eT8xKJ$\"\u0001\u00182\u0011\u0005u\u0003W\"\u00010\u000b\u0005}\u001b\u0012aC3yaJ,7o]5p]NL!!\u00190\u0003%\u0005#HO]5ckR,'+\u001a4fe\u0016t7-\u001a\u0005\u0006G6\u0001\r\u0001X\u0001\u0005CR$(/A\u0011uKN$(+Z:pYZ,Gm\u0014<fe^\u0014\u0018\u000e^3Cs\u0016C\bO]3tg&|g\u000eF\u0001P\u0003\u0011\"Xm\u001d;O_R\u0014Vm]8mm\u0016$wJ^3soJLG/\u001a\"z\u000bb\u0004(/Z:tS>t\u0007")
public abstract class DataSourceV2AnalysisBaseSuite
extends SparkFunSuite
implements AnalysisTest {
    private final TestRelation table;
    private final TestRelation requiredTable;
    private final TestRelation widerTable;
    private String sparkHome;
    private volatile boolean bitmap$0;

    @Override
    public /* synthetic */ void org$apache$spark$sql$catalyst$analysis$AnalysisTest$$super$comparePlans(LogicalPlan plan1, LogicalPlan plan2, boolean checkAnalysis) {
        PlanTestBase.comparePlans$(this, plan1, plan2, checkAnalysis);
    }

    @Override
    public Seq<Rule<LogicalPlan>> extendedAnalysisRules() {
        return AnalysisTest.extendedAnalysisRules$(this);
    }

    @Override
    public void checkAnalysis(LogicalPlan inputPlan, LogicalPlan expectedPlan, boolean caseSensitive) {
        AnalysisTest.checkAnalysis$(this, inputPlan, expectedPlan, caseSensitive);
    }

    @Override
    public boolean checkAnalysis$default$3() {
        return AnalysisTest.checkAnalysis$default$3$(this);
    }

    @Override
    public void comparePlans(LogicalPlan plan1, LogicalPlan plan2, boolean checkAnalysis) {
        AnalysisTest.comparePlans$(this, plan1, plan2, checkAnalysis);
    }

    @Override
    public boolean comparePlans$default$3() {
        return AnalysisTest.comparePlans$default$3$(this);
    }

    @Override
    public void assertAnalysisSuccess(LogicalPlan inputPlan, boolean caseSensitive) {
        AnalysisTest.assertAnalysisSuccess$(this, inputPlan, caseSensitive);
    }

    @Override
    public boolean assertAnalysisSuccess$default$2() {
        return AnalysisTest.assertAnalysisSuccess$default$2$(this);
    }

    @Override
    public void assertAnalysisError(LogicalPlan inputPlan, Seq<String> expectedErrors, boolean caseSensitive) {
        AnalysisTest.assertAnalysisError$(this, inputPlan, expectedErrors, caseSensitive);
    }

    @Override
    public boolean assertAnalysisError$default$3() {
        return AnalysisTest.assertAnalysisError$default$3$(this);
    }

    @Override
    public void interceptParseException(Function1<String, Object> parser, String sqlCommand, Seq<String> messages) {
        AnalysisTest.interceptParseException$(this, parser, sqlCommand, messages);
    }

    @Override
    public LogicalPlan normalizeExprIds(LogicalPlan plan) {
        return PlanTestBase.normalizeExprIds$(this, plan);
    }

    @Override
    public LogicalPlan rewriteNameFromAttrNullability(LogicalPlan plan) {
        return PlanTestBase.rewriteNameFromAttrNullability$(this, plan);
    }

    @Override
    public LogicalPlan normalizePlan(LogicalPlan plan) {
        return PlanTestBase.normalizePlan$(this, plan);
    }

    @Override
    public void compareExpressions(Expression e1, Expression e2) {
        PlanTestBase.compareExpressions$(this, e1, e2);
    }

    public SQLConf conf() {
        return SQLConfHelper.conf$((SQLConfHelper)this);
    }

    @Override
    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        SQLHelper.withSQLConf$(this, pairs, f);
    }

    @Override
    public void withTempPath(Function1<File, BoxedUnit> f) {
        SQLHelper.withTempPath$(this, f);
    }

    @Override
    public <T> void testSpecialDatetimeValues(Function1<ZoneId, T> test) {
        SQLHelper.testSpecialDatetimeValues$(this, test);
    }

    public Seq<Expression> splitConjunctivePredicates(Expression condition) {
        return PredicateHelper.splitConjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Option<Tuple2<Expression, LogicalPlan>> findExpressionAndTrackLineageDown(Expression exp, LogicalPlan plan) {
        return PredicateHelper.findExpressionAndTrackLineageDown$((PredicateHelper)this, (Expression)exp, (LogicalPlan)plan);
    }

    public Seq<Expression> splitDisjunctivePredicates(Expression condition) {
        return PredicateHelper.splitDisjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public boolean canEvaluate(Expression expr, LogicalPlan plan) {
        return PredicateHelper.canEvaluate$((PredicateHelper)this, (Expression)expr, (LogicalPlan)plan);
    }

    public boolean canEvaluateWithinJoin(Expression expr) {
        return PredicateHelper.canEvaluateWithinJoin$((PredicateHelper)this, (Expression)expr);
    }

    public Option<Expression> extractPredicatesWithinOutputSet(Expression condition, AttributeSet outputSet) {
        return PredicateHelper.extractPredicatesWithinOutputSet$((PredicateHelper)this, (Expression)condition, (AttributeSet)outputSet);
    }

    public AttributeMap<Alias> getAliasMap(Project plan) {
        return AliasHelper.getAliasMap$((AliasHelper)this, (Project)plan);
    }

    public AttributeMap<Alias> getAliasMap(Aggregate plan) {
        return AliasHelper.getAliasMap$((AliasHelper)this, (Aggregate)plan);
    }

    public AttributeMap<Alias> getAliasMap(Seq<NamedExpression> exprs) {
        return AliasHelper.getAliasMap$((AliasHelper)this, exprs);
    }

    public Expression replaceAlias(Expression expr, AttributeMap<Alias> aliasMap) {
        return AliasHelper.replaceAlias$((AliasHelper)this, (Expression)expr, aliasMap);
    }

    public NamedExpression replaceAliasButKeepName(NamedExpression expr, AttributeMap<Alias> aliasMap) {
        return AliasHelper.replaceAliasButKeepName$((AliasHelper)this, (NamedExpression)expr, aliasMap);
    }

    public Expression trimAliases(Expression e) {
        return AliasHelper.trimAliases$((AliasHelper)this, (Expression)e);
    }

    public <T extends Expression> T trimNonTopLevelAliases(T e) {
        return (T)AliasHelper.trimNonTopLevelAliases$((AliasHelper)this, e);
    }

    private String sparkHome$lzycompute() {
        DataSourceV2AnalysisBaseSuite dataSourceV2AnalysisBaseSuite = this;
        synchronized (dataSourceV2AnalysisBaseSuite) {
            if (!this.bitmap$0) {
                this.sparkHome = SQLHelper.sparkHome$(this);
                this.bitmap$0 = true;
            }
        }
        return this.sparkHome;
    }

    @Override
    public String sparkHome() {
        return !this.bitmap$0 ? this.sparkHome$lzycompute() : this.sparkHome;
    }

    @Override
    public Analyzer getAnalyzer() {
        SessionCatalog catalog = new SessionCatalog((ExternalCatalog)new InMemoryCatalog(InMemoryCatalog$.MODULE$.$lessinit$greater$default$1(), InMemoryCatalog$.MODULE$.$lessinit$greater$default$2()), (FunctionRegistry)FunctionRegistry$.MODULE$.builtin());
        catalog.createDatabase(new CatalogDatabase("default", "", new URI("loc"), Predef$.MODULE$.Map().empty()), false);
        return new Analyzer(null, catalog){
            private final List<EliminateSubqueryAliases$> extendedResolutionRules;

            public List<EliminateSubqueryAliases$> extendedResolutionRules() {
                return this.extendedResolutionRules;
            }
            {
                EliminateSubqueryAliases$ eliminateSubqueryAliases$ = EliminateSubqueryAliases$.MODULE$;
                this.extendedResolutionRules = Nil$.MODULE$.$colon$colon((Object)eliminateSubqueryAliases$);
            }
        };
    }

    public TestRelation table() {
        return this.table;
    }

    public TestRelation requiredTable() {
        return this.requiredTable;
    }

    public TestRelation widerTable() {
        return this.widerTable;
    }

    public abstract LogicalPlan byName(NamedRelation var1, LogicalPlan var2);

    public abstract LogicalPlan byPosition(NamedRelation var1, LogicalPlan var2);

    public void assertNotResolved(LogicalPlan logicalPlan) {
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(logicalPlan.resolved(), "logicalPlan.resolved", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder(29).append("Plan should not be resolved: ").append(logicalPlan).toString(), Prettifier$.MODULE$.default(), new Position("DataSourceV2AnalysisSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 639));
    }

    public void assertResolved(LogicalPlan logicalPlan) {
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(logicalPlan.resolved(), "logicalPlan.resolved", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder(25).append("Plan should be resolved: ").append(logicalPlan).toString(), Prettifier$.MODULE$.default(), new Position("DataSourceV2AnalysisSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 643));
    }

    public AttributeReference toLower(AttributeReference attr) {
        String x$1 = attr.name().toLowerCase(Locale.ROOT);
        DataType x$2 = attr.dataType();
        boolean x$3 = AttributeReference$.MODULE$.apply$default$3();
        Metadata x$4 = AttributeReference$.MODULE$.apply$default$4();
        ExprId x$5 = attr.exprId();
        Seq x$6 = AttributeReference$.MODULE$.apply$default$6(x$1, x$2, x$3, x$4);
        return new AttributeReference(x$1, x$2, x$3, x$4, x$5, x$6);
    }

    public void testResolvedOverwriteByExpression() {
        TestRelation table = new TestRelation((Seq<AttributeReference>)StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("x", (DataType)DoubleType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), new StructField("y", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())}))).toAttributes());
        TestRelation query = new TestRelation((Seq<AttributeReference>)StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("a", (DataType)DoubleType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), new StructField("b", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())}))).toAttributes());
        AttributeReference a = (AttributeReference)query.output().head();
        AttributeReference b = (AttributeReference)query.output().last();
        AttributeReference x = (AttributeReference)table.output().head();
        OverwriteByExpression parsedPlan = OverwriteByExpression$.MODULE$.byPosition((NamedRelation)table, (LogicalPlan)query, (Expression)new LessThanOrEqual((Expression)new UnresolvedAttribute((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"x"}))), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)15.0))), OverwriteByExpression$.MODULE$.byPosition$default$4());
        Alias[] aliasArray = new Alias[2];
        Cast x$1 = new Cast((Expression)a, (DataType)DoubleType$.MODULE$, (Option)new Some((Object)this.conf().sessionLocalTimeZone()));
        String x$2 = "x";
        ExprId x$3 = Alias$.MODULE$.apply$default$3((Expression)x$1, x$2);
        Seq x$4 = Alias$.MODULE$.apply$default$4((Expression)x$1, x$2);
        Option x$5 = Alias$.MODULE$.apply$default$5((Expression)x$1, x$2);
        Seq x$6 = Alias$.MODULE$.apply$default$6((Expression)x$1, x$2);
        aliasArray[0] = new Alias((Expression)x$1, x$2, x$3, x$4, x$5, x$6);
        Cast x$7 = new Cast((Expression)b, (DataType)DoubleType$.MODULE$, (Option)new Some((Object)this.conf().sessionLocalTimeZone()));
        String x$8 = "y";
        ExprId x$9 = Alias$.MODULE$.apply$default$3((Expression)x$7, x$8);
        Seq x$10 = Alias$.MODULE$.apply$default$4((Expression)x$7, x$8);
        Option x$11 = Alias$.MODULE$.apply$default$5((Expression)x$7, x$8);
        Seq x$12 = Alias$.MODULE$.apply$default$6((Expression)x$7, x$8);
        aliasArray[1] = new Alias((Expression)x$7, x$8, x$9, x$10, x$11, x$12);
        OverwriteByExpression expectedPlan = OverwriteByExpression$.MODULE$.byPosition((NamedRelation)table, (LogicalPlan)new Project((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])aliasArray)), (LogicalPlan)query), (Expression)new LessThanOrEqual((Expression)x, (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)15.0))), OverwriteByExpression$.MODULE$.byPosition$default$4());
        this.assertNotResolved((LogicalPlan)parsedPlan);
        this.checkAnalysis((LogicalPlan)parsedPlan, (LogicalPlan)expectedPlan, this.checkAnalysis$default$3());
        this.assertResolved((LogicalPlan)expectedPlan);
    }

    public void testNotResolvedOverwriteByExpression() {
        TestRelation table = new TestRelation((Seq<AttributeReference>)StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("x", (DataType)DoubleType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), new StructField("y", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())}))).toAttributes());
        TestRelation query = new TestRelation((Seq<AttributeReference>)StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("a", (DataType)DoubleType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), new StructField("b", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())}))).toAttributes());
        OverwriteByExpression parsedPlan = OverwriteByExpression$.MODULE$.byPosition((NamedRelation)table, (LogicalPlan)query, (Expression)new LessThanOrEqual((Expression)new UnresolvedAttribute((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)15.0))), OverwriteByExpression$.MODULE$.byPosition$default$4());
        this.assertNotResolved((LogicalPlan)parsedPlan);
        this.assertAnalysisError((LogicalPlan)parsedPlan, (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"cannot resolve", "`a`", "given input columns", "x, y"}))), this.assertAnalysisError$default$3());
        TestRelationAcceptAnySchema tableAcceptAnySchema = new TestRelationAcceptAnySchema((Seq<AttributeReference>)StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("x", (DataType)DoubleType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), new StructField("y", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())}))).toAttributes());
        OverwriteByExpression parsedPlan2 = OverwriteByExpression$.MODULE$.byPosition((NamedRelation)tableAcceptAnySchema, (LogicalPlan)query, (Expression)new LessThanOrEqual((Expression)new UnresolvedAttribute((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)15.0))), OverwriteByExpression$.MODULE$.byPosition$default$4());
        this.assertNotResolved((LogicalPlan)parsedPlan2);
        this.assertAnalysisError((LogicalPlan)parsedPlan2, (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"cannot resolve", "`a`", "given input columns", "x, y"}))), this.assertAnalysisError$default$3());
    }

    private final void assertTypeCompatibility$1(String name, DataType fromType, DataType toType) {
        TestRelation table = new TestRelation((Seq<AttributeReference>)StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("a", toType, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())}))).toAttributes());
        TestRelation query = new TestRelation((Seq<AttributeReference>)StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("a", fromType, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())}))).toAttributes());
        LogicalPlan parsedPlan = this.byName(table, (LogicalPlan)query);
        this.assertResolved(parsedPlan);
        this.checkAnalysis(parsedPlan, parsedPlan, this.checkAnalysis$default$3());
    }

    public DataSourceV2AnalysisBaseSuite() {
        AliasHelper.$init$((AliasHelper)this);
        PredicateHelper.$init$((PredicateHelper)this);
        SQLHelper.$init$(this);
        SQLConfHelper.$init$((SQLConfHelper)this);
        PlanTestBase.$init$(this);
        AnalysisTest.$init$(this);
        this.table = new TestRelation((Seq<AttributeReference>)StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("x", (DataType)FloatType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("y", (DataType)FloatType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())}))).toAttributes());
        this.requiredTable = new TestRelation((Seq<AttributeReference>)StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("x", (DataType)FloatType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), new StructField("y", (DataType)FloatType$.MODULE$, false, StructField$.MODULE$.apply$default$4())}))).toAttributes());
        this.widerTable = new TestRelation((Seq<AttributeReference>)StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("x", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("y", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())}))).toAttributes());
        this.test("SPARK-33136: output resolved on complex types for V2 write commands", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            StructType fromStructType = new StructType((StructField[])((Object[])new StructField[]{new StructField("s", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("i_nonnull", (DataType)IntegerType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), new StructField("st", (DataType)new StructType((StructField[])((Object[])new StructField[]{new StructField("l", (DataType)LongType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("s_nonnull", (DataType)StringType$.MODULE$, false, StructField$.MODULE$.apply$default$4())})), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())}));
            StructType toStructType = new StructType((StructField[])((Object[])new StructField[]{new StructField("s", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("i_nonnull", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("st", (DataType)new StructType((StructField[])((Object[])new StructField[]{new StructField("l", (DataType)LongType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("s_nonnull", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())})), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())}));
            this.assertTypeCompatibility$1("struct", (DataType)fromStructType, (DataType)toStructType);
            this.assertTypeCompatibility$1("array", (DataType)new ArrayType((DataType)LongType$.MODULE$, false), (DataType)new ArrayType((DataType)LongType$.MODULE$, true));
            ArrayType fromArrayWithStructType = new ArrayType((DataType)new StructType((StructField[])((Object[])new StructField[]{new StructField("s", (DataType)StringType$.MODULE$, false, StructField$.MODULE$.apply$default$4())})), false);
            ArrayType toArrayWithStructType = new ArrayType((DataType)new StructType((StructField[])((Object[])new StructField[]{new StructField("s", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())})), true);
            this.assertTypeCompatibility$1("array_struct", (DataType)fromArrayWithStructType, (DataType)toArrayWithStructType);
            this.assertTypeCompatibility$1("map", (DataType)new MapType((DataType)IntegerType$.MODULE$, (DataType)StringType$.MODULE$, false), (DataType)new MapType((DataType)IntegerType$.MODULE$, (DataType)StringType$.MODULE$, true));
            MapType fromMapWithStructType = new MapType((DataType)IntegerType$.MODULE$, (DataType)new StructType((StructField[])((Object[])new StructField[]{new StructField("s", (DataType)StringType$.MODULE$, false, StructField$.MODULE$.apply$default$4())})), false);
            MapType toMapWithStructType = new MapType((DataType)IntegerType$.MODULE$, (DataType)new StructType((StructField[])((Object[])new StructField[]{new StructField("s", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())})), true);
            this.assertTypeCompatibility$1("map_struct", (DataType)fromMapWithStructType, (DataType)toMapWithStructType);
        }, new Position("DataSourceV2AnalysisSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 251));
        this.test("skipSchemaResolution should still require query to be resolved", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            TestRelationAcceptAnySchema table = new TestRelationAcceptAnySchema((Seq<AttributeReference>)StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("a", (DataType)FloatType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("b", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())}))).toAttributes());
            UnresolvedRelation query = new UnresolvedRelation((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"})), UnresolvedRelation$.MODULE$.apply$default$2(), UnresolvedRelation$.MODULE$.apply$default$3());
            LogicalPlan parsedPlan = this.byName(table, (LogicalPlan)query);
            this.assertNotResolved(parsedPlan);
        }, new Position("DataSourceV2AnalysisSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 313));
        this.test("byName: basic behavior", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            TestRelation query = new TestRelation((Seq<AttributeReference>)this.table().schema().toAttributes());
            LogicalPlan parsedPlan = this.byName(this.table(), (LogicalPlan)query);
            this.checkAnalysis(parsedPlan, parsedPlan, this.checkAnalysis$default$3());
            this.assertResolved(parsedPlan);
        }, new Position("DataSourceV2AnalysisSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 322));
        this.test("byName: does not match by position", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            TestRelation query = new TestRelation((Seq<AttributeReference>)StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("a", (DataType)FloatType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("b", (DataType)FloatType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())}))).toAttributes());
            LogicalPlan parsedPlan = this.byName(this.table(), (LogicalPlan)query);
            this.assertNotResolved(parsedPlan);
            this.assertAnalysisError(parsedPlan, (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot write incompatible data to table", "'table-name'", "Cannot find data for output column", "'x'", "'y'"}))), this.assertAnalysisError$default$3());
        }, new Position("DataSourceV2AnalysisSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 331));
        this.test("byName: case sensitive column resolution", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            TestRelation query = new TestRelation((Seq<AttributeReference>)StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("X", (DataType)FloatType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("y", (DataType)FloatType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())}))).toAttributes());
            LogicalPlan parsedPlan = this.byName(this.table(), (LogicalPlan)query);
            this.assertNotResolved(parsedPlan);
            this.assertAnalysisError(parsedPlan, (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot write incompatible data to table", "'table-name'", "Cannot find data for output column", "'x'"}))), true);
        }, new Position("DataSourceV2AnalysisSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 344));
        this.test("byName: case insensitive column resolution", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            TestRelation query = new TestRelation((Seq<AttributeReference>)StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("X", (DataType)FloatType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("y", (DataType)FloatType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())}))).toAttributes());
            AttributeReference X = (AttributeReference)query.output().head();
            AttributeReference y = (AttributeReference)query.output().last();
            LogicalPlan parsedPlan = this.byName(this.table(), (LogicalPlan)query);
            LogicalPlan expectedPlan = this.byName(this.table(), (LogicalPlan)new Project((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AttributeReference[]{X.withName("x"), y})), (LogicalPlan)query));
            this.assertNotResolved(parsedPlan);
            this.checkAnalysis(parsedPlan, expectedPlan, false);
            this.assertResolved(expectedPlan);
        }, new Position("DataSourceV2AnalysisSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 358));
        this.test("byName: data columns are reordered by name", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            TestRelation query = new TestRelation((Seq<AttributeReference>)StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("y", (DataType)FloatType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("x", (DataType)FloatType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())}))).toAttributes());
            AttributeReference y = (AttributeReference)query.output().head();
            AttributeReference x = (AttributeReference)query.output().last();
            LogicalPlan parsedPlan = this.byName(this.table(), (LogicalPlan)query);
            LogicalPlan expectedPlan = this.byName(this.table(), (LogicalPlan)new Project((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AttributeReference[]{x, y})), (LogicalPlan)query));
            this.assertNotResolved(parsedPlan);
            this.checkAnalysis(parsedPlan, expectedPlan, this.checkAnalysis$default$3());
            this.assertResolved(expectedPlan);
        }, new Position("DataSourceV2AnalysisSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 374));
        this.test("byName: fail nullable data written to required columns", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LogicalPlan parsedPlan = this.byName(this.requiredTable(), (LogicalPlan)this.table());
            this.assertNotResolved(parsedPlan);
            this.assertAnalysisError(parsedPlan, (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot write incompatible data to table", "'table-name'", "Cannot write nullable values to non-null column", "'x'", "'y'"}))), this.assertAnalysisError$default$3());
        }, new Position("DataSourceV2AnalysisSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 391));
        this.test("byName: allow required data written to nullable columns", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LogicalPlan parsedPlan = this.byName(this.table(), (LogicalPlan)this.requiredTable());
            this.assertResolved(parsedPlan);
            this.checkAnalysis(parsedPlan, parsedPlan, this.checkAnalysis$default$3());
        }, new Position("DataSourceV2AnalysisSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 399));
        this.test("byName: missing required columns cause failure and are identified by name", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            TestRelation query = new TestRelation((Seq<AttributeReference>)StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("y", (DataType)FloatType$.MODULE$, false, StructField$.MODULE$.apply$default$4())}))).toAttributes());
            LogicalPlan parsedPlan = this.byName(this.requiredTable(), (LogicalPlan)query);
            this.assertNotResolved(parsedPlan);
            this.assertAnalysisError(parsedPlan, (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot write incompatible data to table", "'table-name'", "Cannot find data for output column", "'x'"}))), this.assertAnalysisError$default$3());
        }, new Position("DataSourceV2AnalysisSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 405));
        this.test("byName: missing optional columns cause failure and are identified by name", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            TestRelation query = new TestRelation((Seq<AttributeReference>)StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("y", (DataType)FloatType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())}))).toAttributes());
            LogicalPlan parsedPlan = this.byName(this.table(), (LogicalPlan)query);
            this.assertNotResolved(parsedPlan);
            this.assertAnalysisError(parsedPlan, (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot write incompatible data to table", "'table-name'", "Cannot find data for output column", "'x'"}))), this.assertAnalysisError$default$3());
        }, new Position("DataSourceV2AnalysisSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 418));
        this.test("byName: insert safe cast", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            AttributeReference x = (AttributeReference)this.table().output().head();
            AttributeReference y = (AttributeReference)this.table().output().last();
            LogicalPlan parsedPlan = this.byName(this.widerTable(), (LogicalPlan)this.table());
            Alias[] aliasArray = new Alias[2];
            Cast x$1 = new Cast((Expression)x, (DataType)DoubleType$.MODULE$, (Option)new Some((Object)this.conf().sessionLocalTimeZone()));
            String x$2 = "x";
            ExprId x$3 = Alias$.MODULE$.apply$default$3((Expression)x$1, x$2);
            Seq x$4 = Alias$.MODULE$.apply$default$4((Expression)x$1, x$2);
            Option x$5 = Alias$.MODULE$.apply$default$5((Expression)x$1, x$2);
            Seq x$6 = Alias$.MODULE$.apply$default$6((Expression)x$1, x$2);
            aliasArray[0] = new Alias((Expression)x$1, x$2, x$3, x$4, x$5, x$6);
            Cast x$7 = new Cast((Expression)y, (DataType)DoubleType$.MODULE$, (Option)new Some((Object)this.conf().sessionLocalTimeZone()));
            String x$8 = "y";
            ExprId x$9 = Alias$.MODULE$.apply$default$3((Expression)x$7, x$8);
            Seq x$10 = Alias$.MODULE$.apply$default$4((Expression)x$7, x$8);
            Option x$11 = Alias$.MODULE$.apply$default$5((Expression)x$7, x$8);
            Seq x$12 = Alias$.MODULE$.apply$default$6((Expression)x$7, x$8);
            aliasArray[1] = new Alias((Expression)x$7, x$8, x$9, x$10, x$11, x$12);
            LogicalPlan expectedPlan = this.byName(this.widerTable(), (LogicalPlan)new Project((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])aliasArray)), (LogicalPlan)this.table()));
            this.assertNotResolved(parsedPlan);
            this.checkAnalysis(parsedPlan, expectedPlan, this.checkAnalysis$default$3());
            this.assertResolved(expectedPlan);
        }, new Position("DataSourceV2AnalysisSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 431));
        this.test("byName: fail extra data fields", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            TestRelation query = new TestRelation((Seq<AttributeReference>)StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("x", (DataType)FloatType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("y", (DataType)FloatType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("z", (DataType)FloatType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())}))).toAttributes());
            LogicalPlan parsedPlan = this.byName(this.table(), (LogicalPlan)query);
            this.assertNotResolved(parsedPlan);
            this.assertAnalysisError(parsedPlan, (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot write", "'table-name'", "too many data columns", "Table columns: 'x', 'y'", "Data columns: 'x', 'y', 'z'"}))), this.assertAnalysisError$default$3());
        }, new Position("DataSourceV2AnalysisSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 447));
        this.test("byPosition: basic behavior", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            TestRelation query = new TestRelation((Seq<AttributeReference>)StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("a", (DataType)FloatType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("b", (DataType)FloatType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())}))).toAttributes());
            AttributeReference a = (AttributeReference)query.output().head();
            AttributeReference b = (AttributeReference)query.output().last();
            LogicalPlan parsedPlan = this.byPosition(this.table(), (LogicalPlan)query);
            Alias[] aliasArray = new Alias[2];
            Cast x$13 = new Cast((Expression)a, (DataType)FloatType$.MODULE$, (Option)new Some((Object)this.conf().sessionLocalTimeZone()));
            String x$14 = "x";
            ExprId x$15 = Alias$.MODULE$.apply$default$3((Expression)x$13, x$14);
            Seq x$16 = Alias$.MODULE$.apply$default$4((Expression)x$13, x$14);
            Option x$17 = Alias$.MODULE$.apply$default$5((Expression)x$13, x$14);
            Seq x$18 = Alias$.MODULE$.apply$default$6((Expression)x$13, x$14);
            aliasArray[0] = new Alias((Expression)x$13, x$14, x$15, x$16, x$17, x$18);
            Cast x$19 = new Cast((Expression)b, (DataType)FloatType$.MODULE$, (Option)new Some((Object)this.conf().sessionLocalTimeZone()));
            String x$20 = "y";
            ExprId x$21 = Alias$.MODULE$.apply$default$3((Expression)x$19, x$20);
            Seq x$22 = Alias$.MODULE$.apply$default$4((Expression)x$19, x$20);
            Option x$23 = Alias$.MODULE$.apply$default$5((Expression)x$19, x$20);
            Seq x$24 = Alias$.MODULE$.apply$default$6((Expression)x$19, x$20);
            aliasArray[1] = new Alias((Expression)x$19, x$20, x$21, x$22, x$23, x$24);
            LogicalPlan expectedPlan = this.byPosition(this.table(), (LogicalPlan)new Project((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])aliasArray)), (LogicalPlan)query));
            this.assertNotResolved(parsedPlan);
            this.checkAnalysis(parsedPlan, expectedPlan, false);
            this.assertResolved(expectedPlan);
        }, new Position("DataSourceV2AnalysisSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 462));
        this.test("byPosition: data columns are not reordered", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            TestRelation query = new TestRelation((Seq<AttributeReference>)StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("y", (DataType)FloatType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("x", (DataType)FloatType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())}))).toAttributes());
            AttributeReference y = (AttributeReference)query.output().head();
            AttributeReference x = (AttributeReference)query.output().last();
            LogicalPlan parsedPlan = this.byPosition(this.table(), (LogicalPlan)query);
            Alias[] aliasArray = new Alias[2];
            Cast x$25 = new Cast((Expression)y, (DataType)FloatType$.MODULE$, (Option)new Some((Object)this.conf().sessionLocalTimeZone()));
            String x$26 = "x";
            ExprId x$27 = Alias$.MODULE$.apply$default$3((Expression)x$25, x$26);
            Seq x$28 = Alias$.MODULE$.apply$default$4((Expression)x$25, x$26);
            Option x$29 = Alias$.MODULE$.apply$default$5((Expression)x$25, x$26);
            Seq x$30 = Alias$.MODULE$.apply$default$6((Expression)x$25, x$26);
            aliasArray[0] = new Alias((Expression)x$25, x$26, x$27, x$28, x$29, x$30);
            Cast x$31 = new Cast((Expression)x, (DataType)FloatType$.MODULE$, (Option)new Some((Object)this.conf().sessionLocalTimeZone()));
            String x$32 = "y";
            ExprId x$33 = Alias$.MODULE$.apply$default$3((Expression)x$31, x$32);
            Seq x$34 = Alias$.MODULE$.apply$default$4((Expression)x$31, x$32);
            Option x$35 = Alias$.MODULE$.apply$default$5((Expression)x$31, x$32);
            Seq x$36 = Alias$.MODULE$.apply$default$6((Expression)x$31, x$32);
            aliasArray[1] = new Alias((Expression)x$31, x$32, x$33, x$34, x$35, x$36);
            LogicalPlan expectedPlan = this.byPosition(this.table(), (LogicalPlan)new Project((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])aliasArray)), (LogicalPlan)query));
            this.assertNotResolved(parsedPlan);
            this.checkAnalysis(parsedPlan, expectedPlan, this.checkAnalysis$default$3());
            this.assertResolved(expectedPlan);
        }, new Position("DataSourceV2AnalysisSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 482));
        this.test("byPosition: fail nullable data written to required columns", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LogicalPlan parsedPlan = this.byPosition(this.requiredTable(), (LogicalPlan)this.table());
            this.assertNotResolved(parsedPlan);
            this.assertAnalysisError(parsedPlan, (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot write incompatible data to table", "'table-name'", "Cannot write nullable values to non-null column", "'x'", "'y'"}))), this.assertAnalysisError$default$3());
        }, new Position("DataSourceV2AnalysisSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 503));
        this.test("byPosition: allow required data written to nullable columns", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LogicalPlan parsedPlan = this.byPosition(this.table(), (LogicalPlan)this.requiredTable());
            this.assertResolved(parsedPlan);
            this.checkAnalysis(parsedPlan, parsedPlan, this.checkAnalysis$default$3());
        }, new Position("DataSourceV2AnalysisSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 511));
        this.test("byPosition: missing required columns cause failure", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            TestRelation query = new TestRelation((Seq<AttributeReference>)StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("y", (DataType)FloatType$.MODULE$, false, StructField$.MODULE$.apply$default$4())}))).toAttributes());
            LogicalPlan parsedPlan = this.byPosition(this.requiredTable(), (LogicalPlan)query);
            this.assertNotResolved(parsedPlan);
            this.assertAnalysisError(parsedPlan, (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot write", "'table-name'", "not enough data columns", "Table columns: 'x', 'y'", "Data columns: 'y'"}))), this.assertAnalysisError$default$3());
        }, new Position("DataSourceV2AnalysisSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 517));
        this.test("byPosition: missing optional columns cause failure", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            TestRelation query = new TestRelation((Seq<AttributeReference>)StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("y", (DataType)FloatType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())}))).toAttributes());
            LogicalPlan parsedPlan = this.byPosition(this.table(), (LogicalPlan)query);
            this.assertNotResolved(parsedPlan);
            this.assertAnalysisError(parsedPlan, (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot write", "'table-name'", "not enough data columns", "Table columns: 'x', 'y'", "Data columns: 'y'"}))), this.assertAnalysisError$default$3());
        }, new Position("DataSourceV2AnalysisSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 531));
        this.test("byPosition: insert safe cast", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            TestRelation widerTable = new TestRelation((Seq<AttributeReference>)StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("a", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("b", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())}))).toAttributes());
            AttributeReference x = (AttributeReference)this.table().output().head();
            AttributeReference y = (AttributeReference)this.table().output().last();
            LogicalPlan parsedPlan = this.byPosition(widerTable, (LogicalPlan)this.table());
            Alias[] aliasArray = new Alias[2];
            Cast x$37 = new Cast((Expression)x, (DataType)DoubleType$.MODULE$, (Option)new Some((Object)this.conf().sessionLocalTimeZone()));
            String x$38 = "a";
            ExprId x$39 = Alias$.MODULE$.apply$default$3((Expression)x$37, x$38);
            Seq x$40 = Alias$.MODULE$.apply$default$4((Expression)x$37, x$38);
            Option x$41 = Alias$.MODULE$.apply$default$5((Expression)x$37, x$38);
            Seq x$42 = Alias$.MODULE$.apply$default$6((Expression)x$37, x$38);
            aliasArray[0] = new Alias((Expression)x$37, x$38, x$39, x$40, x$41, x$42);
            Cast x$43 = new Cast((Expression)y, (DataType)DoubleType$.MODULE$, (Option)new Some((Object)this.conf().sessionLocalTimeZone()));
            String x$44 = "b";
            ExprId x$45 = Alias$.MODULE$.apply$default$3((Expression)x$43, x$44);
            Seq x$46 = Alias$.MODULE$.apply$default$4((Expression)x$43, x$44);
            Option x$47 = Alias$.MODULE$.apply$default$5((Expression)x$43, x$44);
            Seq x$48 = Alias$.MODULE$.apply$default$6((Expression)x$43, x$44);
            aliasArray[1] = new Alias((Expression)x$43, x$44, x$45, x$46, x$47, x$48);
            LogicalPlan expectedPlan = this.byPosition(widerTable, (LogicalPlan)new Project((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])aliasArray)), (LogicalPlan)this.table()));
            this.assertNotResolved(parsedPlan);
            this.checkAnalysis(parsedPlan, expectedPlan, this.checkAnalysis$default$3());
            this.assertResolved(expectedPlan);
        }, new Position("DataSourceV2AnalysisSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 545));
        this.test("byPosition: fail extra data fields", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            TestRelation query = new TestRelation((Seq<AttributeReference>)StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("a", (DataType)FloatType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("b", (DataType)FloatType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("c", (DataType)FloatType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())}))).toAttributes());
            LogicalPlan parsedPlan = this.byName(this.table(), (LogicalPlan)query);
            this.assertNotResolved(parsedPlan);
            this.assertAnalysisError(parsedPlan, (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot write", "'table-name'", "too many data columns", "Table columns: 'x', 'y'", "Data columns: 'a', 'b', 'c'"}))), this.assertAnalysisError$default$3());
        }, new Position("DataSourceV2AnalysisSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 565));
        this.test("bypass output column resolution", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            TestRelationAcceptAnySchema table = new TestRelationAcceptAnySchema((Seq<AttributeReference>)StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("a", (DataType)FloatType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), new StructField("b", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())}))).toAttributes());
            TestRelation query = new TestRelation((Seq<AttributeReference>)StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("s", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())}))).toAttributes());
            this.withClue("byName", (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                LogicalPlan parsedPlan = this.byName(table, (LogicalPlan)query);
                this.assertResolved(parsedPlan);
                this.checkAnalysis(parsedPlan, parsedPlan, this.checkAnalysis$default$3());
            });
            this.withClue("byPosition", (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                LogicalPlan parsedPlan = this.byPosition(table, (LogicalPlan)query);
                this.assertResolved(parsedPlan);
                this.checkAnalysis(parsedPlan, parsedPlan, this.checkAnalysis$default$3());
            });
        }, new Position("DataSourceV2AnalysisSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 580));
        this.test("check fields of struct type column", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            TestRelation tableWithStructCol = new TestRelation((Seq<AttributeReference>)new StructType().add("col", (DataType)new StructType().add("a", (DataType)IntegerType$.MODULE$).add("b", (DataType)IntegerType$.MODULE$)).toAttributes());
            TestRelation query = new TestRelation((Seq<AttributeReference>)new StructType().add("col", (DataType)new StructType().add("x", (DataType)IntegerType$.MODULE$).add("y", (DataType)IntegerType$.MODULE$)).toAttributes());
            this.withClue("byName", (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                LogicalPlan parsedPlan = this.byName(tableWithStructCol, (LogicalPlan)query);
                this.assertNotResolved(parsedPlan);
                this.assertAnalysisError(parsedPlan, (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot write incompatible data to table", "'table-name'", "Struct 'col' 0-th field name does not match", "expected 'a', found 'x'", "Struct 'col' 1-th field name does not match", "expected 'b', found 'y'"}))), this.assertAnalysisError$default$3());
            });
            this.withClue("byPosition", (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                LogicalPlan parsedPlan = this.byPosition(tableWithStructCol, (LogicalPlan)query);
                this.assertNotResolved(parsedPlan);
                Alias[] aliasArray = new Alias[1];
                Cast x$49 = new Cast((Expression)query.output().head(), (DataType)new StructType().add("a", (DataType)IntegerType$.MODULE$).add("b", (DataType)IntegerType$.MODULE$), (Option)new Some((Object)this.conf().sessionLocalTimeZone()));
                String x$50 = "col";
                ExprId x$51 = Alias$.MODULE$.apply$default$3((Expression)x$49, x$50);
                Seq x$52 = Alias$.MODULE$.apply$default$4((Expression)x$49, x$50);
                Option x$53 = Alias$.MODULE$.apply$default$5((Expression)x$49, x$50);
                Seq x$54 = Alias$.MODULE$.apply$default$6((Expression)x$49, x$50);
                aliasArray[0] = new Alias((Expression)x$49, x$50, x$51, x$52, x$53, x$54);
                Project expectedQuery = new Project((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])aliasArray)), (LogicalPlan)query);
                this.checkAnalysis(parsedPlan, this.byPosition(tableWithStructCol, (LogicalPlan)expectedQuery), this.checkAnalysis$default$3());
            });
        }, new Position("DataSourceV2AnalysisSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 601));
    }
}

