/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst;

import java.io.File;
import java.io.Serializable;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.catalyst.CatalystTypeConverters$;
import org.apache.spark.sql.catalyst.expressions.UnsafeArrayData;
import org.apache.spark.sql.catalyst.plans.SQLHelper;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.unsafe.types.UTF8String;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001Y2A\u0001B\u0003\u0001!!)1\u0004\u0001C\u00019!9q\u0004\u0001b\u0001\n\u0013\u0001\u0003BB\u001b\u0001A\u0003%\u0011EA\u000eDCR\fG._:u)f\u0004XmQ8om\u0016\u0014H/\u001a:t'VLG/\u001a\u0006\u0003\r\u001d\t\u0001bY1uC2L8\u000f\u001e\u0006\u0003\u0011%\t1a]9m\u0015\tQ1\"A\u0003ta\u0006\u00148N\u0003\u0002\r\u001b\u00051\u0011\r]1dQ\u0016T\u0011AD\u0001\u0004_J<7\u0001A\n\u0004\u0001E)\u0002C\u0001\n\u0014\u001b\u0005I\u0011B\u0001\u000b\n\u00055\u0019\u0006/\u0019:l\rVt7+^5uKB\u0011a#G\u0007\u0002/)\u0011\u0001$B\u0001\u0006a2\fgn]\u0005\u00035]\u0011\u0011bU)M\u0011\u0016d\u0007/\u001a:\u0002\rqJg.\u001b;?)\u0005i\u0002C\u0001\u0010\u0001\u001b\u0005)\u0011aC:j[BdW\rV=qKN,\u0012!\t\t\u0004E1zcBA\u0012*\u001d\t!s%D\u0001&\u0015\t1s\"\u0001\u0004=e>|GOP\u0005\u0002Q\u0005)1oY1mC&\u0011!fK\u0001\ba\u0006\u001c7.Y4f\u0015\u0005A\u0013BA\u0017/\u0005\r\u0019V-\u001d\u0006\u0003U-\u0002\"\u0001M\u001a\u000e\u0003ER!AM\u0004\u0002\u000bQL\b/Z:\n\u0005Q\n$\u0001\u0003#bi\u0006$\u0016\u0010]3\u0002\u0019MLW\u000e\u001d7f)f\u0004Xm\u001d\u0011")
public class CatalystTypeConvertersSuite
extends SparkFunSuite
implements SQLHelper {
    private final Seq<DataType> simpleTypes;
    private String sparkHome;
    private volatile boolean bitmap$0;

    @Override
    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        SQLHelper.withSQLConf$(this, pairs, f);
    }

    @Override
    public void withTempPath(Function1<File, BoxedUnit> f) {
        SQLHelper.withTempPath$(this, f);
    }

    @Override
    public <T> void testSpecialDatetimeValues(Function1<ZoneId, T> test) {
        SQLHelper.testSpecialDatetimeValues$(this, test);
    }

    private String sparkHome$lzycompute() {
        CatalystTypeConvertersSuite catalystTypeConvertersSuite = this;
        synchronized (catalystTypeConvertersSuite) {
            if (!this.bitmap$0) {
                this.sparkHome = SQLHelper.sparkHome$(this);
                this.bitmap$0 = true;
            }
        }
        return this.sparkHome;
    }

    @Override
    public String sparkHome() {
        return !this.bitmap$0 ? this.sparkHome$lzycompute() : this.sparkHome;
    }

    private Seq<DataType> simpleTypes() {
        return this.simpleTypes;
    }

    public static final /* synthetic */ Assertion $anonfun$new$26(CatalystTypeConvertersSuite $this, long us) {
        Instant instant = DateTimeUtils$.MODULE$.microsToInstant(us);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(CatalystTypeConverters$.MODULE$.createToScalaConverter((DataType)TimestampType$.MODULE$).apply((Object)BoxesRunTime.boxToLong((long)us)));
        Instant $org_scalatest_assert_macro_right = instant;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalystTypeConvertersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 187));
    }

    public static final /* synthetic */ Assertion $anonfun$new$31(CatalystTypeConvertersSuite $this, int days) {
        LocalDate localDate = DateTimeUtils$.MODULE$.daysToLocalDate(days);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(CatalystTypeConverters$.MODULE$.createToScalaConverter((DataType)DateType$.MODULE$).apply((Object)BoxesRunTime.boxToInteger((int)days)));
        LocalDate $org_scalatest_assert_macro_right = localDate;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalystTypeConvertersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 222));
    }

    public CatalystTypeConvertersSuite() {
        SQLHelper.$init$(this);
        this.simpleTypes = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AtomicType[]{StringType$.MODULE$, DateType$.MODULE$, BooleanType$.MODULE$, ByteType$.MODULE$, ShortType$.MODULE$, IntegerType$.MODULE$, LongType$.MODULE$, FloatType$.MODULE$, DoubleType$.MODULE$, DecimalType$.MODULE$.SYSTEM_DEFAULT(), DecimalType$.MODULE$.USER_DEFAULT()}));
        this.test("null handling in rows", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            StructType schema = StructType$.MODULE$.apply((Seq)this.simpleTypes().map((Function1 & Serializable & scala.Serializable)t -> new StructField(t.getClass().getName(), t, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), Seq$.MODULE$.canBuildFrom()));
            Function1 convertToCatalyst = CatalystTypeConverters$.MODULE$.createToCatalystConverter((DataType)schema);
            Function1 convertToScala = CatalystTypeConverters$.MODULE$.createToScalaConverter((DataType)schema);
            Row scalaRow = Row$.MODULE$.fromSeq((Seq)Seq$.MODULE$.fill(this.simpleTypes().length(), (Function0 & Serializable & scala.Serializable)() -> null));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(convertToScala.apply(convertToCatalyst.apply((Object)scalaRow)));
            Row $org_scalatest_assert_macro_right = scalaRow;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalystTypeConvertersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 52));
        }, new Position("CatalystTypeConvertersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 46));
        this.test("null handling for individual values", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.simpleTypes().foreach((Function1 & Serializable & scala.Serializable)dataType -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(CatalystTypeConverters$.MODULE$.createToScalaConverter(dataType).apply(null));
            Null$ $org_scalatest_assert_macro_right = null;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", null, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalystTypeConvertersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 57));
        }), new Position("CatalystTypeConvertersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 55));
        this.test("option handling in convertToCatalyst", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(CatalystTypeConverters$.MODULE$.convertToCatalyst((Object)new Some((Object)BoxesRunTime.boxToInteger((int)123))));
            Some $org_scalatest_assert_macro_right = new Some((Object)BoxesRunTime.boxToInteger((int)123));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalystTypeConvertersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 65));
        }, new Position("CatalystTypeConvertersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 61));
        this.test("option handling in createToCatalystConverter", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(CatalystTypeConverters$.MODULE$.createToCatalystConverter((DataType)IntegerType$.MODULE$).apply((Object)new Some((Object)BoxesRunTime.boxToInteger((int)123))));
            int $org_scalatest_assert_macro_right = 123;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalystTypeConvertersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 69));
        }, new Position("CatalystTypeConvertersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 68));
        this.test("primitive array handling", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            int[] intArray = new int[]{1, 100, 10000};
            UnsafeArrayData intUnsafeArray = UnsafeArrayData.fromPrimitiveArray((int[])intArray);
            ArrayType intArrayType = new ArrayType((DataType)IntegerType$.MODULE$, false);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(CatalystTypeConverters$.MODULE$.createToScalaConverter((DataType)intArrayType).apply((Object)intUnsafeArray));
            int[] $org_scalatest_assert_macro_right = intArray;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalystTypeConvertersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 76));
            double[] doubleArray = new double[]{1.1, 111.1, 11111.1};
            UnsafeArrayData doubleUnsafeArray = UnsafeArrayData.fromPrimitiveArray((double[])doubleArray);
            ArrayType doubleArrayType = new ArrayType((DataType)DoubleType$.MODULE$, false);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(CatalystTypeConverters$.MODULE$.createToScalaConverter((DataType)doubleArrayType).apply((Object)doubleUnsafeArray));
            double[] $org_scalatest_assert_macro_right2 = doubleArray;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalystTypeConvertersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 81));
        }, new Position("CatalystTypeConvertersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 72));
        this.test("An array with null handling", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Object[] intArray = (Object[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), null, BoxesRunTime.boxToInteger((int)100), null, BoxesRunTime.boxToInteger((int)10000)}), ClassTag$.MODULE$.Any());
            GenericArrayData intGenericArray = new GenericArrayData(intArray);
            ArrayType intArrayType = new ArrayType((DataType)IntegerType$.MODULE$, true);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(CatalystTypeConverters$.MODULE$.createToScalaConverter((DataType)intArrayType).apply((Object)intGenericArray));
            Object[] $org_scalatest_assert_macro_right = intArray;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalystTypeConvertersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 89));
            Object $org_scalatest_assert_macro_left2 = CatalystTypeConverters$.MODULE$.createToCatalystConverter((DataType)intArrayType).apply((Object)intArray);
            GenericArrayData $org_scalatest_assert_macro_right2 = intGenericArray;
            Object object = $org_scalatest_assert_macro_left2;
            GenericArrayData genericArrayData = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(object != null ? !object.equals(genericArrayData) : genericArrayData != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalystTypeConvertersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 91));
            Object[] doubleArray = (Object[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)1.1), null, BoxesRunTime.boxToDouble((double)111.1), null, BoxesRunTime.boxToDouble((double)11111.1)}), ClassTag$.MODULE$.Any());
            GenericArrayData doubleGenericArray = new GenericArrayData(doubleArray);
            ArrayType doubleArrayType = new ArrayType((DataType)DoubleType$.MODULE$, true);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(CatalystTypeConverters$.MODULE$.createToScalaConverter((DataType)doubleArrayType).apply((Object)doubleGenericArray));
            Object[] $org_scalatest_assert_macro_right3 = doubleArray;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalystTypeConvertersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 97));
            Object $org_scalatest_assert_macro_left4 = CatalystTypeConverters$.MODULE$.createToCatalystConverter((DataType)doubleArrayType).apply((Object)doubleArray);
            GenericArrayData $org_scalatest_assert_macro_right4 = doubleGenericArray;
            Object object2 = $org_scalatest_assert_macro_left4;
            GenericArrayData genericArrayData2 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(object2 != null ? !object2.equals(genericArrayData2) : genericArrayData2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalystTypeConvertersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 99));
        }, new Position("CatalystTypeConvertersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 85));
        this.test("converting a wrong value to the struct type", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            StructType structType = new StructType().add("f1", (DataType)IntegerType$.MODULE$);
            IllegalArgumentException exception = (IllegalArgumentException)this.intercept((Function0 & Serializable & scala.Serializable)() -> CatalystTypeConverters$.MODULE$.createToCatalystConverter((DataType)structType).apply((Object)"test"), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("CatalystTypeConvertersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 105));
            String $org_scalatest_assert_macro_left = exception.getMessage();
            String $org_scalatest_assert_macro_right = "The value (test) of the type (java.lang.String) cannot be converted to struct<f1:int>";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalystTypeConvertersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 108));
        }, new Position("CatalystTypeConvertersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 103));
        this.test("converting a wrong value to the map type", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            MapType mapType = new MapType((DataType)StringType$.MODULE$, (DataType)IntegerType$.MODULE$, false);
            IllegalArgumentException exception = (IllegalArgumentException)this.intercept((Function0 & Serializable & scala.Serializable)() -> CatalystTypeConverters$.MODULE$.createToCatalystConverter((DataType)mapType).apply((Object)"test"), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("CatalystTypeConvertersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 114));
            String $org_scalatest_assert_macro_left = exception.getMessage();
            String $org_scalatest_assert_macro_right = "The value (test) of the type (java.lang.String) cannot be converted to a map type with key type (string) and value type (int)";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalystTypeConvertersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 117));
        }, new Position("CatalystTypeConvertersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 112));
        this.test("converting a wrong value to the array type", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            ArrayType arrayType = new ArrayType((DataType)IntegerType$.MODULE$, true);
            IllegalArgumentException exception = (IllegalArgumentException)this.intercept((Function0 & Serializable & scala.Serializable)() -> CatalystTypeConverters$.MODULE$.createToCatalystConverter((DataType)arrayType).apply((Object)"test"), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("CatalystTypeConvertersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 124));
            String $org_scalatest_assert_macro_left = exception.getMessage();
            String $org_scalatest_assert_macro_right = "The value (test) of the type (java.lang.String) cannot be converted to an array of int";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalystTypeConvertersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 127));
        }, new Position("CatalystTypeConvertersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 122));
        this.test("converting a wrong value to the decimal type", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            DecimalType decimalType = new DecimalType(10, 0);
            IllegalArgumentException exception = (IllegalArgumentException)this.intercept((Function0 & Serializable & scala.Serializable)() -> CatalystTypeConverters$.MODULE$.createToCatalystConverter((DataType)decimalType).apply((Object)"test"), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("CatalystTypeConvertersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 133));
            String $org_scalatest_assert_macro_left = exception.getMessage();
            String $org_scalatest_assert_macro_right = "The value (test) of the type (java.lang.String) cannot be converted to decimal(10,0)";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalystTypeConvertersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 136));
        }, new Position("CatalystTypeConvertersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 131));
        this.test("converting a wrong value to the string type", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            IllegalArgumentException exception = (IllegalArgumentException)this.intercept((Function0 & Serializable & scala.Serializable)() -> CatalystTypeConverters$.MODULE$.createToCatalystConverter((DataType)StringType$.MODULE$).apply((Object)BoxesRunTime.boxToDouble((double)0.1)), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("CatalystTypeConvertersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 141));
            String $org_scalatest_assert_macro_left = exception.getMessage();
            String $org_scalatest_assert_macro_right = "The value (0.1) of the type (java.lang.Double) cannot be converted to the string type";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalystTypeConvertersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 144));
        }, new Position("CatalystTypeConvertersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 140));
        this.test("SPARK-24571: convert Char to String", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            char chr = 'X';
            Function1 converter = CatalystTypeConverters$.MODULE$.createToCatalystConverter((DataType)StringType$.MODULE$);
            UTF8String expected = UTF8String.fromString((String)"X");
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(converter.apply((Object)BoxesRunTime.boxToCharacter((char)chr)));
            UTF8String $org_scalatest_assert_macro_right = expected;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalystTypeConvertersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 152));
        }, new Position("CatalystTypeConvertersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 148));
        this.test("SPARK-33390: Make Literal support char array", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            char[] ac = new char[]{'a', 'c'};
            Function1 converter = CatalystTypeConverters$.MODULE$.createToCatalystConverter((DataType)StringType$.MODULE$);
            UTF8String expected = UTF8String.fromString((String)String.valueOf(ac));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(converter.apply((Object)ac));
            UTF8String $org_scalatest_assert_macro_right = expected;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalystTypeConvertersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 159));
        }, new Position("CatalystTypeConvertersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 155));
        this.test("converting java.time.Instant to TimestampType", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0101-02-16T10:11:32Z", "1582-10-02T01:02:03.04Z", "1582-12-31T23:59:59.999999Z", "1970-01-01T00:00:01.123Z", "1972-12-31T23:59:59.123456Z", "2019-02-16T18:12:30Z", "2119-03-16T19:13:31Z"}))).foreach((Function1 & Serializable & scala.Serializable)timestamp -> {
            Instant input = Instant.parse(timestamp);
            Object result = CatalystTypeConverters$.MODULE$.convertToCatalyst((Object)input);
            long expected = DateTimeUtils$.MODULE$.instantToMicros(input);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(result);
            long $org_scalatest_assert_macro_right = expected;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalystTypeConvertersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 174));
        }), new Position("CatalystTypeConvertersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 162));
        this.test("converting TimestampType to java.time.Instant", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.DATETIME_JAVA8API_ENABLED().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{-9463427405253013L, -244000001L, 0L, 99628200102030L, 1543749753123456L}))).foreach((Function1 & Serializable & scala.Serializable)us -> CatalystTypeConvertersSuite.$anonfun$new$26(this, BoxesRunTime.unboxToLong((Object)us)))), new Position("CatalystTypeConvertersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 178));
        this.test("converting java.time.LocalDate to DateType", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0101-02-16", "1582-10-02", "1582-12-31", "1970-01-01", "1972-12-31", "2019-02-16", "2119-03-16"}))).foreach((Function1 & Serializable & scala.Serializable)timestamp -> {
            LocalDate input = LocalDate.parse(timestamp);
            Object result = CatalystTypeConverters$.MODULE$.convertToCatalyst((Object)input);
            int expected = DateTimeUtils$.MODULE$.localDateToDays(input);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(result);
            int $org_scalatest_assert_macro_right = expected;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalystTypeConvertersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 204));
        }), new Position("CatalystTypeConvertersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 192));
        this.test("converting DateType to java.time.LocalDate", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.DATETIME_JAVA8API_ENABLED().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{-701265, -371419, -199722, -1, 0, 967, 2094, 17877, 24837, 1110657}))).foreach((Function1 & Serializable & scala.Serializable)days -> CatalystTypeConvertersSuite.$anonfun$new$31(this, BoxesRunTime.unboxToInt((Object)days)))), new Position("CatalystTypeConvertersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 208));
    }
}

