/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.xml;

import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.xml.XPathExtract;
import org.apache.spark.sql.catalyst.expressions.xml.XPathList$;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import org.w3c.dom.NodeList;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(xml, xpath) - Returns a string array of values within the nodes of xml that match the XPath expression.", examples="\n    Examples:\n      > SELECT _FUNC_('<a><b>b1</b><b>b2</b><b>b3</b><c>c1</c><c>c2</c></a>','a/b/text()');\n       ['b1','b2','b3']\n  ")
@ScalaSignature(bytes="\u0006\u0001\u0005md\u0001B\r\u001b\u0001&B\u0001b\u0007\u0001\u0003\u0016\u0004%\ta\u000e\u0005\ty\u0001\u0011\t\u0012)A\u0005q!AQ\b\u0001BK\u0002\u0013\u0005q\u0007\u0003\u0005?\u0001\tE\t\u0015!\u00039\u0011\u0015y\u0004\u0001\"\u0001A\u0011\u0015!\u0005\u0001\"\u0011F\u0011\u0015\t\u0006\u0001\"\u0011S\u0011\u0015I\u0006\u0001\"\u0011[\u0011\u001d\u0001\u0007!!A\u0005\u0002\u0005Dq\u0001\u001a\u0001\u0012\u0002\u0013\u0005Q\rC\u0004q\u0001E\u0005I\u0011A3\t\u000fE\u0004\u0011\u0011!C!e\"9!\u0010AA\u0001\n\u0003Y\b\u0002C@\u0001\u0003\u0003%\t!!\u0001\t\u0013\u0005\u001d\u0001!!A\u0005B\u0005%\u0001\"CA\f\u0001\u0005\u0005I\u0011AA\r\u0011%\t\u0019\u0003AA\u0001\n\u0003\n)cB\u0005\u0002>i\t\t\u0011#\u0001\u0002@\u0019A\u0011DGA\u0001\u0012\u0003\t\t\u0005\u0003\u0004@'\u0011\u0005\u0011q\n\u0005\n\u0003#\u001a\u0012\u0011!C#\u0003'B\u0011\"!\u0016\u0014\u0003\u0003%\t)a\u0016\t\u0013\u0005u3#!A\u0005\u0002\u0006}\u0003\"CA9'\u0005\u0005I\u0011BA:\u0005%A\u0006+\u0019;i\u0019&\u001cHO\u0003\u0002\u001c9\u0005\u0019\u00010\u001c7\u000b\u0005uq\u0012aC3yaJ,7o]5p]NT!a\b\u0011\u0002\u0011\r\fG/\u00197zgRT!!\t\u0012\u0002\u0007M\fHN\u0003\u0002$I\u0005)1\u000f]1sW*\u0011QEJ\u0001\u0007CB\f7\r[3\u000b\u0003\u001d\n1a\u001c:h\u0007\u0001\u0019B\u0001\u0001\u0016/iA\u00111\u0006L\u0007\u00025%\u0011QF\u0007\u0002\r1B\u000bG\u000f[#yiJ\f7\r\u001e\t\u0003_Ij\u0011\u0001\r\u0006\u0002c\u0005)1oY1mC&\u00111\u0007\r\u0002\b!J|G-^2u!\tyS'\u0003\u00027a\ta1+\u001a:jC2L'0\u00192mKV\t\u0001\b\u0005\u0002:u5\tA$\u0003\u0002<9\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\u0002\talG\u000eI\u0001\u0005a\u0006$\b.A\u0003qCRD\u0007%\u0001\u0004=S:LGO\u0010\u000b\u0004\u0003\n\u001b\u0005CA\u0016\u0001\u0011\u0015YR\u00011\u00019\u0011\u0015iT\u00011\u00019\u0003)\u0001(/\u001a;us:\u000bW.Z\u000b\u0002\rB\u0011qI\u0014\b\u0003\u00112\u0003\"!\u0013\u0019\u000e\u0003)S!a\u0013\u0015\u0002\rq\u0012xn\u001c;?\u0013\ti\u0005'\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u001fB\u0013aa\u0015;sS:<'BA'1\u0003!!\u0017\r^1UsB,W#A*\u0011\u0005Q;V\"A+\u000b\u0005Y\u0003\u0013!\u0002;za\u0016\u001c\u0018B\u0001-V\u0005!!\u0015\r^1UsB,\u0017\u0001\u00048vY2\u001c\u0016MZ3Fm\u0006dGcA._?B\u0011q\u0006X\u0005\u0003;B\u00121!\u00118z\u0011\u0015Y\u0002\u00021\u0001\\\u0011\u0015i\u0004\u00021\u0001\\\u0003\u0011\u0019w\u000e]=\u0015\u0007\u0005\u00137\rC\u0004\u001c\u0013A\u0005\t\u0019\u0001\u001d\t\u000fuJ\u0001\u0013!a\u0001q\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\nT#\u00014+\u0005a:7&\u00015\u0011\u0005%tW\"\u00016\u000b\u0005-d\u0017!C;oG\",7m[3e\u0015\ti\u0007'\u0001\u0006b]:|G/\u0019;j_:L!a\u001c6\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\u0005\u0019\bC\u0001;z\u001b\u0005)(B\u0001<x\u0003\u0011a\u0017M\\4\u000b\u0003a\fAA[1wC&\u0011q*^\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0002yB\u0011q&`\u0005\u0003}B\u00121!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$2aWA\u0002\u0011!\t)ADA\u0001\u0002\u0004a\u0018a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002\fA)\u0011QBA\n76\u0011\u0011q\u0002\u0006\u0004\u0003#\u0001\u0014AC2pY2,7\r^5p]&!\u0011QCA\b\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005m\u0011\u0011\u0005\t\u0004_\u0005u\u0011bAA\u0010a\t9!i\\8mK\u0006t\u0007\u0002CA\u0003!\u0005\u0005\t\u0019A.\u0002\r\u0015\fX/\u00197t)\u0011\tY\"a\n\t\u0011\u0005\u0015\u0011#!AA\u0002mC3\u0002AA\u0016\u0003c\t\u0019$a\u000e\u0002:A\u0019\u0011(!\f\n\u0007\u0005=BDA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\u0005U\u0012A\\0G+:\u001bu\f\u000b=nY2\u0002\u0003\u0010]1uQ&\u0002S\u0006\t*fiV\u0014hn\u001d\u0011bAM$(/\u001b8hA\u0005\u0014(/Y=!_\u001a\u0004c/\u00197vKN\u0004s/\u001b;iS:\u0004C\u000f[3!]>$Wm\u001d\u0011pM\u0002BX\u000e\u001c\u0011uQ\u0006$\b%\\1uG\"\u0004C\u000f[3!1B\u000bG\u000f\u001b\u0011fqB\u0014Xm]:j_:t\u0013\u0001C3yC6\u0004H.Z:\"\u0005\u0005m\u0012!a\u0003\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u001db\u0014M\u0010\u001fc}\t\fDh\f2?y\tt$M\r\u001f0Ezb$M\u001024y=\u0012g\bP2?GFbtf\u0019 =Gz\u001a'\u0007P\u0018d}qz\u0013MP\u0014-O\u0005|#m\f;fqRD\u0013fJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!Am;#-M\u0014-O\t\u0014t\u0005L\u0014cg\u001dj&\u0002\t\u0011\u0002\u0013a\u0003\u0016\r\u001e5MSN$\bCA\u0016\u0014'\u0011\u0019\u00121\t\u001b\u0011\u000f\u0005\u0015\u00131\n\u001d9\u00036\u0011\u0011q\t\u0006\u0004\u0003\u0013\u0002\u0014a\u0002:v]RLW.Z\u0005\u0005\u0003\u001b\n9EA\tBEN$(/Y2u\rVt7\r^5p]J\"\"!a\u0010\u0002\u0011Q|7\u000b\u001e:j]\u001e$\u0012a]\u0001\u0006CB\u0004H.\u001f\u000b\u0006\u0003\u0006e\u00131\f\u0005\u00067Y\u0001\r\u0001\u000f\u0005\u0006{Y\u0001\r\u0001O\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\t\t'!\u001c\u0011\u000b=\n\u0019'a\u001a\n\u0007\u0005\u0015\u0004G\u0001\u0004PaRLwN\u001c\t\u0006_\u0005%\u0004\bO\u0005\u0004\u0003W\u0002$A\u0002+va2,'\u0007\u0003\u0005\u0002p]\t\t\u00111\u0001B\u0003\rAH\u0005M\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002vA\u0019A/a\u001e\n\u0007\u0005eTO\u0001\u0004PE*,7\r\u001e")
public class XPathList
extends XPathExtract
implements Serializable {
    private final Expression xml;
    private final Expression path;

    public static Option<Tuple2<Expression, Expression>> unapply(XPathList xPathList) {
        return XPathList$.MODULE$.unapply(xPathList);
    }

    public static Function1<Tuple2<Expression, Expression>, XPathList> tupled() {
        return XPathList$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, XPathList>> curried() {
        return XPathList$.MODULE$.curried();
    }

    @Override
    public Expression xml() {
        return this.xml;
    }

    @Override
    public Expression path() {
        return this.path;
    }

    @Override
    public String prettyName() {
        return "xpath";
    }

    @Override
    public DataType dataType() {
        return new ArrayType(StringType$.MODULE$, false);
    }

    @Override
    public Object nullSafeEval(Object xml, Object path) {
        GenericArrayData genericArrayData;
        NodeList nodeList = this.xpathUtil().evalNodeList(((UTF8String)xml).toString(), this.pathString());
        if (nodeList != null) {
            UTF8String[] ret = new UTF8String[nodeList.getLength()];
            for (int i = 0; i < nodeList.getLength(); ++i) {
                ret[i] = UTF8String.fromString((String)nodeList.item(i).getNodeValue());
            }
            genericArrayData = new GenericArrayData((Object)ret);
        } else {
            genericArrayData = null;
        }
        return genericArrayData;
    }

    public XPathList copy(Expression xml, Expression path) {
        return new XPathList(xml, path);
    }

    public Expression copy$default$1() {
        return this.xml();
    }

    public Expression copy$default$2() {
        return this.path();
    }

    @Override
    public String productPrefix() {
        return "XPathList";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.xml();
                break;
            }
            case 1: {
                expression = this.path();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof XPathList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof XPathList)) return false;
        boolean bl = true;
        if (!bl) return false;
        XPathList xPathList = (XPathList)x$1;
        Expression expression = this.xml();
        Expression expression2 = xPathList.xml();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.path();
        Expression expression4 = xPathList.path();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!xPathList.canEqual(this)) return false;
        return true;
    }

    public XPathList(Expression xml, Expression path) {
        this.xml = xml;
        this.path = path;
    }
}

