/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.aggregate;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import org.apache.spark.SparkException;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection$;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.catalyst.expressions.aggregate.Percentile$;
import org.apache.spark.sql.catalyst.expressions.aggregate.TypedImperativeAggregate;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.IntegralType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.NumericType;
import org.apache.spark.sql.types.NumericType$;
import org.apache.spark.util.collection.OpenHashMap;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple5;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichDouble$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ExpressionDescription(usage="\n      _FUNC_(col, percentage [, frequency]) - Returns the exact percentile value of numeric column\n       `col` at the given percentage. The value of percentage must be between 0.0 and 1.0. The\n       value of frequency should be positive integral\n\n      _FUNC_(col, array(percentage1 [, percentage2]...) [, frequency]) - Returns the exact\n      percentile value array of numeric column `col` at the given percentage(s). Each value\n      of the percentage array must be between 0.0 and 1.0. The value of frequency should be\n      positive integral\n\n      ")
@ScalaSignature(bytes="\u0006\u0001\t]h\u0001\u0002\u001e<\u0001*C\u0001B\u001b\u0001\u0003\u0016\u0004%\ta\u001b\u0005\t_\u0002\u0011\t\u0012)A\u0005Y\"A\u0001\u000f\u0001BK\u0002\u0013\u00051\u000e\u0003\u0005r\u0001\tE\t\u0015!\u0003m\u0011!\u0011\bA!f\u0001\n\u0003Y\u0007\u0002C:\u0001\u0005#\u0005\u000b\u0011\u00027\t\u0011Q\u0004!Q3A\u0005\u0002UD\u0001\"\u001f\u0001\u0003\u0012\u0003\u0006IA\u001e\u0005\tu\u0002\u0011)\u001a!C\u0001k\"A1\u0010\u0001B\tB\u0003%a\u000fC\u0003}\u0001\u0011\u0005Q\u0010\u0003\u0004}\u0001\u0011\u0005\u0011\u0011\u0002\u0005\u0007y\u0002!\t!a\u0004\t\u000f\u0005e\u0001\u0001\"\u0011\u0002\u001c!9\u00111\u0007\u0001\u0005B\u0005U\u0002bBA\u001e\u0001\u0011\u0005\u0013Q\b\u0005\u000b\u0003\u0007\u0002\u0001R1A\u0005\n\u0005\u0015\u0003BCA+\u0001!\u0015\r\u0011\"\u0003\u0002X!9\u00111\u000e\u0001\u0005B\u00055\u0004bBA@\u0001\u0011\u0005\u0013Q\t\u0005\u000b\u0003\u0003\u0003\u0001R1A\u0005B\u0005\r\u0005bBAI\u0001\u0011\u0005\u00131\u0013\u0005\b\u0003;\u0003A\u0011IAP\u0011\u001d\ti\u000b\u0001C\u0005\u0003_Cq!a/\u0001\t\u0003\ni\fC\u0004\u0002@\u0002!\t%!1\t\u000f\u0005M\u0007\u0001\"\u0011\u0002V\"9\u0011Q\u001c\u0001\u0005B\u0005}\u0007bBAr\u0001\u0011%\u0011Q\u001d\u0005\b\u0003W\u0004A\u0011BAw\u0011\u001d\t\u0019\u0010\u0001C\u0005\u0003kDqAa\u0002\u0001\t\u0013\u0011I\u0001C\u0004\u0003\"\u0001!\tEa\t\t\u000f\tE\u0002\u0001\"\u0011\u00034!I!\u0011\b\u0001\u0002\u0002\u0013\u0005!1\b\u0005\n\u0005\u000f\u0002\u0011\u0013!C\u0001\u0005\u0013B\u0011Ba\u0018\u0001#\u0003%\tA!\u0013\t\u0013\t\u0005\u0004!%A\u0005\u0002\t%\u0003\"\u0003B2\u0001E\u0005I\u0011\u0001B3\u0011%\u0011I\u0007AI\u0001\n\u0003\u0011)\u0007C\u0005\u0003l\u0001\t\t\u0011\"\u0011\u0003n!A!Q\u0010\u0001\u0002\u0002\u0013\u0005Q\u000fC\u0005\u0003\u0000\u0001\t\t\u0011\"\u0001\u0003\u0002\"I!q\u0011\u0001\u0002\u0002\u0013\u0005#\u0011\u0012\u0005\n\u0005#\u0003\u0011\u0011!C\u0001\u0005'C\u0011Ba&\u0001\u0003\u0003%\tE!'\b\u0013\t-6(!A\t\u0002\t5f\u0001\u0003\u001e<\u0003\u0003E\tAa,\t\rq\u0004D\u0011\u0001B_\u0011%\u0011y\fMA\u0001\n\u000b\u0012\t\rC\u0005\u0003DB\n\t\u0011\"!\u0003F\"I!\u0011\u001b\u0019\u0012\u0002\u0013\u0005!Q\r\u0005\n\u0005'\u0004\u0014\u0013!C\u0001\u0005KB\u0011B!61\u0003\u0003%\tIa6\t\u0013\t%\b'%A\u0005\u0002\t\u0015\u0004\"\u0003BvaE\u0005I\u0011\u0001B3\u0011%\u0011i\u000fMA\u0001\n\u0013\u0011yO\u0001\u0006QKJ\u001cWM\u001c;jY\u0016T!\u0001P\u001f\u0002\u0013\u0005<wM]3hCR,'B\u0001 @\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005\u0001\u000b\u0015\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005\t\u001b\u0015aA:rY*\u0011A)R\u0001\u0006gB\f'o\u001b\u0006\u0003\r\u001e\u000ba!\u00199bG\",'\"\u0001%\u0002\u0007=\u0014xm\u0001\u0001\u0014\u000b\u0001Y\u0005\rZ4\u0011\u00071ku*D\u0001<\u0013\tq5H\u0001\rUsB,G-S7qKJ\fG/\u001b<f\u0003\u001e<'/Z4bi\u0016\u0004B\u0001U+X;6\t\u0011K\u0003\u0002S'\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\u000b\u0005Q\u001b\u0015\u0001B;uS2L!AV)\u0003\u0017=\u0003XM\u001c%bg\"l\u0015\r\u001d\t\u00031nk\u0011!\u0017\u0006\u00025\u0006)1oY1mC&\u0011A,\u0017\u0002\u0007\u0003:L(+\u001a4\u0011\u0005as\u0016BA0Z\u0005\u0011auN\\4\u0011\u0005\u0005\u0014W\"A\u001f\n\u0005\rl$AF%na2L7-\u001b;DCN$\u0018J\u001c9viRK\b/Z:\u0011\u0005a+\u0017B\u00014Z\u0005\u001d\u0001&o\u001c3vGR\u0004\"\u0001\u00175\n\u0005%L&\u0001D*fe&\fG.\u001b>bE2,\u0017!B2iS2$W#\u00017\u0011\u0005\u0005l\u0017B\u00018>\u0005))\u0005\u0010\u001d:fgNLwN\\\u0001\u0007G\"LG\u000e\u001a\u0011\u0002)A,'oY3oi\u0006<W-\u0012=qe\u0016\u001c8/[8o\u0003U\u0001XM]2f]R\fw-Z#yaJ,7o]5p]\u0002\n1C\u001a:fcV,gnY=FqB\u0014Xm]:j_:\fAC\u001a:fcV,gnY=FqB\u0014Xm]:j_:\u0004\u0013AF7vi\u0006\u0014G.Z!hO\n+hMZ3s\u001f\u001a47/\u001a;\u0016\u0003Y\u0004\"\u0001W<\n\u0005aL&aA%oi\u00069R.\u001e;bE2,\u0017iZ4Ck\u001a4WM](gMN,G\u000fI\u0001\u0015S:\u0004X\u000f^!hO\n+hMZ3s\u001f\u001a47/\u001a;\u0002+%t\u0007/\u001e;BO\u001e\u0014UO\u001a4fe>3gm]3uA\u00051A(\u001b8jiz\"\"B`@\u0002\u0002\u0005\r\u0011QAA\u0004!\ta\u0005\u0001C\u0003k\u0017\u0001\u0007A\u000eC\u0003q\u0017\u0001\u0007A\u000eC\u0003s\u0017\u0001\u0007A\u000eC\u0004u\u0017A\u0005\t\u0019\u0001<\t\u000fi\\\u0001\u0013!a\u0001mR)a0a\u0003\u0002\u000e!)!\u000e\u0004a\u0001Y\")\u0001\u000f\u0004a\u0001YR9a0!\u0005\u0002\u0014\u0005U\u0001\"\u00026\u000e\u0001\u0004a\u0007\"\u00029\u000e\u0001\u0004a\u0007BBA\f\u001b\u0001\u0007A.A\u0005ge\u0016\fX/\u001a8ds\u0006Q\u0001O]3uift\u0015-\\3\u0016\u0005\u0005u\u0001\u0003BA\u0010\u0003[qA!!\t\u0002*A\u0019\u00111E-\u000e\u0005\u0005\u0015\"bAA\u0014\u0013\u00061AH]8pizJ1!a\u000bZ\u0003\u0019\u0001&/\u001a3fM&!\u0011qFA\u0019\u0005\u0019\u0019FO]5oO*\u0019\u00111F-\u0002;]LG\u000f\u001b(fo6+H/\u00192mK\u0006;wMQ;gM\u0016\u0014xJ\u001a4tKR$2A`A\u001c\u0011\u0019\tId\u0004a\u0001m\u0006Ib.Z<NkR\f'\r\\3BO\u001e\u0014UO\u001a4fe>3gm]3u\u0003m9\u0018\u000e\u001e5OK^Le\u000e];u\u0003\u001e<')\u001e4gKJ|eMZ:fiR\u0019a0a\u0010\t\r\u0005\u0005\u0003\u00031\u0001w\u0003]qWm^%oaV$\u0018iZ4Ck\u001a4WM](gMN,G/A\u000bsKR,(O\u001c)fe\u000e,g\u000e^5mK\u0006\u0013(/Y=\u0016\u0005\u0005\u001d\u0003c\u0001-\u0002J%\u0019\u00111J-\u0003\u000f\t{w\u000e\\3b]\"\u001a\u0011#a\u0014\u0011\u0007a\u000b\t&C\u0002\u0002Te\u0013\u0011\u0002\u001e:b]NLWM\u001c;\u0002\u0017A,'oY3oi\u0006<Wm]\u000b\u0003\u00033\u0002b!a\u0017\u0002`\u0005\rTBAA/\u0015\t\u0011\u0016,\u0003\u0003\u0002b\u0005u#aA*fcB\u0019\u0001,!\u001a\n\u0007\u0005\u001d\u0014L\u0001\u0004E_V\u0014G.\u001a\u0015\u0004%\u0005=\u0013\u0001C2iS2$'/\u001a8\u0016\u0005\u0005=\u0004#BA9\u0003wbg\u0002BA:\u0003orA!a\t\u0002v%\t!,C\u0002\u0002ze\u000bq\u0001]1dW\u0006<W-\u0003\u0003\u0002b\u0005u$bAA=3\u0006Aa.\u001e7mC\ndW-\u0001\u0005eCR\fG+\u001f9f+\t\t)\t\u0005\u0003\u0002\b\u00065UBAAE\u0015\r\tY)Q\u0001\u0006if\u0004Xm]\u0005\u0005\u0003\u001f\u000bII\u0001\u0005ECR\fG+\u001f9f\u0003)Ig\u000e];u)f\u0004Xm]\u000b\u0003\u0003+\u0003b!!\u001d\u0002|\u0005]\u0005\u0003BAD\u00033KA!a'\u0002\n\n\u0001\u0012IY:ue\u0006\u001cG\u000fR1uCRK\b/Z\u0001\u0014G\",7m[%oaV$H)\u0019;b)f\u0004Xm\u001d\u000b\u0003\u0003C\u0003B!a)\u0002*6\u0011\u0011Q\u0015\u0006\u0004\u0003O{\u0014\u0001C1oC2L8/[:\n\t\u0005-\u0016Q\u0015\u0002\u0010)f\u0004Xm\u00115fG.\u0014Vm];mi\u0006iAo\u001c#pk\ndWMV1mk\u0016$B!a\u0019\u00022\"9\u00111\u0017\rA\u0002\u0005U\u0016!\u00013\u0011\u0007a\u000b9,C\u0002\u0002:f\u00131!\u00118z\u0003]\u0019'/Z1uK\u0006;wM]3hCRLwN\u001c\"vM\u001a,'\u000fF\u0001P\u0003\u0019)\b\u000fZ1uKR)q*a1\u0002H\"1\u0011Q\u0019\u000eA\u0002=\u000baAY;gM\u0016\u0014\bbBAe5\u0001\u0007\u00111Z\u0001\u0006S:\u0004X\u000f\u001e\t\u0005\u0003\u001b\fy-D\u0001@\u0013\r\t\tn\u0010\u0002\f\u0013:$XM\u001d8bYJ{w/A\u0003nKJ<W\rF\u0003P\u0003/\fI\u000e\u0003\u0004\u0002Fn\u0001\ra\u0014\u0005\u0007\u00037\\\u0002\u0019A(\u0002\u000b=$\b.\u001a:\u0002\t\u00154\u0018\r\u001c\u000b\u0005\u0003k\u000b\t\u000f\u0003\u0004\u0002Fr\u0001\raT\u0001\u000fO\u0016$\b+\u001a:dK:$\u0018\u000e\\3t)\u0011\t9/!;\u0011\r\u0005E\u00141PA2\u0011\u0019\t)-\ba\u0001\u001f\u0006qq-\u001a8fe\u0006$XmT;uaV$H\u0003BA[\u0003_Dq!!=\u001f\u0001\u0004\t9/A\u0004sKN,H\u000e^:\u0002\u001b\u001d,G\u000fU3sG\u0016tG/\u001b7f)\u0019\t\u0019'a>\u0003\u0004!9\u0011\u0011`\u0010A\u0002\u0005m\u0018aC1hOJ,7i\\;oiN\u0004b!!\u001d\u0002|\u0005u\b#\u0002-\u0002\u0000^k\u0016b\u0001B\u00013\n1A+\u001e9mKJBqA!\u0002 \u0001\u0004\t\u0019'\u0001\u0005q_NLG/[8o\u0003E\u0011\u0017N\\1ssN+\u0017M]2i\u0007>,h\u000e\u001e\u000b\nm\n-!Q\u0003B\r\u0005;AqA!\u0004!\u0001\u0004\u0011y!A\u0006d_VtGo]!se\u0006L\b\u0003\u0002-\u0003\u0012uK1Aa\u0005Z\u0005\u0015\t%O]1z\u0011\u0019\u00119\u0002\ta\u0001m\u0006)1\u000f^1si\"1!1\u0004\u0011A\u0002Y\f1!\u001a8e\u0011\u0019\u0011y\u0002\ta\u0001;\u0006)a/\u00197vK\u0006I1/\u001a:jC2L'0\u001a\u000b\u0005\u0005K\u0011i\u0003E\u0003Y\u0005#\u00119\u0003E\u0002Y\u0005SI1Aa\u000bZ\u0005\u0011\u0011\u0015\u0010^3\t\r\t=\u0012\u00051\u0001P\u0003\ry'M[\u0001\fI\u0016\u001cXM]5bY&TX\rF\u0002P\u0005kAqAa\u000e#\u0001\u0004\u0011)#A\u0003csR,7/\u0001\u0003d_BLHc\u0003@\u0003>\t}\"\u0011\tB\"\u0005\u000bBqA[\u0012\u0011\u0002\u0003\u0007A\u000eC\u0004qGA\u0005\t\u0019\u00017\t\u000fI\u001c\u0003\u0013!a\u0001Y\"9Ao\tI\u0001\u0002\u00041\bb\u0002>$!\u0003\u0005\rA^\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\u0011YEK\u0002m\u0005\u001bZ#Aa\u0014\u0011\t\tE#1L\u0007\u0003\u0005'RAA!\u0016\u0003X\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u00053J\u0016AC1o]>$\u0018\r^5p]&!!Q\fB*\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM\nabY8qs\u0012\"WMZ1vYR$C'\u0006\u0002\u0003h)\u001aaO!\u0014\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%k\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"Aa\u001c\u0011\t\tE$1P\u0007\u0003\u0005gRAA!\u001e\u0003x\u0005!A.\u00198h\u0015\t\u0011I(\u0001\u0003kCZ\f\u0017\u0002BA\u0018\u0005g\nA\u0002\u001d:pIV\u001cG/\u0011:jif\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u00026\n\r\u0005\u0002\u0003BCW\u0005\u0005\t\u0019\u0001<\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\u0011Y\t\u0005\u0004\u0002\\\t5\u0015QW\u0005\u0005\u0005\u001f\u000biF\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BA$\u0005+C\u0011B!\".\u0003\u0003\u0005\r!!.\u0002\r\u0015\fX/\u00197t)\u0011\t9Ea'\t\u0013\t\u0015e&!AA\u0002\u0005U\u0006f\u0002\u0001\u0003 \n\u0015&q\u0015\t\u0004C\n\u0005\u0016b\u0001BR{\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017E\u0001BU\u0003\u0011e#\u0002\t\u0011!A\u0001\u0002sLR+O\u0007~C3m\u001c7-AA,'oY3oi\u0006<W\rI.-A\u0019\u0014X-];f]\u000eLX,\u000b\u0011.AI+G/\u001e:og\u0002\"\b.\u001a\u0011fq\u0006\u001cG\u000f\t9fe\u000e,g\u000e^5mK\u00022\u0018\r\\;fA=4\u0007E\\;nKJL7\rI2pYVlgN\u0003\u0011!A\u0001\u0002\u0003\u0005\t1d_2\u0004\u0007%\u0019;!i\",\u0007eZ5wK:\u0004\u0003/\u001a:dK:$\u0018mZ3/AQCW\r\t<bYV,\u0007e\u001c4!a\u0016\u00148-\u001a8uC\u001e,\u0007%\\;ti\u0002\u0012W\r\t2fi^,WM\u001c\u00111]A\u0002\u0013M\u001c3!c9\u0002d\u0006\t+iK*\u0001\u0003\u0005\t\u0011!A\u00012\u0018\r\\;fA=4\u0007E\u001a:fcV,gnY=!g\"|W\u000f\u001c3!E\u0016\u0004\u0003o\\:ji&4X\rI5oi\u0016<'/\u00197\u000b\u0015\u0001\u0002\u0003\u0005\t\u0011!?\u001a+fjQ0)G>dG\u0006I1se\u0006L\b\u0006]3sG\u0016tG/Y4fc\u0001ZF\u0006\t9fe\u000e,g\u000e^1hKJjfF\f\u0018*Amc\u0003E\u001a:fcV,gnY=^S\u0001j\u0003EU3ukJt7\u000f\t;iK\u0002*\u00070Y2u\u0015\u0001\u0002\u0003\u0005\t\u0011!a\u0016\u00148-\u001a8uS2,\u0007E^1mk\u0016\u0004\u0013M\u001d:bs\u0002zg\r\t8v[\u0016\u0014\u0018n\u0019\u0011d_2,XN\u001c\u0011aG>d\u0007\rI1uAQDW\rI4jm\u0016t\u0007\u0005]3sG\u0016tG/Y4fQMLc\u0006I#bG\"\u0004c/\u00197vK*\u0001\u0003\u0005\t\u0011!A=4\u0007\u0005\u001e5fAA,'oY3oi\u0006<W\rI1se\u0006L\b%\\;ti\u0002\u0012W\r\t2fi^,WM\u001c\u00111]A\u0002\u0013M\u001c3!c9\u0002d\u0006\t+iK\u00022\u0018\r\\;fA=4\u0007E\u001a:fcV,gnY=!g\"|W\u000f\u001c3!E\u0016T\u0001\u0005\t\u0011!A\u0001\u0002xn]5uSZ,\u0007%\u001b8uK\u001e\u0014\u0018\r\u001c\u0006\u000bA\u0001\u0002\u0003\u0005\t\u0011\u0002\u0015A+'oY3oi&dW\r\u0005\u0002MaM!\u0001G!-h!)\u0011\u0019L!/mY24hO`\u0007\u0003\u0005kS1Aa.Z\u0003\u001d\u0011XO\u001c;j[\u0016LAAa/\u00036\n\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\\\u001b\u0015\u0005\t5\u0016\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\t=\u0014!B1qa2LHc\u0003@\u0003H\n%'1\u001aBg\u0005\u001fDQA[\u001aA\u00021DQ\u0001]\u001aA\u00021DQA]\u001aA\u00021Dq\u0001^\u001a\u0011\u0002\u0003\u0007a\u000fC\u0004{gA\u0005\t\u0019\u0001<\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uIQ\nq\"\u00199qYf$C-\u001a4bk2$H%N\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0011IN!:\u0011\u000ba\u0013YNa8\n\u0007\tu\u0017L\u0001\u0004PaRLwN\u001c\t\t1\n\u0005H\u000e\u001c7wm&\u0019!1]-\u0003\rQ+\b\u000f\\36\u0011!\u00119ONA\u0001\u0002\u0004q\u0018a\u0001=%a\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIQ\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012*\u0014a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"A!=\u0011\t\tE$1_\u0005\u0005\u0005k\u0014\u0019H\u0001\u0004PE*,7\r\u001e")
public class Percentile
extends TypedImperativeAggregate<OpenHashMap<Object, Object>>
implements ImplicitCastInputTypes,
scala.Serializable {
    private transient boolean returnPercentileArray;
    private transient Seq<Object> percentages;
    private DataType dataType;
    private final Expression child;
    private final Expression percentageExpression;
    private final Expression frequencyExpression;
    private final int mutableAggBufferOffset;
    private final int inputAggBufferOffset;
    private volatile boolean bitmap$0;
    private volatile transient byte bitmap$trans$0;

    public static int $lessinit$greater$default$5() {
        return Percentile$.MODULE$.$lessinit$greater$default$5();
    }

    public static int $lessinit$greater$default$4() {
        return Percentile$.MODULE$.$lessinit$greater$default$4();
    }

    public static Option<Tuple5<Expression, Expression, Expression, Object, Object>> unapply(Percentile percentile) {
        return Percentile$.MODULE$.unapply(percentile);
    }

    public static int apply$default$5() {
        return Percentile$.MODULE$.apply$default$5();
    }

    public static int apply$default$4() {
        return Percentile$.MODULE$.apply$default$4();
    }

    public static Function1<Tuple5<Expression, Expression, Expression, Object, Object>, Percentile> tupled() {
        return Percentile$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, Function1<Object, Function1<Object, Percentile>>>>> curried() {
        return Percentile$.MODULE$.curried();
    }

    public Expression child() {
        return this.child;
    }

    public Expression percentageExpression() {
        return this.percentageExpression;
    }

    public Expression frequencyExpression() {
        return this.frequencyExpression;
    }

    @Override
    public int mutableAggBufferOffset() {
        return this.mutableAggBufferOffset;
    }

    @Override
    public int inputAggBufferOffset() {
        return this.inputAggBufferOffset;
    }

    @Override
    public String prettyName() {
        return "percentile";
    }

    @Override
    public Percentile withNewMutableAggBufferOffset(int newMutableAggBufferOffset) {
        int x$1 = newMutableAggBufferOffset;
        Expression x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        Expression x$4 = this.copy$default$3();
        int x$5 = this.copy$default$5();
        return this.copy(x$2, x$3, x$4, x$1, x$5);
    }

    @Override
    public Percentile withNewInputAggBufferOffset(int newInputAggBufferOffset) {
        int x$1 = newInputAggBufferOffset;
        Expression x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        Expression x$4 = this.copy$default$3();
        int x$5 = this.copy$default$4();
        return this.copy(x$2, x$3, x$4, x$5, x$1);
    }

    private boolean returnPercentileArray$lzycompute() {
        Percentile percentile = this;
        synchronized (percentile) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.returnPercentileArray = this.percentageExpression().dataType() instanceof ArrayType;
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.returnPercentileArray;
    }

    private boolean returnPercentileArray() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.returnPercentileArray$lzycompute() : this.returnPercentileArray;
    }

    private Seq<Object> percentages$lzycompute() {
        Percentile percentile = this;
        synchronized (percentile) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                Seq seq;
                Object object = this.percentageExpression().eval(this.percentageExpression().eval$default$1());
                if (object instanceof Double) {
                    double d = BoxesRunTime.unboxToDouble((Object)object);
                    seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{d}));
                } else if (object instanceof ArrayData) {
                    ArrayData arrayData = (ArrayData)object;
                    seq = new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(arrayData.toDoubleArray())).toSeq();
                } else {
                    throw new MatchError(object);
                }
                this.percentages = seq;
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.percentages;
    }

    private Seq<Object> percentages() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.percentages$lzycompute() : this.percentages;
    }

    @Override
    public Seq<Expression> children() {
        Expression expression = this.child();
        Expression expression2 = this.percentageExpression();
        Expression expression3 = this.frequencyExpression();
        return Nil$.MODULE$.$colon$colon((Object)expression3).$colon$colon((Object)expression2).$colon$colon((Object)expression);
    }

    @Override
    public boolean nullable() {
        return true;
    }

    private DataType dataType$lzycompute() {
        Percentile percentile = this;
        synchronized (percentile) {
            if (!this.bitmap$0) {
                DataType dataType = this.percentageExpression().dataType();
                DataType dataType2 = dataType instanceof ArrayType ? new ArrayType(DoubleType$.MODULE$, false) : DoubleType$.MODULE$;
                this.dataType = dataType2;
                this.bitmap$0 = true;
            }
        }
        return this.dataType;
    }

    @Override
    public DataType dataType() {
        return !this.bitmap$0 ? this.dataType$lzycompute() : this.dataType;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        DataType dataType = this.percentageExpression().dataType();
        DataType dataType2 = dataType instanceof ArrayType ? ArrayType$.MODULE$.apply(DoubleType$.MODULE$) : DoubleType$.MODULE$;
        DataType percentageExpType = dataType2;
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{NumericType$.MODULE$, percentageExpType, IntegralType$.MODULE$}));
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        TypeCheckResult defaultCheck = ExpectsInputTypes.checkInputDataTypes$(this);
        return defaultCheck.isFailure() ? defaultCheck : (!this.percentageExpression().foldable() ? new TypeCheckResult.TypeCheckFailure(new StringBuilder(46).append("The percentage(s) must be a constant literal, ").append(new StringBuilder(8).append("but got ").append(this.percentageExpression()).toString()).toString()) : (this.percentages().exists((Function1)(JFunction1.mcZD.sp & Serializable & scala.Serializable)percentage -> percentage < 0.0 || percentage > 1.0) ? new TypeCheckResult.TypeCheckFailure(new StringBuilder(43).append("Percentage(s) must be between 0.0 and 1.0, ").append(new StringBuilder(8).append("but got ").append(this.percentageExpression()).toString()).toString()) : TypeCheckResult$TypeCheckSuccess$.MODULE$));
    }

    private double toDoubleValue(Object d) {
        double d2;
        Object object = d;
        if (object instanceof Decimal) {
            Decimal decimal = (Decimal)object;
            d2 = decimal.toDouble();
        } else if (object instanceof Number) {
            Number number = (Number)object;
            d2 = number.doubleValue();
        } else {
            throw new MatchError(object);
        }
        return d2;
    }

    @Override
    public OpenHashMap<Object, Object> createAggregationBuffer() {
        return new OpenHashMap.mcJ.sp(ClassTag$.MODULE$.AnyRef(), ClassTag$.MODULE$.Long());
    }

    @Override
    public OpenHashMap<Object, Object> update(OpenHashMap<Object, Object> buffer, InternalRow input) {
        Object object;
        Object key = this.child().eval(input);
        Object frqValue = this.frequencyExpression().eval(input);
        if (key != null && frqValue != null) {
            long frqLong = ((Number)frqValue).longValue();
            if (frqLong > 0L) {
                object = BoxesRunTime.boxToLong((long)buffer.changeValue$mcJ$sp(key, (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> frqLong, (Function1)(JFunction1.mcJJ.sp & Serializable & scala.Serializable)x$4 -> x$4 + frqLong));
            } else {
                if (frqLong < 0L) {
                    throw new SparkException(new StringBuilder(25).append("Negative values found in ").append(this.frequencyExpression().sql()).toString());
                }
                object = BoxedUnit.UNIT;
            }
        } else {
            object = BoxedUnit.UNIT;
        }
        return buffer;
    }

    @Override
    public OpenHashMap<Object, Object> merge(OpenHashMap<Object, Object> buffer, OpenHashMap<Object, Object> other) {
        other.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToLong((long)Percentile.$anonfun$merge$1(buffer, x0$1)));
        return buffer;
    }

    @Override
    public Object eval(OpenHashMap<Object, Object> buffer) {
        return this.generateOutput(this.getPercentiles(buffer));
    }

    private Seq<Object> getPercentiles(OpenHashMap<Object, Object> buffer) {
        if (buffer.isEmpty()) {
            return (Seq)Seq$.MODULE$.empty();
        }
        Seq sortedCounts = (Seq)buffer.toSeq().sortBy((Function1 & Serializable & scala.Serializable)x$6 -> x$6._1(), ((NumericType)this.child().dataType()).ordering());
        Seq accumlatedCounts = (Seq)((TraversableLike)sortedCounts.scanLeft((Object)new Tuple2(((Tuple2)sortedCounts.head())._1(), (Object)BoxesRunTime.boxToLong((long)0L)), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            long count1;
            Tuple2 tuple2;
            block3: {
                Tuple2 tuple22;
                block2: {
                    tuple22 = new Tuple2(x0$1, x1$1);
                    if (tuple22 == null) break block2;
                    Tuple2 tuple23 = (Tuple2)tuple22._1();
                    tuple2 = (Tuple2)tuple22._2();
                    if (tuple23 == null) break block2;
                    count1 = tuple23._2$mcJ$sp();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError((Object)tuple22);
            }
            Object key2 = tuple2._1();
            long count2 = tuple2._2$mcJ$sp();
            Tuple2 tuple24 = new Tuple2(key2, (Object)BoxesRunTime.boxToLong((long)(count1 + count2)));
            return tuple24;
        }, Seq$.MODULE$.canBuildFrom())).tail();
        long maxPosition = ((Tuple2)accumlatedCounts.last())._2$mcJ$sp() - 1L;
        return (Seq)this.percentages().map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)percentile -> this.getPercentile((Seq<Tuple2<Object, Object>>)accumlatedCounts, (double)maxPosition * percentile), Seq$.MODULE$.canBuildFrom());
    }

    private Object generateOutput(Seq<Object> results) {
        return results.isEmpty() ? null : (this.returnPercentileArray() ? new GenericArrayData(results) : results.head());
    }

    private double getPercentile(Seq<Tuple2<Object, Object>> aggreCounts, double position) {
        long lower = (long)RichDouble$.MODULE$.floor$extension(Predef$.MODULE$.doubleWrapper(position));
        long higher = (long)RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper(position));
        long[] countsArray = (long[])((TraversableOnce)aggreCounts.map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToLong((long)x$7._2$mcJ$sp()), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Long());
        int lowerIndex = this.binarySearchCount(countsArray, 0, aggreCounts.size(), lower + 1L);
        int higherIndex = this.binarySearchCount(countsArray, 0, aggreCounts.size(), higher + 1L);
        Object lowerKey = ((Tuple2)aggreCounts.apply(lowerIndex))._1();
        if (higher == lower) {
            return this.toDoubleValue(lowerKey);
        }
        Object higherKey = ((Tuple2)aggreCounts.apply(higherIndex))._1();
        if (BoxesRunTime.equals((Object)higherKey, (Object)lowerKey)) {
            return this.toDoubleValue(lowerKey);
        }
        return ((double)higher - position) * this.toDoubleValue(lowerKey) + (position - (double)lower) * this.toDoubleValue(higherKey);
    }

    private int binarySearchCount(long[] countsArray, int start, int end, long value) {
        int n = Arrays.binarySearch(countsArray, 0, end, value);
        switch (n) {
            default: 
        }
        return n < 0 ? -(n + 1) : n;
    }

    @Override
    public byte[] serialize(OpenHashMap<Object, Object> obj) {
        byte[] byArray;
        byte[] buffer = new byte[4096];
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(bos);
        try {
            UnsafeProjection projection = UnsafeProjection$.MODULE$.create((DataType[])((Object[])new DataType[]{this.child().dataType(), LongType$.MODULE$}));
            obj.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Percentile.$anonfun$serialize$1(projection, out, buffer, x0$1);
                return BoxedUnit.UNIT;
            });
            out.writeInt(-1);
            out.flush();
            byArray = bos.toByteArray();
        }
        finally {
            out.close();
            bos.close();
        }
        return byArray;
    }

    @Override
    public OpenHashMap<Object, Object> deserialize(byte[] bytes) {
        OpenHashMap.mcJ.sp sp2;
        ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
        DataInputStream ins = new DataInputStream(bis);
        try {
            OpenHashMap.mcJ.sp counts = new OpenHashMap.mcJ.sp(ClassTag$.MODULE$.AnyRef(), ClassTag$.MODULE$.Long());
            int sizeOfNextRow = ins.readInt();
            while (sizeOfNextRow >= 0) {
                byte[] bs = new byte[sizeOfNextRow];
                ins.readFully(bs);
                UnsafeRow row = new UnsafeRow(2);
                row.pointTo(bs, sizeOfNextRow);
                Object key = row.get(0, this.child().dataType());
                long count = BoxesRunTime.unboxToLong((Object)row.get(1, LongType$.MODULE$));
                counts.update$mcJ$sp(key, count);
                sizeOfNextRow = ins.readInt();
            }
            sp2 = counts;
        }
        finally {
            ins.close();
            bis.close();
        }
        return sp2;
    }

    public Percentile copy(Expression child, Expression percentageExpression, Expression frequencyExpression, int mutableAggBufferOffset, int inputAggBufferOffset) {
        return new Percentile(child, percentageExpression, frequencyExpression, mutableAggBufferOffset, inputAggBufferOffset);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    public Expression copy$default$2() {
        return this.percentageExpression();
    }

    public Expression copy$default$3() {
        return this.frequencyExpression();
    }

    public int copy$default$4() {
        return this.mutableAggBufferOffset();
    }

    public int copy$default$5() {
        return this.inputAggBufferOffset();
    }

    @Override
    public String productPrefix() {
        return "Percentile";
    }

    public int productArity() {
        return 5;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.child();
                break;
            }
            case 1: {
                object = this.percentageExpression();
                break;
            }
            case 2: {
                object = this.frequencyExpression();
                break;
            }
            case 3: {
                object = BoxesRunTime.boxToInteger((int)this.mutableAggBufferOffset());
                break;
            }
            case 4: {
                object = BoxesRunTime.boxToInteger((int)this.inputAggBufferOffset());
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Percentile;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Percentile)) return false;
        boolean bl = true;
        if (!bl) return false;
        Percentile percentile = (Percentile)x$1;
        Expression expression = this.child();
        Expression expression2 = percentile.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.percentageExpression();
        Expression expression4 = percentile.percentageExpression();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.frequencyExpression();
        Expression expression6 = percentile.frequencyExpression();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (this.mutableAggBufferOffset() != percentile.mutableAggBufferOffset()) return false;
        if (this.inputAggBufferOffset() != percentile.inputAggBufferOffset()) return false;
        if (!percentile.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ long $anonfun$merge$1(OpenHashMap buffer$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Object key = tuple2._1();
        long count = tuple2._2$mcJ$sp();
        long l = buffer$1.changeValue$mcJ$sp(key, (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> count, (Function1)(JFunction1.mcJJ.sp & Serializable & scala.Serializable)x$5 -> x$5 + count);
        return l;
    }

    public static final /* synthetic */ void $anonfun$serialize$1(UnsafeProjection projection$1, DataOutputStream out$1, byte[] buffer$2, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Object key = tuple2._1();
        long count = tuple2._2$mcJ$sp();
        InternalRow row = InternalRow$.MODULE$.apply((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{key, BoxesRunTime.boxToLong((long)count)}));
        UnsafeRow unsafeRow = projection$1.apply(row);
        out$1.writeInt(unsafeRow.getSizeInBytes());
        unsafeRow.writeToStream(out$1, buffer$2);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public Percentile(Expression child, Expression percentageExpression, Expression frequencyExpression, int mutableAggBufferOffset, int inputAggBufferOffset) {
        this.child = child;
        this.percentageExpression = percentageExpression;
        this.frequencyExpression = frequencyExpression;
        this.mutableAggBufferOffset = mutableAggBufferOffset;
        this.inputAggBufferOffset = inputAggBufferOffset;
        ExpectsInputTypes.$init$(this);
    }

    public Percentile(Expression child, Expression percentageExpression) {
        this(child, percentageExpression, Literal$.MODULE$.apply(BoxesRunTime.boxToLong((long)1L)), 0, 0);
    }

    public Percentile(Expression child, Expression percentageExpression, Expression frequency) {
        this(child, percentageExpression, frequency, 0, 0);
    }
}

