/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.SubstringIndex$;
import org.apache.spark.sql.catalyst.expressions.TernaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function3;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(str, delim, count) - Returns the substring from `str` before `count` occurrences of the delimiter `delim`.\n      If `count` is positive, everything to the left of the final delimiter (counting from the\n      left) is returned. If `count` is negative, everything to the right of the final delimiter\n      (counting from the right) is returned. The function substring_index performs a case-sensitive match\n      when searching for `delim`.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('www.apache.org', '.', 2);\n       www.apache\n  ")
@ScalaSignature(bytes="\u0006\u0001\u0005]g\u0001B\u0010!\u00016B\u0001B\u0010\u0001\u0003\u0016\u0004%\ta\u0010\u0005\t\u0007\u0002\u0011\t\u0012)A\u0005\u0001\"AA\t\u0001BK\u0002\u0013\u0005q\b\u0003\u0005F\u0001\tE\t\u0015!\u0003A\u0011!1\u0005A!f\u0001\n\u0003y\u0004\u0002C$\u0001\u0005#\u0005\u000b\u0011\u0002!\t\u000b!\u0003A\u0011A%\t\u000b9\u0003A\u0011I(\t\u000bY\u0003A\u0011I,\t\u000b\u0011\u0004A\u0011I3\t\u000b\u001d\u0004A\u0011\t5\t\u000bE\u0004A\u0011\t:\t\u000bq\u0004A\u0011I?\t\u0013\u0005]\u0001!!A\u0005\u0002\u0005e\u0001\"CA\u0011\u0001E\u0005I\u0011AA\u0012\u0011%\tI\u0004AI\u0001\n\u0003\t\u0019\u0003C\u0005\u0002<\u0001\t\n\u0011\"\u0001\u0002$!I\u0011Q\b\u0001\u0002\u0002\u0013\u0005\u0013q\b\u0005\n\u0003\u001f\u0002\u0011\u0011!C\u0001\u0003#B\u0011\"!\u0017\u0001\u0003\u0003%\t!a\u0017\t\u0013\u0005\u0005\u0004!!A\u0005B\u0005\r\u0004\"CA9\u0001\u0005\u0005I\u0011AA:\u0011%\ti\bAA\u0001\n\u0003\nyhB\u0005\u0002\u0018\u0002\n\t\u0011#\u0001\u0002\u001a\u001aAq\u0004IA\u0001\u0012\u0003\tY\n\u0003\u0004I3\u0011\u0005\u0011\u0011\u0016\u0005\n\u0003WK\u0012\u0011!C#\u0003[C\u0011\"a,\u001a\u0003\u0003%\t)!-\t\u0013\u0005e\u0016$!A\u0005\u0002\u0006m\u0006\"CAg3\u0005\u0005I\u0011BAh\u00059\u0019VOY:ue&tw-\u00138eKbT!!\t\u0012\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003G\u0011\n\u0001bY1uC2L8\u000f\u001e\u0006\u0003K\u0019\n1a]9m\u0015\t9\u0003&A\u0003ta\u0006\u00148N\u0003\u0002*U\u00051\u0011\r]1dQ\u0016T\u0011aK\u0001\u0004_J<7\u0001A\n\u0006\u00019\u0012Tg\u000f\t\u0003_Aj\u0011\u0001I\u0005\u0003c\u0001\u0012\u0011\u0003V3s]\u0006\u0014\u00180\u0012=qe\u0016\u001c8/[8o!\ty3'\u0003\u00025A\t1\u0012*\u001c9mS\u000eLGoQ1ti&s\u0007/\u001e;UsB,7\u000f\u0005\u00027s5\tqGC\u00019\u0003\u0015\u00198-\u00197b\u0013\tQtGA\u0004Qe>$Wo\u0019;\u0011\u0005Yb\u0014BA\u001f8\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003\u001d\u0019HO]#yaJ,\u0012\u0001\u0011\t\u0003_\u0005K!A\u0011\u0011\u0003\u0015\u0015C\bO]3tg&|g.\u0001\u0005tiJ,\u0005\u0010\u001d:!\u0003%!W\r\\5n\u000bb\u0004(/\u0001\u0006eK2LW.\u0012=qe\u0002\n\u0011bY8v]R,\u0005\u0010\u001d:\u0002\u0015\r|WO\u001c;FqB\u0014\b%\u0001\u0004=S:LGO\u0010\u000b\u0005\u0015.cU\n\u0005\u00020\u0001!)ah\u0002a\u0001\u0001\")Ai\u0002a\u0001\u0001\")ai\u0002a\u0001\u0001\u0006AA-\u0019;b)f\u0004X-F\u0001Q!\t\tF+D\u0001S\u0015\t\u0019F%A\u0003usB,7/\u0003\u0002V%\nAA)\u0019;b)f\u0004X-\u0001\u0006j]B,H\u000fV=qKN,\u0012\u0001\u0017\t\u00043\u0006\u0004fB\u0001.`\u001d\tYf,D\u0001]\u0015\tiF&\u0001\u0004=e>|GOP\u0005\u0002q%\u0011\u0001mN\u0001\ba\u0006\u001c7.Y4f\u0013\t\u00117MA\u0002TKFT!\u0001Y\u001c\u0002\u0011\rD\u0017\u000e\u001c3sK:,\u0012A\u001a\t\u00043\u0006\u0004\u0015A\u00039sKR$\u0018PT1nKV\t\u0011\u000e\u0005\u0002k]:\u00111\u000e\u001c\t\u00037^J!!\\\u001c\u0002\rA\u0013X\rZ3g\u0013\ty\u0007O\u0001\u0004TiJLgn\u001a\u0006\u0003[^\nAB\\;mYN\u000bg-Z#wC2$Ba\u001d<yuB\u0011a\u0007^\u0005\u0003k^\u00121!\u00118z\u0011\u00159H\u00021\u0001t\u0003\r\u0019HO\u001d\u0005\u0006s2\u0001\ra]\u0001\u0006I\u0016d\u0017.\u001c\u0005\u0006w2\u0001\ra]\u0001\u0006G>,h\u000e^\u0001\nI><UM\\\"pI\u0016$RA`A\u0005\u0003'\u00012a`A\u0003\u001b\t\t\tAC\u0002\u0002\u0004\u0001\nqaY8eK\u001e,g.\u0003\u0003\u0002\b\u0005\u0005!\u0001C#yaJ\u001cu\u000eZ3\t\u000f\u0005-Q\u00021\u0001\u0002\u000e\u0005\u00191\r\u001e=\u0011\u0007}\fy!\u0003\u0003\u0002\u0012\u0005\u0005!AD\"pI\u0016<WM\\\"p]R,\u0007\u0010\u001e\u0005\u0007\u0003+i\u0001\u0019\u0001@\u0002\u0005\u00154\u0018\u0001B2paf$rASA\u000e\u0003;\ty\u0002C\u0004?\u001dA\u0005\t\u0019\u0001!\t\u000f\u0011s\u0001\u0013!a\u0001\u0001\"9aI\u0004I\u0001\u0002\u0004\u0001\u0015AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003KQ3\u0001QA\u0014W\t\tI\u0003\u0005\u0003\u0002,\u0005URBAA\u0017\u0015\u0011\ty#!\r\u0002\u0013Ut7\r[3dW\u0016$'bAA\u001ao\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005]\u0012Q\u0006\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011\u0011\t\t\u0005\u0003\u0007\ni%\u0004\u0002\u0002F)!\u0011qIA%\u0003\u0011a\u0017M\\4\u000b\u0005\u0005-\u0013\u0001\u00026bm\u0006L1a\\A#\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\t\u0019\u0006E\u00027\u0003+J1!a\u00168\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\r\u0019\u0018Q\f\u0005\n\u0003?\"\u0012\u0011!a\u0001\u0003'\n1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAA3!\u0015\t9'!\u001ct\u001b\t\tIGC\u0002\u0002l]\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\ty'!\u001b\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003k\nY\bE\u00027\u0003oJ1!!\u001f8\u0005\u001d\u0011un\u001c7fC:D\u0001\"a\u0018\u0017\u0003\u0003\u0005\ra]\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005U\u0014\u0011\u0011\u0005\t\u0003?:\u0012\u0011!a\u0001g\"Z\u0001!!\"\u0002\f\u00065\u0015\u0011SAJ!\ry\u0013qQ\u0005\u0004\u0003\u0013\u0003#!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u0003\u001f\u000b1\u0011\u0012\u0006!A\u0001\u0002sLR+O\u0007~C3\u000f\u001e:-A\u0011,G.[7-A\r|WO\u001c;*A5\u0002#+\u001a;ve:\u001c\b\u0005\u001e5fAM,(m\u001d;sS:<\u0007E\u001a:p[\u0002\u00027\u000f\u001e:aA\t,gm\u001c:fA\u0001\u001cw.\u001e8uA\u0002z7mY;se\u0016t7-Z:!_\u001a\u0004C\u000f[3!I\u0016d\u0017.\\5uKJ\u0004\u0003\rZ3mS6\u0004gF\u0003\u0011!A\u0001\u0002\u0003%\u00134!A\u000e|WO\u001c;aA%\u001c\b\u0005]8tSRLg/\u001a\u0017!KZ,'/\u001f;iS:<\u0007\u0005^8!i\",\u0007\u0005\\3gi\u0002zg\r\t;iK\u00022\u0017N\\1mA\u0011,G.[7ji\u0016\u0014\b\u0005K2pk:$\u0018N\\4!MJ|W\u000e\t;iK*\u0001\u0003\u0005\t\u0011!A1,g\r^\u0015!SN\u0004#/\u001a;ve:,GM\f\u0011JM\u0002\u00027m\\;oi\u0002\u0004\u0013n\u001d\u0011oK\u001e\fG/\u001b<fY\u0001*g/\u001a:zi\"Lgn\u001a\u0011u_\u0002\"\b.\u001a\u0011sS\u001eDG\u000fI8gAQDW\r\t4j]\u0006d\u0007\u0005Z3mS6LG/\u001a:\u000bA\u0001\u0002\u0003\u0005\t\u0011)G>,h\u000e^5oO\u00022'o\\7!i\",\u0007E]5hQRL\u0003%[:!e\u0016$XO\u001d8fI:\u0002C\u000b[3!MVt7\r^5p]\u0002\u001aXOY:ue&twmX5oI\u0016D\b\u0005]3sM>\u0014Xn\u001d\u0011bA\r\f7/Z\u0017tK:\u001c\u0018\u000e^5wK\u0002j\u0017\r^2i\u0015\u0001\u0002\u0003\u0005\t\u0011!o\",g\u000eI:fCJ\u001c\u0007.\u001b8hA\u0019|'\u000f\t1eK2LW\u000e\u0019\u0018\u000bA\u0001\n\u0001\"\u001a=b[BdWm]\u0011\u0003\u0003+\u000bAK\u0003\u0011!A\u0001*\u00050Y7qY\u0016\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015(o^<h&\u00199bG\",gf\u001c:hO1\u0002sEL\u0014-AIJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005I<xo:\n\u0007/Y2iK*\u0001\u0003%\u0001\bTk\n\u001cHO]5oO&sG-\u001a=\u0011\u0005=J2\u0003B\r\u0002\u001en\u0002\u0002\"a(\u0002&\u0002\u0003\u0005IS\u0007\u0003\u0003CS1!a)8\u0003\u001d\u0011XO\u001c;j[\u0016LA!a*\u0002\"\n\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\\\u001a\u0015\u0005\u0005e\u0015\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005\u0005\u0013!B1qa2LHc\u0002&\u00024\u0006U\u0016q\u0017\u0005\u0006}q\u0001\r\u0001\u0011\u0005\u0006\tr\u0001\r\u0001\u0011\u0005\u0006\rr\u0001\r\u0001Q\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\ti,!3\u0011\u000bY\ny,a1\n\u0007\u0005\u0005wG\u0001\u0004PaRLwN\u001c\t\u0007m\u0005\u0015\u0007\t\u0011!\n\u0007\u0005\u001dwG\u0001\u0004UkBdWm\r\u0005\t\u0003\u0017l\u0012\u0011!a\u0001\u0015\u0006\u0019\u0001\u0010\n\u0019\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003#\u0004B!a\u0011\u0002T&!\u0011Q[A#\u0005\u0019y%M[3di\u0002")
public class SubstringIndex
extends TernaryExpression
implements ImplicitCastInputTypes,
scala.Serializable {
    private final Expression strExpr;
    private final Expression delimExpr;
    private final Expression countExpr;

    public static Option<Tuple3<Expression, Expression, Expression>> unapply(SubstringIndex substringIndex) {
        return SubstringIndex$.MODULE$.unapply(substringIndex);
    }

    public static Function1<Tuple3<Expression, Expression, Expression>, SubstringIndex> tupled() {
        return SubstringIndex$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, SubstringIndex>>> curried() {
        return SubstringIndex$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public Expression strExpr() {
        return this.strExpr;
    }

    public Expression delimExpr() {
        return this.delimExpr;
    }

    public Expression countExpr() {
        return this.countExpr;
    }

    @Override
    public DataType dataType() {
        return StringType$.MODULE$;
    }

    public Seq<DataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AtomicType[]{StringType$.MODULE$, StringType$.MODULE$, IntegerType$.MODULE$}));
    }

    @Override
    public Seq<Expression> children() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.strExpr(), this.delimExpr(), this.countExpr()}));
    }

    @Override
    public String prettyName() {
        return "substring_index";
    }

    @Override
    public Object nullSafeEval(Object str, Object delim, Object count) {
        return ((UTF8String)str).subStringIndex((UTF8String)delim, BoxesRunTime.unboxToInt((Object)count));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.defineCodeGen(ctx, ev, (Function3<String, String, String, String>)(Function3 & Serializable & scala.Serializable)(str, delim, count) -> new StringBuilder(19).append((String)str).append(".subStringIndex(").append((String)delim).append(", ").append((String)count).append(")").toString());
    }

    public SubstringIndex copy(Expression strExpr, Expression delimExpr, Expression countExpr) {
        return new SubstringIndex(strExpr, delimExpr, countExpr);
    }

    public Expression copy$default$1() {
        return this.strExpr();
    }

    public Expression copy$default$2() {
        return this.delimExpr();
    }

    public Expression copy$default$3() {
        return this.countExpr();
    }

    @Override
    public String productPrefix() {
        return "SubstringIndex";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.strExpr();
                break;
            }
            case 1: {
                expression = this.delimExpr();
                break;
            }
            case 2: {
                expression = this.countExpr();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof SubstringIndex;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof SubstringIndex)) return false;
        boolean bl = true;
        if (!bl) return false;
        SubstringIndex substringIndex = (SubstringIndex)x$1;
        Expression expression = this.strExpr();
        Expression expression2 = substringIndex.strExpr();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.delimExpr();
        Expression expression4 = substringIndex.delimExpr();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.countExpr();
        Expression expression6 = substringIndex.countExpr();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!substringIndex.canEqual(this)) return false;
        return true;
    }

    public SubstringIndex(Expression strExpr, Expression delimExpr, Expression countExpr) {
        this.strExpr = strExpr;
        this.delimExpr = delimExpr;
        this.countExpr = countExpr;
        ExpectsInputTypes.$init$(this);
    }
}

