/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.String2TrimExpression;
import org.apache.spark.sql.catalyst.expressions.StringTrimRight$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(str) - Removes the trailing space characters from `str`.\n\n    _FUNC_(trimStr, str) - Removes the trailing string which contains the characters from the trim string from the `str`\n  ", arguments="\n    Arguments:\n      * str - a string expression\n      * trimStr - the trim string characters to trim, the default value is a single space\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('    SparkSQL   ');\n       SparkSQL\n      > SELECT _FUNC_('LQSa', 'SSparkSQLS');\n       SSpark\n  ")
@ScalaSignature(bytes="\u0006\u0001\u00055w!B\u0010!\u0011\u0003ic!B\u0018!\u0011\u0003\u0001\u0004\"\u0002\u001e\u0002\t\u0003Y\u0004\"\u0002\u001f\u0002\t\u0003i\u0004B\u0002\u001f\u0002\t\u0003\t)\u000b\u0003\u0005=\u0003\u0005\u0005I\u0011QAU\u0011%\ty+AI\u0001\n\u0003\tY\u0004C\u0005\u00022\u0006\t\t\u0011\"!\u00024\"I\u0011\u0011Y\u0001\u0012\u0002\u0013\u0005\u00111\b\u0005\n\u0003\u0007\f\u0011\u0011!C\u0005\u0003\u000b4Aa\f\u0011A\u007f!A\u0011J\u0003BK\u0002\u0013\u0005!\n\u0003\u0005L\u0015\tE\t\u0015!\u0003A\u0011!a%B!f\u0001\n\u0003i\u0005\u0002C)\u000b\u0005#\u0005\u000b\u0011\u0002(\t\u000biRA\u0011\u0001*\t\u000biRA\u0011A+\t\u000biRA\u0011\u0001-\t\u000biSA\u0011I.\t\u000b\u001dTA\u0011\t5\t\u000bITA\u0011I:\t\u000buTA\u0011\u000b@\t\u0013\u0005e!\"!A\u0005\u0002\u0005m\u0001\"CA\u0011\u0015E\u0005I\u0011AA\u0012\u0011%\tIDCI\u0001\n\u0003\tY\u0004C\u0005\u0002@)\t\t\u0011\"\u0011\u0002B!I\u0011\u0011\u000b\u0006\u0002\u0002\u0013\u0005\u00111\u000b\u0005\n\u00037R\u0011\u0011!C\u0001\u0003;B\u0011\"a\u0019\u000b\u0003\u0003%\t%!\u001a\t\u0013\u0005M$\"!A\u0005\u0002\u0005U\u0004\"CA@\u0015\u0005\u0005I\u0011IAA\u0003=\u0019FO]5oOR\u0013\u0018.\u001c*jO\"$(BA\u0011#\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005\r\"\u0013\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005\u00152\u0013aA:rY*\u0011q\u0005K\u0001\u0006gB\f'o\u001b\u0006\u0003S)\na!\u00199bG\",'\"A\u0016\u0002\u0007=\u0014xm\u0001\u0001\u0011\u00059\nQ\"\u0001\u0011\u0003\u001fM#(/\u001b8h)JLWNU5hQR\u001c2!A\u00198!\t\u0011T'D\u00014\u0015\u0005!\u0014!B:dC2\f\u0017B\u0001\u001c4\u0005\u0019\te.\u001f*fMB\u0011!\u0007O\u0005\u0003sM\u0012AbU3sS\u0006d\u0017N_1cY\u0016\fa\u0001P5oSRtD#A\u0017\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000by\ny*a)\u0011\u00059R1#\u0002\u0006A\u0007\u001a;\u0004C\u0001\u0018B\u0013\t\u0011\u0005E\u0001\u0006FqB\u0014Xm]:j_:\u0004\"A\f#\n\u0005\u0015\u0003#!F*ue&twM\r+sS6,\u0005\u0010\u001d:fgNLwN\u001c\t\u0003e\u001dK!\u0001S\u001a\u0003\u000fA\u0013x\u000eZ;di\u000611O]2TiJ,\u0012\u0001Q\u0001\bgJ\u001c7\u000b\u001e:!\u0003\u001d!(/[7TiJ,\u0012A\u0014\t\u0004e=\u0003\u0015B\u0001)4\u0005\u0019y\u0005\u000f^5p]\u0006AAO]5n'R\u0014\b\u0005F\u0002?'RCQ!S\bA\u0002\u0001Cq\u0001T\b\u0011\u0002\u0003\u0007a\nF\u0002?-^CQ\u0001\u0014\tA\u0002\u0001CQ!\u0013\tA\u0002\u0001#\"AP-\t\u000b%\u000b\u0002\u0019\u0001!\u0002\u0015A\u0014X\r\u001e;z\u001d\u0006lW-F\u0001]!\tiFM\u0004\u0002_EB\u0011qlM\u0007\u0002A*\u0011\u0011\rL\u0001\u0007yI|w\u000e\u001e \n\u0005\r\u001c\u0014A\u0002)sK\u0012,g-\u0003\u0002fM\n11\u000b\u001e:j]\u001eT!aY\u001a\u0002\u0011\rD\u0017\u000e\u001c3sK:,\u0012!\u001b\t\u0004U>\u0004eBA6n\u001d\tyF.C\u00015\u0013\tq7'A\u0004qC\u000e\\\u0017mZ3\n\u0005A\f(aA*fc*\u0011anM\u0001\u0005KZ\fG\u000e\u0006\u0002uoB\u0011!'^\u0005\u0003mN\u00121!\u00118z\u0011\u001dAH\u0003%AA\u0002e\fQ!\u001b8qkR\u0004\"A_>\u000e\u0003\tJ!\u0001 \u0012\u0003\u0017%sG/\u001a:oC2\u0014vn^\u0001\nI><UM\\\"pI\u0016$Ra`A\u0006\u0003+\u0001B!!\u0001\u0002\b5\u0011\u00111\u0001\u0006\u0004\u0003\u000b\u0001\u0013aB2pI\u0016<WM\\\u0005\u0005\u0003\u0013\t\u0019A\u0001\u0005FqB\u00148i\u001c3f\u0011\u001d\ti!\u0006a\u0001\u0003\u001f\t1a\u0019;y!\u0011\t\t!!\u0005\n\t\u0005M\u00111\u0001\u0002\u000f\u0007>$WmZ3o\u0007>tG/\u001a=u\u0011\u0019\t9\"\u0006a\u0001\u007f\u0006\u0011QM^\u0001\u0005G>\u0004\u0018\u0010F\u0003?\u0003;\ty\u0002C\u0004J-A\u0005\t\u0019\u0001!\t\u000f13\u0002\u0013!a\u0001\u001d\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAA\u0013U\r\u0001\u0015qE\u0016\u0003\u0003S\u0001B!a\u000b\u000265\u0011\u0011Q\u0006\u0006\u0005\u0003_\t\t$A\u0005v]\u000eDWmY6fI*\u0019\u00111G\u001a\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u00028\u00055\"!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TCAA\u001fU\rq\u0015qE\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005\r\u0003\u0003BA#\u0003\u001fj!!a\u0012\u000b\t\u0005%\u00131J\u0001\u0005Y\u0006twM\u0003\u0002\u0002N\u0005!!.\u0019<b\u0013\r)\u0017qI\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003+\u00022AMA,\u0013\r\tIf\r\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0004i\u0006}\u0003\"CA17\u0005\u0005\t\u0019AA+\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011q\r\t\u0006\u0003S\ny\u0007^\u0007\u0003\u0003WR1!!\u001c4\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003c\nYG\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BA<\u0003{\u00022AMA=\u0013\r\tYh\r\u0002\b\u0005>|G.Z1o\u0011!\t\t'HA\u0001\u0002\u0004!\u0018AB3rk\u0006d7\u000f\u0006\u0003\u0002x\u0005\r\u0005\u0002CA1=\u0005\u0005\t\u0019\u0001;)\u001f)\t9)!$\u0002\u0010\u0006M\u0015QSAM\u00037\u00032ALAE\u0013\r\tY\t\t\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\t\t*AAB\u0015\u0001\u0002\u0003\u0005I0G+:\u001bu\fK:ue&\u0002S\u0006\t*f[>4Xm\u001d\u0011uQ\u0016\u0004CO]1jY&tw\rI:qC\u000e,\u0007e\u00195be\u0006\u001cG/\u001a:tA\u0019\u0014x.\u001c\u0011agR\u0014\bM\f\u0006\u000bA\u0001\u0002\u0003e\u0018$V\u001d\u000e{\u0006\u0006\u001e:j[N#(\u000f\f\u0011tiJL\u0003%\f\u0011SK6|g/Z:!i\",\u0007\u0005\u001e:bS2Lgn\u001a\u0011tiJLgn\u001a\u0011xQ&\u001c\u0007\u000eI2p]R\f\u0017N\\:!i\",\u0007e\u00195be\u0006\u001cG/\u001a:tA\u0019\u0014x.\u001c\u0011uQ\u0016\u0004CO]5nAM$(/\u001b8hA\u0019\u0014x.\u001c\u0011uQ\u0016\u0004\u0003m\u001d;sA*\u0001\u0003%A\u0005be\u001e,X.\u001a8ug\u0006\u0012\u0011qS\u0001\u0002\u001e)\u0001\u0003\u0005\t\u0011Be\u001e,X.\u001a8ugjR\u0001\u0005\t\u0011!A\u0001R\u0003e\u001d;sA5\u0002\u0013\rI:ue&tw\rI3yaJ,7o]5p]*\u0001\u0003\u0005\t\u0011!A)\u0002CO]5n'R\u0014\b%\f\u0011uQ\u0016\u0004CO]5nAM$(/\u001b8hA\rD\u0017M]1di\u0016\u00148\u000f\t;pAQ\u0014\u0018.\u001c\u0017!i\",\u0007\u0005Z3gCVdG\u000f\t<bYV,\u0007%[:!C\u0002\u001a\u0018N\\4mK\u0002\u001a\b/Y2f\u0015\u0001\u0002\u0013\u0001C3yC6\u0004H.Z:\"\u0005\u0005u\u0015!!\u0004\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u001d\u0002\u0003\u0005\t\u0011Ta\u0006\u00148nU)MA\u0001\u0002s%K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!'B\f'o[*R\u0019*\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~Cs\u0005T)TC\u001eb\u0003eJ*Ta\u0006\u00148nU)M'\u001eJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005I*Ta\u0006\u00148N\u0003\u0011!\u0011\u0019\t\tk\u0001a\u0001\u0001\u0006\u00191\u000f\u001e:\t\u000b1\u001b\u0001\u0019\u0001!\u0015\u0007y\n9\u000b\u0003\u0004\u0002\"\u0012\u0001\r\u0001\u0011\u000b\u0006}\u0005-\u0016Q\u0016\u0005\u0006\u0013\u0016\u0001\r\u0001\u0011\u0005\b\u0019\u0016\u0001\n\u00111\u0001O\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012\u0012\u0014aB;oCB\u0004H.\u001f\u000b\u0005\u0003k\u000bi\f\u0005\u00033\u001f\u0006]\u0006#\u0002\u001a\u0002:\u0002s\u0015bAA^g\t1A+\u001e9mKJB\u0001\"a0\b\u0003\u0003\u0005\rAP\u0001\u0004q\u0012\u0002\u0014a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$#'A\u0006sK\u0006$'+Z:pYZ,GCAAd!\u0011\t)%!3\n\t\u0005-\u0017q\t\u0002\u0007\u001f\nTWm\u0019;")
public class StringTrimRight
extends Expression
implements String2TrimExpression,
scala.Serializable {
    private final Expression srcStr;
    private final Option<Expression> trimStr;

    public static Option<Expression> $lessinit$greater$default$2() {
        return StringTrimRight$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple2<Expression, Option<Expression>>> unapply(StringTrimRight stringTrimRight) {
        return StringTrimRight$.MODULE$.unapply(stringTrimRight);
    }

    public static Option<Expression> apply$default$2() {
        return StringTrimRight$.MODULE$.apply$default$2();
    }

    @Override
    public DataType dataType() {
        return String2TrimExpression.dataType$(this);
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return String2TrimExpression.inputTypes$(this);
    }

    @Override
    public boolean nullable() {
        return String2TrimExpression.nullable$(this);
    }

    @Override
    public boolean foldable() {
        return String2TrimExpression.foldable$(this);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public Expression srcStr() {
        return this.srcStr;
    }

    public Option<Expression> trimStr() {
        return this.trimStr;
    }

    @Override
    public String prettyName() {
        return "rtrim";
    }

    @Override
    public Seq<Expression> children() {
        List list;
        if (this.trimStr().isDefined()) {
            Expression expression = this.srcStr();
            Expression expression2 = (Expression)this.trimStr().get();
            list = Nil$.MODULE$.$colon$colon((Object)expression2).$colon$colon((Object)expression);
        } else {
            Expression expression = this.srcStr();
            list = Nil$.MODULE$.$colon$colon((Object)expression);
        }
        return list;
    }

    @Override
    public Object eval(InternalRow input) {
        UTF8String srcString = (UTF8String)this.srcStr().eval(input);
        return srcString == null ? null : (this.trimStr().isDefined() ? srcString.trimRight((UTF8String)((Expression)this.trimStr().get()).eval(input)) : srcString.trimRight());
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        ExprCode exprCode;
        Seq evals = (Seq)this.children().map((Function1 & Serializable & scala.Serializable)x$44 -> x$44.genCode(ctx), Seq$.MODULE$.canBuildFrom());
        ExprCode srcString = (ExprCode)evals.apply(0);
        if (evals.length() == 1) {
            exprCode = ev.copy(Block$.MODULE$.blocksToBlock((Seq<Block>)((Seq)((SeqLike)evals.map((Function1 & Serializable & scala.Serializable)x$45 -> x$45.code(), Seq$.MODULE$.canBuildFrom())).$colon$plus((Object)Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n        boolean ", " = false;\n        UTF8String ", " = null;\n        if (", ") {\n          ", " = true;\n        } else {\n          ", " = ", ".trimRight();\n        }"}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ev.isNull(), ev.value(), srcString.isNull(), ev.isNull(), ev.value(), srcString.value()})), Seq$.MODULE$.canBuildFrom()))), ev.copy$default$2(), ev.copy$default$3());
        } else {
            ExprCode trimString = (ExprCode)evals.apply(1);
            String getTrimRightFunction = new StringBuilder(89).append("\n        if (").append(trimString.isNull()).append(") {\n          ").append(ev.isNull()).append(" = true;\n        } else {\n          ").append(ev.value()).append(" = ").append(srcString.value()).append(".trimRight(").append(trimString.value()).append(");\n        }").toString();
            exprCode = ev.copy(Block$.MODULE$.blocksToBlock((Seq<Block>)((Seq)((SeqLike)evals.map((Function1 & Serializable & scala.Serializable)x$46 -> x$46.code(), Seq$.MODULE$.canBuildFrom())).$colon$plus((Object)Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n        boolean ", " = false;\n        UTF8String ", " = null;\n        if (", ") {\n          ", " = true;\n        } else {\n          ", "\n        }"}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ev.isNull(), ev.value(), srcString.isNull(), ev.isNull(), getTrimRightFunction})), Seq$.MODULE$.canBuildFrom()))), ev.copy$default$2(), ev.copy$default$3());
        }
        return exprCode;
    }

    public StringTrimRight copy(Expression srcStr, Option<Expression> trimStr) {
        return new StringTrimRight(srcStr, trimStr);
    }

    public Expression copy$default$1() {
        return this.srcStr();
    }

    public Option<Expression> copy$default$2() {
        return this.trimStr();
    }

    @Override
    public String productPrefix() {
        return "StringTrimRight";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Option<Expression> option;
        int n = x$1;
        switch (n) {
            case 0: {
                option = this.srcStr();
                break;
            }
            case 1: {
                option = this.trimStr();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return option;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof StringTrimRight;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof StringTrimRight)) return false;
        boolean bl = true;
        if (!bl) return false;
        StringTrimRight stringTrimRight = (StringTrimRight)x$1;
        Expression expression = this.srcStr();
        Expression expression2 = stringTrimRight.srcStr();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Option<Expression> option = this.trimStr();
        Option<Expression> option2 = stringTrimRight.trimStr();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!stringTrimRight.canEqual(this)) return false;
        return true;
    }

    public StringTrimRight(Expression srcStr, Option<Expression> trimStr) {
        this.srcStr = srcStr;
        this.trimStr = trimStr;
        ExpectsInputTypes.$init$(this);
        String2TrimExpression.$init$(this);
    }

    public StringTrimRight(Expression trimStr, Expression srcStr) {
        this(srcStr, (Option<Expression>)Option$.MODULE$.apply((Object)trimStr));
    }

    public StringTrimRight(Expression srcStr) {
        this(srcStr, (Option<Expression>)None$.MODULE$);
    }
}

