/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import com.fasterxml.jackson.core.JsonFactory;
import java.io.Serializable;
import java.util.TimeZone;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.JsonExprUtils$;
import org.apache.spark.sql.catalyst.expressions.JsonToStructs$;
import org.apache.spark.sql.catalyst.expressions.SpecializedGetters;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenFallback;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.json.CreateJacksonParser$;
import org.apache.spark.sql.catalyst.json.JSONOptions;
import org.apache.spark.sql.catalyst.json.JSONOptions$;
import org.apache.spark.sql.catalyst.json.JacksonParser;
import org.apache.spark.sql.catalyst.util.BadRecordException;
import org.apache.spark.sql.catalyst.util.FailFastMode$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(jsonStr, schema[, options]) - Returns a struct value with the given `jsonStr` and `schema`.", examples="\n    Examples:\n      > SELECT _FUNC_('{\"a\":1, \"b\":0.8}', 'a INT, b DOUBLE');\n       {\"a\":1, \"b\":0.8}\n      > SELECT _FUNC_('{\"time\":\"26/08/2015\"}', 'time Timestamp', map('timestampFormat', 'dd/MM/yyyy'));\n       {\"time\":\"2015-08-26 00:00:00.0\"}\n  ", since="2.2.0")
@ScalaSignature(bytes="\u0006\u0001\t]d\u0001\u0002\u00180\u0001rB\u0001B\u0016\u0001\u0003\u0016\u0004%\ta\u0016\u0005\t=\u0002\u0011\t\u0012)A\u00051\"Aq\f\u0001BK\u0002\u0013\u0005\u0001\r\u0003\u0005p\u0001\tE\t\u0015!\u0003b\u0011!\u0001\bA!f\u0001\n\u0003\t\b\u0002C;\u0001\u0005#\u0005\u000b\u0011\u0002:\t\u0011Y\u0004!Q3A\u0005\u0002]D\u0001b\u001f\u0001\u0003\u0012\u0003\u0006I\u0001\u001f\u0005\u0006y\u0002!\t! \u0005\n\u0003\u000f\u0001!\u0019!C\u0001\u0003\u0013A\u0001\"!\u0005\u0001A\u0003%\u00111\u0002\u0005\t\u0003'\u0001!\u0019!C\u0001/\"9\u0011Q\u0003\u0001!\u0002\u0013A\u0006bBA\f\u0001\u0011\u0005\u0013\u0011\u0002\u0005\u0007y\u0002!\t!!\u0007\t\rq\u0004A\u0011AA\u0011\u0011\u0019a\b\u0001\"\u0001\u0002(!9\u0011q\u0006\u0001\u0005B\u0005E\u0002BCA \u0001!\u0015\r\u0011\"\u0001\u0002B!Q\u0011\u0011\u0011\u0001\t\u0006\u0004%\t!a!\t\r\u0005M\u0005\u0001\"\u0011X\u0011\u001d\t)\n\u0001C!\u0003/Cq!a'\u0001\t\u0003\ni\nC\u0004\u0002(\u0002!\t%!+\t\rQ\u0002A\u0011IAZ\u0011%\t)\fAA\u0001\n\u0003\t9\fC\u0005\u0002B\u0002\t\n\u0011\"\u0001\u0002D\"I\u0011\u0011\u001c\u0001\u0012\u0002\u0013\u0005\u00111\u001c\u0005\n\u0003?\u0004\u0011\u0013!C\u0001\u0003CD\u0011\"!:\u0001#\u0003%\t!a:\t\u0013\u0005-\b!!A\u0005B\u00055\b\"CAz\u0001\u0005\u0005I\u0011AA{\u0011%\ti\u0010AA\u0001\n\u0003\ty\u0010C\u0005\u0003\u0006\u0001\t\t\u0011\"\u0011\u0003\b!I!Q\u0003\u0001\u0002\u0002\u0013\u0005!q\u0003\u0005\n\u00057\u0001\u0011\u0011!C!\u0005;9\u0011Ba\u000f0\u0003\u0003E\tA!\u0010\u0007\u00119z\u0013\u0011!E\u0001\u0005\u007fAa\u0001 \u0014\u0005\u0002\t5\u0003\"\u0003B(M\u0005\u0005IQ\tB)\u0011%\u0011\u0019FJA\u0001\n\u0003\u0013)\u0006C\u0005\u0003`\u0019\n\n\u0011\"\u0001\u0002h\"I!\u0011\r\u0014\u0002\u0002\u0013\u0005%1\r\u0005\n\u0005c2\u0013\u0013!C\u0001\u0003OD\u0011Ba\u001d'\u0003\u0003%IA!\u001e\u0003\u001b)\u001bxN\u001c+p'R\u0014Xo\u0019;t\u0015\t\u0001\u0014'A\u0006fqB\u0014Xm]:j_:\u001c(B\u0001\u001a4\u0003!\u0019\u0017\r^1msN$(B\u0001\u001b6\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003m]\nQa\u001d9be.T!\u0001O\u001d\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Q\u0014aA8sO\u000e\u00011c\u0002\u0001>\u0003\u0012SUj\u0015\t\u0003}}j\u0011aL\u0005\u0003\u0001>\u0012q\"\u00168bef,\u0005\u0010\u001d:fgNLwN\u001c\t\u0003}\tK!aQ\u0018\u0003/QKW.\u001a.p]\u0016\fu/\u0019:f\u000bb\u0004(/Z:tS>t\u0007CA#I\u001b\u00051%BA$0\u0003\u001d\u0019w\u000eZ3hK:L!!\u0013$\u0003\u001f\r{G-Z4f]\u001a\u000bG\u000e\u001c2bG.\u0004\"AP&\n\u00051{#!E#ya\u0016\u001cGo]%oaV$H+\u001f9fgB\u0011a*U\u0007\u0002\u001f*\t\u0001+A\u0003tG\u0006d\u0017-\u0003\u0002S\u001f\n9\u0001K]8ek\u000e$\bC\u0001(U\u0013\t)vJ\u0001\u0007TKJL\u0017\r\\5{C\ndW-\u0001\u0004tG\",W.Y\u000b\u00021B\u0011\u0011\fX\u0007\u00025*\u00111lM\u0001\u0006if\u0004Xm]\u0005\u0003;j\u0013\u0001\u0002R1uCRK\b/Z\u0001\bg\u000eDW-\\1!\u0003\u001dy\u0007\u000f^5p]N,\u0012!\u0019\t\u0005E&dGN\u0004\u0002dOB\u0011AmT\u0007\u0002K*\u0011amO\u0001\u0007yI|w\u000e\u001e \n\u0005!|\u0015A\u0002)sK\u0012,g-\u0003\u0002kW\n\u0019Q*\u00199\u000b\u0005!|\u0005C\u00012n\u0013\tq7N\u0001\u0004TiJLgnZ\u0001\t_B$\u0018n\u001c8tA\u0005)1\r[5mIV\t!\u000f\u0005\u0002?g&\u0011Ao\f\u0002\u000b\u000bb\u0004(/Z:tS>t\u0017AB2iS2$\u0007%\u0001\u0006uS6,'l\u001c8f\u0013\u0012,\u0012\u0001\u001f\t\u0004\u001dfd\u0017B\u0001>P\u0005\u0019y\u0005\u000f^5p]\u0006YA/[7f5>tW-\u00133!\u0003\u0019a\u0014N\\5u}QAap`A\u0001\u0003\u0007\t)\u0001\u0005\u0002?\u0001!)a+\u0003a\u00011\")q,\u0003a\u0001C\")\u0001/\u0003a\u0001e\"9a/\u0003I\u0001\u0002\u0004A\u0018a\u00054pe\u000e,g*\u001e7mC\ndWmU2iK6\fWCAA\u0006!\rq\u0015QB\u0005\u0004\u0003\u001fy%a\u0002\"p_2,\u0017M\\\u0001\u0015M>\u00148-\u001a(vY2\f'\r\\3TG\",W.\u0019\u0011\u0002\u001d9,H\u000e\\1cY\u0016\u001c6\r[3nC\u0006ya.\u001e7mC\ndWmU2iK6\f\u0007%\u0001\u0005ok2d\u0017M\u00197f)\u001dq\u00181DA\u000f\u0003?AQ\u0001]\bA\u0002IDQAV\bA\u0002IDQaX\bA\u0002\u0005$RA`A\u0012\u0003KAQ\u0001\u001d\tA\u0002IDQA\u0016\tA\u0002I$rA`A\u0015\u0003W\ti\u0003C\u0003q#\u0001\u0007!\u000fC\u0003W#\u0001\u0007!\u000fC\u0003`#\u0001\u0007!/A\ndQ\u0016\u001c7.\u00138qkR$\u0015\r^1UsB,7\u000f\u0006\u0002\u00024A!\u0011QGA\u001e\u001b\t\t9DC\u0002\u0002:E\n\u0001\"\u00198bYf\u001c\u0018n]\u0005\u0005\u0003{\t9DA\bUsB,7\t[3dWJ+7/\u001e7u\u0003%\u0019wN\u001c<feR,'/\u0006\u0002\u0002DA9a*!\u0012\u0002J\u0005\r\u0014bAA$\u001f\nIa)\u001e8di&|g.\r\t\u0007\u0003\u0017\n)&a\u0017\u000f\t\u00055\u0013\u0011\u000b\b\u0004I\u0006=\u0013\"\u0001)\n\u0007\u0005Ms*A\u0004qC\u000e\\\u0017mZ3\n\t\u0005]\u0013\u0011\f\u0002\u0004'\u0016\f(bAA*\u001fB!\u0011QLA0\u001b\u0005\t\u0014bAA1c\tY\u0011J\u001c;fe:\fGNU8x%\u0015\t)gUA5\r\u0019\t9\u0007\u0001\u0001\u0002d\taAH]3gS:,W.\u001a8u}A!\u00111NA;\u001b\t\tiG\u0003\u0003\u0002p\u0005E\u0014\u0001\u00027b]\u001eT!!a\u001d\u0002\t)\fg/Y\u0005\u0005\u0003o\niG\u0001\u0004PE*,7\r\u001e\u0015\u0004'\u0005m\u0004c\u0001(\u0002~%\u0019\u0011qP(\u0003\u0013Q\u0014\u0018M\\:jK:$\u0018A\u00029beN,'/\u0006\u0002\u0002\u0006B!\u0011qQAG\u001b\t\tIIC\u0002\u0002\fF\nAA[:p]&!\u0011qRAE\u00055Q\u0015mY6t_:\u0004\u0016M]:fe\"\u001aA#a\u001f\u0002\u0011\u0011\fG/\u0019+za\u0016\fAb^5uQRKW.\u001a.p]\u0016$2!QAM\u0011\u00151h\u00031\u0001m\u00031qW\u000f\u001c7TC\u001a,WI^1m)\u0011\ty*!*\u0011\u00079\u000b\t+C\u0002\u0002$>\u00131!\u00118z\u0011\u001d\tYi\u0006a\u0001\u0003?\u000b!\"\u001b8qkR$\u0016\u0010]3t+\t\tY\u000b\u0005\u0004\u0002L\u0005U\u0013Q\u0016\t\u00043\u0006=\u0016bAAY5\n\u0001\u0012IY:ue\u0006\u001cG\u000fR1uCRK\b/Z\u000b\u0002Y\u0006!1m\u001c9z)%q\u0018\u0011XA^\u0003{\u000by\fC\u0004W5A\u0005\t\u0019\u0001-\t\u000f}S\u0002\u0013!a\u0001C\"9\u0001O\u0007I\u0001\u0002\u0004\u0011\bb\u0002<\u001b!\u0003\u0005\r\u0001_\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\t)MK\u0002Y\u0003\u000f\\#!!3\u0011\t\u0005-\u0017Q[\u0007\u0003\u0003\u001bTA!a4\u0002R\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003'|\u0015AC1o]>$\u0018\r^5p]&!\u0011q[Ag\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\tiNK\u0002b\u0003\u000f\fabY8qs\u0012\"WMZ1vYR$3'\u0006\u0002\u0002d*\u001a!/a2\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%iU\u0011\u0011\u0011\u001e\u0016\u0004q\u0006\u001d\u0017!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002pB!\u00111NAy\u0013\rq\u0017QN\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003o\u00042ATA}\u0013\r\tYp\u0014\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003?\u0013\t\u0001C\u0005\u0003\u0004\u0005\n\t\u00111\u0001\u0002x\u0006\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"A!\u0003\u0011\r\t-!\u0011CAP\u001b\t\u0011iAC\u0002\u0003\u0010=\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0011\u0019B!\u0004\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003\u0017\u0011I\u0002C\u0005\u0003\u0004\r\n\t\u00111\u0001\u0002 \u00061Q-];bYN$B!a\u0003\u0003 !I!1\u0001\u0013\u0002\u0002\u0003\u0007\u0011q\u0014\u0015\u0010\u0001\t\r\"\u0011\u0006B\u0016\u0005_\u0011\tD!\u000e\u00038A\u0019aH!\n\n\u0007\t\u001drFA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\t5\u0012AY0G+:\u001bu\f\u000b6t_:\u001cFO\u001d\u0017!g\u000eDW-\\1\\Y\u0001z\u0007\u000f^5p]Nl\u0016\u0006I\u0017!%\u0016$XO\u001d8tA\u0005\u00043\u000f\u001e:vGR\u0004c/\u00197vK\u0002:\u0018\u000e\u001e5!i\",\u0007eZ5wK:\u0004\u0003M[:p]N#(\u000f\u0019\u0011b]\u0012\u0004\u0003m]2iK6\f\u0007ML\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012!1G\u0001\u0002p*\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~Cse\u001f\u0012bEi\nD\u0006\t\u0012cEi\u0002d\u0006O?(Y\u0001:\u0013\rI%O)2\u0002#\r\t#P+\ncUiJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!Am\u0014\u0013M\t\u001e2Y\u0001\u0012#M\t\u001e1]aj(\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK\u0014|EQLW.\u001a\u0012;EI2t\u0006\r\u001d0eA\nTGI?(Y\u0001:C/[7fAQKW.Z:uC6\u0004x\u0005\f\u0011nCBDs\u0005^5nKN$\u0018-\u001c9G_Jl\u0017\r^\u0014-A\u001d\"GmL'N_eL\u00180_\u0014*SmR\u0001\u0005\t\u0011!A\u0001\u00023P\t;j[\u0016\u0014#H\t\u001a1cUj\u0003\u0007O\u00173m\u0001\u0002\u0004G\u000f\u00191uA\u0002d\u0006\r\u0012~\u0015\u0001\u0002\u0013!B:j]\u000e,\u0017E\u0001B\u001d\u0003\u0015\u0011dF\r\u00181\u00035Q5o\u001c8U_N#(/^2ugB\u0011aHJ\n\u0005M\t\u00053\u000bE\u0005\u0003D\t%\u0003,\u0019:y}6\u0011!Q\t\u0006\u0004\u0005\u000fz\u0015a\u0002:v]RLW.Z\u0005\u0005\u0005\u0017\u0012)EA\tBEN$(/Y2u\rVt7\r^5p]R\"\"A!\u0010\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!a<\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0013y\u00149F!\u0017\u0003\\\tu\u0003\"\u0002,*\u0001\u0004A\u0006\"B0*\u0001\u0004\t\u0007\"\u00029*\u0001\u0004\u0011\bb\u0002<*!\u0003\u0005\r\u0001_\u0001\u0010CB\u0004H.\u001f\u0013eK\u001a\fW\u000f\u001c;%i\u00059QO\\1qa2LH\u0003\u0002B3\u0005[\u0002BAT=\u0003hA9aJ!\u001bYCJD\u0018b\u0001B6\u001f\n1A+\u001e9mKRB\u0001Ba\u001c,\u0003\u0003\u0005\rA`\u0001\u0004q\u0012\u0002\u0014a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$C'A\u0006sK\u0006$'+Z:pYZ,GCAA5\u0001")
public class JsonToStructs
extends UnaryExpression
implements TimeZoneAwareExpression,
CodegenFallback,
ExpectsInputTypes,
scala.Serializable {
    private transient Function1<Seq<InternalRow>, Object> converter;
    private transient JacksonParser parser;
    private final DataType schema;
    private final Map<String, String> options;
    private final Expression child;
    private final Option<String> timeZoneId;
    private final boolean forceNullableSchema;
    private final DataType nullableSchema;
    private boolean resolved;
    private transient TimeZone timeZone;
    private volatile boolean bitmap$0;
    private volatile transient byte bitmap$trans$0;

    public static Option<String> $lessinit$greater$default$4() {
        return JsonToStructs$.MODULE$.$lessinit$greater$default$4();
    }

    public static Option<Tuple4<DataType, Map<String, String>, Expression, Option<String>>> unapply(JsonToStructs jsonToStructs) {
        return JsonToStructs$.MODULE$.unapply(jsonToStructs);
    }

    public static Option<String> apply$default$4() {
        return JsonToStructs$.MODULE$.apply$default$4();
    }

    public static Function1<Tuple4<DataType, Map<String, String>, Expression, Option<String>>, JsonToStructs> tupled() {
        return JsonToStructs$.MODULE$.tupled();
    }

    public static Function1<DataType, Function1<Map<String, String>, Function1<Expression, Function1<Option<String>, JsonToStructs>>>> curried() {
        return JsonToStructs$.MODULE$.curried();
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return CodegenFallback.doGenCode$(this, ctx, ev);
    }

    private boolean resolved$lzycompute() {
        JsonToStructs jsonToStructs = this;
        synchronized (jsonToStructs) {
            if (!this.bitmap$0) {
                this.resolved = TimeZoneAwareExpression.resolved$(this);
                this.bitmap$0 = true;
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        return !this.bitmap$0 ? this.resolved$lzycompute() : this.resolved;
    }

    private TimeZone timeZone$lzycompute() {
        JsonToStructs jsonToStructs = this;
        synchronized (jsonToStructs) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                this.timeZone = TimeZoneAwareExpression.timeZone$(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
        }
        return this.timeZone;
    }

    @Override
    public TimeZone timeZone() {
        return (byte)(this.bitmap$trans$0 & 4) == 0 ? this.timeZone$lzycompute() : this.timeZone;
    }

    public DataType schema() {
        return this.schema;
    }

    public Map<String, String> options() {
        return this.options;
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public Option<String> timeZoneId() {
        return this.timeZoneId;
    }

    public boolean forceNullableSchema() {
        return this.forceNullableSchema;
    }

    public DataType nullableSchema() {
        return this.nullableSchema;
    }

    @Override
    public boolean nullable() {
        return true;
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        DataType dataType = this.nullableSchema();
        boolean bl = dataType instanceof StructType ? true : (dataType instanceof ArrayType ? true : dataType instanceof MapType);
        TypeCheckResult typeCheckResult = bl ? ExpectsInputTypes.checkInputDataTypes$(this) : new TypeCheckResult.TypeCheckFailure(new StringBuilder(50).append("Input schema ").append(this.nullableSchema().catalogString()).append(" must be a struct, an array or a map.").toString());
        return typeCheckResult;
    }

    private Function1<Seq<InternalRow>, Object> converter$lzycompute() {
        JsonToStructs jsonToStructs = this;
        synchronized (jsonToStructs) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                Function1 & Serializable & scala.Serializable intersect;
                DataType dataType = this.nullableSchema();
                if (dataType instanceof StructType) {
                    intersect = (Function1 & Serializable & scala.Serializable)rows -> rows.length() == 1 ? (InternalRow)rows.head() : null;
                } else if (dataType instanceof ArrayType) {
                    intersect = (Function1 & Serializable & scala.Serializable)rows -> ((SpecializedGetters)rows.head()).getArray(0);
                } else if (dataType instanceof MapType) {
                    intersect = (Function1 & Serializable & scala.Serializable)rows -> ((SpecializedGetters)rows.head()).getMap(0);
                } else {
                    throw new MatchError((Object)dataType);
                }
                this.converter = intersect;
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.converter;
    }

    public Function1<Seq<InternalRow>, Object> converter() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.converter$lzycompute() : this.converter;
    }

    private JacksonParser parser$lzycompute() {
        JsonToStructs jsonToStructs = this;
        synchronized (jsonToStructs) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.parser = new JacksonParser(this.nullableSchema(), new JSONOptions((Map<String, String>)this.options().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"mode"), (Object)FailFastMode$.MODULE$.name())), (String)this.timeZoneId().get(), JSONOptions$.MODULE$.$lessinit$greater$default$3()));
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.parser;
    }

    public JacksonParser parser() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.parser$lzycompute() : this.parser;
    }

    @Override
    public DataType dataType() {
        return this.nullableSchema();
    }

    @Override
    public TimeZoneAwareExpression withTimeZone(String timeZoneId) {
        Option x$1 = Option$.MODULE$.apply((Object)timeZoneId);
        DataType x$2 = this.copy$default$1();
        Map<String, String> x$3 = this.copy$default$2();
        Expression x$4 = this.copy$default$3();
        return this.copy(x$2, x$3, x$4, (Option<String>)x$1);
    }

    @Override
    public Object nullSafeEval(Object json) {
        Object object;
        if (json.toString().trim().isEmpty()) {
            return null;
        }
        try {
            object = this.converter().apply(this.parser().parse((UTF8String)json, (Function2 & Serializable & scala.Serializable)(jsonFactory, record) -> CreateJacksonParser$.MODULE$.utf8String((JsonFactory)jsonFactory, (UTF8String)record), (Function1 & Serializable & scala.Serializable)x -> (UTF8String)Predef$.MODULE$.identity(x)));
        }
        catch (BadRecordException badRecordException) {
            object = null;
        }
        return object;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        StringType$ stringType$ = StringType$.MODULE$;
        return Nil$.MODULE$.$colon$colon((Object)stringType$);
    }

    @Override
    public String sql() {
        DataType dataType = this.schema();
        String string = dataType instanceof MapType ? "entries" : super.sql();
        return string;
    }

    public JsonToStructs copy(DataType schema, Map<String, String> options, Expression child, Option<String> timeZoneId) {
        return new JsonToStructs(schema, options, child, timeZoneId);
    }

    public DataType copy$default$1() {
        return this.schema();
    }

    public Map<String, String> copy$default$2() {
        return this.options();
    }

    public Expression copy$default$3() {
        return this.child();
    }

    public Option<String> copy$default$4() {
        return this.timeZoneId();
    }

    @Override
    public String productPrefix() {
        return "JsonToStructs";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.schema();
                break;
            }
            case 1: {
                object = this.options();
                break;
            }
            case 2: {
                object = this.child();
                break;
            }
            case 3: {
                object = this.timeZoneId();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof JsonToStructs;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof JsonToStructs)) return false;
        boolean bl = true;
        if (!bl) return false;
        JsonToStructs jsonToStructs = (JsonToStructs)x$1;
        DataType dataType = this.schema();
        DataType dataType2 = jsonToStructs.schema();
        if (dataType == null) {
            if (dataType2 != null) {
                return false;
            }
        } else if (!dataType.equals(dataType2)) return false;
        Map<String, String> map = this.options();
        Map<String, String> map2 = jsonToStructs.options();
        if (map == null) {
            if (map2 != null) {
                return false;
            }
        } else if (!map.equals(map2)) return false;
        Expression expression = this.child();
        Expression expression2 = jsonToStructs.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Option<String> option = this.timeZoneId();
        Option<String> option2 = jsonToStructs.timeZoneId();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!jsonToStructs.canEqual(this)) return false;
        return true;
    }

    public JsonToStructs(DataType schema, Map<String, String> options, Expression child, Option<String> timeZoneId) {
        this.schema = schema;
        this.options = options;
        this.child = child;
        this.timeZoneId = timeZoneId;
        TimeZoneAwareExpression.$init$(this);
        CodegenFallback.$init$(this);
        ExpectsInputTypes.$init$(this);
        this.forceNullableSchema = BoxesRunTime.unboxToBoolean((Object)SQLConf$.MODULE$.get().getConf(SQLConf$.MODULE$.FROM_JSON_FORCE_NULLABLE_SCHEMA()));
        this.nullableSchema = this.forceNullableSchema() ? schema.asNullable() : schema;
    }

    public JsonToStructs(Expression child, Expression schema, Map<String, String> options) {
        this(JsonExprUtils$.MODULE$.evalSchemaExpr(schema), options, child, (Option<String>)None$.MODULE$);
    }

    public JsonToStructs(Expression child, Expression schema) {
        this(child, schema, (Map<String, String>)Predef$.MODULE$.Map().empty());
    }

    public JsonToStructs(Expression child, Expression schema, Expression options) {
        this(JsonExprUtils$.MODULE$.evalSchemaExpr(schema), JsonExprUtils$.MODULE$.convertToMapData(options), child, (Option<String>)None$.MODULE$);
    }
}

