/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import java.util.TimeZone;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes$class;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.JsonExprUtils$;
import org.apache.spark.sql.catalyst.expressions.JsonToStructs$;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression$class;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenFallback;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenFallback$class;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.json.CreateJacksonParser$;
import org.apache.spark.sql.catalyst.json.JSONOptions;
import org.apache.spark.sql.catalyst.json.JSONOptions$;
import org.apache.spark.sql.catalyst.json.JacksonParser;
import org.apache.spark.sql.catalyst.util.BadRecordException;
import org.apache.spark.sql.catalyst.util.FailFastMode$;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple5;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(jsonStr, schema[, options]) - Returns a struct value with the given `jsonStr` and `schema`.", examples="\n    Examples:\n      > SELECT _FUNC_('{\"a\":1, \"b\":0.8}', 'a INT, b DOUBLE');\n       {\"a\":1, \"b\":0.8}\n      > SELECT _FUNC_('{\"time\":\"26/08/2015\"}', 'time Timestamp', map('timestampFormat', 'dd/MM/yyyy'));\n       {\"time\":\"2015-08-26 00:00:00.0\"}\n  ", since="2.2.0")
@ScalaSignature(bytes="\u0006\u0001\t]e\u0001B\u0001\u0003\u0001>\u0011QBS:p]R{7\u000b\u001e:vGR\u001c(BA\u0002\u0005\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005\u00151\u0011\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005\u001dA\u0011aA:rY*\u0011\u0011BC\u0001\u0006gB\f'o\u001b\u0006\u0003\u00171\ta!\u00199bG\",'\"A\u0007\u0002\u0007=\u0014xm\u0001\u0001\u0014\u000f\u0001\u0001BcF\u000f!MA\u0011\u0011CE\u0007\u0002\u0005%\u00111C\u0001\u0002\u0010+:\f'/_#yaJ,7o]5p]B\u0011\u0011#F\u0005\u0003-\t\u0011q\u0003V5nKj{g.Z!xCJ,W\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u0005aYR\"A\r\u000b\u0005i\u0011\u0011aB2pI\u0016<WM\\\u0005\u00039e\u0011qbQ8eK\u001e,gNR1mY\n\f7m\u001b\t\u0003#yI!a\b\u0002\u0003#\u0015C\b/Z2ug&s\u0007/\u001e;UsB,7\u000f\u0005\u0002\"I5\t!EC\u0001$\u0003\u0015\u00198-\u00197b\u0013\t)#EA\u0004Qe>$Wo\u0019;\u0011\u0005\u0005:\u0013B\u0001\u0015#\u00051\u0019VM]5bY&T\u0018M\u00197f\u0011!Q\u0003A!f\u0001\n\u0003Y\u0013AB:dQ\u0016l\u0017-F\u0001-!\ti\u0003'D\u0001/\u0015\tyc!A\u0003usB,7/\u0003\u00022]\tAA)\u0019;b)f\u0004X\r\u0003\u00054\u0001\tE\t\u0015!\u0003-\u0003\u001d\u00198\r[3nC\u0002B\u0001\"\u000e\u0001\u0003\u0016\u0004%\tAN\u0001\b_B$\u0018n\u001c8t+\u00059\u0004\u0003\u0002\u001d<}yr!!I\u001d\n\u0005i\u0012\u0013A\u0002)sK\u0012,g-\u0003\u0002={\t\u0019Q*\u00199\u000b\u0005i\u0012\u0003C\u0001\u001d@\u0013\t\u0001UH\u0001\u0004TiJLgn\u001a\u0005\t\u0005\u0002\u0011\t\u0012)A\u0005o\u0005Aq\u000e\u001d;j_:\u001c\b\u0005\u0003\u0005E\u0001\tU\r\u0011\"\u0001F\u0003\u0015\u0019\u0007.\u001b7e+\u00051\u0005CA\tH\u0013\tA%A\u0001\u0006FqB\u0014Xm]:j_:D\u0001B\u0013\u0001\u0003\u0012\u0003\u0006IAR\u0001\u0007G\"LG\u000e\u001a\u0011\t\u00111\u0003!Q3A\u0005\u00025\u000b!\u0002^5nKj{g.Z%e+\u0005q\u0005cA\u0011P}%\u0011\u0001K\t\u0002\u0007\u001fB$\u0018n\u001c8\t\u0011I\u0003!\u0011#Q\u0001\n9\u000b1\u0002^5nKj{g.Z%eA!AA\u000b\u0001BK\u0002\u0013\u0005Q+A\ng_J\u001cWMT;mY\u0006\u0014G.Z*dQ\u0016l\u0017-F\u0001W!\t\ts+\u0003\u0002YE\t9!i\\8mK\u0006t\u0007\u0002\u0003.\u0001\u0005#\u0005\u000b\u0011\u0002,\u0002)\u0019|'oY3Ok2d\u0017M\u00197f'\u000eDW-\\1!\u0011\u0015a\u0006\u0001\"\u0001^\u0003\u0019a\u0014N\\5u}Q1al\u00181bE\u000e\u0004\"!\u0005\u0001\t\u000b)Z\u0006\u0019\u0001\u0017\t\u000bUZ\u0006\u0019A\u001c\t\u000b\u0011[\u0006\u0019\u0001$\t\u000b1[\u0006\u0019\u0001(\t\u000bQ[\u0006\u0019\u0001,\t\u000f\u0015\u0004!\u0019!C\u0001W\u0005qa.\u001e7mC\ndWmU2iK6\f\u0007BB4\u0001A\u0003%A&A\bok2d\u0017M\u00197f'\u000eDW-\\1!\u0011\u0015I\u0007\u0001\"\u0011V\u0003!qW\u000f\u001c7bE2,\u0007\"\u0002/\u0001\t\u0003YGc\u00010m[\")AI\u001ba\u0001\r\")!F\u001ba\u0001\r\")A\f\u0001C\u0001_R!a\f]9s\u0011\u0015!e\u000e1\u0001G\u0011\u0015Qc\u000e1\u0001G\u0011\u0015)d\u000e1\u0001G\u0011\u0015a\u0006\u0001\"\u0001u)\u0011qVO^<\t\u000b)\u001a\b\u0019\u0001\u0017\t\u000bU\u001a\b\u0019A\u001c\t\u000b\u0011\u001b\b\u0019\u0001$\t\u000be\u0004A\u0011\t>\u0002'\rDWmY6J]B,H\u000fR1uCRK\b/Z:\u0015\u0003m\u0004\"\u0001`@\u000e\u0003uT!A \u0003\u0002\u0011\u0005t\u0017\r\\=tSNL1!!\u0001~\u0005=!\u0016\u0010]3DQ\u0016\u001c7NU3tk2$\bBCA\u0003\u0001!\u0015\r\u0011\"\u0001\u0002\b\u0005I!o\\<TG\",W.Y\u000b\u0003\u0003\u0013\u00012!LA\u0006\u0013\r\tiA\f\u0002\u000b'R\u0014Xo\u0019;UsB,\u0007BCA\t\u0001!\u0005\t\u0015)\u0003\u0002\n\u0005Q!o\\<TG\",W.\u0019\u0011)\t\u0005=\u0011Q\u0003\t\u0004C\u0005]\u0011bAA\rE\tIAO]1og&,g\u000e\u001e\u0005\u000b\u0003;\u0001\u0001R1A\u0005\u0002\u0005}\u0011!C2p]Z,'\u000f^3s+\t\t\t\u0003E\u0004\"\u0003G\t9#a\u0012\n\u0007\u0005\u0015\"EA\u0005Gk:\u001cG/[8ocA1\u0011\u0011FA\u001d\u0003\u007fqA!a\u000b\u000269!\u0011QFA\u001a\u001b\t\tyCC\u0002\u000229\ta\u0001\u0010:p_Rt\u0014\"A\u0012\n\u0007\u0005]\"%A\u0004qC\u000e\\\u0017mZ3\n\t\u0005m\u0012Q\b\u0002\u0004'\u0016\f(bAA\u001cEA!\u0011\u0011IA\"\u001b\u0005!\u0011bAA#\t\tY\u0011J\u001c;fe:\fGNU8x%\u0015\tIEJA'\r\u0019\tY\u0005\u0001\u0001\u0002H\taAH]3gS:,W.\u001a8u}A\u0019\u0011#a\u0014\n\u0007\u0005E#A\u0001\nTa\u0016\u001c\u0017.\u00197ju\u0016$w)\u001a;uKJ\u001c\bBCA+\u0001!\u0005\t\u0015)\u0003\u0002\"\u0005Q1m\u001c8wKJ$XM\u001d\u0011)\t\u0005M\u0013Q\u0003\u0005\u000b\u00037\u0002\u0001R1A\u0005\u0002\u0005u\u0013A\u00029beN,'/\u0006\u0002\u0002`A!\u0011\u0011MA4\u001b\t\t\u0019GC\u0002\u0002f\u0011\tAA[:p]&!\u0011\u0011NA2\u00055Q\u0015mY6t_:\u0004\u0016M]:fe\"Q\u0011Q\u000e\u0001\t\u0002\u0003\u0006K!a\u0018\u0002\u000fA\f'o]3sA!\"\u00111NA\u000b\u0011\u0019\t\u0019\b\u0001C!W\u0005AA-\u0019;b)f\u0004X\rC\u0004\u0002x\u0001!\t%!\u001f\u0002\u0019]LG\u000f\u001b+j[\u0016TvN\\3\u0015\u0007Q\tY\b\u0003\u0004M\u0003k\u0002\rA\u0010\u0005\b\u0003\u007f\u0002A\u0011IAA\u00031qW\u000f\u001c7TC\u001a,WI^1m)\u0011\t\u0019)!#\u0011\u0007\u0005\n))C\u0002\u0002\b\n\u00121!\u00118z\u0011!\t)'! A\u0002\u0005\r\u0005bBAG\u0001\u0011\u0005\u0013qR\u0001\u000bS:\u0004X\u000f\u001e+za\u0016\u001cXCAAI!\u0019\tI#!\u000f\u0002\u0014B\u0019Q&!&\n\u0007\u0005]eF\u0001\tBEN$(/Y2u\t\u0006$\u0018\rV=qK\"I\u00111\u0014\u0001\u0002\u0002\u0013\u0005\u0011QT\u0001\u0005G>\u0004\u0018\u0010F\u0006_\u0003?\u000b\t+a)\u0002&\u0006\u001d\u0006\u0002\u0003\u0016\u0002\u001aB\u0005\t\u0019\u0001\u0017\t\u0011U\nI\n%AA\u0002]B\u0001\u0002RAM!\u0003\u0005\rA\u0012\u0005\t\u0019\u0006e\u0005\u0013!a\u0001\u001d\"AA+!'\u0011\u0002\u0003\u0007a\u000bC\u0005\u0002,\u0002\t\n\u0011\"\u0001\u0002.\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAAXU\ra\u0013\u0011W\u0016\u0003\u0003g\u0003B!!.\u0002@6\u0011\u0011q\u0017\u0006\u0005\u0003s\u000bY,A\u0005v]\u000eDWmY6fI*\u0019\u0011Q\u0018\u0012\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002B\u0006]&!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"I\u0011Q\u0019\u0001\u0012\u0002\u0013\u0005\u0011qY\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\tIMK\u00028\u0003cC\u0011\"!4\u0001#\u0003%\t!a4\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u0011\u0011\u001b\u0016\u0004\r\u0006E\u0006\"CAk\u0001E\u0005I\u0011AAl\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIQ*\"!!7+\u00079\u000b\t\fC\u0005\u0002^\u0002\t\n\u0011\"\u0001\u0002`\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012*TCAAqU\r1\u0016\u0011\u0017\u0005\n\u0003K\u0004\u0011\u0011!C!\u0003O\fQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAAu!\u0011\tY/!>\u000e\u0005\u00055(\u0002BAx\u0003c\fA\u0001\\1oO*\u0011\u00111_\u0001\u0005U\u00064\u0018-C\u0002A\u0003[D\u0011\"!?\u0001\u0003\u0003%\t!a?\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005u\bcA\u0011\u0002\u0000&\u0019!\u0011\u0001\u0012\u0003\u0007%sG\u000fC\u0005\u0003\u0006\u0001\t\t\u0011\"\u0001\u0003\b\u0005q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BAB\u0005\u0013A!Ba\u0003\u0003\u0004\u0005\u0005\t\u0019AA\u007f\u0003\rAH%\r\u0005\n\u0005\u001f\u0001\u0011\u0011!C!\u0005#\tq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0005'\u0001bA!\u0006\u0003\u001c\u0005\rUB\u0001B\f\u0015\r\u0011IBI\u0001\u000bG>dG.Z2uS>t\u0017\u0002\u0002B\u000f\u0005/\u0011\u0001\"\u0013;fe\u0006$xN\u001d\u0005\n\u0005C\u0001\u0011\u0011!C\u0001\u0005G\t\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0004-\n\u0015\u0002B\u0003B\u0006\u0005?\t\t\u00111\u0001\u0002\u0004\"I!\u0011\u0006\u0001\u0002\u0002\u0013\u0005#1F\u0001\u0007KF,\u0018\r\\:\u0015\u0007Y\u0013i\u0003\u0003\u0006\u0003\f\t\u001d\u0012\u0011!a\u0001\u0003\u0007Cs\u0002\u0001B\u0019\u0005o\u0011ID!\u0010\u0003@\t\r#Q\t\t\u0004#\tM\u0012b\u0001B\u001b\u0005\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017E\u0001B\u001e\u0003\t|f)\u0016(D?\"R7o\u001c8TiJd\u0003e]2iK6\f7\f\f\u0011paRLwN\\:^S\u0001j\u0003EU3ukJt7\u000fI1!gR\u0014Xo\u0019;!m\u0006dW/\u001a\u0011xSRD\u0007\u0005\u001e5fA\u001dLg/\u001a8!A*\u001cxN\\*ue\u0002\u0004\u0013M\u001c3!AN\u001c\u0007.Z7bA:\n\u0001\"\u001a=b[BdWm]\u0011\u0003\u0005\u0003\n\u0011q\u001e\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)Om\u0014\u0013M\t\u001e2Y\u0001\u0012#M\t\u001e1]ajx\u0005\f\u0011(C\u0002Je\n\u0016\u0017!E\u0002\"u*\u0016\"M\u000b\u001eJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005I>#C\nR\u0014\u0007\f\u0011#E\nR\u0004G\f\u001d~\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\":3P\t;j[\u0016\u0014#H\t\u001a7_ABtF\r\u00192k\tjx\u0005\f\u0011(i&lW\r\t+j[\u0016\u001cH/Y7qO1\u0002S.\u00199)OQLW.Z:uC6\u0004hi\u001c:nCR<C\u0006I\u0014eI>jUjL=zsf<\u0013&K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!w\n\"\u0018.\\3#u\t\u0012\u0004'M\u001b.aaj#G\u000e\u00111ai\u0002\u0004G\u000f\u00191]A\u0012SP\u0003\u0011!\u0003\u0015\u0019\u0018N\\2fC\t\u00119%A\u00033]Ir\u0003gB\u0005\u0003L\t\t\t\u0011#\u0001\u0003N\u0005i!j]8o)>\u001cFO];diN\u00042!\u0005B(\r!\t!!!A\t\u0002\tE3#\u0002B(\u0005'2\u0003C\u0003B+\u00057bsG\u0012(W=6\u0011!q\u000b\u0006\u0004\u00053\u0012\u0013a\u0002:v]RLW.Z\u0005\u0005\u0005;\u00129FA\tBEN$(/Y2u\rVt7\r^5p]VBq\u0001\u0018B(\t\u0003\u0011\t\u0007\u0006\u0002\u0003N!Q!Q\rB(\u0003\u0003%)Ea\u001a\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!!;\t\u0015\t-$qJA\u0001\n\u0003\u0013i'A\u0003baBd\u0017\u0010F\u0006_\u0005_\u0012\tHa\u001d\u0003v\t]\u0004B\u0002\u0016\u0003j\u0001\u0007A\u0006\u0003\u00046\u0005S\u0002\ra\u000e\u0005\u0007\t\n%\u0004\u0019\u0001$\t\r1\u0013I\u00071\u0001O\u0011\u0019!&\u0011\u000ea\u0001-\"Q!1\u0010B(\u0003\u0003%\tI! \u0002\u000fUt\u0017\r\u001d9msR!!q\u0010BD!\u0011\tsJ!!\u0011\u0011\u0005\u0012\u0019\tL\u001cG\u001dZK1A!\"#\u0005\u0019!V\u000f\u001d7fk!I!\u0011\u0012B=\u0003\u0003\u0005\rAX\u0001\u0004q\u0012\u0002\u0004B\u0003BG\u0005\u001f\n\t\u0011\"\u0003\u0003\u0010\u0006Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\u0011\t\n\u0005\u0003\u0002l\nM\u0015\u0002\u0002BK\u0003[\u0014aa\u00142kK\u000e$\b")
public class JsonToStructs
extends UnaryExpression
implements TimeZoneAwareExpression,
CodegenFallback,
ExpectsInputTypes,
Serializable {
    private final DataType schema;
    private final Map<String, String> options;
    private final Expression child;
    private final Option<String> timeZoneId;
    private final boolean forceNullableSchema;
    private final DataType nullableSchema;
    private transient StructType rowSchema;
    private transient Function1<Seq<InternalRow>, Serializable> converter;
    private transient JacksonParser parser;
    private final boolean resolved;
    private final transient TimeZone timeZone;
    private volatile transient byte bitmap$trans$0;
    private volatile boolean bitmap$0;

    public static Option<Tuple5<DataType, Map<String, String>, Expression, Option<String>, Object>> unapply(JsonToStructs jsonToStructs) {
        return JsonToStructs$.MODULE$.unapply(jsonToStructs);
    }

    public static Function1<Tuple5<DataType, Map<String, String>, Expression, Option<String>, Object>, JsonToStructs> tupled() {
        return JsonToStructs$.MODULE$.tupled();
    }

    public static Function1<DataType, Function1<Map<String, String>, Function1<Expression, Function1<Option<String>, Function1<Object, JsonToStructs>>>>> curried() {
        return JsonToStructs$.MODULE$.curried();
    }

    private StructType rowSchema$lzycompute() {
        JsonToStructs jsonToStructs = this;
        synchronized (jsonToStructs) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                StructType structType2;
                DataType dataType2 = this.nullableSchema();
                if (dataType2 instanceof StructType) {
                    StructType structType3;
                    structType2 = structType3 = (StructType)dataType2;
                } else {
                    StructType structType4;
                    ArrayType arrayType2;
                    DataType st;
                    if (!(dataType2 instanceof ArrayType) || !((st = (arrayType2 = (ArrayType)dataType2).elementType()) instanceof StructType)) {
                        throw new MatchError((Object)dataType2);
                    }
                    structType2 = structType4 = (StructType)st;
                }
                this.rowSchema = structType2;
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
            return this.rowSchema;
        }
    }

    private Function1 converter$lzycompute() {
        JsonToStructs jsonToStructs = this;
        synchronized (jsonToStructs) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                Object object;
                DataType dataType2 = this.nullableSchema();
                if (dataType2 instanceof StructType) {
                    object = new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final InternalRow apply(Seq<InternalRow> rows) {
                            return rows.length() == 1 ? (InternalRow)rows.head() : null;
                        }
                    };
                } else {
                    ArrayType arrayType2;
                    if (!(dataType2 instanceof ArrayType) || !((arrayType2 = (ArrayType)dataType2).elementType() instanceof StructType)) {
                        throw new MatchError((Object)dataType2);
                    }
                    object = new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final GenericArrayData apply(Seq<InternalRow> rows) {
                            return new GenericArrayData(rows);
                        }
                    };
                }
                this.converter = object;
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
            return this.converter;
        }
    }

    private JacksonParser parser$lzycompute() {
        JsonToStructs jsonToStructs = this;
        synchronized (jsonToStructs) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                this.parser = new JacksonParser(this.rowSchema(), new JSONOptions((Map<String, String>)this.options().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"mode"), (Object)FailFastMode$.MODULE$.name())), (String)this.timeZoneId().get(), JSONOptions$.MODULE$.$lessinit$greater$default$3()));
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
            return this.parser;
        }
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return CodegenFallback$class.doGenCode(this, ctx, ev);
    }

    private boolean resolved$lzycompute() {
        JsonToStructs jsonToStructs = this;
        synchronized (jsonToStructs) {
            if (!this.bitmap$0) {
                this.resolved = TimeZoneAwareExpression$class.resolved(this);
                this.bitmap$0 = true;
            }
            return this.resolved;
        }
    }

    @Override
    public boolean resolved() {
        return this.bitmap$0 ? this.resolved : this.resolved$lzycompute();
    }

    private TimeZone timeZone$lzycompute() {
        JsonToStructs jsonToStructs = this;
        synchronized (jsonToStructs) {
            if ((byte)(this.bitmap$trans$0 & 8) == 0) {
                this.timeZone = TimeZoneAwareExpression$class.timeZone(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 8);
            }
            return this.timeZone;
        }
    }

    @Override
    public TimeZone timeZone() {
        return (byte)(this.bitmap$trans$0 & 8) == 0 ? this.timeZone$lzycompute() : this.timeZone;
    }

    public DataType schema() {
        return this.schema;
    }

    public Map<String, String> options() {
        return this.options;
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public Option<String> timeZoneId() {
        return this.timeZoneId;
    }

    public boolean forceNullableSchema() {
        return this.forceNullableSchema;
    }

    public DataType nullableSchema() {
        return this.nullableSchema;
    }

    @Override
    public boolean nullable() {
        return true;
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        ArrayType arrayType2;
        DataType dataType2 = this.nullableSchema();
        boolean bl = dataType2 instanceof StructType ? true : dataType2 instanceof ArrayType && (arrayType2 = (ArrayType)dataType2).elementType() instanceof StructType;
        TypeCheckResult typeCheckResult = bl ? ExpectsInputTypes$class.checkInputDataTypes(this) : new TypeCheckResult.TypeCheckFailure(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Input schema ", " must be a struct or an array of structs."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.nullableSchema().simpleString()})));
        return typeCheckResult;
    }

    public StructType rowSchema() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.rowSchema$lzycompute() : this.rowSchema;
    }

    public Function1<Seq<InternalRow>, Serializable> converter() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.converter$lzycompute() : this.converter;
    }

    public JacksonParser parser() {
        return (byte)(this.bitmap$trans$0 & 4) == 0 ? this.parser$lzycompute() : this.parser;
    }

    @Override
    public DataType dataType() {
        return this.nullableSchema();
    }

    @Override
    public TimeZoneAwareExpression withTimeZone(String timeZoneId) {
        Option x$14 = Option$.MODULE$.apply((Object)timeZoneId);
        DataType x$15 = this.copy$default$1();
        Map<String, String> x$16 = this.copy$default$2();
        Expression x$17 = this.copy$default$3();
        boolean x$18 = this.copy$default$5();
        return this.copy(x$15, x$16, x$17, (Option<String>)x$14, x$18);
    }

    @Override
    public Object nullSafeEval(Object json) {
        Object object;
        if (json.toString().trim().isEmpty()) {
            return null;
        }
        try {
            object = this.converter().apply(this.parser().parse((UTF8String)json, new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final JsonParser apply(JsonFactory jsonFactory, UTF8String record) {
                    return CreateJacksonParser$.MODULE$.utf8String(jsonFactory, record);
                }
            }, new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final UTF8String apply(UTF8String x) {
                    return (UTF8String)Predef$.MODULE$.identity((Object)x);
                }
            }));
        }
        catch (BadRecordException badRecordException) {
            object = null;
        }
        return object;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        StringType$ stringType$ = StringType$.MODULE$;
        return Nil$.MODULE$.$colon$colon((Object)stringType$);
    }

    public JsonToStructs copy(DataType schema, Map<String, String> options, Expression child, Option<String> timeZoneId, boolean forceNullableSchema) {
        return new JsonToStructs(schema, options, child, timeZoneId, forceNullableSchema);
    }

    public DataType copy$default$1() {
        return this.schema();
    }

    public Map<String, String> copy$default$2() {
        return this.options();
    }

    public Expression copy$default$3() {
        return this.child();
    }

    public Option<String> copy$default$4() {
        return this.timeZoneId();
    }

    public boolean copy$default$5() {
        return this.forceNullableSchema();
    }

    @Override
    public String productPrefix() {
        return "JsonToStructs";
    }

    public int productArity() {
        return 5;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 4: {
                object = BoxesRunTime.boxToBoolean((boolean)this.forceNullableSchema());
                break;
            }
            case 3: {
                object = this.timeZoneId();
                break;
            }
            case 2: {
                object = this.child();
                break;
            }
            case 1: {
                object = this.options();
                break;
            }
            case 0: {
                object = this.schema();
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof JsonToStructs;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof JsonToStructs)) return false;
        boolean bl = true;
        if (!bl) return false;
        JsonToStructs jsonToStructs = (JsonToStructs)x$1;
        DataType dataType2 = this.schema();
        DataType dataType3 = jsonToStructs.schema();
        if (dataType2 == null) {
            if (dataType3 != null) {
                return false;
            }
        } else if (!dataType2.equals(dataType3)) return false;
        Map<String, String> map2 = this.options();
        Map<String, String> map3 = jsonToStructs.options();
        if (map2 == null) {
            if (map3 != null) {
                return false;
            }
        } else if (!map2.equals(map3)) return false;
        Expression expression = this.child();
        Expression expression2 = jsonToStructs.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Option<String> option = this.timeZoneId();
        Option<String> option2 = jsonToStructs.timeZoneId();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (this.forceNullableSchema() != jsonToStructs.forceNullableSchema()) return false;
        if (!jsonToStructs.canEqual(this)) return false;
        return true;
    }

    public JsonToStructs(DataType schema, Map<String, String> options, Expression child, Option<String> timeZoneId, boolean forceNullableSchema) {
        this.schema = schema;
        this.options = options;
        this.child = child;
        this.timeZoneId = timeZoneId;
        this.forceNullableSchema = forceNullableSchema;
        TimeZoneAwareExpression$class.$init$(this);
        CodegenFallback$class.$init$(this);
        ExpectsInputTypes$class.$init$(this);
        this.nullableSchema = forceNullableSchema ? schema.asNullable() : schema;
    }

    public JsonToStructs(Expression child, Expression schema) {
        this(JsonExprUtils$.MODULE$.validateSchemaLiteral(schema), (Map<String, String>)Predef$.MODULE$.Map().empty(), child, (Option<String>)None$.MODULE$, BoxesRunTime.unboxToBoolean((Object)SQLConf$.MODULE$.get().getConf(SQLConf$.MODULE$.FROM_JSON_FORCE_NULLABLE_SCHEMA())));
    }

    public JsonToStructs(Expression child, Expression schema, Expression options) {
        this(JsonExprUtils$.MODULE$.validateSchemaLiteral(schema), JsonExprUtils$.MODULE$.convertToMapData(options), child, (Option<String>)None$.MODULE$, BoxesRunTime.unboxToBoolean((Object)SQLConf$.MODULE$.get().getConf(SQLConf$.MODULE$.FROM_JSON_FORCE_NULLABLE_SCHEMA())));
    }

    public JsonToStructs(DataType schema, Map<String, String> options, Expression child) {
        this(schema, options, child, (Option<String>)None$.MODULE$, BoxesRunTime.unboxToBoolean((Object)SQLConf$.MODULE$.get().getConf(SQLConf$.MODULE$.FROM_JSON_FORCE_NULLABLE_SCHEMA())));
    }
}

