/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.cosid.algorithm.sharding.mod;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Properties;
import lombok.Generated;
import me.ahoo.cosid.sharding.ModCycle;
import org.apache.shardingsphere.sharding.api.sharding.standard.PreciseShardingValue;
import org.apache.shardingsphere.sharding.api.sharding.standard.RangeShardingValue;
import org.apache.shardingsphere.sharding.api.sharding.standard.StandardShardingAlgorithm;

public final class CosIdModShardingAlgorithm<T extends Number>
implements StandardShardingAlgorithm<T> {
    public static final String TYPE = "COSID_MOD";
    public static final String MODULO_KEY = "mod";
    private Properties props;
    private ModCycle<T> modCycle;

    public void init(Properties props) {
        this.props = props;
        String divisorStr = this.getRequiredValue(props, MODULO_KEY);
        int divisor = Integer.parseInt(divisorStr);
        String logicNamePrefix = this.getRequiredValue(props, "logic-name-prefix");
        this.modCycle = new ModCycle(divisor, logicNamePrefix);
    }

    private String getRequiredValue(Properties props, String key) {
        Preconditions.checkArgument((boolean)props.containsKey(key), (String)"%s can not be null.", (Object)key);
        return props.getProperty(key);
    }

    public String doSharding(Collection<String> availableTargetNames, PreciseShardingValue<T> shardingValue) {
        return this.modCycle.sharding((Number)((Object)shardingValue.getValue()));
    }

    public Collection<String> doSharding(Collection<String> availableTargetNames, RangeShardingValue<T> shardingValue) {
        return this.modCycle.sharding(shardingValue.getValueRange());
    }

    public String getType() {
        return TYPE;
    }

    @Generated
    public Properties getProps() {
        return this.props;
    }
}

