/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.cosid.algorithm.sharding.interval;

import com.google.common.base.Strings;
import java.time.LocalDateTime;
import java.util.Properties;
import me.ahoo.cosid.converter.Radix62IdConverter;
import me.ahoo.cosid.snowflake.MillisecondSnowflakeIdStateParser;
import me.ahoo.cosid.snowflake.SnowflakeIdStateParser;
import org.apache.shardingsphere.sharding.cosid.algorithm.keygen.CosIdSnowflakeKeyGenerateAlgorithm;
import org.apache.shardingsphere.sharding.cosid.algorithm.sharding.interval.AbstractCosIdIntervalShardingAlgorithm;

public final class CosIdSnowflakeIntervalShardingAlgorithm
extends AbstractCosIdIntervalShardingAlgorithm<Comparable<?>> {
    public static final String TYPE = "COSID_INTERVAL_SNOWFLAKE";
    public static final String EPOCH_KEY = "epoch";
    private SnowflakeIdStateParser snowflakeIdStateParser;

    @Override
    public void init(Properties props) {
        super.init(props);
        this.snowflakeIdStateParser = this.getSnowflakeIdStateParser(props);
    }

    private SnowflakeIdStateParser getSnowflakeIdStateParser(Properties props) {
        long epoch = Long.parseLong(props.getProperty(EPOCH_KEY, CosIdSnowflakeKeyGenerateAlgorithm.DEFAULT_EPOCH + ""));
        return new MillisecondSnowflakeIdStateParser(epoch, 41, 10, 12, this.getZoneId());
    }

    @Override
    protected LocalDateTime convertShardingValue(Comparable<?> shardingValue) {
        Long snowflakeId = this.convertToSnowflakeId(shardingValue);
        return this.snowflakeIdStateParser.parseTimestamp(snowflakeId.longValue());
    }

    private Long convertToSnowflakeId(Comparable<?> shardingValue) {
        if (shardingValue instanceof Long) {
            return (Long)shardingValue;
        }
        if (shardingValue instanceof String) {
            String shardingValueStr = (String)((Object)shardingValue);
            return Radix62IdConverter.PAD_START.asLong(shardingValueStr);
        }
        throw new IllegalArgumentException(Strings.lenientFormat((String)"The current shard type:[%s] is not supported!", (Object[])new Object[]{shardingValue.getClass()}));
    }

    public String getType() {
        return TYPE;
    }
}

