/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.cosid.algorithm.keygen;

import java.util.Properties;
import lombok.Generated;
import me.ahoo.cosid.provider.LazyIdGenerator;
import org.apache.shardingsphere.sharding.spi.KeyGenerateAlgorithm;

public final class CosIdKeyGenerateAlgorithm
implements KeyGenerateAlgorithm {
    public static final String TYPE = "cosid".toUpperCase();
    public static final String AS_STRING_KEY = "as-string";
    private Properties props;
    private LazyIdGenerator lazyIdGenerator;
    private boolean asString;

    public void init(Properties props) {
        this.props = props;
        this.lazyIdGenerator = new LazyIdGenerator(props.getProperty("id-name", "__share__"));
        this.asString = Boolean.parseBoolean(props.getProperty(AS_STRING_KEY, Boolean.FALSE.toString()));
        this.lazyIdGenerator.tryGet(false);
    }

    public Comparable<?> generateKey() {
        if (this.asString) {
            return this.lazyIdGenerator.generateAsString();
        }
        return this.lazyIdGenerator.generate();
    }

    public String getType() {
        return TYPE;
    }

    @Generated
    public Properties getProps() {
        return this.props;
    }
}

