/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.api.config.rule;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import lombok.Generated;
import org.apache.shardingsphere.sharding.api.config.strategy.keygen.KeyGenerateStrategyConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.ShardingStrategyConfiguration;

public final class ShardingAutoTableRuleConfiguration {
    private final String logicTable;
    private final String actualDataSources;
    private String replaceTablePrefix;
    private ShardingStrategyConfiguration shardingStrategy;
    private KeyGenerateStrategyConfiguration keyGenerateStrategy;

    public ShardingAutoTableRuleConfiguration(String logicTable) {
        this(logicTable, null);
    }

    public ShardingAutoTableRuleConfiguration(String logicTable, String actualDataSources) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)logicTable) ? 1 : 0) != 0, (Object)"LogicTable is required.");
        this.logicTable = logicTable;
        this.actualDataSources = actualDataSources;
    }

    @Generated
    public String getLogicTable() {
        return this.logicTable;
    }

    @Generated
    public String getActualDataSources() {
        return this.actualDataSources;
    }

    @Generated
    public String getReplaceTablePrefix() {
        return this.replaceTablePrefix;
    }

    @Generated
    public ShardingStrategyConfiguration getShardingStrategy() {
        return this.shardingStrategy;
    }

    @Generated
    public KeyGenerateStrategyConfiguration getKeyGenerateStrategy() {
        return this.keyGenerateStrategy;
    }

    @Generated
    public void setReplaceTablePrefix(String replaceTablePrefix) {
        this.replaceTablePrefix = replaceTablePrefix;
    }

    @Generated
    public void setShardingStrategy(ShardingStrategyConfiguration shardingStrategy) {
        this.shardingStrategy = shardingStrategy;
    }

    @Generated
    public void setKeyGenerateStrategy(KeyGenerateStrategyConfiguration keyGenerateStrategy) {
        this.keyGenerateStrategy = keyGenerateStrategy;
    }
}

