/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shadow.distsql.handler.update;

import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.shardingsphere.distsql.parser.segment.AlgorithmSegment;
import org.apache.shardingsphere.infra.config.RuleConfiguration;
import org.apache.shardingsphere.infra.config.algorithm.ShardingSphereAlgorithmConfiguration;
import org.apache.shardingsphere.infra.distsql.exception.DistSQLException;
import org.apache.shardingsphere.infra.distsql.exception.rule.DuplicateRuleException;
import org.apache.shardingsphere.infra.distsql.exception.rule.InvalidAlgorithmConfigurationException;
import org.apache.shardingsphere.infra.distsql.update.RuleDefinitionCreateUpdater;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.shadow.api.config.ShadowRuleConfiguration;
import org.apache.shardingsphere.shadow.distsql.handler.checker.ShadowRuleStatementChecker;
import org.apache.shardingsphere.shadow.distsql.parser.segment.ShadowAlgorithmSegment;
import org.apache.shardingsphere.shadow.distsql.parser.statement.CreateShadowAlgorithmStatement;
import org.apache.shardingsphere.shadow.factory.ShadowAlgorithmFactory;

public final class CreateShadowAlgorithmStatementUpdater
implements RuleDefinitionCreateUpdater<CreateShadowAlgorithmStatement, ShadowRuleConfiguration> {
    private static final String SHADOW = "shadow";

    public RuleConfiguration buildToBeCreatedRuleConfiguration(CreateShadowAlgorithmStatement sqlStatement) {
        ShadowRuleConfiguration result = new ShadowRuleConfiguration();
        result.setShadowAlgorithms(this.buildAlgorithmMap(sqlStatement));
        return result;
    }

    private Map<String, ShardingSphereAlgorithmConfiguration> buildAlgorithmMap(CreateShadowAlgorithmStatement sqlStatement) {
        return sqlStatement.getAlgorithms().stream().collect(Collectors.toMap(ShadowAlgorithmSegment::getAlgorithmName, each -> new ShardingSphereAlgorithmConfiguration(each.getAlgorithmSegment().getName(), each.getAlgorithmSegment().getProps())));
    }

    public void updateCurrentRuleConfiguration(ShadowRuleConfiguration currentRuleConfig, ShadowRuleConfiguration toBeAlteredRuleConfig) {
        currentRuleConfig.getShadowAlgorithms().putAll(toBeAlteredRuleConfig.getShadowAlgorithms());
    }

    public void checkSQLStatement(ShardingSphereDatabase database, CreateShadowAlgorithmStatement sqlStatement, ShadowRuleConfiguration currentRuleConfig) throws DistSQLException {
        ShadowRuleStatementChecker.checkAlgorithmCompleteness(sqlStatement.getAlgorithms());
        this.checkDuplicatedInput(database.getName(), sqlStatement);
        this.checkExist(database.getName(), sqlStatement, currentRuleConfig);
        this.checkAlgorithmType(sqlStatement);
    }

    private void checkAlgorithmType(CreateShadowAlgorithmStatement sqlStatement) throws DistSQLException {
        Collection notExistedShadowAlgorithms = sqlStatement.getAlgorithms().stream().map(ShadowAlgorithmSegment::getAlgorithmSegment).map(AlgorithmSegment::getName).filter(each -> !ShadowAlgorithmFactory.contains((String)each)).collect(Collectors.toList());
        DistSQLException.predictionThrow((boolean)notExistedShadowAlgorithms.isEmpty(), () -> new InvalidAlgorithmConfigurationException(SHADOW, notExistedShadowAlgorithms));
    }

    private void checkDuplicatedInput(String databaseName, CreateShadowAlgorithmStatement sqlStatement) throws DistSQLException {
        Collection requireAlgorithmNames = sqlStatement.getAlgorithms().stream().map(ShadowAlgorithmSegment::getAlgorithmName).collect(Collectors.toList());
        ShadowRuleStatementChecker.checkAnyDuplicate(requireAlgorithmNames, duplicated -> new DuplicateRuleException(SHADOW, databaseName, duplicated));
    }

    private void checkExist(String databaseName, CreateShadowAlgorithmStatement sqlStatement, ShadowRuleConfiguration currentRuleConfig) throws DistSQLException {
        if (null == currentRuleConfig) {
            return;
        }
        Collection requireAlgorithmNames = sqlStatement.getAlgorithms().stream().map(ShadowAlgorithmSegment::getAlgorithmName).collect(Collectors.toList());
        ShadowRuleStatementChecker.checkAnyDuplicate(requireAlgorithmNames, currentRuleConfig.getShadowAlgorithms().keySet(), different -> new DuplicateRuleException(SHADOW, databaseName, different));
    }

    public Class<ShadowRuleConfiguration> getRuleConfigurationClass() {
        return ShadowRuleConfiguration.class;
    }

    public String getType() {
        return CreateShadowAlgorithmStatement.class.getName();
    }
}

