/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shadow.distsql.handler.converter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.algorithm.ShardingSphereAlgorithmConfiguration;
import org.apache.shardingsphere.shadow.api.config.ShadowRuleConfiguration;
import org.apache.shardingsphere.shadow.api.config.datasource.ShadowDataSourceConfiguration;
import org.apache.shardingsphere.shadow.api.config.table.ShadowTableConfiguration;
import org.apache.shardingsphere.shadow.distsql.handler.supporter.ShadowRuleStatementSupporter;
import org.apache.shardingsphere.shadow.distsql.parser.segment.ShadowAlgorithmSegment;
import org.apache.shardingsphere.shadow.distsql.parser.segment.ShadowRuleSegment;

public final class ShadowRuleStatementConverter {
    public static ShadowRuleConfiguration convert(Collection<ShadowRuleSegment> rules) {
        ShadowRuleConfiguration result = new ShadowRuleConfiguration();
        result.setShadowAlgorithms(ShadowRuleStatementConverter.getShadowAlgorithms(rules));
        result.setDataSources(ShadowRuleStatementConverter.getDataSource(rules));
        result.setTables(ShadowRuleStatementConverter.getTables(rules));
        return result;
    }

    private static Map<String, ShadowTableConfiguration> getTables(Collection<ShadowRuleSegment> rules) {
        HashMap<String, ShadowTableConfiguration> result = new HashMap<String, ShadowTableConfiguration>();
        rules.forEach(each -> {
            Map<String, ShadowTableConfiguration> currentRuleTableConfig = each.getShadowTableRules().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ShadowRuleStatementConverter.buildShadowTableConfiguration(each.getRuleName(), entry), ShadowRuleStatementSupporter::mergeConfiguration));
            currentRuleTableConfig.forEach((key, value) -> result.merge((String)key, (ShadowTableConfiguration)value, ShadowRuleStatementSupporter::mergeConfiguration));
        });
        return result;
    }

    private static ShadowTableConfiguration buildShadowTableConfiguration(String ruleName, Map.Entry<String, Collection<ShadowAlgorithmSegment>> entry) {
        return new ShadowTableConfiguration(new ArrayList<String>(Collections.singleton(ruleName)), (Collection)entry.getValue().stream().map(ShadowAlgorithmSegment::getAlgorithmName).collect(Collectors.toList()));
    }

    private static Map<String, ShadowDataSourceConfiguration> getDataSource(Collection<ShadowRuleSegment> rules) {
        return rules.stream().collect(Collectors.toMap(ShadowRuleSegment::getRuleName, each -> new ShadowDataSourceConfiguration(each.getSource(), each.getShadow())));
    }

    private static Map<String, ShardingSphereAlgorithmConfiguration> getShadowAlgorithms(Collection<ShadowRuleSegment> rules) {
        return rules.stream().flatMap(each -> each.getShadowTableRules().values().stream()).flatMap(Collection::stream).collect(Collectors.toMap(ShadowAlgorithmSegment::getAlgorithmName, ShadowRuleStatementConverter::buildAlgorithmConfiguration));
    }

    private static ShardingSphereAlgorithmConfiguration buildAlgorithmConfiguration(ShadowAlgorithmSegment segment) {
        return new ShardingSphereAlgorithmConfiguration(segment.getAlgorithmSegment().getName(), segment.getAlgorithmSegment().getProps());
    }

    @Generated
    private ShadowRuleStatementConverter() {
    }
}

