/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.spring.boot.datasource;

import com.google.common.base.Preconditions;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.naming.NamingException;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.infra.exception.ShardingSphereException;
import org.apache.shardingsphere.sharding.support.InlineExpressionParser;
import org.apache.shardingsphere.spring.boot.datasource.prop.impl.DataSourcePropertiesSetterHolder;
import org.apache.shardingsphere.spring.boot.util.DataSourceUtil;
import org.apache.shardingsphere.spring.boot.util.PropertyUtil;
import org.springframework.core.env.Environment;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.jndi.JndiObjectFactoryBean;
import org.springframework.util.StringUtils;

public final class DataSourceMapSetter {
    private static final String PREFIX = "spring.shardingsphere.datasource.";
    private static final String DATA_SOURCE_NAME = "name";
    private static final String DATA_SOURCE_NAMES = "names";
    private static final String DATA_SOURCE_TYPE = "type";
    private static final String JNDI_NAME = "jndi-name";

    public static Map<String, DataSource> getDataSourceMap(Environment environment) {
        LinkedHashMap<String, DataSource> result = new LinkedHashMap<String, DataSource>();
        for (String each : DataSourceMapSetter.getDataSourceNames(environment)) {
            try {
                result.put(each, DataSourceMapSetter.getDataSource(environment, each));
            }
            catch (ReflectiveOperationException ex) {
                throw new ShardingSphereException("Can't find data source type.", (Exception)ex);
            }
            catch (NamingException ex) {
                throw new ShardingSphereException("Can't find JNDI data source.", (Exception)ex);
            }
        }
        return result;
    }

    private static List<String> getDataSourceNames(Environment environment) {
        StandardEnvironment standardEnv = (StandardEnvironment)environment;
        standardEnv.setIgnoreUnresolvableNestedPlaceholders(true);
        String dataSourceNames = standardEnv.getProperty("spring.shardingsphere.datasource.name");
        if (StringUtils.isEmpty((Object)dataSourceNames)) {
            dataSourceNames = standardEnv.getProperty("spring.shardingsphere.datasource.names");
        }
        return new InlineExpressionParser(dataSourceNames).splitAndEvaluate();
    }

    private static DataSource getDataSource(Environment environment, String dataSourceName) throws ReflectiveOperationException, NamingException {
        Map dataSourceProps = PropertyUtil.handle(environment, String.join((CharSequence)"", PREFIX, dataSourceName), Map.class);
        Preconditions.checkState((!dataSourceProps.isEmpty() ? 1 : 0) != 0, (String)"Wrong datasource [%s] properties.", (Object)dataSourceName);
        if (dataSourceProps.containsKey(JNDI_NAME)) {
            return DataSourceMapSetter.getJNDIDataSource(dataSourceProps.get(JNDI_NAME).toString());
        }
        DataSource result = DataSourceUtil.getDataSource(dataSourceProps.get(DATA_SOURCE_TYPE).toString(), dataSourceProps);
        DataSourcePropertiesSetterHolder.getDataSourcePropertiesSetterByType(dataSourceProps.get(DATA_SOURCE_TYPE).toString()).ifPresent(propsSetter -> propsSetter.propertiesSet(environment, PREFIX, dataSourceName, result));
        return result;
    }

    private static DataSource getJNDIDataSource(String jndiName) throws NamingException {
        JndiObjectFactoryBean bean = new JndiObjectFactoryBean();
        bean.setResourceRef(true);
        bean.setJndiName(jndiName);
        bean.setProxyInterface(DataSource.class);
        bean.afterPropertiesSet();
        return (DataSource)bean.getObject();
    }

    @Generated
    private DataSourceMapSetter() {
    }
}

