/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.route.engine.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import javax.sql.DataSource;
import org.apache.shardingsphere.infra.binder.LogicSQL;
import org.apache.shardingsphere.infra.binder.statement.CommonSQLStatementContext;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.exception.ShardingSphereException;
import org.apache.shardingsphere.infra.hint.HintManager;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.route.SQLRouter;
import org.apache.shardingsphere.infra.route.SQLRouterFactory;
import org.apache.shardingsphere.infra.route.context.RouteContext;
import org.apache.shardingsphere.infra.route.context.RouteMapper;
import org.apache.shardingsphere.infra.route.context.RouteUnit;
import org.apache.shardingsphere.infra.route.engine.SQLRouteExecutor;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;

public final class PartialSQLRouteExecutor
implements SQLRouteExecutor {
    private final ConfigurationProperties props;
    private final Map<ShardingSphereRule, SQLRouter> routers;

    public PartialSQLRouteExecutor(Collection<ShardingSphereRule> rules, ConfigurationProperties props) {
        this.props = props;
        this.routers = SQLRouterFactory.getInstances(rules);
    }

    @Override
    public RouteContext route(LogicSQL logicSQL, ShardingSphereDatabase database) {
        RouteContext result = new RouteContext();
        Optional<String> dataSourceName = this.findDataSourceByHint(logicSQL.getSqlStatementContext(), database.getResource().getDataSources());
        if (dataSourceName.isPresent()) {
            result.getRouteUnits().add(new RouteUnit(new RouteMapper(dataSourceName.get(), dataSourceName.get()), Collections.emptyList()));
            return result;
        }
        for (Map.Entry<ShardingSphereRule, SQLRouter> entry : this.routers.entrySet()) {
            if (result.getRouteUnits().isEmpty()) {
                result = entry.getValue().createRouteContext(logicSQL, database, entry.getKey(), this.props);
                continue;
            }
            entry.getValue().decorateRouteContext(result, logicSQL, database, entry.getKey(), this.props);
        }
        if (result.getRouteUnits().isEmpty() && 1 == database.getResource().getDataSources().size()) {
            String singleDataSourceName = (String)database.getResource().getDataSources().keySet().iterator().next();
            result.getRouteUnits().add(new RouteUnit(new RouteMapper(singleDataSourceName, singleDataSourceName), Collections.emptyList()));
        }
        return result;
    }

    private Optional<String> findDataSourceByHint(SQLStatementContext<?> sqlStatementContext, Map<String, DataSource> dataSources) {
        Optional result = HintManager.isInstantiated() && HintManager.getDataSourceName().isPresent() ? HintManager.getDataSourceName() : ((CommonSQLStatementContext)sqlStatementContext).findHintDataSourceName();
        if (result.isPresent() && !dataSources.containsKey(result.get())) {
            throw new ShardingSphereException("Hint datasource: %s is not exist!", new Object[]{result.get()});
        }
        return result;
    }
}

