/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.rewrite.parameter.builder.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import lombok.Generated;
import org.apache.shardingsphere.infra.rewrite.parameter.builder.ParameterBuilder;

public final class StandardParameterBuilder
implements ParameterBuilder {
    private final List<Object> originalParameters;
    private final Map<Integer, Collection<Object>> addedIndexAndParameters = new TreeMap<Integer, Collection<Object>>();
    private final Map<Integer, Object> replacedIndexAndParameters = new LinkedHashMap<Integer, Object>();

    public void addAddedParameters(int index, Collection<Object> parameters) {
        this.addedIndexAndParameters.put(index, parameters);
    }

    public void addReplacedParameters(int index, Object parameter) {
        this.replacedIndexAndParameters.put(index, parameter);
    }

    @Override
    public List<Object> getParameters() {
        ArrayList<Object> replacedParameters = new ArrayList<Object>(this.originalParameters);
        for (Map.Entry<Integer, Object> entry : this.replacedIndexAndParameters.entrySet()) {
            replacedParameters.set(entry.getKey(), entry.getValue());
        }
        int maxParameterIndex = this.getMaxParameterIndex(this.originalParameters, this.addedIndexAndParameters);
        LinkedList<Object> result = new LinkedList<Object>();
        for (int index = 0; index <= maxParameterIndex; ++index) {
            LinkedList<Object> currentIndexParameters = new LinkedList<Object>();
            if (replacedParameters.size() > index) {
                currentIndexParameters.add(replacedParameters.get(index));
            }
            if (this.addedIndexAndParameters.containsKey(index)) {
                currentIndexParameters.addAll(this.addedIndexAndParameters.get(index));
            }
            result.addAll(currentIndexParameters);
        }
        return result;
    }

    private int getMaxParameterIndex(List<Object> originalParameters, Map<Integer, Collection<Object>> addedIndexAndParameters) {
        if (addedIndexAndParameters.isEmpty()) {
            return originalParameters.size() - 1;
        }
        return Math.max(originalParameters.size() - 1, (Integer)((TreeMap)addedIndexAndParameters).descendingMap().firstKey());
    }

    @Generated
    public StandardParameterBuilder(List<Object> originalParameters) {
        this.originalParameters = originalParameters;
    }

    @Generated
    public Map<Integer, Collection<Object>> getAddedIndexAndParameters() {
        return this.addedIndexAndParameters;
    }
}

