/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.rewrite.sql.token.pojo.generic;

import com.google.common.base.Strings;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.segment.select.projection.impl.ColumnProjection;
import org.apache.shardingsphere.infra.rewrite.sql.token.pojo.RouteUnitAware;
import org.apache.shardingsphere.infra.rewrite.sql.token.pojo.SQLToken;
import org.apache.shardingsphere.infra.rewrite.sql.token.pojo.Substitutable;
import org.apache.shardingsphere.infra.route.context.RouteMapper;
import org.apache.shardingsphere.infra.route.context.RouteUnit;
import org.apache.shardingsphere.sql.parser.sql.common.constant.QuoteCharacter;

public final class SubstitutableColumnNameToken
extends SQLToken
implements Substitutable,
RouteUnitAware {
    private static final String COLUMN_NAME_SPLITTER = ", ";
    private final int stopIndex;
    private final Collection<ColumnProjection> projections;
    private final boolean lastColumn;
    private final QuoteCharacter quoteCharacter;

    public SubstitutableColumnNameToken(int startIndex, int stopIndex, Collection<ColumnProjection> projections) {
        super(startIndex);
        this.stopIndex = stopIndex;
        this.lastColumn = false;
        this.quoteCharacter = QuoteCharacter.NONE;
        this.projections = projections;
    }

    public SubstitutableColumnNameToken(int startIndex, int stopIndex, Collection<ColumnProjection> projections, boolean lastColumn) {
        super(startIndex);
        this.stopIndex = stopIndex;
        this.lastColumn = lastColumn;
        this.quoteCharacter = QuoteCharacter.NONE;
        this.projections = projections;
    }

    public SubstitutableColumnNameToken(int startIndex, int stopIndex, Collection<ColumnProjection> projections, QuoteCharacter quoteCharacter) {
        super(startIndex);
        this.stopIndex = stopIndex;
        this.lastColumn = false;
        this.quoteCharacter = quoteCharacter;
        this.projections = projections;
    }

    @Override
    public String toString(RouteUnit routeUnit) {
        Map<String, String> logicAndActualTables = this.getLogicAndActualTables(routeUnit);
        StringBuilder builder = this.lastColumn ? new StringBuilder(COLUMN_NAME_SPLITTER) : new StringBuilder();
        for (ColumnProjection each : this.projections) {
            builder.append(this.getColumnName(each, logicAndActualTables)).append(COLUMN_NAME_SPLITTER);
        }
        return builder.substring(0, builder.length() - COLUMN_NAME_SPLITTER.length());
    }

    private Map<String, String> getLogicAndActualTables(RouteUnit routeUnit) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (RouteMapper each : routeUnit.getTableMappers()) {
            result.put(each.getLogicName(), each.getActualName());
        }
        return result;
    }

    private String getColumnName(ColumnProjection columnProjection, Map<String, String> logicActualTableNames) {
        StringBuilder builder = new StringBuilder();
        String owner = columnProjection.getOwner();
        if (!Strings.isNullOrEmpty((String)owner)) {
            builder.append(this.quoteCharacter.wrap(logicActualTableNames.getOrDefault(owner, owner))).append(".");
        }
        builder.append(this.quoteCharacter.wrap(columnProjection.getName()));
        if (columnProjection.getAlias().isPresent()) {
            builder.append(" AS ").append(this.quoteCharacter.wrap((String)columnProjection.getAlias().get()));
        }
        return builder.toString();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SubstitutableColumnNameToken)) {
            return false;
        }
        SubstitutableColumnNameToken other = (SubstitutableColumnNameToken)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getStopIndex() != other.getStopIndex()) {
            return false;
        }
        if (this.lastColumn != other.lastColumn) {
            return false;
        }
        Collection<ColumnProjection> this$projections = this.projections;
        Collection<ColumnProjection> other$projections = other.projections;
        if (this$projections == null ? other$projections != null : !((Object)this$projections).equals(other$projections)) {
            return false;
        }
        QuoteCharacter this$quoteCharacter = this.quoteCharacter;
        QuoteCharacter other$quoteCharacter = other.quoteCharacter;
        return !(this$quoteCharacter == null ? other$quoteCharacter != null : !this$quoteCharacter.equals(other$quoteCharacter));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SubstitutableColumnNameToken;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getStopIndex();
        result = result * 59 + (this.lastColumn ? 79 : 97);
        Collection<ColumnProjection> $projections = this.projections;
        result = result * 59 + ($projections == null ? 43 : ((Object)$projections).hashCode());
        QuoteCharacter $quoteCharacter = this.quoteCharacter;
        result = result * 59 + ($quoteCharacter == null ? 43 : $quoteCharacter.hashCode());
        return result;
    }

    @Override
    @Generated
    public int getStopIndex() {
        return this.stopIndex;
    }
}

