/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.rewrite.sql.token.generator.generic;

import java.util.Collection;
import java.util.LinkedList;
import java.util.stream.Collectors;
import org.apache.shardingsphere.infra.binder.segment.table.TablesContext;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.type.RemoveAvailable;
import org.apache.shardingsphere.infra.binder.type.TableAvailable;
import org.apache.shardingsphere.infra.rewrite.sql.token.generator.CollectionSQLTokenGenerator;
import org.apache.shardingsphere.infra.rewrite.sql.token.pojo.generic.RemoveToken;
import org.apache.shardingsphere.sql.parser.sql.common.segment.SQLSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.OwnerSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SimpleTableSegment;

public final class RemoveTokenGenerator
implements CollectionSQLTokenGenerator<SQLStatementContext<?>> {
    public boolean isGenerateSQLToken(SQLStatementContext sqlStatementContext) {
        boolean containsRemoveSegment = false;
        if (sqlStatementContext instanceof RemoveAvailable) {
            containsRemoveSegment = !((RemoveAvailable)sqlStatementContext).getRemoveSegments().isEmpty();
        }
        boolean containsSchemaName = false;
        if (sqlStatementContext instanceof TableAvailable) {
            TablesContext tablesContext = ((TableAvailable)sqlStatementContext).getTablesContext();
            containsSchemaName = tablesContext.getDatabaseName().isPresent() || !tablesContext.getSchemaNames().isEmpty();
        }
        return containsRemoveSegment || containsSchemaName;
    }

    @Override
    public Collection<RemoveToken> generateSQLTokens(SQLStatementContext sqlStatementContext) {
        LinkedList<RemoveToken> result = new LinkedList<RemoveToken>();
        if (sqlStatementContext instanceof RemoveAvailable && !((RemoveAvailable)sqlStatementContext).getRemoveSegments().isEmpty()) {
            result.addAll(this.generateRemoveAvailableSQLTokens(((RemoveAvailable)sqlStatementContext).getRemoveSegments()));
        }
        if (sqlStatementContext instanceof TableAvailable && (((TableAvailable)sqlStatementContext).getTablesContext().getDatabaseName().isPresent() || !((TableAvailable)sqlStatementContext).getTablesContext().getSchemaNames().isEmpty())) {
            result.addAll(this.generateTableAvailableSQLTokens((TableAvailable)sqlStatementContext));
        }
        return result;
    }

    private Collection<RemoveToken> generateRemoveAvailableSQLTokens(Collection<SQLSegment> removeSegments) {
        return removeSegments.stream().map(each -> new RemoveToken(each.getStartIndex(), each.getStopIndex())).collect(Collectors.toList());
    }

    private Collection<RemoveToken> generateTableAvailableSQLTokens(TableAvailable tableAvailable) {
        LinkedList<RemoveToken> result = new LinkedList<RemoveToken>();
        for (SimpleTableSegment each : tableAvailable.getAllTables()) {
            if (!each.getOwner().isPresent()) continue;
            OwnerSegment owner = (OwnerSegment)each.getOwner().get();
            int startIndex = owner.getOwner().isPresent() ? ((OwnerSegment)owner.getOwner().get()).getStartIndex() : owner.getStartIndex();
            result.add(new RemoveToken(startIndex, each.getTableName().getStartIndex() - 1));
        }
        return result;
    }
}

