/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.rewrite.sql.token.generator;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.metadata.schema.ShardingSphereSchema;
import org.apache.shardingsphere.infra.rewrite.sql.token.generator.CollectionSQLTokenGenerator;
import org.apache.shardingsphere.infra.rewrite.sql.token.generator.OptionalSQLTokenGenerator;
import org.apache.shardingsphere.infra.rewrite.sql.token.generator.SQLTokenGenerator;
import org.apache.shardingsphere.infra.rewrite.sql.token.generator.aware.ParametersAware;
import org.apache.shardingsphere.infra.rewrite.sql.token.generator.aware.PreviousSQLTokensAware;
import org.apache.shardingsphere.infra.rewrite.sql.token.generator.aware.SchemaMetaDataAware;
import org.apache.shardingsphere.infra.rewrite.sql.token.pojo.SQLToken;

public final class SQLTokenGenerators {
    private final Map<Class<?>, SQLTokenGenerator> sqlTokenGenerators = new LinkedHashMap();

    public void addAll(Collection<SQLTokenGenerator> sqlTokenGenerators) {
        for (SQLTokenGenerator each : sqlTokenGenerators) {
            if (this.sqlTokenGenerators.containsKey(each.getClass())) continue;
            this.sqlTokenGenerators.put(each.getClass(), each);
        }
    }

    public List<SQLToken> generateSQLTokens(SQLStatementContext sqlStatementContext, List<Object> parameters, ShardingSphereSchema schema) {
        LinkedList<SQLToken> result = new LinkedList<SQLToken>();
        for (SQLTokenGenerator each : this.sqlTokenGenerators.values()) {
            this.setUpSQLTokenGenerator(each, parameters, schema, result);
            if (each instanceof OptionalSQLTokenGenerator) {
                SQLToken sqlToken = ((OptionalSQLTokenGenerator)each).generateSQLToken(sqlStatementContext);
                if (result.contains(sqlToken)) continue;
                result.add(sqlToken);
                continue;
            }
            if (!(each instanceof CollectionSQLTokenGenerator)) continue;
            result.addAll(((CollectionSQLTokenGenerator)each).generateSQLTokens(sqlStatementContext));
        }
        return result;
    }

    private void setUpSQLTokenGenerator(SQLTokenGenerator sqlTokenGenerator, List<Object> parameters, ShardingSphereSchema schema, List<SQLToken> previousSQLTokens) {
        if (sqlTokenGenerator instanceof ParametersAware) {
            ((ParametersAware)((Object)sqlTokenGenerator)).setParameters(parameters);
        }
        if (sqlTokenGenerator instanceof SchemaMetaDataAware) {
            ((SchemaMetaDataAware)((Object)sqlTokenGenerator)).setSchema(schema);
        }
        if (sqlTokenGenerator instanceof PreviousSQLTokensAware) {
            ((PreviousSQLTokensAware)((Object)sqlTokenGenerator)).setPreviousSQLTokens(previousSQLTokens);
        }
    }
}

