/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.rewrite;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.metadata.schema.ShardingSphereSchema;
import org.apache.shardingsphere.infra.rewrite.context.SQLRewriteContext;
import org.apache.shardingsphere.infra.rewrite.context.SQLRewriteContextDecorator;
import org.apache.shardingsphere.infra.rewrite.engine.GenericSQLRewriteEngine;
import org.apache.shardingsphere.infra.rewrite.engine.RouteSQLRewriteEngine;
import org.apache.shardingsphere.infra.rewrite.engine.result.SQLRewriteResult;
import org.apache.shardingsphere.infra.route.context.RouteContext;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.spi.ShardingSphereServiceLoader;
import org.apache.shardingsphere.spi.ordered.OrderedSPIRegistry;

public final class SQLRewriteEntry {
    private final String schemaName;
    private final ShardingSphereSchema schema;
    private final ConfigurationProperties props;
    private final Map<ShardingSphereRule, SQLRewriteContextDecorator> decorators;

    public SQLRewriteEntry(String schemaName, ShardingSphereSchema schema, ConfigurationProperties props, Collection<ShardingSphereRule> rules) {
        this.schemaName = schemaName;
        this.schema = schema;
        this.props = props;
        this.decorators = OrderedSPIRegistry.getRegisteredServices(SQLRewriteContextDecorator.class, rules);
    }

    public SQLRewriteResult rewrite(String sql, List<Object> parameters, SQLStatementContext<?> sqlStatementContext, RouteContext routeContext) {
        SQLRewriteContext sqlRewriteContext = this.createSQLRewriteContext(sql, parameters, sqlStatementContext, routeContext);
        return routeContext.getRouteUnits().isEmpty() ? new GenericSQLRewriteEngine().rewrite(sqlRewriteContext) : new RouteSQLRewriteEngine().rewrite(sqlRewriteContext, routeContext);
    }

    private SQLRewriteContext createSQLRewriteContext(String sql, List<Object> parameters, SQLStatementContext<?> sqlStatementContext, RouteContext routeContext) {
        SQLRewriteContext result = new SQLRewriteContext(this.schemaName, this.schema, sqlStatementContext, sql, parameters);
        this.decorate(this.decorators, result, routeContext);
        result.generateSQLTokens();
        return result;
    }

    private void decorate(Map<ShardingSphereRule, SQLRewriteContextDecorator> decorators, SQLRewriteContext sqlRewriteContext, RouteContext routeContext) {
        for (Map.Entry<ShardingSphereRule, SQLRewriteContextDecorator> entry : decorators.entrySet()) {
            entry.getValue().decorate(entry.getKey(), this.props, sqlRewriteContext, routeContext);
        }
    }

    static {
        ShardingSphereServiceLoader.register(SQLRewriteContextDecorator.class);
    }
}

