/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.executor.sql.federate.original.sql;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.infra.executor.sql.context.ExecutionContext;
import org.apache.shardingsphere.infra.executor.sql.context.ExecutionUnit;
import org.apache.shardingsphere.infra.executor.sql.context.SQLUnit;
import org.apache.shardingsphere.infra.executor.sql.federate.original.sql.FilterableSQLGenerator;
import org.apache.shardingsphere.infra.executor.sql.federate.original.sql.RouteContextFilter;
import org.apache.shardingsphere.infra.executor.sql.federate.original.table.FilterableTableScanContext;
import org.apache.shardingsphere.infra.optimize.metadata.FederationTableMetaData;
import org.apache.shardingsphere.infra.route.context.RouteContext;
import org.apache.shardingsphere.infra.route.context.RouteMapper;
import org.apache.shardingsphere.infra.route.context.RouteUnit;
import org.apache.shardingsphere.sql.parser.sql.common.constant.QuoteCharacter;

public final class FilterableExecutionContextGenerator {
    private final ExecutionContext routeExecutionContext;
    private final QuoteCharacter quoteCharacter;

    public ExecutionContext generate(FederationTableMetaData tableMetaData, FilterableTableScanContext scanContext) {
        RouteContext filteredRouteContext = new RouteContextFilter().filter(tableMetaData.getName(), this.routeExecutionContext.getRouteContext());
        return new ExecutionContext(this.routeExecutionContext.getLogicSQL(), this.generate(filteredRouteContext.getRouteUnits(), tableMetaData, scanContext, this.quoteCharacter), filteredRouteContext);
    }

    private Collection<ExecutionUnit> generate(Collection<RouteUnit> routeUnits, FederationTableMetaData tableMetaData, FilterableTableScanContext scanContext, QuoteCharacter quoteCharacter) {
        LinkedHashSet<ExecutionUnit> result = new LinkedHashSet<ExecutionUnit>();
        FilterableSQLGenerator sqlGenerator = new FilterableSQLGenerator(tableMetaData, scanContext, quoteCharacter);
        for (RouteUnit each : routeUnits) {
            result.addAll(this.generate(each, sqlGenerator));
        }
        return result;
    }

    private Collection<ExecutionUnit> generate(RouteUnit routeUnit, FilterableSQLGenerator sqlGenerator) {
        return routeUnit.getTableMappers().stream().map(each -> this.generate(routeUnit, (RouteMapper)each, sqlGenerator)).collect(Collectors.toList());
    }

    private ExecutionUnit generate(RouteUnit routeUnit, RouteMapper tableMapper, FilterableSQLGenerator sqlGenerator) {
        String sql = sqlGenerator.generate(tableMapper.getActualName());
        return new ExecutionUnit(routeUnit.getDataSourceMapper().getActualName(), new SQLUnit(sql, Collections.emptyList(), Collections.singletonList(tableMapper)));
    }

    @Generated
    public FilterableExecutionContextGenerator(ExecutionContext routeExecutionContext, QuoteCharacter quoteCharacter) {
        this.routeExecutionContext = routeExecutionContext;
        this.quoteCharacter = quoteCharacter;
    }
}

