/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.statement.ddl;

import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.segment.table.TablesContext;
import org.apache.shardingsphere.infra.binder.statement.CommonSQLStatementContext;
import org.apache.shardingsphere.infra.binder.type.IndexAvailable;
import org.apache.shardingsphere.infra.binder.type.TableAvailable;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.index.IndexSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.DropIndexStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.handler.ddl.DropIndexStatementHandler;

public final class DropIndexStatementContext
extends CommonSQLStatementContext<DropIndexStatement>
implements TableAvailable,
IndexAvailable {
    private final TablesContext tablesContext;

    public DropIndexStatementContext(DropIndexStatement sqlStatement) {
        super(sqlStatement);
        SimpleTableSegment simpleTableSegment = DropIndexStatementHandler.getSimpleTableSegment((DropIndexStatement)sqlStatement).orElse(null);
        this.tablesContext = new TablesContext(simpleTableSegment, this.getDatabaseType());
    }

    @Override
    public Collection<SimpleTableSegment> getAllTables() {
        Optional simpleTableSegment = DropIndexStatementHandler.getSimpleTableSegment((DropIndexStatement)((DropIndexStatement)this.getSqlStatement()));
        return simpleTableSegment.map(Collections::singletonList).orElseGet(Collections::emptyList);
    }

    @Override
    public Collection<IndexSegment> getIndexes() {
        return ((DropIndexStatement)this.getSqlStatement()).getIndexes();
    }

    @Override
    @Generated
    public TablesContext getTablesContext() {
        return this.tablesContext;
    }
}

