/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.authentication.consumer;

import java.security.PrivateKey;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.servicecomb.authentication.RSAAuthenticationToken;
import org.apache.servicecomb.foundation.common.utils.RSAUtils;
import org.apache.servicecomb.foundation.token.RSAKeypair4Auth;
import org.apache.servicecomb.registry.RegistrationManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RSAConsumerTokenManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(RSAConsumerTokenManager.class);
    private Object lock = new Object();
    private RSAAuthenticationToken token;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getToken() {
        if (this.isExpired(this.token)) {
            Object object = this.lock;
            synchronized (object) {
                if (this.isExpired(this.token)) {
                    return this.createToken();
                }
            }
        }
        return this.token.format();
    }

    public String createToken() {
        PrivateKey privateKey = RSAKeypair4Auth.INSTANCE.getPrivateKey();
        String instanceId = RegistrationManager.INSTANCE.getMicroserviceInstance().getInstanceId();
        String serviceId = RegistrationManager.INSTANCE.getMicroservice().getServiceId();
        if (instanceId == null || serviceId == null) {
            LOGGER.error("service not ready when create token.");
            return null;
        }
        String randomCode = RandomStringUtils.randomAlphanumeric((int)128);
        long generateTime = System.currentTimeMillis();
        try {
            String plain = String.format("%s@%s@%s@%s", instanceId, serviceId, generateTime, randomCode);
            String sign = RSAUtils.sign((String)plain, (PrivateKey)privateKey);
            this.token = RSAAuthenticationToken.fromStr(String.format("%s@%s", plain, sign));
        }
        catch (Exception e) {
            LOGGER.error("create token error", (Throwable)e);
            return null;
        }
        return this.token.format();
    }

    public boolean isExpired(RSAAuthenticationToken token) {
        if (null == token) {
            return true;
        }
        long generateTime = token.getGenerateTime();
        long expiredDate = generateTime + 86400000L - 900000L;
        long now = System.currentTimeMillis();
        return now > expiredDate;
    }
}

