/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.provider.db.generic;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.sentry.core.common.ActiveRoleSet;
import org.apache.sentry.core.common.Authorizable;
import org.apache.sentry.core.common.exception.SentryConfigurationException;
import org.apache.sentry.provider.common.CacheProvider;
import org.apache.sentry.provider.common.ProviderBackend;
import org.apache.sentry.provider.common.ProviderBackendContext;
import org.apache.sentry.provider.common.TableCache;
import org.apache.sentry.provider.db.generic.UpdatableCache;
import org.apache.sentry.provider.db.generic.service.thrift.SentryGenericServiceClient;
import org.apache.sentry.provider.db.generic.service.thrift.SentryGenericServiceClientFactory;
import org.apache.sentry.provider.db.generic.service.thrift.TSentryRole;
import org.apache.sentry.provider.db.generic.tools.command.TSentryPrivilegeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SentryGenericProviderBackend
extends CacheProvider
implements ProviderBackend {
    private static final Logger LOGGER = LoggerFactory.getLogger(SentryGenericProviderBackend.class);
    private final Configuration conf;
    private volatile boolean initialized = false;
    private String componentType;
    private String serviceName;
    private boolean enableCaching;
    private String privilegeConverter;

    public SentryGenericProviderBackend(Configuration conf, String resource) throws Exception {
        this.conf = conf;
        this.enableCaching = conf.getBoolean("sentry.provider.backend.generic.cache.enabled", false);
        this.privilegeConverter = conf.get("sentry.provider.backend.generic.privilege.converter");
    }

    public void initialize(ProviderBackendContext context) {
        if (this.initialized) {
            throw new IllegalStateException("SentryGenericProviderBackend has already been initialized, cannot be initialized twice");
        }
        if (this.enableCaching) {
            TSentryPrivilegeConverter sentryPrivilegeConverter;
            if (this.privilegeConverter == null) {
                throw new SentryConfigurationException("sentry.provider.backend.generic.privilege.converter not configured.");
            }
            try {
                Constructor<?> privilegeConverterConstructor = Class.forName(this.privilegeConverter).getDeclaredConstructor(String.class, String.class);
                privilegeConverterConstructor.setAccessible(true);
                sentryPrivilegeConverter = (TSentryPrivilegeConverter)privilegeConverterConstructor.newInstance(this.getComponentType(), this.getServiceName());
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException("Failed to create privilege converter of type " + this.privilegeConverter, e);
            }
            UpdatableCache cache = new UpdatableCache(this.conf, this.getComponentType(), this.getServiceName(), sentryPrivilegeConverter);
            try {
                cache.startUpdateThread(true);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to get privileges from Sentry to build cache.", e);
            }
            super.initialize((TableCache)cache);
        }
        this.initialized = true;
    }

    private SentryGenericServiceClient getClient() throws Exception {
        return SentryGenericServiceClientFactory.create((Configuration)this.conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImmutableSet<String> getPrivileges(Set<String> groups, ActiveRoleSet roleSet, Authorizable ... authorizableHierarchy) {
        if (!this.initialized) {
            throw new IllegalStateException("SentryGenericProviderBackend has not been properly initialized");
        }
        if (this.enableCaching) {
            return super.getPrivileges(groups, roleSet, authorizableHierarchy);
        }
        try (SentryGenericServiceClient client = null;){
            client = this.getClient();
            ImmutableSet immutableSet = ImmutableSet.copyOf((Collection)client.listPrivilegesForProvider(this.componentType, this.serviceName, roleSet, groups, Arrays.asList(authorizableHierarchy)));
            return immutableSet;
        }
        return ImmutableSet.of();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImmutableSet<String> getRoles(Set<String> groups, ActiveRoleSet roleSet) {
        if (!this.initialized) {
            throw new IllegalStateException("SentryGenericProviderBackend has not been properly initialized");
        }
        if (this.enableCaching) {
            return super.getRoles(groups, roleSet);
        }
        try (SentryGenericServiceClient client = null;){
            HashSet tRoles = Sets.newHashSet();
            client = this.getClient();
            String requestor = UserGroupInformation.getCurrentUser().getShortUserName();
            for (String group : groups) {
                tRoles.addAll(client.listRolesByGroupName(requestor, group, this.getComponentType()));
            }
            HashSet roles = Sets.newHashSet();
            for (TSentryRole tRole : tRoles) {
                roles.add(tRole.getRoleName());
            }
            ImmutableSet immutableSet = ImmutableSet.copyOf((Collection)(roleSet.isAll() ? roles : Sets.intersection((Set)roles, (Set)roleSet.getRoles())));
            return immutableSet;
        }
        return ImmutableSet.of();
    }

    public void validatePolicy(boolean strictValidation) throws SentryConfigurationException {
        if (!this.initialized) {
            throw new IllegalStateException("SentryGenericProviderBackend has not been properly initialized");
        }
    }

    public ImmutableSet<String> getPrivileges(Set<String> groups, Set<String> users, ActiveRoleSet roleSet, Authorizable ... authorizableHierarchy) {
        return this.getPrivileges(groups, roleSet, new Authorizable[0]);
    }

    public void close() {
    }

    public void setComponentType(String componentType) {
        this.componentType = componentType;
    }

    public String getComponentType() {
        return this.componentType;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }
}

