/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.provider.db;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.sentry.core.common.ActiveRoleSet;
import org.apache.sentry.core.common.Authorizable;
import org.apache.sentry.core.common.exception.SentryConfigurationException;
import org.apache.sentry.provider.common.ProviderBackend;
import org.apache.sentry.provider.common.ProviderBackendContext;
import org.apache.sentry.provider.db.service.thrift.SentryPolicyServiceClient;
import org.apache.sentry.service.thrift.SentryServiceClientFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleDBProviderBackend
implements ProviderBackend {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleDBProviderBackend.class);
    private Configuration conf;
    private int retryCount;
    private int retryIntervalSec;

    public SimpleDBProviderBackend(Configuration conf, String resourcePath) throws Exception {
        this(conf);
    }

    public SimpleDBProviderBackend(Configuration conf) throws Exception {
        this.conf = conf;
        this.retryCount = conf.getInt("sentry.provider.backend.db.retry.count", 3);
        this.retryIntervalSec = conf.getInt("sentry.provider.backend.db.retry.interval.seconds", 30);
    }

    public void initialize(ProviderBackendContext context) {
    }

    public ImmutableSet<String> getPrivileges(Set<String> groups, ActiveRoleSet roleSet, Authorizable ... authorizableHierarchy) {
        return this.getPrivileges(groups, null, roleSet, authorizableHierarchy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImmutableSet<String> getPrivileges(Set<String> groups, Set<String> users, ActiveRoleSet roleSet, Authorizable ... authorizableHierarchy) {
        int retries = Math.max(this.retryCount + 1, 1);
        while (retries > 0) {
            --retries;
            SentryPolicyServiceClient policyServiceClient = null;
            try {
                policyServiceClient = SentryServiceClientFactory.create((Configuration)this.conf);
                ImmutableSet immutableSet = ImmutableSet.copyOf((Collection)policyServiceClient.listPrivilegesForProvider(groups, users, roleSet, authorizableHierarchy));
                return immutableSet;
            }
            catch (Exception e) {
                String msg = "Unable to obtain privileges from server: " + e.getMessage() + ".";
                if (retries > 0) {
                    LOGGER.warn(msg + " Will retry for " + retries + " time(s)");
                } else {
                    LOGGER.error(msg, (Throwable)e);
                }
                if (retries <= 0) continue;
                try {
                    Thread.sleep(this.retryIntervalSec * 1000);
                }
                catch (InterruptedException e1) {
                    LOGGER.info("Sleeping is interrupted.", (Throwable)e1);
                }
            }
            finally {
                if (policyServiceClient == null) continue;
                policyServiceClient.close();
            }
        }
        return ImmutableSet.of();
    }

    public ImmutableSet<String> getRoles(Set<String> groups, ActiveRoleSet roleSet) {
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    public void close() {
    }

    public void validatePolicy(boolean strictValidation) throws SentryConfigurationException {
    }
}

