/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.policy.engine.common;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.apache.sentry.core.common.ActiveRoleSet;
import org.apache.sentry.core.common.Authorizable;
import org.apache.sentry.core.common.exception.SentryConfigurationException;
import org.apache.sentry.policy.common.PolicyEngine;
import org.apache.sentry.policy.common.PrivilegeFactory;
import org.apache.sentry.policy.engine.common.CommonPrivilegeFactory;
import org.apache.sentry.provider.common.ProviderBackend;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonPolicyEngine
implements PolicyEngine {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommonPolicyEngine.class);
    private final ProviderBackend providerBackend;

    public CommonPolicyEngine(ProviderBackend providerBackend) {
        this.providerBackend = providerBackend;
    }

    public PrivilegeFactory getPrivilegeFactory() {
        return new CommonPrivilegeFactory();
    }

    public ImmutableSet<String> getAllPrivileges(Set<String> groups, ActiveRoleSet roleSet) throws SentryConfigurationException {
        return this.getPrivileges(groups, roleSet, new Authorizable[0]);
    }

    public ImmutableSet<String> getAllPrivileges(Set<String> groups, Set<String> users, ActiveRoleSet roleSet) throws SentryConfigurationException {
        return this.getPrivileges(groups, users, roleSet, new Authorizable[0]);
    }

    public ImmutableSet<String> getPrivileges(Set<String> groups, ActiveRoleSet roleSet, Authorizable ... authorizableHierarchy) throws SentryConfigurationException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Getting permissions for {}", groups);
        }
        ImmutableSet result = this.providerBackend.getPrivileges(groups, roleSet, authorizableHierarchy);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("result = " + result);
        }
        return result;
    }

    public ImmutableSet<String> getPrivileges(Set<String> groups, Set<String> users, ActiveRoleSet roleSet, Authorizable ... authorizableHierarchy) throws SentryConfigurationException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Getting permissions for groups: {}, users: {}", groups, users);
        }
        ImmutableSet result = this.providerBackend.getPrivileges(groups, users, roleSet, authorizableHierarchy);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("result = " + result);
        }
        return result;
    }

    public void validatePolicy(boolean strictValidation) throws SentryConfigurationException {
        this.providerBackend.validatePolicy(strictValidation);
    }

    public void close() {
        if (this.providerBackend != null) {
            this.providerBackend.close();
        }
    }
}

