/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.binding.metastore;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.MetaStoreEventListener;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.events.AddPartitionEvent;
import org.apache.hadoop.hive.metastore.events.AlterPartitionEvent;
import org.apache.hadoop.hive.metastore.events.AlterTableEvent;
import org.apache.hadoop.hive.metastore.events.CreateDatabaseEvent;
import org.apache.hadoop.hive.metastore.events.CreateTableEvent;
import org.apache.hadoop.hive.metastore.events.DropDatabaseEvent;
import org.apache.hadoop.hive.metastore.events.DropPartitionEvent;
import org.apache.hadoop.hive.metastore.events.DropTableEvent;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.sentry.binding.hive.conf.HiveAuthzConf;
import org.apache.sentry.core.common.Authorizable;
import org.apache.sentry.core.common.exception.SentryUserException;
import org.apache.sentry.core.model.db.Database;
import org.apache.sentry.core.model.db.Server;
import org.apache.sentry.core.model.db.Table;
import org.apache.sentry.provider.db.SentryMetastoreListenerPlugin;
import org.apache.sentry.provider.db.service.thrift.SentryPolicyServiceClient;
import org.apache.sentry.service.thrift.SentryServiceClientFactory;
import org.apache.sentry.service.thrift.ServiceConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SentryMetastorePostEventListenerBase
extends MetaStoreEventListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(SentryMetastoreListenerPlugin.class);
    private final HiveAuthzConf authzConf;
    private final Server server;
    protected List<SentryMetastoreListenerPlugin> sentryPlugins = new ArrayList<SentryMetastoreListenerPlugin>();

    public SentryMetastorePostEventListenerBase(Configuration config) {
        super(config);
        if (!(config instanceof HiveConf)) {
            String error = "Could not initialize Plugin - Configuration is not an instanceof HiveConf";
            LOGGER.error(error);
            throw new RuntimeException(error);
        }
        this.authzConf = HiveAuthzConf.getAuthzConf((HiveConf)config);
        this.server = new Server(this.authzConf.get(HiveAuthzConf.AuthzConfVars.AUTHZ_SERVER_NAME.getVar()));
        Iterable pluginClasses = ServiceConstants.ConfUtilties.CLASS_SPLITTER.split((CharSequence)config.get("sentry.metastore.plugins", "").trim());
        try {
            for (String pluginClassStr : pluginClasses) {
                Class clazz = config.getClassByName(pluginClassStr);
                if (!SentryMetastoreListenerPlugin.class.isAssignableFrom(clazz)) {
                    throw new IllegalArgumentException("Class [" + pluginClassStr + "] is not a " + SentryMetastoreListenerPlugin.class.getName());
                }
                SentryMetastoreListenerPlugin plugin = (SentryMetastoreListenerPlugin)clazz.getConstructor(Configuration.class, Configuration.class).newInstance(new Object[]{config, this.authzConf});
                this.sentryPlugins.add(plugin);
            }
        }
        catch (Exception e) {
            LOGGER.error("Could not initialize Plugin !!", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void onCreateTable(CreateTableEvent tableEvent) throws MetaException {
        if (!tableEvent.getStatus()) {
            LOGGER.debug("Skip sync paths/privileges with Sentry server for onCreateTable event, since the operation failed. \n");
            return;
        }
        if (tableEvent.getTable().getSd().getLocation() != null) {
            String authzObj = tableEvent.getTable().getDbName() + "." + tableEvent.getTable().getTableName();
            String path = tableEvent.getTable().getSd().getLocation();
            for (SentryMetastoreListenerPlugin plugin : this.sentryPlugins) {
                plugin.addPath(authzObj, path);
            }
        }
        if (!this.syncWithPolicyStore(HiveAuthzConf.AuthzConfVars.AUTHZ_SYNC_CREATE_WITH_POLICY_STORE)) {
            return;
        }
        this.dropSentryTablePrivilege(tableEvent.getTable().getDbName(), tableEvent.getTable().getTableName());
    }

    public void onDropTable(DropTableEvent tableEvent) throws MetaException {
        if (!tableEvent.getStatus()) {
            LOGGER.debug("Skip syncing paths/privileges with Sentry server for onDropTable event, since the operation failed. \n");
            return;
        }
        if (tableEvent.getTable().getSd().getLocation() != null) {
            String authzObj = tableEvent.getTable().getDbName() + "." + tableEvent.getTable().getTableName();
            for (SentryMetastoreListenerPlugin plugin : this.sentryPlugins) {
                plugin.removeAllPaths(authzObj, null);
            }
        }
        if (!this.syncWithPolicyStore(HiveAuthzConf.AuthzConfVars.AUTHZ_SYNC_DROP_WITH_POLICY_STORE)) {
            return;
        }
        if (!tableEvent.getStatus()) {
            return;
        }
        this.dropSentryTablePrivilege(tableEvent.getTable().getDbName(), tableEvent.getTable().getTableName());
    }

    public void onCreateDatabase(CreateDatabaseEvent dbEvent) throws MetaException {
        if (!dbEvent.getStatus()) {
            LOGGER.debug("Skip syncing paths/privileges with Sentry server for onCreateDatabase event, since the operation failed. \n");
            return;
        }
        if (dbEvent.getDatabase().getLocationUri() != null) {
            String authzObj = dbEvent.getDatabase().getName();
            String path = dbEvent.getDatabase().getLocationUri();
            for (SentryMetastoreListenerPlugin plugin : this.sentryPlugins) {
                plugin.addPath(authzObj, path);
            }
        }
        if (!this.syncWithPolicyStore(HiveAuthzConf.AuthzConfVars.AUTHZ_SYNC_CREATE_WITH_POLICY_STORE)) {
            return;
        }
        this.dropSentryDbPrivileges(dbEvent.getDatabase().getName());
    }

    public void onDropDatabase(DropDatabaseEvent dbEvent) throws MetaException {
        if (!dbEvent.getStatus()) {
            LOGGER.debug("Skip syncing paths/privileges with Sentry server for onDropDatabase event, since the operation failed. \n");
            return;
        }
        String authzObj = dbEvent.getDatabase().getName();
        for (SentryMetastoreListenerPlugin plugin : this.sentryPlugins) {
            List tNames = dbEvent.getHandler().get_all_tables(authzObj);
            plugin.removeAllPaths(authzObj, tNames);
        }
        if (!this.syncWithPolicyStore(HiveAuthzConf.AuthzConfVars.AUTHZ_SYNC_DROP_WITH_POLICY_STORE)) {
            return;
        }
        this.dropSentryDbPrivileges(dbEvent.getDatabase().getName());
    }

    public void onAlterTable(AlterTableEvent tableEvent) throws MetaException {
        if (!tableEvent.getStatus()) {
            LOGGER.debug("Skip syncing privileges with Sentry server for onAlterTable event, since the operation failed. \n");
            return;
        }
        String oldLoc = null;
        String newLoc = null;
        org.apache.hadoop.hive.metastore.api.Table oldTal = tableEvent.getOldTable();
        org.apache.hadoop.hive.metastore.api.Table newTal = tableEvent.getNewTable();
        if (oldTal != null && oldTal.getSd() != null) {
            oldLoc = oldTal.getSd().getLocation();
        }
        if (newTal != null && newTal.getSd() != null) {
            newLoc = newTal.getSd().getLocation();
        }
        if (oldLoc != null && newLoc != null && !oldLoc.equals(newLoc)) {
            String oldDbName = tableEvent.getOldTable().getDbName();
            String oldTbName = tableEvent.getOldTable().getTableName();
            String newTbName = tableEvent.getNewTable().getTableName();
            String newDbName = tableEvent.getNewTable().getDbName();
            this.renameSentryTablePrivilege(oldDbName, oldTbName, oldLoc, newDbName, newTbName, newLoc);
        }
    }

    public void onAlterPartition(AlterPartitionEvent partitionEvent) throws MetaException {
        if (!partitionEvent.getStatus()) {
            LOGGER.debug("Skip syncing privileges with Sentry server for onAlterPartition event, since the operation failed. \n");
            return;
        }
        String oldLoc = null;
        String newLoc = null;
        if (partitionEvent.getOldPartition() != null) {
            oldLoc = partitionEvent.getOldPartition().getSd().getLocation();
        }
        if (partitionEvent.getNewPartition() != null) {
            newLoc = partitionEvent.getNewPartition().getSd().getLocation();
        }
        if (oldLoc != null && newLoc != null && !oldLoc.equals(newLoc)) {
            String authzObj = partitionEvent.getOldPartition().getDbName() + "." + partitionEvent.getOldPartition().getTableName();
            for (SentryMetastoreListenerPlugin plugin : this.sentryPlugins) {
                plugin.renameAuthzObject(authzObj, oldLoc, authzObj, newLoc);
            }
        }
    }

    public void onAddPartition(AddPartitionEvent partitionEvent) throws MetaException {
        if (!partitionEvent.getStatus()) {
            LOGGER.debug("Skip syncing path with Sentry server for onAddPartition event, since the operation failed. \n");
            return;
        }
        for (Partition part : partitionEvent.getPartitions()) {
            if (part.getSd() == null || part.getSd().getLocation() == null) continue;
            String authzObj = part.getDbName() + "." + part.getTableName();
            String path = part.getSd().getLocation();
            for (SentryMetastoreListenerPlugin plugin : this.sentryPlugins) {
                plugin.addPath(authzObj, path);
            }
        }
        super.onAddPartition(partitionEvent);
    }

    public void onDropPartition(DropPartitionEvent partitionEvent) throws MetaException {
        if (!partitionEvent.getStatus()) {
            LOGGER.debug("Skip syncing path with Sentry server for onDropPartition event, since the operation failed. \n");
            return;
        }
        String authzObj = partitionEvent.getTable().getDbName() + "." + partitionEvent.getTable().getTableName();
        String path = partitionEvent.getPartition().getSd().getLocation();
        for (SentryMetastoreListenerPlugin plugin : this.sentryPlugins) {
            plugin.removePath(authzObj, path);
        }
        super.onDropPartition(partitionEvent);
    }

    private SentryPolicyServiceClient getSentryServiceClient() throws MetaException {
        try {
            return SentryServiceClientFactory.create((Configuration)this.authzConf);
        }
        catch (Exception e) {
            throw new MetaException("Failed to connect to Sentry service " + e.getMessage());
        }
    }

    private void dropSentryDbPrivileges(String dbName) throws MetaException {
        ArrayList<Object> authorizableTable = new ArrayList<Object>();
        authorizableTable.add(this.server);
        authorizableTable.add(new Database(dbName));
        try {
            this.dropSentryPrivileges(authorizableTable);
        }
        catch (SentryUserException e) {
            throw new MetaException("Failed to remove Sentry policies for drop DB " + dbName + " Error: " + e.getMessage());
        }
        catch (IOException e) {
            throw new MetaException("Failed to find local user " + e.getMessage());
        }
    }

    private void dropSentryTablePrivilege(String dbName, String tabName) throws MetaException {
        ArrayList<Object> authorizableTable = new ArrayList<Object>();
        authorizableTable.add(this.server);
        authorizableTable.add(new Database(dbName));
        authorizableTable.add(new Table(tabName));
        try {
            this.dropSentryPrivileges(authorizableTable);
        }
        catch (SentryUserException e) {
            throw new MetaException("Failed to remove Sentry policies for drop table " + dbName + "." + tabName + " Error: " + e.getMessage());
        }
        catch (IOException e) {
            throw new MetaException("Failed to find local user " + e.getMessage());
        }
    }

    private void dropSentryPrivileges(List<? extends Authorizable> authorizableTable) throws SentryUserException, IOException, MetaException {
        String requestorUserName = UserGroupInformation.getCurrentUser().getShortUserName();
        SentryPolicyServiceClient sentryClient = this.getSentryServiceClient();
        sentryClient.dropPrivileges(requestorUserName, authorizableTable);
        sentryClient.close();
    }

    private void renameSentryTablePrivilege(String oldDbName, String oldTabName, String oldPath, String newDbName, String newTabName, String newPath) throws MetaException {
        ArrayList<Object> oldAuthorizableTable = new ArrayList<Object>();
        oldAuthorizableTable.add(this.server);
        oldAuthorizableTable.add(new Database(oldDbName));
        oldAuthorizableTable.add(new Table(oldTabName));
        ArrayList<Object> newAuthorizableTable = new ArrayList<Object>();
        newAuthorizableTable.add(this.server);
        newAuthorizableTable.add(new Database(newDbName));
        newAuthorizableTable.add(new Table(newTabName));
        if (!oldTabName.equalsIgnoreCase(newTabName) && this.syncWithPolicyStore(HiveAuthzConf.AuthzConfVars.AUTHZ_SYNC_ALTER_WITH_POLICY_STORE)) {
            try (SentryPolicyServiceClient sentryClient = this.getSentryServiceClient();){
                String requestorUserName = UserGroupInformation.getCurrentUser().getShortUserName();
                sentryClient.renamePrivileges(requestorUserName, oldAuthorizableTable, newAuthorizableTable);
            }
        }
        for (SentryMetastoreListenerPlugin plugin : this.sentryPlugins) {
            plugin.renameAuthzObject(oldDbName + "." + oldTabName, oldPath, newDbName + "." + newTabName, newPath);
        }
    }

    private boolean syncWithPolicyStore(HiveAuthzConf.AuthzConfVars syncConfVar) {
        return "true".equalsIgnoreCase(this.authzConf.get(syncConfVar.getVar(), "true"));
    }
}

