/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.binding.metastore;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.MetaStoreFilterHook;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.Index;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.PartitionSpec;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.ql.plan.HiveOperation;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.sentry.binding.hive.HiveAuthzBindingHookBase;
import org.apache.sentry.binding.hive.authz.HiveAuthzBinding;
import org.apache.sentry.binding.hive.conf.HiveAuthzConf;

public class SentryMetaStoreFilterHook
implements MetaStoreFilterHook {
    protected static final Log LOG = LogFactory.getLog(SentryMetaStoreFilterHook.class);
    private HiveAuthzBinding hiveAuthzBinding;
    private HiveAuthzConf authzConf;

    public SentryMetaStoreFilterHook(HiveConf hiveConf) {
    }

    public List<String> filterDatabases(List<String> dbList) {
        return this.filterDb(dbList);
    }

    public Database filterDatabase(Database dataBase) throws NoSuchObjectException {
        return dataBase;
    }

    public List<String> filterTableNames(String dbName, List<String> tableList) {
        return this.filterTab(dbName, tableList);
    }

    public Table filterTable(Table table) throws NoSuchObjectException {
        return table;
    }

    public List<Table> filterTables(List<Table> tableList) {
        return tableList;
    }

    public List<Partition> filterPartitions(List<Partition> partitionList) {
        return partitionList;
    }

    public List<PartitionSpec> filterPartitionSpecs(List<PartitionSpec> partitionSpecList) {
        return partitionSpecList;
    }

    public Partition filterPartition(Partition partition) throws NoSuchObjectException {
        return partition;
    }

    public List<String> filterPartitionNames(String dbName, String tblName, List<String> partitionNames) {
        return partitionNames;
    }

    public Index filterIndex(Index index) throws NoSuchObjectException {
        return index;
    }

    public List<String> filterIndexNames(String dbName, String tblName, List<String> indexList) {
        return indexList;
    }

    public List<Index> filterIndexes(List<Index> indexeList) {
        return indexeList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> filterDb(List<String> dbList) {
        try {
            List<String> list = HiveAuthzBindingHookBase.filterShowDatabases(this.getHiveAuthzBinding(), dbList, HiveOperation.SHOWDATABASES, this.getUserName());
            return list;
        }
        catch (Exception e) {
            LOG.warn((Object)"Error getting DB list ", (Throwable)e);
            ArrayList<String> arrayList = new ArrayList<String>();
            return arrayList;
        }
        finally {
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> filterTab(String dbName, List<String> tabList) {
        try {
            List<String> list = HiveAuthzBindingHookBase.filterShowTables(this.getHiveAuthzBinding(), tabList, HiveOperation.SHOWTABLES, this.getUserName(), dbName);
            return list;
        }
        catch (Exception e) {
            LOG.warn((Object)"Error getting Table list ", (Throwable)e);
            ArrayList<String> arrayList = new ArrayList<String>();
            return arrayList;
        }
        finally {
            this.close();
        }
    }

    private String getUserName() {
        return this.getConf().get("hive.sentry.subject.name");
    }

    private HiveAuthzBinding getHiveAuthzBinding() throws MetaException {
        if (this.hiveAuthzBinding == null) {
            String hiveAuthzConf = this.getConf().get("hive.sentry.conf.url");
            if (hiveAuthzConf == null || (hiveAuthzConf = hiveAuthzConf.trim()).isEmpty()) {
                throw new MetaException("Configuration key hive.sentry.conf.url value '" + hiveAuthzConf + "' is invalid.");
            }
            try {
                this.authzConf = new HiveAuthzConf(new URL(hiveAuthzConf));
            }
            catch (MalformedURLException e) {
                throw new MetaException("Configuration key hive.sentry.conf.url specifies a malformed URL '" + hiveAuthzConf + "' " + e.getMessage());
            }
            try {
                this.hiveAuthzBinding = new HiveAuthzBinding(HiveAuthzBinding.HiveHook.HiveMetaStore, this.getConf(), this.authzConf);
            }
            catch (Exception e) {
                throw new MetaException("Failed to load Hive binding " + e.getMessage());
            }
        }
        return this.hiveAuthzBinding;
    }

    private HiveConf getConf() {
        return SessionState.get().getConf();
    }

    private void close() {
        if (this.hiveAuthzBinding != null) {
            this.hiveAuthzBinding.close();
            this.hiveAuthzBinding = null;
        }
    }
}

