/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.binding.metastore;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.security.auth.login.LoginException;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.MetaStorePreEventListener;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.events.PreAddPartitionEvent;
import org.apache.hadoop.hive.metastore.events.PreAlterPartitionEvent;
import org.apache.hadoop.hive.metastore.events.PreAlterTableEvent;
import org.apache.hadoop.hive.metastore.events.PreCreateTableEvent;
import org.apache.hadoop.hive.metastore.events.PreDropDatabaseEvent;
import org.apache.hadoop.hive.metastore.events.PreDropPartitionEvent;
import org.apache.hadoop.hive.metastore.events.PreDropTableEvent;
import org.apache.hadoop.hive.metastore.events.PreEventContext;
import org.apache.hadoop.hive.ql.plan.HiveOperation;
import org.apache.hadoop.hive.shims.Utils;
import org.apache.sentry.binding.hive.authz.HiveAuthzBinding;
import org.apache.sentry.binding.hive.conf.HiveAuthzConf;
import org.apache.sentry.core.common.utils.PathUtils;
import org.apache.sentry.core.model.db.AccessURI;
import org.apache.sentry.core.model.db.DBModelAuthorizable;
import org.apache.sentry.core.model.db.Database;
import org.apache.sentry.core.model.db.Server;
import org.apache.sentry.core.model.db.Table;

public abstract class MetastoreAuthzBindingBase
extends MetaStorePreEventListener {
    private HiveAuthzConf authzConf;
    private final Server authServer;
    private final HiveConf hiveConf;
    private final ImmutableSet<String> serviceUsers;
    private HiveAuthzBinding hiveAuthzBinding;
    private final String warehouseDir;
    protected static boolean sentryCacheOutOfSync = false;

    public MetastoreAuthzBindingBase(Configuration config) throws Exception {
        super(config);
        String hiveAuthzConf = config.get("hive.sentry.conf.url");
        if (hiveAuthzConf == null || (hiveAuthzConf = hiveAuthzConf.trim()).isEmpty()) {
            throw new IllegalArgumentException("Configuration key hive.sentry.conf.url value '" + hiveAuthzConf + "' is invalid.");
        }
        try {
            this.authzConf = new HiveAuthzConf(new URL(hiveAuthzConf));
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Configuration key hive.sentry.conf.url specifies a malformed URL '" + hiveAuthzConf + "'", e);
        }
        this.hiveConf = new HiveConf(config, ((Object)((Object)this)).getClass());
        this.authServer = new Server(this.authzConf.get(HiveAuthzConf.AuthzConfVars.AUTHZ_SERVER_NAME.getVar()));
        this.serviceUsers = ImmutableSet.copyOf(MetastoreAuthzBindingBase.toTrimedLower(Sets.newHashSet((Object[])this.authzConf.getStrings(HiveAuthzConf.AuthzConfVars.AUTHZ_METASTORE_SERVICE_USERS.getVar(), new String[]{""}))));
        this.warehouseDir = this.hiveConf.getVar(HiveConf.ConfVars.METASTOREWAREHOUSE);
    }

    public void onEvent(PreEventContext context) throws MetaException, NoSuchObjectException, InvalidOperationException {
        if (!this.needsAuthorization(this.getUserName())) {
            return;
        }
        switch (context.getEventType()) {
            case CREATE_TABLE: {
                this.authorizeCreateTable((PreCreateTableEvent)context);
                break;
            }
            case DROP_TABLE: {
                this.authorizeDropTable((PreDropTableEvent)context);
                break;
            }
            case ALTER_TABLE: {
                this.authorizeAlterTable((PreAlterTableEvent)context);
                break;
            }
            case ADD_PARTITION: {
                this.authorizeAddPartition((PreAddPartitionEvent)context);
                break;
            }
            case DROP_PARTITION: {
                this.authorizeDropPartition((PreDropPartitionEvent)context);
                break;
            }
            case ALTER_PARTITION: {
                this.authorizeAlterPartition((PreAlterPartitionEvent)context);
                break;
            }
            case CREATE_DATABASE: {
                this.authorizeCreateDatabase();
                break;
            }
            case DROP_DATABASE: {
                this.authorizeDropDatabase((PreDropDatabaseEvent)context);
                break;
            }
            case LOAD_PARTITION_DONE: {
                break;
            }
        }
    }

    private void authorizeCreateDatabase() throws InvalidOperationException, MetaException {
        this.authorizeMetastoreAccess(HiveOperation.CREATEDATABASE, new HierarcyBuilder().addServerToOutput(this.getAuthServer()).build(), new HierarcyBuilder().addServerToOutput(this.getAuthServer()).build());
    }

    private void authorizeDropDatabase(PreDropDatabaseEvent context) throws InvalidOperationException, MetaException {
        this.authorizeMetastoreAccess(HiveOperation.DROPDATABASE, new HierarcyBuilder().addDbToOutput(this.getAuthServer(), context.getDatabase().getName()).build(), new HierarcyBuilder().addDbToOutput(this.getAuthServer(), context.getDatabase().getName()).build());
    }

    private void authorizeCreateTable(PreCreateTableEvent context) throws InvalidOperationException, MetaException {
        HierarcyBuilder inputBuilder = new HierarcyBuilder();
        inputBuilder.addDbToOutput(this.getAuthServer(), context.getTable().getDbName());
        HierarcyBuilder outputBuilder = new HierarcyBuilder();
        outputBuilder.addDbToOutput(this.getAuthServer(), context.getTable().getDbName());
        if (!StringUtils.isEmpty((String)context.getTable().getSd().getLocation())) {
            String uriPath;
            try {
                uriPath = PathUtils.parseDFSURI((String)this.warehouseDir, (String)this.getSdLocation(context.getTable().getSd()));
            }
            catch (URISyntaxException e) {
                throw new MetaException(e.getMessage());
            }
            inputBuilder.addUriToOutput(this.getAuthServer(), uriPath, this.warehouseDir);
        }
        this.authorizeMetastoreAccess(HiveOperation.CREATETABLE, inputBuilder.build(), outputBuilder.build());
    }

    private void authorizeDropTable(PreDropTableEvent context) throws InvalidOperationException, MetaException {
        this.authorizeMetastoreAccess(HiveOperation.DROPTABLE, new HierarcyBuilder().addTableToOutput(this.getAuthServer(), context.getTable().getDbName(), context.getTable().getTableName()).build(), new HierarcyBuilder().addTableToOutput(this.getAuthServer(), context.getTable().getDbName(), context.getTable().getTableName()).build());
    }

    private void authorizeAlterTable(PreAlterTableEvent context) throws InvalidOperationException, MetaException {
        HiveOperation operation = HiveOperation.ALTERTABLE_ADDCOLS;
        HierarcyBuilder inputBuilder = new HierarcyBuilder();
        inputBuilder.addTableToOutput(this.getAuthServer(), context.getOldTable().getDbName(), context.getOldTable().getTableName());
        HierarcyBuilder outputBuilder = new HierarcyBuilder();
        outputBuilder.addTableToOutput(this.getAuthServer(), context.getOldTable().getDbName(), context.getOldTable().getTableName());
        String oldLocationUri = null;
        String newLocationUri = null;
        try {
            if (!StringUtils.isEmpty((String)context.getOldTable().getSd().getLocation())) {
                oldLocationUri = PathUtils.parseDFSURI((String)this.warehouseDir, (String)this.getSdLocation(context.getOldTable().getSd()));
            }
            if (!StringUtils.isEmpty((String)context.getNewTable().getSd().getLocation())) {
                newLocationUri = PathUtils.parseDFSURI((String)this.warehouseDir, (String)this.getSdLocation(context.getNewTable().getSd()));
            }
        }
        catch (URISyntaxException e) {
            throw new MetaException(e.getMessage());
        }
        if (!StringUtils.equals((String)oldLocationUri, newLocationUri)) {
            outputBuilder.addUriToOutput(this.getAuthServer(), newLocationUri, this.warehouseDir);
            operation = HiveOperation.ALTERTABLE_LOCATION;
        }
        this.authorizeMetastoreAccess(operation, inputBuilder.build(), outputBuilder.build());
    }

    private void authorizeAddPartition(PreAddPartitionEvent context) throws InvalidOperationException, MetaException, NoSuchObjectException {
        for (Partition mapiPart : context.getPartitions()) {
            HierarcyBuilder inputBuilder = new HierarcyBuilder();
            inputBuilder.addTableToOutput(this.getAuthServer(), mapiPart.getDbName(), mapiPart.getTableName());
            HierarcyBuilder outputBuilder = new HierarcyBuilder();
            outputBuilder.addTableToOutput(this.getAuthServer(), mapiPart.getDbName(), mapiPart.getTableName());
            String partitionLocation = null;
            if (mapiPart.isSetSd()) {
                partitionLocation = mapiPart.getSd().getLocation();
            }
            if (!StringUtils.isEmpty(partitionLocation)) {
                String uriPath;
                String tableLocation = context.getHandler().get_table(mapiPart.getDbName(), mapiPart.getTableName()).getSd().getLocation();
                try {
                    uriPath = PathUtils.parseDFSURI((String)this.warehouseDir, (String)mapiPart.getSd().getLocation());
                }
                catch (URISyntaxException e) {
                    throw new MetaException(e.getMessage());
                }
                if (!partitionLocation.equals(tableLocation) && !partitionLocation.startsWith(tableLocation + File.separator)) {
                    outputBuilder.addUriToOutput(this.getAuthServer(), uriPath, this.warehouseDir);
                }
            }
            this.authorizeMetastoreAccess(HiveOperation.ALTERTABLE_ADDPARTS, inputBuilder.build(), outputBuilder.build());
        }
    }

    protected void authorizeDropPartition(PreDropPartitionEvent context) throws InvalidOperationException, MetaException {
        this.authorizeMetastoreAccess(HiveOperation.ALTERTABLE_DROPPARTS, new HierarcyBuilder().addTableToOutput(this.getAuthServer(), context.getPartition().getDbName(), context.getPartition().getTableName()).build(), new HierarcyBuilder().addTableToOutput(this.getAuthServer(), context.getPartition().getDbName(), context.getPartition().getTableName()).build());
    }

    private void authorizeAlterPartition(PreAlterPartitionEvent context) throws InvalidOperationException, MetaException, NoSuchObjectException {
        HierarcyBuilder inputBuilder = new HierarcyBuilder().addTableToOutput(this.getAuthServer(), context.getDbName(), context.getTableName());
        HierarcyBuilder outputBuilder = new HierarcyBuilder().addTableToOutput(this.getAuthServer(), context.getDbName(), context.getTableName());
        Partition partition = context.getNewPartition();
        String partitionLocation = this.getSdLocation(partition.getSd());
        if (!StringUtils.isEmpty((String)partitionLocation)) {
            String uriPath;
            String tableLocation = context.getHandler().get_table(partition.getDbName(), partition.getTableName()).getSd().getLocation();
            try {
                uriPath = PathUtils.parseDFSURI((String)this.warehouseDir, (String)partitionLocation);
            }
            catch (URISyntaxException e) {
                throw new MetaException(e.getMessage());
            }
            if (!partitionLocation.startsWith(tableLocation + File.separator)) {
                outputBuilder.addUriToOutput(this.getAuthServer(), uriPath, this.warehouseDir);
            }
        }
        this.authorizeMetastoreAccess(HiveOperation.ALTERPARTITION_LOCATION, inputBuilder.build(), outputBuilder.build());
    }

    protected InvalidOperationException invalidOperationException(Exception e) {
        InvalidOperationException ex = new InvalidOperationException(e.getMessage());
        ex.initCause(e.getCause());
        return ex;
    }

    protected abstract void authorizeMetastoreAccess(HiveOperation var1, List<List<DBModelAuthorizable>> var2, List<List<DBModelAuthorizable>> var3) throws InvalidOperationException;

    public Server getAuthServer() {
        return this.authServer;
    }

    private boolean needsAuthorization(String userName) {
        return !this.serviceUsers.contains((Object)userName);
    }

    private static Set<String> toTrimedLower(Set<String> s) {
        HashSet result = Sets.newHashSet();
        for (String v : s) {
            result.add(v.trim().toLowerCase());
        }
        return result;
    }

    protected HiveAuthzBinding getHiveAuthzBinding() throws Exception {
        if (this.hiveAuthzBinding == null) {
            this.hiveAuthzBinding = new HiveAuthzBinding(HiveAuthzBinding.HiveHook.HiveMetaStore, this.hiveConf, this.authzConf);
        }
        return this.hiveAuthzBinding;
    }

    protected String getUserName() throws MetaException {
        try {
            return Utils.getUGI().getShortUserName();
        }
        catch (LoginException e) {
            throw new MetaException("Failed to get username " + e.getMessage());
        }
        catch (IOException e) {
            throw new MetaException("Failed to get username " + e.getMessage());
        }
    }

    private String getSdLocation(StorageDescriptor sd) {
        if (sd == null) {
            return "";
        }
        return sd.getLocation();
    }

    public static boolean isSentryCacheOutOfSync() {
        return sentryCacheOutOfSync;
    }

    public static void setSentryCacheOutOfSync(boolean sentryCacheOutOfSync) {
        MetastoreAuthzBindingBase.sentryCacheOutOfSync = sentryCacheOutOfSync;
    }

    protected static class HierarcyBuilder {
        private List<List<DBModelAuthorizable>> authHierarchy = new ArrayList<List<DBModelAuthorizable>>();

        public HierarcyBuilder addServerToOutput(Server server) {
            ArrayList<Server> serverHierarchy = new ArrayList<Server>();
            serverHierarchy.add(server);
            this.authHierarchy.add(serverHierarchy);
            return this;
        }

        public HierarcyBuilder addDbToOutput(Server server, String dbName) {
            ArrayList<Object> dbHierarchy = new ArrayList<Object>();
            this.addServerToOutput(server);
            dbHierarchy.add(server);
            dbHierarchy.add(new Database(dbName));
            this.authHierarchy.add(dbHierarchy);
            return this;
        }

        public HierarcyBuilder addUriToOutput(Server server, String uriPath, String warehouseDirPath) throws MetaException {
            ArrayList<Object> uriHierarchy = new ArrayList<Object>();
            this.addServerToOutput(server);
            uriHierarchy.add(server);
            try {
                uriHierarchy.add(new AccessURI(PathUtils.parseDFSURI((String)warehouseDirPath, (String)uriPath)));
            }
            catch (URISyntaxException e) {
                throw new MetaException("Error paring the URI " + e.getMessage());
            }
            this.authHierarchy.add(uriHierarchy);
            return this;
        }

        public HierarcyBuilder addTableToOutput(Server server, String dbName, String tableName) {
            ArrayList<Object> tableHierarchy = new ArrayList<Object>();
            this.addDbToOutput(server, dbName);
            tableHierarchy.add(server);
            tableHierarchy.add(new Database(dbName));
            tableHierarchy.add(new Table(tableName));
            this.authHierarchy.add(tableHierarchy);
            return this;
        }

        public List<List<DBModelAuthorizable>> build() {
            return this.authHierarchy;
        }
    }
}

