/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.binding.hive.authz;

import java.security.CodeSource;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.Set;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.Driver;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.processors.CommandProcessorResponse;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.sentry.Command;
import org.apache.sentry.binding.hive.HiveAuthzBindingHookBase;
import org.apache.sentry.binding.hive.SentryPolicyFileFormatFactory;
import org.apache.sentry.binding.hive.SentryPolicyFileFormatter;
import org.apache.sentry.binding.hive.authz.HiveAuthzBinding;
import org.apache.sentry.binding.hive.conf.HiveAuthzConf;
import org.apache.sentry.core.common.Subject;
import org.apache.sentry.core.common.exception.SentryConfigurationException;
import org.apache.sentry.core.model.db.Server;
import org.apache.sentry.provider.common.AuthorizationProvider;
import org.apache.sentry.provider.db.service.thrift.SentryPolicyServiceClient;
import org.apache.sentry.service.thrift.SentryServiceClientFactory;

public class SentryConfigTool {
    private String sentrySiteFile = null;
    private String policyFile = null;
    private String query = null;
    private String jdbcURL = null;
    private String user = null;
    private String passWord = null;
    private String importPolicyFilePath = null;
    private String exportPolicyFilePath = null;
    private String objectPath = null;
    private boolean listPrivs = false;
    private boolean validate = false;
    private boolean importOverwriteRole = false;
    private HiveConf hiveConf = null;
    private HiveAuthzConf authzConf = null;
    private AuthorizationProvider sentryProvider = null;

    public AuthorizationProvider getSentryProvider() {
        return this.sentryProvider;
    }

    public void setSentryProvider(AuthorizationProvider sentryProvider) {
        this.sentryProvider = sentryProvider;
    }

    public HiveConf getHiveConf() {
        return this.hiveConf;
    }

    public void setHiveConf(HiveConf hiveConf) {
        this.hiveConf = hiveConf;
    }

    public HiveAuthzConf getAuthzConf() {
        return this.authzConf;
    }

    public void setAuthzConf(HiveAuthzConf authzConf) {
        this.authzConf = authzConf;
    }

    public boolean isValidate() {
        return this.validate;
    }

    public void setValidate(boolean validate) {
        this.validate = validate;
    }

    public String getImportPolicyFilePath() {
        return this.importPolicyFilePath;
    }

    public void setImportPolicyFilePath(String importPolicyFilePath) {
        this.importPolicyFilePath = importPolicyFilePath;
    }

    public String getObjectPath() {
        return this.objectPath;
    }

    public void setObjectPath(String objectPath) {
        this.objectPath = objectPath;
    }

    public String getExportPolicyFilePath() {
        return this.exportPolicyFilePath;
    }

    public void setExportPolicyFilePath(String exportPolicyFilePath) {
        this.exportPolicyFilePath = exportPolicyFilePath;
    }

    public String getSentrySiteFile() {
        return this.sentrySiteFile;
    }

    public void setSentrySiteFile(String sentrySiteFile) {
        this.sentrySiteFile = sentrySiteFile;
    }

    public String getPolicyFile() {
        return this.policyFile;
    }

    public void setPolicyFile(String policyFile) {
        this.policyFile = policyFile;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public String getJdbcURL() {
        return this.jdbcURL;
    }

    public void setJdbcURL(String jdbcURL) {
        this.jdbcURL = jdbcURL;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassWord() {
        return this.passWord;
    }

    public void setPassWord(String passWord) {
        this.passWord = passWord;
    }

    public boolean isListPrivs() {
        return this.listPrivs;
    }

    public void setListPrivs(boolean listPrivs) {
        this.listPrivs = listPrivs;
    }

    public boolean isImportOverwriteRole() {
        return this.importOverwriteRole;
    }

    public void setImportOverwriteRole(boolean importOverwriteRole) {
        this.importOverwriteRole = importOverwriteRole;
    }

    public void setupConfig() throws Exception {
        System.out.println("Configuration: ");
        CodeSource src = SentryConfigTool.class.getProtectionDomain().getCodeSource();
        if (src != null) {
            System.out.println("Sentry package jar: " + src.getLocation());
        }
        if (this.getPolicyFile() != null) {
            System.setProperty(HiveAuthzConf.AuthzConfVars.AUTHZ_PROVIDER_RESOURCE.getVar(), this.getPolicyFile());
        }
        System.setProperty(HiveAuthzConf.AuthzConfVars.SENTRY_TESTING_MODE.getVar(), "true");
        this.setHiveConf(new HiveConf(SessionState.class));
        this.getHiveConf().setVar(HiveConf.ConfVars.SEMANTIC_ANALYZER_HOOK, HiveAuthzBindingHookBase.class.getName());
        try {
            System.out.println("Hive config: " + HiveConf.getHiveSiteLocation());
        }
        catch (NullPointerException e) {
            throw new SentryConfigurationException("Didn't find a hive-site.xml");
        }
        if (this.getSentrySiteFile() != null) {
            this.getHiveConf().set("hive.sentry.conf.url", this.getSentrySiteFile());
        }
        this.setAuthzConf(HiveAuthzConf.getAuthzConf(this.getHiveConf()));
        System.out.println("Sentry config: " + this.getAuthzConf().getHiveAuthzSiteFile());
        System.out.println("Sentry Policy: " + this.getAuthzConf().get(HiveAuthzConf.AuthzConfVars.AUTHZ_PROVIDER_RESOURCE.getVar()));
        System.out.println("Sentry server: " + this.getAuthzConf().get(HiveAuthzConf.AuthzConfVars.AUTHZ_SERVER_NAME.getVar()));
        this.setSentryProvider(this.getAuthorizationProvider());
    }

    private AuthorizationProvider getAuthorizationProvider() throws IllegalStateException, SentryConfigurationException {
        String serverName = new Server(this.getAuthzConf().get(HiveAuthzConf.AuthzConfVars.AUTHZ_SERVER_NAME.getVar())).getName();
        try {
            return HiveAuthzBinding.getAuthProvider(this.getHiveConf(), this.authzConf, serverName);
        }
        catch (SentryConfigurationException eC) {
            this.printConfigErrors(eC);
            throw eC;
        }
        catch (Exception e) {
            throw new IllegalStateException("Couldn't load sentry provider ", e);
        }
    }

    public void validatePolicy() throws Exception {
        try {
            this.getSentryProvider().validateResource(true);
        }
        catch (SentryConfigurationException e) {
            this.printConfigErrors(e);
            throw e;
        }
        System.out.println("No errors found in the policy file");
    }

    public void importPolicy() throws Exception {
        String requestorUserName = System.getProperty("user.name", "");
        SentryPolicyFileFormatter sentryPolicyFileFormatter = SentryPolicyFileFormatFactory.createFileFormatter(this.authzConf);
        Map<String, Map<String, Set<String>>> policyFileMappingData = sentryPolicyFileFormatter.parse(this.importPolicyFilePath, this.authzConf);
        SentryPolicyServiceClient client = SentryServiceClientFactory.create((Configuration)this.getAuthzConf());
        client.importPolicy(policyFileMappingData, requestorUserName, this.importOverwriteRole);
    }

    public void exportPolicy() throws Exception {
        String requestorUserName = System.getProperty("user.name", "");
        SentryPolicyServiceClient client = SentryServiceClientFactory.create((Configuration)this.getAuthzConf());
        Map policyFileMappingData = client.exportPolicy(requestorUserName, this.objectPath);
        SentryPolicyFileFormatter sentryPolicyFileFormatter = SentryPolicyFileFormatFactory.createFileFormatter(this.authzConf);
        sentryPolicyFileFormatter.write(this.exportPolicyFilePath, policyFileMappingData);
    }

    public void listPrivs() throws Exception {
        this.getSentryProvider().validateResource(true);
        System.out.println("Available privileges for user " + this.getUser() + ":");
        Set permList = this.getSentryProvider().listPrivilegesForSubject(new Subject(this.getUser()));
        for (String perms : permList) {
            System.out.println("\t" + perms);
        }
        if (permList.isEmpty()) {
            System.out.println("\t*** No permissions available ***");
        }
    }

    public void verifyLocalQuery(String queryStr) throws Exception {
        SessionState session = new SessionState(this.getHiveConf());
        SessionState.start((SessionState)session);
        Driver driver = new Driver(session.getConf(), this.getUser());
        CommandProcessorResponse compilerStatus = driver.compileAndRespond(queryStr);
        if (compilerStatus.getResponseCode() != 0) {
            String errMsg = compilerStatus.getErrorMessage();
            if (errMsg.contains("No valid privileges")) {
                this.printMissingPerms(this.getHiveConf().get("sentry.hive.authorization.errors"));
            }
            throw new SemanticException("Compilation error: " + compilerStatus.getErrorMessage());
        }
        driver.close();
        System.out.println("User " + this.getUser() + " has privileges to run the query");
    }

    public void verifyRemoteQuery(String queryStr) throws Exception {
        Class.forName("org.apache.hive.jdbc.HiveDriver");
        Connection conn = DriverManager.getConnection(this.getJdbcURL(), this.getUser(), this.getPassWord());
        Statement stmt = conn.createStatement();
        if (!this.isSentryEnabledOnHiveServer(stmt)) {
            throw new IllegalStateException("Sentry is not enabled on HiveServer2");
        }
        stmt.execute("set sentry.hive.mock.compilation=true");
        try {
            stmt.execute(queryStr);
        }
        catch (SQLException e) {
            String errMsg = e.getMessage();
            if (errMsg.contains("sentry.hive.mock.error")) {
                System.out.println("User " + this.readConfig(stmt, "hive.sentry.subject.name") + " has privileges to run the query");
                return;
            }
            if (errMsg.contains("No valid privileges")) {
                this.printMissingPerms(this.readConfig(stmt, "sentry.hive.authorization.errors"));
                throw e;
            }
            throw e;
        }
        finally {
            if (!stmt.isClosed()) {
                stmt.close();
            }
            conn.close();
        }
    }

    private boolean isSentryEnabledOnHiveServer(Statement stmt) throws SQLException {
        String bindingString = this.readConfig(stmt, HiveConf.ConfVars.HIVE_SERVER2_SESSION_HOOK.varname).toUpperCase();
        return bindingString.contains("org.apache.sentry.binding.hive".toUpperCase()) && bindingString.contains("HiveAuthzBindingSessionHook".toUpperCase());
    }

    private String readConfig(Statement stmt, String configKey) throws SQLException {
        try (ResultSet res = stmt.executeQuery("set " + configKey);){
            if (!res.next()) {
                String string = null;
                return string;
            }
            String result = res.getString(1);
            res.close();
            String string = result.substring(result.indexOf("=") + 1);
            return string;
        }
    }

    private void printConfigErrors(SentryConfigurationException configException) throws SentryConfigurationException {
        System.out.println(" *** Found configuration problems *** ");
        for (String errMsg : configException.getConfigErrors()) {
            System.out.println("ERROR: " + errMsg);
        }
        for (String warnMsg : configException.getConfigWarnings()) {
            System.out.println("Warning: " + warnMsg);
        }
    }

    private void printMissingPerms(String errMsg) {
        if (errMsg == null || errMsg.isEmpty()) {
            return;
        }
        System.out.println("*** Query compilation failed ***");
        String[] perms = errMsg.replaceFirst(".*No valid privileges", "").split(";");
        System.out.println("Required privileges for given query:");
        for (int count = 0; count < perms.length; ++count) {
            System.out.println(" \t " + perms[count]);
        }
    }

    private void usage(Options sentryOptions) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("sentry --command config-tool", sentryOptions);
        System.exit(-1);
    }

    private void parseArgs(String[] args) {
        boolean enableDebug = false;
        Options sentryOptions = new Options();
        Option helpOpt = new Option("h", "help", false, "Print usage");
        helpOpt.setRequired(false);
        Option validateOpt = new Option("v", "validate", false, "Validate policy file");
        validateOpt.setRequired(false);
        Option queryOpt = new Option("e", "query", true, "Query privilege verification, requires -u");
        queryOpt.setRequired(false);
        Option listPermsOpt = new Option("l", "listPerms", false, "list permissions for given user, requires -u");
        listPermsOpt.setRequired(false);
        Option listPrivsOpt = new Option("listPrivs", false, "list privileges for given user, requires -u");
        listPrivsOpt.setRequired(false);
        Option importOpt = new Option("I", "import", true, "Import policy file");
        importOpt.setRequired(false);
        Option exportOpt = new Option("E", "export", true, "Export policy file");
        exportOpt.setRequired(false);
        OptionGroup sentryOptGroup = new OptionGroup();
        sentryOptGroup.addOption(helpOpt);
        sentryOptGroup.addOption(validateOpt);
        sentryOptGroup.addOption(queryOpt);
        sentryOptGroup.addOption(listPermsOpt);
        sentryOptGroup.addOption(listPrivsOpt);
        sentryOptGroup.addOption(importOpt);
        sentryOptGroup.addOption(exportOpt);
        sentryOptGroup.setRequired(true);
        sentryOptions.addOptionGroup(sentryOptGroup);
        Option jdbcArg = new Option("j", "jdbcURL", true, "JDBC URL");
        jdbcArg.setRequired(false);
        sentryOptions.addOption(jdbcArg);
        Option sentrySitePath = new Option("s", "sentry-site", true, "sentry-site file path");
        sentrySitePath.setRequired(false);
        sentryOptions.addOption(sentrySitePath);
        Option globalPolicyPath = new Option("i", "policyIni", true, "Policy file path");
        globalPolicyPath.setRequired(false);
        sentryOptions.addOption(globalPolicyPath);
        Option userOpt = new Option("u", "user", true, "user name");
        userOpt.setRequired(false);
        sentryOptions.addOption(userOpt);
        Option passWordOpt = new Option("p", "password", true, "Password");
        userOpt.setRequired(false);
        sentryOptions.addOption(passWordOpt);
        Option debugOpt = new Option("d", "debug", false, "enable debug output");
        debugOpt.setRequired(false);
        sentryOptions.addOption(debugOpt);
        Option overwriteOpt = new Option("o", "overwrite", false, "enable import overwrite");
        overwriteOpt.setRequired(false);
        sentryOptions.addOption(overwriteOpt);
        Option objectPathOpt = new Option("b", "objectPath", false, "The path of the object whose privileges will be exported");
        objectPathOpt.setRequired(false);
        sentryOptions.addOption(objectPathOpt);
        try {
            GnuParser parser = new GnuParser();
            CommandLine cmd = parser.parse(sentryOptions, args);
            for (Option opt : cmd.getOptions()) {
                if (opt.getOpt().equals("s")) {
                    this.setSentrySiteFile(opt.getValue());
                    continue;
                }
                if (opt.getOpt().equals("i")) {
                    this.setPolicyFile(opt.getValue());
                    continue;
                }
                if (opt.getOpt().equals("e")) {
                    this.setQuery(opt.getValue());
                    continue;
                }
                if (opt.getOpt().equals("j")) {
                    this.setJdbcURL(opt.getValue());
                    continue;
                }
                if (opt.getOpt().equals("u")) {
                    this.setUser(opt.getValue());
                    continue;
                }
                if (opt.getOpt().equals("p")) {
                    this.setPassWord(opt.getValue());
                    continue;
                }
                if (opt.getOpt().equals("l") || opt.getOpt().equals("listPrivs")) {
                    this.setListPrivs(true);
                    continue;
                }
                if (opt.getOpt().equals("v")) {
                    this.setValidate(true);
                    continue;
                }
                if (opt.getOpt().equals("I")) {
                    this.setImportPolicyFilePath(opt.getValue());
                    continue;
                }
                if (opt.getOpt().equals("E")) {
                    this.setExportPolicyFilePath(opt.getValue());
                    continue;
                }
                if (opt.getOpt().equals("h")) {
                    this.usage(sentryOptions);
                    continue;
                }
                if (opt.getOpt().equals("d")) {
                    enableDebug = true;
                    continue;
                }
                if (opt.getOpt().equals("o")) {
                    this.setImportOverwriteRole(true);
                    continue;
                }
                if (!opt.getOpt().equals("b")) continue;
                this.setObjectPath(opt.getValue());
            }
            if (this.isListPrivs() && this.getUser() == null) {
                throw new ParseException("Can't use -l without -u ");
            }
            if (this.getQuery() != null && this.getUser() == null) {
                throw new ParseException("Must use -u with -e ");
            }
        }
        catch (ParseException e1) {
            this.usage(sentryOptions);
        }
        if (!enableDebug) {
            LogManager.getRootLogger().setLevel(Level.OFF);
        }
    }

    public static class CommandImpl
    implements Command {
        public void run(String[] args) throws Exception {
            SentryConfigTool sentryTool = new SentryConfigTool();
            try {
                sentryTool.parseArgs(args);
                sentryTool.setupConfig();
                if (sentryTool.isValidate()) {
                    sentryTool.validatePolicy();
                }
                if (!StringUtils.isEmpty((CharSequence)sentryTool.getImportPolicyFilePath())) {
                    sentryTool.importPolicy();
                }
                if (!StringUtils.isEmpty((CharSequence)sentryTool.getExportPolicyFilePath())) {
                    sentryTool.exportPolicy();
                }
                if (sentryTool.isListPrivs()) {
                    sentryTool.listPrivs();
                }
                if (sentryTool.getQuery() != null) {
                    if (sentryTool.getJdbcURL() != null) {
                        sentryTool.verifyRemoteQuery(sentryTool.getQuery());
                    } else {
                        sentryTool.verifyLocalQuery(sentryTool.getQuery());
                    }
                }
            }
            catch (Exception e) {
                System.out.println("Sentry tool reported Errors: " + e.getMessage());
                e.printStackTrace(System.out);
                System.exit(1);
            }
        }
    }
}

