/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.binding.hive.authz;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import java.lang.reflect.Constructor;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.metadata.AuthorizationException;
import org.apache.hadoop.hive.ql.plan.HiveOperation;
import org.apache.sentry.binding.hive.authz.HiveAuthzPrivileges;
import org.apache.sentry.binding.hive.conf.HiveAuthzConf;
import org.apache.sentry.binding.hive.conf.InvalidConfigurationException;
import org.apache.sentry.core.common.ActiveRoleSet;
import org.apache.sentry.core.common.Model;
import org.apache.sentry.core.common.Subject;
import org.apache.sentry.core.common.exception.SentryUserException;
import org.apache.sentry.core.model.db.AccessConstants;
import org.apache.sentry.core.model.db.DBModelAction;
import org.apache.sentry.core.model.db.DBModelAuthorizable;
import org.apache.sentry.core.model.db.HivePrivilegeModel;
import org.apache.sentry.core.model.db.Server;
import org.apache.sentry.policy.common.PolicyEngine;
import org.apache.sentry.provider.cache.PrivilegeCache;
import org.apache.sentry.provider.cache.SimpleCacheProviderBackend;
import org.apache.sentry.provider.common.AuthorizationProvider;
import org.apache.sentry.provider.common.ProviderBackend;
import org.apache.sentry.provider.common.ProviderBackendContext;
import org.apache.sentry.provider.db.service.thrift.TSentryRole;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveAuthzBinding {
    private static final Logger LOG = LoggerFactory.getLogger(HiveAuthzBinding.class);
    private static final Splitter ROLE_SET_SPLITTER = Splitter.on((String)",").trimResults().omitEmptyStrings();
    public static final String HIVE_BINDING_TAG = "hive.authz.bindings.tag";
    public static final String HIVE_POLICY_ENGINE_OLD = "org.apache.sentry.policy.db.SimpleDBPolicyEngine";
    private final HiveConf hiveConf;
    private final Server authServer;
    private final AuthorizationProvider authProvider;
    private volatile boolean open;
    private ActiveRoleSet activeRoleSet;
    private HiveAuthzConf authzConf;

    public HiveAuthzBinding(HiveConf hiveConf, HiveAuthzConf authzConf) throws Exception {
        this(HiveHook.HiveServer2, hiveConf, authzConf);
    }

    public HiveAuthzBinding(HiveHook hiveHook, HiveConf hiveConf, HiveAuthzConf authzConf) throws Exception {
        this.validateHiveConfig(hiveHook, hiveConf, authzConf);
        this.hiveConf = hiveConf;
        this.authzConf = authzConf;
        this.authServer = new Server(authzConf.get(HiveAuthzConf.AuthzConfVars.AUTHZ_SERVER_NAME.getVar()));
        this.authProvider = HiveAuthzBinding.getAuthProvider(hiveConf, authzConf, this.authServer.getName());
        this.open = true;
        this.activeRoleSet = HiveAuthzBinding.parseActiveRoleSet(hiveConf.get("hive.sentry.active.role.set", authzConf.get("hive.sentry.active.role.set", "")).trim());
    }

    public HiveAuthzBinding(HiveHook hiveHook, HiveConf hiveConf, HiveAuthzConf authzConf, PrivilegeCache privilegeCache) throws Exception {
        this.validateHiveConfig(hiveHook, hiveConf, authzConf);
        this.hiveConf = hiveConf;
        this.authzConf = authzConf;
        this.authServer = new Server(authzConf.get(HiveAuthzConf.AuthzConfVars.AUTHZ_SERVER_NAME.getVar()));
        this.authProvider = HiveAuthzBinding.getAuthProviderWithPrivilegeCache(authzConf, this.authServer.getName(), privilegeCache);
        this.open = true;
        this.activeRoleSet = HiveAuthzBinding.parseActiveRoleSet(hiveConf.get("hive.sentry.active.role.set", authzConf.get("hive.sentry.active.role.set", "")).trim());
    }

    private static ActiveRoleSet parseActiveRoleSet(String name) throws SentryUserException {
        return HiveAuthzBinding.parseActiveRoleSet(name, null);
    }

    private static ActiveRoleSet parseActiveRoleSet(String name, Set<TSentryRole> allowedRoles) throws SentryUserException {
        if (name.isEmpty()) {
            return ActiveRoleSet.ALL;
        }
        if ("NONE".equalsIgnoreCase(name)) {
            return new ActiveRoleSet(new HashSet());
        }
        if ("ALL".equalsIgnoreCase(name)) {
            return ActiveRoleSet.ALL;
        }
        if (AccessConstants.RESERVED_ROLE_NAMES.contains((Object)name.toUpperCase())) {
            String msg = "Role " + name + " is reserved";
            throw new IllegalArgumentException(msg);
        }
        if (allowedRoles != null) {
            boolean foundRole = false;
            for (TSentryRole role : allowedRoles) {
                if (!role.getRoleName().equalsIgnoreCase(name)) continue;
                foundRole = true;
                break;
            }
            if (!foundRole) {
                throw new SentryUserException("Not authorized to set role " + name, "Not authorized to set role " + name);
            }
        }
        return new ActiveRoleSet((Set)Sets.newHashSet((Iterable)ROLE_SET_SPLITTER.split((CharSequence)name)));
    }

    private void validateHiveConfig(HiveHook hiveHook, HiveConf hiveConf, HiveAuthzConf authzConf) throws InvalidConfigurationException {
        if (hiveHook.equals((Object)HiveHook.HiveMetaStore)) {
            this.validateHiveMetaStoreConfig(hiveConf, authzConf);
        } else if (hiveHook.equals((Object)HiveHook.HiveServer2)) {
            this.validateHiveServer2Config(hiveConf, authzConf);
        }
    }

    private void validateHiveMetaStoreConfig(HiveConf hiveConf, HiveAuthzConf authzConf) throws InvalidConfigurationException {
        boolean isTestingMode = Boolean.parseBoolean(Strings.nullToEmpty((String)authzConf.get(HiveAuthzConf.AuthzConfVars.SENTRY_TESTING_MODE.getVar())).trim());
        LOG.debug("Testing mode is " + isTestingMode);
        if (!isTestingMode) {
            boolean sasl = hiveConf.getBoolVar(HiveConf.ConfVars.METASTORE_USE_THRIFT_SASL);
            if (!sasl) {
                throw new InvalidConfigurationException(HiveConf.ConfVars.METASTORE_USE_THRIFT_SASL + " can't be false in non-testing mode");
            }
        } else {
            boolean setUgi = hiveConf.getBoolVar(HiveConf.ConfVars.METASTORE_EXECUTE_SET_UGI);
            if (!setUgi) {
                throw new InvalidConfigurationException(HiveConf.ConfVars.METASTORE_EXECUTE_SET_UGI.toString() + " can't be false in non secure mode");
            }
        }
    }

    private void validateHiveServer2Config(HiveConf hiveConf, HiveAuthzConf authzConf) throws InvalidConfigurationException {
        String defaultUmask;
        boolean isTestingMode = Boolean.parseBoolean(Strings.nullToEmpty((String)authzConf.get(HiveAuthzConf.AuthzConfVars.SENTRY_TESTING_MODE.getVar())).trim());
        LOG.debug("Testing mode is " + isTestingMode);
        if (!isTestingMode) {
            String authMethod = Strings.nullToEmpty((String)hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_AUTHENTICATION)).trim();
            if ("none".equalsIgnoreCase(authMethod)) {
                throw new InvalidConfigurationException(HiveConf.ConfVars.HIVE_SERVER2_AUTHENTICATION + " can't be none in non-testing mode");
            }
            boolean impersonation = hiveConf.getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_ENABLE_DOAS);
            boolean allowImpersonation = Boolean.parseBoolean(Strings.nullToEmpty((String)authzConf.get(HiveAuthzConf.AuthzConfVars.AUTHZ_ALLOW_HIVE_IMPERSONATION.getVar())).trim());
            if (impersonation && !allowImpersonation) {
                LOG.error("Role based authorization does not work with HiveServer2 impersonation");
                throw new InvalidConfigurationException(HiveConf.ConfVars.HIVE_SERVER2_ENABLE_DOAS + " can't be set to true in non-testing mode");
            }
        }
        if ("077".equalsIgnoreCase(defaultUmask = hiveConf.get("fs.permissions.umask-mode"))) {
            LOG.error("HiveServer2 required a default umask of 077");
            throw new InvalidConfigurationException("fs.permissions.umask-mode should be 077 in non-testing mode");
        }
    }

    public static AuthorizationProvider getAuthProvider(HiveConf hiveConf, HiveAuthzConf authzConf, String serverName) throws Exception {
        String authProviderName = authzConf.get(HiveAuthzConf.AuthzConfVars.AUTHZ_PROVIDER.getVar());
        String resourceName = authzConf.get(HiveAuthzConf.AuthzConfVars.AUTHZ_PROVIDER_RESOURCE.getVar());
        String providerBackendName = authzConf.get(HiveAuthzConf.AuthzConfVars.AUTHZ_PROVIDER_BACKEND.getVar());
        String policyEngineName = authzConf.get(HiveAuthzConf.AuthzConfVars.AUTHZ_POLICY_ENGINE.getVar());
        if (HIVE_POLICY_ENGINE_OLD.equals(policyEngineName)) {
            policyEngineName = HiveAuthzConf.AuthzConfVars.AUTHZ_POLICY_ENGINE.getDefault();
        }
        LOG.debug("Using authorization provider " + authProviderName + " with resource " + resourceName + ", policy engine " + policyEngineName + ", provider backend " + providerBackendName);
        Constructor<?> providerBackendConstructor = Class.forName(providerBackendName).getDeclaredConstructor(Configuration.class, String.class);
        providerBackendConstructor.setAccessible(true);
        ProviderBackend providerBackend = (ProviderBackend)providerBackendConstructor.newInstance(new Object[]{authzConf, resourceName});
        ProviderBackendContext context = new ProviderBackendContext();
        context.setAllowPerDatabase(true);
        context.setValidators(HivePrivilegeModel.getInstance().getPrivilegeValidators(serverName));
        providerBackend.initialize(context);
        Constructor<?> policyConstructor = Class.forName(policyEngineName).getDeclaredConstructor(ProviderBackend.class);
        policyConstructor.setAccessible(true);
        PolicyEngine policyEngine = (PolicyEngine)policyConstructor.newInstance(providerBackend);
        Constructor<?> constrctor = Class.forName(authProviderName).getDeclaredConstructor(String.class, PolicyEngine.class, Model.class);
        constrctor.setAccessible(true);
        return (AuthorizationProvider)constrctor.newInstance(resourceName, policyEngine, HivePrivilegeModel.getInstance());
    }

    public static AuthorizationProvider getAuthProviderWithPrivilegeCache(HiveAuthzConf authzConf, String serverName, PrivilegeCache privilegeCache) throws Exception {
        String authProviderName = authzConf.get(HiveAuthzConf.AuthzConfVars.AUTHZ_PROVIDER.getVar());
        String resourceName = authzConf.get(HiveAuthzConf.AuthzConfVars.AUTHZ_PROVIDER_RESOURCE.getVar());
        String policyEngineName = authzConf.get(HiveAuthzConf.AuthzConfVars.AUTHZ_POLICY_ENGINE.getVar(), HiveAuthzConf.AuthzConfVars.AUTHZ_POLICY_ENGINE.getDefault());
        if (HIVE_POLICY_ENGINE_OLD.equals(policyEngineName)) {
            policyEngineName = HiveAuthzConf.AuthzConfVars.AUTHZ_POLICY_ENGINE.getDefault();
        }
        LOG.debug("Using authorization provider " + authProviderName + " with resource " + resourceName + ", policy engine " + policyEngineName + ", provider backend SimpleCacheProviderBackend");
        SimpleCacheProviderBackend providerBackend = new SimpleCacheProviderBackend((Configuration)authzConf, resourceName);
        ProviderBackendContext context = new ProviderBackendContext();
        context.setBindingHandle((Object)privilegeCache);
        providerBackend.initialize(context);
        Constructor<?> policyConstructor = Class.forName(policyEngineName).getDeclaredConstructor(ProviderBackend.class);
        policyConstructor.setAccessible(true);
        PolicyEngine policyEngine = (PolicyEngine)policyConstructor.newInstance(providerBackend);
        Constructor<?> constrctor = Class.forName(authProviderName).getDeclaredConstructor(String.class, PolicyEngine.class, Model.class);
        constrctor.setAccessible(true);
        return (AuthorizationProvider)constrctor.newInstance(resourceName, policyEngine, HivePrivilegeModel.getInstance());
    }

    public void authorize(HiveOperation hiveOp, HiveAuthzPrivileges stmtAuthPrivileges, Subject subject, List<List<DBModelAuthorizable>> inputHierarchyList, List<List<DBModelAuthorizable>> outputHierarchyList) throws AuthorizationException {
        DBModelAuthorizable.AuthorizableType key;
        if (!this.open) {
            throw new IllegalStateException("Binding has been closed");
        }
        boolean isDebug = LOG.isDebugEnabled();
        if (isDebug) {
            LOG.debug("Going to authorize statement " + hiveOp.name() + " for subject " + subject.getName());
        }
        Map<DBModelAuthorizable.AuthorizableType, EnumSet<DBModelAction>> requiredInputPrivileges = stmtAuthPrivileges.getInputPrivileges();
        if (isDebug) {
            LOG.debug("requiredInputPrivileges = " + requiredInputPrivileges);
            LOG.debug("inputHierarchyList = " + inputHierarchyList);
        }
        Map<DBModelAuthorizable.AuthorizableType, EnumSet<DBModelAction>> requiredOutputPrivileges = stmtAuthPrivileges.getOutputPrivileges();
        if (isDebug) {
            LOG.debug("requiredOuputPrivileges = " + requiredOutputPrivileges);
            LOG.debug("outputHierarchyList = " + outputHierarchyList);
        }
        boolean found = false;
        for (Map.Entry<DBModelAuthorizable.AuthorizableType, EnumSet<DBModelAction>> entry : requiredInputPrivileges.entrySet()) {
            key = entry.getKey();
            for (List<DBModelAuthorizable> inputHierarchy : inputHierarchyList) {
                if (!this.getAuthzType(inputHierarchy).equals((Object)key)) continue;
                found = true;
                if (this.authProvider.hasAccess(subject, inputHierarchy, (Set)entry.getValue(), this.activeRoleSet)) continue;
                throw new AuthorizationException("User " + subject.getName() + " does not have privileges for " + hiveOp.name());
            }
            if (!(found || key.equals((Object)DBModelAuthorizable.AuthorizableType.URI) || hiveOp.equals((Object)HiveOperation.QUERY) || hiveOp.equals((Object)HiveOperation.CREATETABLE_AS_SELECT))) {
                throw new AuthorizationException("Required privilege( " + key.name() + ") not available in input privileges");
            }
            found = false;
        }
        for (Map.Entry<DBModelAuthorizable.AuthorizableType, EnumSet<DBModelAction>> entry : requiredOutputPrivileges.entrySet()) {
            key = entry.getKey();
            for (List<DBModelAuthorizable> outputHierarchy : outputHierarchyList) {
                if (!this.getAuthzType(outputHierarchy).equals((Object)key)) continue;
                found = true;
                if (this.authProvider.hasAccess(subject, outputHierarchy, (Set)entry.getValue(), this.activeRoleSet)) continue;
                throw new AuthorizationException("User " + subject.getName() + " does not have privileges for " + hiveOp.name());
            }
            if (!(found || key.equals((Object)DBModelAuthorizable.AuthorizableType.URI) || hiveOp.equals((Object)HiveOperation.QUERY))) {
                throw new AuthorizationException("Required privilege( " + key.name() + ") not available in output privileges");
            }
            found = false;
        }
    }

    public void setActiveRoleSet(String activeRoleSet, Set<TSentryRole> allowedRoles) throws SentryUserException {
        this.activeRoleSet = HiveAuthzBinding.parseActiveRoleSet(activeRoleSet, allowedRoles);
        this.hiveConf.set("hive.sentry.active.role.set", activeRoleSet);
    }

    public ActiveRoleSet getActiveRoleSet() {
        return this.activeRoleSet;
    }

    public Set<String> getGroups(Subject subject) {
        return this.authProvider.getGroupMapping().getGroups(subject.getName());
    }

    public Server getAuthServer() {
        if (!this.open) {
            throw new IllegalStateException("Binding has been closed");
        }
        return this.authServer;
    }

    public HiveAuthzConf getAuthzConf() {
        return this.authzConf;
    }

    public HiveConf getHiveConf() {
        return this.hiveConf;
    }

    private DBModelAuthorizable.AuthorizableType getAuthzType(List<DBModelAuthorizable> hierarchy) {
        return hierarchy.get(hierarchy.size() - 1).getAuthzType();
    }

    public List<String> getLastQueryPrivilegeErrors() {
        if (!this.open) {
            throw new IllegalStateException("Binding has been closed");
        }
        return this.authProvider.getLastFailedPrivileges();
    }

    public void close() {
        this.authProvider.close();
    }

    public AuthorizationProvider getCurrentAuthProvider() {
        return this.authProvider;
    }

    public static enum HiveHook {
        HiveServer2,
        HiveMetaStore;

    }
}

