/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.binding.hive;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.JavaUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.hooks.Entity;
import org.apache.hadoop.hive.ql.hooks.Hook;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.metadata.AuthorizationException;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.AbstractSemanticAnalyzerHook;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.HiveSemanticAnalyzerHookContext;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.HiveOperation;
import org.apache.hadoop.hive.ql.plan.PlanUtils;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.sentry.binding.hive.SentryOnFailureHook;
import org.apache.sentry.binding.hive.SentryOnFailureHookContext;
import org.apache.sentry.binding.hive.SentryOnFailureHookContextImpl;
import org.apache.sentry.binding.hive.authz.HiveAuthzBinding;
import org.apache.sentry.binding.hive.authz.HiveAuthzPrivileges;
import org.apache.sentry.binding.hive.conf.HiveAuthzConf;
import org.apache.sentry.core.common.Authorizable;
import org.apache.sentry.core.common.Subject;
import org.apache.sentry.core.common.utils.PathUtils;
import org.apache.sentry.core.model.db.AccessURI;
import org.apache.sentry.core.model.db.Column;
import org.apache.sentry.core.model.db.DBModelAction;
import org.apache.sentry.core.model.db.DBModelAuthorizable;
import org.apache.sentry.core.model.db.Database;
import org.apache.sentry.core.model.db.Server;
import org.apache.sentry.core.model.db.Table;
import org.apache.sentry.provider.cache.PrivilegeCache;
import org.apache.sentry.provider.cache.SimplePrivilegeCache;
import org.apache.sentry.provider.common.AuthorizationProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HiveAuthzBindingHookBase
extends AbstractSemanticAnalyzerHook {
    private static final Logger LOG = LoggerFactory.getLogger(HiveAuthzBindingHookBase.class);
    protected final HiveAuthzBinding hiveAuthzBinding;
    protected final HiveAuthzConf authzConf;
    protected Database currDB = Database.ALL;
    protected Table currTab;
    protected List<AccessURI> udfURIs;
    protected AccessURI serdeURI;
    protected AccessURI partitionURI;
    protected Table currOutTab = null;
    protected Database currOutDB = null;
    protected final List<String> serdeWhiteList;
    protected boolean serdeURIPrivilegesEnabled;
    protected static final HiveAuthzPrivileges columnMetaDataPrivilege = new HiveAuthzPrivileges.AuthzPrivilegeBuilder().addInputObjectPriviledge(DBModelAuthorizable.AuthorizableType.Column, EnumSet.of(DBModelAction.SELECT, DBModelAction.INSERT)).setOperationScope(HiveAuthzPrivileges.HiveOperationScope.COLUMN).setOperationType(HiveAuthzPrivileges.HiveOperationType.INFO).build();
    protected boolean isDescTableBasic = false;

    public HiveAuthzBindingHookBase() throws Exception {
        SessionState session = SessionState.get();
        if (session == null) {
            throw new IllegalStateException("Session has not been started");
        }
        SessionState.get().setAuthorizer(null);
        HiveConf hiveConf = session.getConf();
        if (hiveConf == null) {
            throw new IllegalStateException("Session HiveConf is null");
        }
        this.authzConf = HiveAuthzBindingHookBase.loadAuthzConf(hiveConf);
        this.udfURIs = Lists.newArrayList();
        this.hiveAuthzBinding = new HiveAuthzBinding(hiveConf, this.authzConf);
        String serdeWhiteLists = this.authzConf.get("hive.sentry.serde.whitelist", "org.apache.hadoop.hive.serde2");
        this.serdeWhiteList = Arrays.asList(serdeWhiteLists.split(","));
        this.serdeURIPrivilegesEnabled = this.authzConf.getBoolean("hive.sentry.turn.on.serde.uri.privileges", false);
        FunctionRegistry.setupPermissionsForBuiltinUDFs((String)"", (String)"reflect,reflect2,java_method");
    }

    public static HiveAuthzConf loadAuthzConf(HiveConf hiveConf) {
        boolean depreicatedConfigFile = false;
        HiveAuthzConf newAuthzConf = null;
        String hiveAuthzConf = hiveConf.get("hive.sentry.conf.url");
        if (hiveAuthzConf == null || (hiveAuthzConf = hiveAuthzConf.trim()).isEmpty()) {
            hiveAuthzConf = hiveConf.get("hive.access.conf.url");
            depreicatedConfigFile = true;
        }
        if (hiveAuthzConf == null || (hiveAuthzConf = hiveAuthzConf.trim()).isEmpty()) {
            throw new IllegalArgumentException("Configuration key hive.sentry.conf.url value '" + hiveAuthzConf + "' is invalid.");
        }
        try {
            newAuthzConf = new HiveAuthzConf(new URL(hiveAuthzConf));
        }
        catch (MalformedURLException e) {
            if (depreicatedConfigFile) {
                throw new IllegalArgumentException("Configuration key hive.access.conf.url specifies a malformed URL '" + hiveAuthzConf + "'", e);
            }
            throw new IllegalArgumentException("Configuration key hive.sentry.conf.url specifies a malformed URL '" + hiveAuthzConf + "'", e);
        }
        return newAuthzConf;
    }

    public abstract ASTNode preAnalyze(HiveSemanticAnalyzerHookContext var1, ASTNode var2) throws SemanticException;

    public abstract void postAnalyze(HiveSemanticAnalyzerHookContext var1, List<Task<? extends Serializable>> var2) throws SemanticException;

    protected void executeOnFailureHooks(HiveSemanticAnalyzerHookContext context, HiveOperation hiveOp, AuthorizationException e) {
        SentryOnFailureHookContextImpl hookCtx = new SentryOnFailureHookContextImpl(context.getCommand(), context.getInputs(), context.getOutputs(), hiveOp, this.currDB, this.currTab, this.udfURIs, null, context.getUserName(), context.getIpAddress(), e, context.getConf());
        String csHooks = this.authzConf.get(HiveAuthzConf.AuthzConfVars.AUTHZ_ONFAILURE_HOOKS.getVar(), "").trim();
        try {
            for (Hook aofh : HiveAuthzBindingHookBase.getHooks(csHooks)) {
                ((SentryOnFailureHook)aofh).run(hookCtx);
            }
        }
        catch (Exception ex) {
            LOG.error("Error executing hook:", (Throwable)ex);
        }
    }

    protected List<String> getFunctionJars(ASTNode ast) {
        ASTNode resourcesNode = (ASTNode)ast.getFirstChildWithType(782);
        ArrayList<String> resources = new ArrayList<String>();
        if (resourcesNode != null) {
            for (int idx = 0; idx < resourcesNode.getChildCount(); ++idx) {
                ASTNode resNode = (ASTNode)resourcesNode.getChild(idx);
                ASTNode resTypeNode = (ASTNode)resNode.getChild(0);
                ASTNode resUriNode = (ASTNode)resNode.getChild(1);
                if (resTypeNode.getType() != 712) continue;
                resources.add(PlanUtils.stripQuotes((String)resUriNode.getText()));
            }
        }
        return resources;
    }

    @VisibleForTesting
    protected static AccessURI extractPartition(ASTNode ast) throws SemanticException {
        for (int i = 0; i < ast.getChildCount(); ++i) {
            ASTNode child = (ASTNode)ast.getChild(i);
            if (child.getToken().getType() != 756 || child.getChildCount() != 1) continue;
            return HiveAuthzBindingHookBase.parseURI(BaseSemanticAnalyzer.unescapeSQLString((String)child.getChild(0).getText()));
        }
        return null;
    }

    @VisibleForTesting
    protected static AccessURI parseURI(String uri) throws SemanticException {
        return HiveAuthzBindingHookBase.parseURI(uri, false);
    }

    @VisibleForTesting
    protected static AccessURI parseURI(String uri, boolean isLocal) throws SemanticException {
        try {
            HiveConf conf = SessionState.get().getConf();
            String warehouseDir = conf.getVar(HiveConf.ConfVars.METASTOREWAREHOUSE);
            Path warehousePath = new Path(warehouseDir);
            if (warehousePath.isAbsoluteAndSchemeAuthorityNull()) {
                URI defaultUri = FileSystem.getDefaultUri((Configuration)conf);
                warehousePath = warehousePath.makeQualified(defaultUri, warehousePath);
                warehouseDir = warehousePath.toUri().toString();
            }
            return new AccessURI(PathUtils.parseURI((String)warehouseDir, (String)uri, (boolean)isLocal));
        }
        catch (Exception e) {
            throw new SemanticException("Error parsing URI " + uri + ": " + e.getMessage(), (Throwable)e);
        }
    }

    protected Database getCanonicalDb() {
        return new Database(SessionState.get().getCurrentDatabase());
    }

    protected void extractDbTableNameFromTOKTABLE(ASTNode astNode) throws SemanticException {
        String[] fqTableName = BaseSemanticAnalyzer.getQualifiedTableName((ASTNode)astNode);
        Preconditions.checkArgument((fqTableName.length == 2 ? 1 : 0) != 0, (Object)"BaseSemanticAnalyzer.getQualifiedTableName should return an array with dbName and tableName");
        this.currOutDB = new Database(fqTableName[0]);
        this.currOutTab = new Table(fqTableName[1]);
    }

    protected Database extractDatabase(ASTNode ast) throws SemanticException {
        String tableName = BaseSemanticAnalyzer.getUnescapedName((ASTNode)ast);
        if (tableName.contains(".")) {
            return new Database(tableName.split("\\.")[0]);
        }
        return this.getCanonicalDb();
    }

    protected Table extractTable(ASTNode ast) throws SemanticException {
        String tableName = BaseSemanticAnalyzer.getUnescapedName((ASTNode)ast);
        if (tableName.contains(".")) {
            return new Table(tableName.split("\\.")[1]);
        }
        return new Table(tableName);
    }

    public static void runFailureHook(SentryOnFailureHookContext hookContext, String csHooks) {
        try {
            for (Hook aofh : HiveAuthzBindingHookBase.getHooks(csHooks)) {
                ((SentryOnFailureHook)aofh).run(hookContext);
            }
        }
        catch (Exception ex) {
            LOG.error("Error executing hook:", (Throwable)ex);
        }
    }

    protected void authorizeWithHiveBindings(HiveSemanticAnalyzerHookContext context, HiveAuthzPrivileges stmtAuthObject, HiveOperation stmtOperation) throws AuthorizationException {
        Set inputs = context.getInputs();
        Set outputs = context.getOutputs();
        ArrayList<List<DBModelAuthorizable>> inputHierarchy = new ArrayList<List<DBModelAuthorizable>>();
        ArrayList<List<DBModelAuthorizable>> outputHierarchy = new ArrayList<List<DBModelAuthorizable>>();
        if (LOG.isDebugEnabled()) {
            LOG.debug("stmtAuthObject.getOperationScope() = " + (Object)((Object)stmtAuthObject.getOperationScope()));
            LOG.debug("context.getInputs() = " + context.getInputs());
            LOG.debug("context.getOutputs() = " + context.getOutputs());
        }
        if (this.isDescTableBasic) {
            stmtAuthObject = columnMetaDataPrivilege;
        }
        switch (stmtAuthObject.getOperationScope()) {
            case SERVER: {
                ArrayList<Server> serverHierarchy = new ArrayList<Server>();
                serverHierarchy.add(this.hiveAuthzBinding.getAuthServer());
                inputHierarchy.add(serverHierarchy);
                break;
            }
            case DATABASE: {
                ArrayList<Object> dbHierarchy = new ArrayList<Object>();
                dbHierarchy.add(this.hiveAuthzBinding.getAuthServer());
                dbHierarchy.add(this.currDB);
                inputHierarchy.add(dbHierarchy);
                if (this.currOutDB != null) {
                    ArrayList<Object> outputDbHierarchy = new ArrayList<Object>();
                    outputDbHierarchy.add(this.hiveAuthzBinding.getAuthServer());
                    outputDbHierarchy.add(this.currOutDB);
                    outputHierarchy.add(outputDbHierarchy);
                } else {
                    outputHierarchy.add(dbHierarchy);
                }
                this.getInputHierarchyFromInputs(inputHierarchy, inputs);
                if (this.serdeURI == null) break;
                ArrayList<Object> serdeUriHierarchy = new ArrayList<Object>();
                serdeUriHierarchy.add(this.hiveAuthzBinding.getAuthServer());
                serdeUriHierarchy.add(this.serdeURI);
                outputHierarchy.add(serdeUriHierarchy);
                break;
            }
            case TABLE: {
                ArrayList<Object> externalAuthorizableHierarchy;
                if (this.partitionURI != null) {
                    inputHierarchy.add((List<DBModelAuthorizable>)ImmutableList.of((Object)this.hiveAuthzBinding.getAuthServer(), (Object)this.partitionURI));
                }
                this.getInputHierarchyFromInputs(inputHierarchy, inputs);
                for (WriteEntity writeEntity : outputs) {
                    if (this.filterWriteEntity(writeEntity)) continue;
                    ArrayList<Object> entityHierarchy = new ArrayList<Object>();
                    entityHierarchy.add(this.hiveAuthzBinding.getAuthServer());
                    entityHierarchy.addAll(this.getAuthzHierarchyFromEntity((Entity)writeEntity));
                    outputHierarchy.add(entityHierarchy);
                }
                if (this.currTab != null) {
                    externalAuthorizableHierarchy = new ArrayList<Object>();
                    externalAuthorizableHierarchy.add(this.hiveAuthzBinding.getAuthServer());
                    externalAuthorizableHierarchy.add(this.currDB);
                    externalAuthorizableHierarchy.add(this.currTab);
                    inputHierarchy.add(externalAuthorizableHierarchy);
                }
                if (this.currOutTab != null) {
                    externalAuthorizableHierarchy = new ArrayList();
                    externalAuthorizableHierarchy.add(this.hiveAuthzBinding.getAuthServer());
                    externalAuthorizableHierarchy.add(this.currOutDB);
                    externalAuthorizableHierarchy.add(this.currOutTab);
                    outputHierarchy.add(externalAuthorizableHierarchy);
                }
                if (this.serdeURI == null) break;
                ArrayList serdeUriHierarchy = new ArrayList();
                serdeUriHierarchy.add(this.hiveAuthzBinding.getAuthServer());
                serdeUriHierarchy.add(this.serdeURI);
                outputHierarchy.add(serdeUriHierarchy);
                break;
            }
            case FUNCTION: {
                if (this.udfURIs.isEmpty()) break;
                ArrayList<Object> udfUriHierarchy = new ArrayList<Object>();
                udfUriHierarchy.add(this.hiveAuthzBinding.getAuthServer());
                udfUriHierarchy.addAll(this.udfURIs);
                inputHierarchy.add(udfUriHierarchy);
                for (WriteEntity writeEntity : outputs) {
                    ArrayList<Object> entityHierarchy = new ArrayList<Object>();
                    entityHierarchy.add(this.hiveAuthzBinding.getAuthServer());
                    entityHierarchy.addAll(this.getAuthzHierarchyFromEntity((Entity)writeEntity));
                    outputHierarchy.add(entityHierarchy);
                }
                break;
            }
            case CONNECT: {
                ArrayList<Object> connectHierarchy = new ArrayList<Object>();
                connectHierarchy.add(this.hiveAuthzBinding.getAuthServer());
                Table currTbl = Table.ALL;
                Column currCol = Column.ALL;
                if ("default".equalsIgnoreCase(this.currDB.getName()) && "false".equalsIgnoreCase(this.authzConf.get(HiveAuthzConf.AuthzConfVars.AUTHZ_RESTRICT_DEFAULT_DB.getVar(), "false"))) {
                    this.currDB = Database.ALL;
                    currTbl = Table.SOME;
                }
                connectHierarchy.add(this.currDB);
                connectHierarchy.add(currTbl);
                connectHierarchy.add(currCol);
                inputHierarchy.add(connectHierarchy);
                outputHierarchy.add(connectHierarchy);
                break;
            }
            case COLUMN: {
                for (ReadEntity readEntity : inputs) {
                    if (readEntity.getAccessedColumns() != null && !readEntity.getAccessedColumns().isEmpty()) {
                        this.addColumnHierarchy(inputHierarchy, readEntity);
                        continue;
                    }
                    ArrayList<Object> entityHierarchy = new ArrayList<Object>();
                    entityHierarchy.add(this.hiveAuthzBinding.getAuthServer());
                    entityHierarchy.addAll(this.getAuthzHierarchyFromEntity((Entity)readEntity));
                    entityHierarchy.add(Column.ALL);
                    inputHierarchy.add(entityHierarchy);
                }
                break;
            }
            default: {
                throw new AuthorizationException("Unknown operation scope type " + stmtAuthObject.getOperationScope().toString());
            }
        }
        HiveAuthzBinding binding = null;
        try {
            binding = HiveAuthzBindingHookBase.getHiveBindingWithPrivilegeCache(this.hiveAuthzBinding, context.getUserName());
        }
        catch (SemanticException e) {
            binding = this.hiveAuthzBinding;
        }
        binding.authorize(stmtOperation, stmtAuthObject, this.getCurrentSubject(context), inputHierarchy, outputHierarchy);
    }

    private List<DBModelAuthorizable> getAuthzHierarchyFromEntity(Entity entity) {
        ArrayList<DBModelAuthorizable> objectHierarchy = new ArrayList<DBModelAuthorizable>();
        switch (entity.getType()) {
            case TABLE: {
                objectHierarchy.add((DBModelAuthorizable)new Database(entity.getTable().getDbName()));
                objectHierarchy.add((DBModelAuthorizable)new Table(entity.getTable().getTableName()));
                break;
            }
            case PARTITION: 
            case DUMMYPARTITION: {
                objectHierarchy.add((DBModelAuthorizable)new Database(entity.getPartition().getTable().getDbName()));
                objectHierarchy.add((DBModelAuthorizable)new Table(entity.getPartition().getTable().getTableName()));
                break;
            }
            case DFS_DIR: 
            case LOCAL_DIR: {
                try {
                    objectHierarchy.add((DBModelAuthorizable)HiveAuthzBindingHookBase.parseURI(entity.toString(), entity.getType().equals((Object)Entity.Type.LOCAL_DIR)));
                    break;
                }
                catch (Exception e) {
                    throw new AuthorizationException("Failed to get File URI", (Throwable)e);
                }
            }
            case DATABASE: 
            case FUNCTION: {
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported entity type " + entity.getType().name());
            }
        }
        return objectHierarchy;
    }

    protected void addColumnHierarchy(List<List<DBModelAuthorizable>> inputHierarchy, ReadEntity entity) {
        ArrayList<Object> entityHierarchy = new ArrayList<Object>();
        entityHierarchy.add(this.hiveAuthzBinding.getAuthServer());
        entityHierarchy.addAll(this.getAuthzHierarchyFromEntity((Entity)entity));
        switch (entity.getType()) {
            case TABLE: 
            case PARTITION: {
                List cols = entity.getAccessedColumns();
                for (String col : cols) {
                    ArrayList<Column> colHierarchy = new ArrayList<Column>(entityHierarchy);
                    colHierarchy.add(new Column(col));
                    inputHierarchy.add(colHierarchy);
                }
                break;
            }
            default: {
                inputHierarchy.add(entityHierarchy);
            }
        }
    }

    protected void getInputHierarchyFromInputs(List<List<DBModelAuthorizable>> inputHierarchy, Set<ReadEntity> inputs) {
        for (ReadEntity readEntity : inputs) {
            if (this.isChildTabForView(readEntity) || this.isDummyEntity((Entity)readEntity)) continue;
            if (readEntity.getAccessedColumns() != null && !readEntity.getAccessedColumns().isEmpty()) {
                this.addColumnHierarchy(inputHierarchy, readEntity);
                continue;
            }
            ArrayList<Object> entityHierarchy = new ArrayList<Object>();
            entityHierarchy.add(this.hiveAuthzBinding.getAuthServer());
            entityHierarchy.addAll(this.getAuthzHierarchyFromEntity((Entity)readEntity));
            inputHierarchy.add(entityHierarchy);
        }
    }

    private boolean filterWriteEntity(WriteEntity writeEntity) throws AuthorizationException {
        if (writeEntity.isTempURI()) {
            return true;
        }
        try {
            if (writeEntity.getTyp().equals((Object)Entity.Type.DFS_DIR) || writeEntity.getTyp().equals((Object)Entity.Type.LOCAL_DIR)) {
                HiveConf conf = SessionState.get().getConf();
                String warehouseDir = conf.getVar(HiveConf.ConfVars.METASTOREWAREHOUSE);
                URI scratchURI = new URI(PathUtils.parseDFSURI((String)warehouseDir, (String)conf.getVar(HiveConf.ConfVars.SCRATCHDIR)));
                URI requestURI = new URI(PathUtils.parseDFSURI((String)warehouseDir, (String)writeEntity.getLocation().getPath()));
                LOG.debug("scratchURI = " + scratchURI + ", requestURI = " + requestURI);
                if (PathUtils.impliesURI((URI)scratchURI, (URI)requestURI)) {
                    return true;
                }
                URI localScratchURI = new URI(PathUtils.parseLocalURI((String)conf.getVar(HiveConf.ConfVars.LOCALSCRATCHDIR)));
                URI localRequestURI = new URI(PathUtils.parseLocalURI((String)writeEntity.getLocation().getPath()));
                LOG.debug("localScratchURI = " + localScratchURI + ", localRequestURI = " + localRequestURI);
                if (PathUtils.impliesURI((URI)localScratchURI, (URI)localRequestURI)) {
                    return true;
                }
            }
        }
        catch (Exception e) {
            throw new AuthorizationException("Failed to extract uri details", (Throwable)e);
        }
        return false;
    }

    public static List<String> filterShowTables(HiveAuthzBinding hiveAuthzBinding, List<String> queryResult, HiveOperation operation, String userName, String dbName) throws SemanticException {
        ArrayList<String> filteredResult = new ArrayList<String>();
        Subject subject = new Subject(userName);
        HiveAuthzPrivileges tableMetaDataPrivilege = new HiveAuthzPrivileges.AuthzPrivilegeBuilder().addInputObjectPriviledge(DBModelAuthorizable.AuthorizableType.Column, EnumSet.of(DBModelAction.SELECT, DBModelAction.INSERT)).setOperationScope(HiveAuthzPrivileges.HiveOperationScope.TABLE).setOperationType(HiveAuthzPrivileges.HiveOperationType.INFO).build();
        HiveAuthzBinding hiveBindingWithPrivilegeCache = HiveAuthzBindingHookBase.getHiveBindingWithPrivilegeCache(hiveAuthzBinding, userName);
        for (String tableName : queryResult) {
            Table table = new Table(tableName);
            Database database = new Database(dbName);
            ArrayList<List<DBModelAuthorizable>> inputHierarchy = new ArrayList<List<DBModelAuthorizable>>();
            ArrayList<List<DBModelAuthorizable>> outputHierarchy = new ArrayList<List<DBModelAuthorizable>>();
            ArrayList<Object> externalAuthorizableHierarchy = new ArrayList<Object>();
            externalAuthorizableHierarchy.add(hiveAuthzBinding.getAuthServer());
            externalAuthorizableHierarchy.add(database);
            externalAuthorizableHierarchy.add(table);
            externalAuthorizableHierarchy.add(Column.ALL);
            inputHierarchy.add(externalAuthorizableHierarchy);
            try {
                hiveBindingWithPrivilegeCache.authorize(operation, tableMetaDataPrivilege, subject, inputHierarchy, outputHierarchy);
                filteredResult.add(table.getName());
            }
            catch (AuthorizationException authorizationException) {}
        }
        return filteredResult;
    }

    public static List<FieldSchema> filterShowColumns(HiveAuthzBinding hiveAuthzBinding, List<FieldSchema> cols, HiveOperation operation, String userName, String tableName, String dbName) throws SemanticException {
        ArrayList<FieldSchema> filteredResult = new ArrayList<FieldSchema>();
        Subject subject = new Subject(userName);
        HiveAuthzBinding hiveBindingWithPrivilegeCache = HiveAuthzBindingHookBase.getHiveBindingWithPrivilegeCache(hiveAuthzBinding, userName);
        Database database = new Database(dbName);
        Table table = new Table(tableName);
        for (FieldSchema col : cols) {
            ArrayList<List<DBModelAuthorizable>> inputHierarchy = new ArrayList<List<DBModelAuthorizable>>();
            ArrayList<List<DBModelAuthorizable>> outputHierarchy = new ArrayList<List<DBModelAuthorizable>>();
            ArrayList<Object> externalAuthorizableHierarchy = new ArrayList<Object>();
            externalAuthorizableHierarchy.add(hiveAuthzBinding.getAuthServer());
            externalAuthorizableHierarchy.add(database);
            externalAuthorizableHierarchy.add(table);
            externalAuthorizableHierarchy.add(new Column(col.getName()));
            inputHierarchy.add(externalAuthorizableHierarchy);
            try {
                hiveBindingWithPrivilegeCache.authorize(operation, columnMetaDataPrivilege, subject, inputHierarchy, outputHierarchy);
                filteredResult.add(col);
            }
            catch (AuthorizationException authorizationException) {}
        }
        return filteredResult;
    }

    public static List<String> filterShowDatabases(HiveAuthzBinding hiveAuthzBinding, List<String> queryResult, HiveOperation operation, String userName) throws SemanticException {
        ArrayList<String> filteredResult = new ArrayList<String>();
        Subject subject = new Subject(userName);
        HiveAuthzBinding hiveBindingWithPrivilegeCache = HiveAuthzBindingHookBase.getHiveBindingWithPrivilegeCache(hiveAuthzBinding, userName);
        HiveAuthzPrivileges anyPrivilege = new HiveAuthzPrivileges.AuthzPrivilegeBuilder().addInputObjectPriviledge(DBModelAuthorizable.AuthorizableType.Column, EnumSet.of(DBModelAction.SELECT, DBModelAction.INSERT)).addInputObjectPriviledge(DBModelAuthorizable.AuthorizableType.URI, EnumSet.of(DBModelAction.SELECT)).setOperationScope(HiveAuthzPrivileges.HiveOperationScope.CONNECT).setOperationType(HiveAuthzPrivileges.HiveOperationType.QUERY).build();
        for (String dbName : queryResult) {
            Database database = null;
            if ("default".equalsIgnoreCase(dbName) && "false".equalsIgnoreCase(hiveAuthzBinding.getAuthzConf().get(HiveAuthzConf.AuthzConfVars.AUTHZ_RESTRICT_DEFAULT_DB.getVar(), "false"))) {
                filteredResult.add("default");
                continue;
            }
            database = new Database(dbName);
            ArrayList<List<DBModelAuthorizable>> inputHierarchy = new ArrayList<List<DBModelAuthorizable>>();
            ArrayList<List<DBModelAuthorizable>> outputHierarchy = new ArrayList<List<DBModelAuthorizable>>();
            ArrayList<Object> externalAuthorizableHierarchy = new ArrayList<Object>();
            externalAuthorizableHierarchy.add(hiveAuthzBinding.getAuthServer());
            externalAuthorizableHierarchy.add(database);
            externalAuthorizableHierarchy.add(Table.ALL);
            externalAuthorizableHierarchy.add(Column.ALL);
            inputHierarchy.add(externalAuthorizableHierarchy);
            try {
                hiveBindingWithPrivilegeCache.authorize(operation, anyPrivilege, subject, inputHierarchy, outputHierarchy);
                filteredResult.add(database.getName());
            }
            catch (AuthorizationException authorizationException) {}
        }
        return filteredResult;
    }

    private boolean isChildTabForView(ReadEntity readEntity) {
        if (!readEntity.getType().equals((Object)Entity.Type.TABLE) && !readEntity.getType().equals((Object)Entity.Type.PARTITION)) {
            return false;
        }
        if (readEntity.getParents() != null && readEntity.getParents().size() > 0) {
            for (ReadEntity parentEntity : readEntity.getParents()) {
                if (parentEntity.getType().equals((Object)Entity.Type.TABLE)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static <T extends Hook> List<T> getHooks(String csHooks) throws Exception {
        ArrayList<Hook> hooks = new ArrayList<Hook>();
        if (csHooks.isEmpty()) {
            return hooks;
        }
        for (String hookClass : Splitter.on((String)",").omitEmptyStrings().trimResults().split((CharSequence)csHooks)) {
            try {
                Hook hook = (Hook)Class.forName(hookClass, true, JavaUtils.getClassLoader()).newInstance();
                hooks.add(hook);
            }
            catch (ClassNotFoundException e) {
                LOG.error(hookClass + " Class not found:" + e.getMessage());
                throw e;
            }
        }
        return hooks;
    }

    private boolean isDummyEntity(Entity entity) {
        return entity.isDummy();
    }

    private static HiveAuthzBinding getHiveBindingWithPrivilegeCache(HiveAuthzBinding hiveAuthzBinding, String userName) throws SemanticException {
        AuthorizationProvider authProvider = hiveAuthzBinding.getCurrentAuthProvider();
        ImmutableSet userPrivileges = authProvider.getPolicyEngine().getPrivileges(authProvider.getGroupMapping().getGroups(userName), (Set)Sets.newHashSet((Object[])new String[]{userName}), hiveAuthzBinding.getActiveRoleSet(), new Authorizable[]{hiveAuthzBinding.getAuthServer()});
        SimplePrivilegeCache privilegeCache = new SimplePrivilegeCache((Set)userPrivileges);
        try {
            return new HiveAuthzBinding(HiveAuthzBinding.HiveHook.HiveServer2, hiveAuthzBinding.getHiveConf(), hiveAuthzBinding.getAuthzConf(), (PrivilegeCache)privilegeCache);
        }
        catch (Exception e) {
            LOG.error("Can not create HiveAuthzBinding with privilege cache.");
            throw new SemanticException((Throwable)e);
        }
    }

    private static boolean hasPrefixMatch(List<String> prefixList, String str) {
        for (String prefix : prefixList) {
            if (!str.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    protected void setSerdeURI(String serdeClassName) throws SemanticException {
        if (!this.serdeURIPrivilegesEnabled) {
            return;
        }
        if (!HiveAuthzBindingHookBase.hasPrefixMatch(this.serdeWhiteList, serdeClassName)) {
            try {
                CodeSource serdeSrc = Class.forName(serdeClassName, true, Utilities.getSessionSpecifiedClassLoader()).getProtectionDomain().getCodeSource();
                if (serdeSrc == null) {
                    throw new SemanticException("Could not resolve the jar for Serde class " + serdeClassName);
                }
                String serdeJar = serdeSrc.getLocation().getPath();
                if (serdeJar == null || serdeJar.isEmpty()) {
                    throw new SemanticException("Could not find the jar for Serde class " + serdeClassName + "to validate privileges");
                }
                this.serdeURI = HiveAuthzBindingHookBase.parseURI(serdeSrc.getLocation().toString(), true);
            }
            catch (ClassNotFoundException e) {
                throw new SemanticException("Error retrieving Serde class:" + e.getMessage(), (Throwable)e);
            }
        }
    }

    protected HiveOperation getCurrentHiveStmtOp() {
        SessionState sessState = SessionState.get();
        if (sessState == null) {
            return null;
        }
        return sessState.getHiveOperation();
    }

    protected Subject getCurrentSubject(HiveSemanticAnalyzerHookContext context) {
        return new Subject(context.getUserName());
    }
}

