/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.broker.transaction;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.rocketmq.broker.BrokerController;
import org.apache.rocketmq.common.ServiceThread;
import org.apache.rocketmq.logging.InternalLogger;
import org.apache.rocketmq.logging.InternalLoggerFactory;

public class TransactionalMessageCheckService
extends ServiceThread {
    private static final InternalLogger log = InternalLoggerFactory.getLogger((String)"RocketmqTransaction");
    private BrokerController brokerController;
    private final AtomicBoolean started = new AtomicBoolean(false);

    public TransactionalMessageCheckService(BrokerController brokerController) {
        this.brokerController = brokerController;
    }

    public void start() {
        if (this.started.compareAndSet(false, true)) {
            super.start();
            this.brokerController.getTransactionalMessageService().open();
        }
    }

    public void shutdown(boolean interrupt) {
        if (this.started.compareAndSet(true, false)) {
            super.shutdown(interrupt);
            this.brokerController.getTransactionalMessageService().close();
            this.brokerController.getTransactionalMessageCheckListener().shutDown();
        }
    }

    public String getServiceName() {
        return TransactionalMessageCheckService.class.getSimpleName();
    }

    public void run() {
        log.info("Start transaction check service thread!");
        long checkInterval = this.brokerController.getBrokerConfig().getTransactionCheckInterval();
        while (!this.isStopped()) {
            this.waitForRunning(checkInterval);
        }
        log.info("End transaction check service thread!");
    }

    protected void onWaitEnd() {
        long timeout = this.brokerController.getBrokerConfig().getTransactionTimeOut();
        int checkMax = this.brokerController.getBrokerConfig().getTransactionCheckMax();
        long begin = System.currentTimeMillis();
        log.info("Begin to check prepare message, begin time:{}", (Object)begin);
        this.brokerController.getTransactionalMessageService().check(timeout, checkMax, this.brokerController.getTransactionalMessageCheckListener());
        log.info("End to check prepare message, consumed time:{}", (Object)(System.currentTimeMillis() - begin));
    }
}

