/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.policies.data.stats;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.pulsar.common.policies.data.ConsumerStats;
import org.apache.pulsar.shade.com.fasterxml.jackson.annotation.JsonIgnore;

public class ConsumerStatsImpl
implements ConsumerStats {
    public double msgRateOut;
    public double msgThroughputOut;
    public long bytesOutCounter;
    public long msgOutCounter;
    public double msgRateRedeliver;
    public double messageAckRate;
    public double chunkedMessageRate;
    public String consumerName;
    public int availablePermits;
    public int unackedMessages;
    public int avgMessagesPerEntry;
    public boolean blockedConsumerOnUnackedMsgs;
    public String readPositionWhenJoining;
    @JsonIgnore
    private int addressOffset = -1;
    @JsonIgnore
    private int addressLength;
    @JsonIgnore
    private int connectedSinceOffset = -1;
    @JsonIgnore
    private int connectedSinceLength;
    @JsonIgnore
    private int clientVersionOffset = -1;
    @JsonIgnore
    private int clientVersionLength;
    public long lastAckedTimestamp;
    public long lastConsumedTimestamp;
    public long lastConsumedFlowTimestamp;
    public List<String> keyHashRanges;
    public Map<String, String> metadata;
    @JsonIgnore
    private StringBuilder stringBuffer = new StringBuilder();

    public ConsumerStatsImpl add(ConsumerStatsImpl stats) {
        Objects.requireNonNull(stats);
        this.msgRateOut += stats.msgRateOut;
        this.messageAckRate += stats.messageAckRate;
        this.msgThroughputOut += stats.msgThroughputOut;
        this.bytesOutCounter += stats.bytesOutCounter;
        this.msgOutCounter += stats.msgOutCounter;
        this.msgRateRedeliver += stats.msgRateRedeliver;
        this.availablePermits += stats.availablePermits;
        this.unackedMessages += stats.unackedMessages;
        this.blockedConsumerOnUnackedMsgs = stats.blockedConsumerOnUnackedMsgs;
        this.readPositionWhenJoining = stats.readPositionWhenJoining;
        return this;
    }

    public String getAddress() {
        return this.addressOffset == -1 ? null : this.stringBuffer.substring(this.addressOffset, this.addressOffset + this.addressLength);
    }

    public void setAddress(String address) {
        if (address == null) {
            this.addressOffset = -1;
            return;
        }
        this.addressOffset = this.stringBuffer.length();
        this.addressLength = address.length();
        this.stringBuffer.append(address);
    }

    public String getConnectedSince() {
        return this.connectedSinceOffset == -1 ? null : this.stringBuffer.substring(this.connectedSinceOffset, this.connectedSinceOffset + this.connectedSinceLength);
    }

    public void setConnectedSince(String connectedSince) {
        if (connectedSince == null) {
            this.connectedSinceOffset = -1;
            return;
        }
        this.connectedSinceOffset = this.stringBuffer.length();
        this.connectedSinceLength = connectedSince.length();
        this.stringBuffer.append(connectedSince);
    }

    public String getClientVersion() {
        return this.clientVersionOffset == -1 ? null : this.stringBuffer.substring(this.clientVersionOffset, this.clientVersionOffset + this.clientVersionLength);
    }

    public void setClientVersion(String clientVersion) {
        if (clientVersion == null) {
            this.clientVersionOffset = -1;
            return;
        }
        this.clientVersionOffset = this.stringBuffer.length();
        this.clientVersionLength = clientVersion.length();
        this.stringBuffer.append(clientVersion);
    }

    public String getReadPositionWhenJoining() {
        return this.readPositionWhenJoining;
    }

    public double getMsgRateOut() {
        return this.msgRateOut;
    }

    public double getMsgThroughputOut() {
        return this.msgThroughputOut;
    }

    public long getBytesOutCounter() {
        return this.bytesOutCounter;
    }

    public long getMsgOutCounter() {
        return this.msgOutCounter;
    }

    public double getMsgRateRedeliver() {
        return this.msgRateRedeliver;
    }

    public double getMessageAckRate() {
        return this.messageAckRate;
    }

    public double getChunkedMessageRate() {
        return this.chunkedMessageRate;
    }

    public String getConsumerName() {
        return this.consumerName;
    }

    public int getAvailablePermits() {
        return this.availablePermits;
    }

    public int getUnackedMessages() {
        return this.unackedMessages;
    }

    public int getAvgMessagesPerEntry() {
        return this.avgMessagesPerEntry;
    }

    public boolean isBlockedConsumerOnUnackedMsgs() {
        return this.blockedConsumerOnUnackedMsgs;
    }

    public int getAddressOffset() {
        return this.addressOffset;
    }

    public int getAddressLength() {
        return this.addressLength;
    }

    public int getConnectedSinceOffset() {
        return this.connectedSinceOffset;
    }

    public int getConnectedSinceLength() {
        return this.connectedSinceLength;
    }

    public int getClientVersionOffset() {
        return this.clientVersionOffset;
    }

    public int getClientVersionLength() {
        return this.clientVersionLength;
    }

    public long getLastAckedTimestamp() {
        return this.lastAckedTimestamp;
    }

    public long getLastConsumedTimestamp() {
        return this.lastConsumedTimestamp;
    }

    public long getLastConsumedFlowTimestamp() {
        return this.lastConsumedFlowTimestamp;
    }

    public List<String> getKeyHashRanges() {
        return this.keyHashRanges;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public StringBuilder getStringBuffer() {
        return this.stringBuffer;
    }

    public void setMsgRateOut(double msgRateOut) {
        this.msgRateOut = msgRateOut;
    }

    public void setMsgThroughputOut(double msgThroughputOut) {
        this.msgThroughputOut = msgThroughputOut;
    }

    public void setBytesOutCounter(long bytesOutCounter) {
        this.bytesOutCounter = bytesOutCounter;
    }

    public void setMsgOutCounter(long msgOutCounter) {
        this.msgOutCounter = msgOutCounter;
    }

    public void setMsgRateRedeliver(double msgRateRedeliver) {
        this.msgRateRedeliver = msgRateRedeliver;
    }

    public void setMessageAckRate(double messageAckRate) {
        this.messageAckRate = messageAckRate;
    }

    public void setChunkedMessageRate(double chunkedMessageRate) {
        this.chunkedMessageRate = chunkedMessageRate;
    }

    public void setConsumerName(String consumerName) {
        this.consumerName = consumerName;
    }

    public void setAvailablePermits(int availablePermits) {
        this.availablePermits = availablePermits;
    }

    public void setUnackedMessages(int unackedMessages) {
        this.unackedMessages = unackedMessages;
    }

    public void setAvgMessagesPerEntry(int avgMessagesPerEntry) {
        this.avgMessagesPerEntry = avgMessagesPerEntry;
    }

    public void setBlockedConsumerOnUnackedMsgs(boolean blockedConsumerOnUnackedMsgs) {
        this.blockedConsumerOnUnackedMsgs = blockedConsumerOnUnackedMsgs;
    }

    public void setReadPositionWhenJoining(String readPositionWhenJoining) {
        this.readPositionWhenJoining = readPositionWhenJoining;
    }

    @JsonIgnore
    public void setAddressOffset(int addressOffset) {
        this.addressOffset = addressOffset;
    }

    @JsonIgnore
    public void setAddressLength(int addressLength) {
        this.addressLength = addressLength;
    }

    @JsonIgnore
    public void setConnectedSinceOffset(int connectedSinceOffset) {
        this.connectedSinceOffset = connectedSinceOffset;
    }

    @JsonIgnore
    public void setConnectedSinceLength(int connectedSinceLength) {
        this.connectedSinceLength = connectedSinceLength;
    }

    @JsonIgnore
    public void setClientVersionOffset(int clientVersionOffset) {
        this.clientVersionOffset = clientVersionOffset;
    }

    @JsonIgnore
    public void setClientVersionLength(int clientVersionLength) {
        this.clientVersionLength = clientVersionLength;
    }

    public void setLastAckedTimestamp(long lastAckedTimestamp) {
        this.lastAckedTimestamp = lastAckedTimestamp;
    }

    public void setLastConsumedTimestamp(long lastConsumedTimestamp) {
        this.lastConsumedTimestamp = lastConsumedTimestamp;
    }

    public void setLastConsumedFlowTimestamp(long lastConsumedFlowTimestamp) {
        this.lastConsumedFlowTimestamp = lastConsumedFlowTimestamp;
    }

    public void setKeyHashRanges(List<String> keyHashRanges) {
        this.keyHashRanges = keyHashRanges;
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    @JsonIgnore
    public void setStringBuffer(StringBuilder stringBuffer) {
        this.stringBuffer = stringBuffer;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConsumerStatsImpl)) {
            return false;
        }
        ConsumerStatsImpl other = (ConsumerStatsImpl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getMsgRateOut(), other.getMsgRateOut()) != 0) {
            return false;
        }
        if (Double.compare(this.getMsgThroughputOut(), other.getMsgThroughputOut()) != 0) {
            return false;
        }
        if (this.getBytesOutCounter() != other.getBytesOutCounter()) {
            return false;
        }
        if (this.getMsgOutCounter() != other.getMsgOutCounter()) {
            return false;
        }
        if (Double.compare(this.getMsgRateRedeliver(), other.getMsgRateRedeliver()) != 0) {
            return false;
        }
        if (Double.compare(this.getMessageAckRate(), other.getMessageAckRate()) != 0) {
            return false;
        }
        if (Double.compare(this.getChunkedMessageRate(), other.getChunkedMessageRate()) != 0) {
            return false;
        }
        if (this.getAvailablePermits() != other.getAvailablePermits()) {
            return false;
        }
        if (this.getUnackedMessages() != other.getUnackedMessages()) {
            return false;
        }
        if (this.getAvgMessagesPerEntry() != other.getAvgMessagesPerEntry()) {
            return false;
        }
        if (this.isBlockedConsumerOnUnackedMsgs() != other.isBlockedConsumerOnUnackedMsgs()) {
            return false;
        }
        if (this.getAddressOffset() != other.getAddressOffset()) {
            return false;
        }
        if (this.getAddressLength() != other.getAddressLength()) {
            return false;
        }
        if (this.getConnectedSinceOffset() != other.getConnectedSinceOffset()) {
            return false;
        }
        if (this.getConnectedSinceLength() != other.getConnectedSinceLength()) {
            return false;
        }
        if (this.getClientVersionOffset() != other.getClientVersionOffset()) {
            return false;
        }
        if (this.getClientVersionLength() != other.getClientVersionLength()) {
            return false;
        }
        if (this.getLastAckedTimestamp() != other.getLastAckedTimestamp()) {
            return false;
        }
        if (this.getLastConsumedTimestamp() != other.getLastConsumedTimestamp()) {
            return false;
        }
        if (this.getLastConsumedFlowTimestamp() != other.getLastConsumedFlowTimestamp()) {
            return false;
        }
        String this$consumerName = this.getConsumerName();
        String other$consumerName = other.getConsumerName();
        if (this$consumerName == null ? other$consumerName != null : !this$consumerName.equals(other$consumerName)) {
            return false;
        }
        String this$readPositionWhenJoining = this.getReadPositionWhenJoining();
        String other$readPositionWhenJoining = other.getReadPositionWhenJoining();
        if (this$readPositionWhenJoining == null ? other$readPositionWhenJoining != null : !this$readPositionWhenJoining.equals(other$readPositionWhenJoining)) {
            return false;
        }
        List<String> this$keyHashRanges = this.getKeyHashRanges();
        List<String> other$keyHashRanges = other.getKeyHashRanges();
        if (this$keyHashRanges == null ? other$keyHashRanges != null : !((Object)this$keyHashRanges).equals(other$keyHashRanges)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        StringBuilder this$stringBuffer = this.getStringBuffer();
        StringBuilder other$stringBuffer = other.getStringBuffer();
        return !(this$stringBuffer == null ? other$stringBuffer != null : !this$stringBuffer.equals(other$stringBuffer));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ConsumerStatsImpl;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $msgRateOut = Double.doubleToLongBits(this.getMsgRateOut());
        result = result * 59 + (int)($msgRateOut >>> 32 ^ $msgRateOut);
        long $msgThroughputOut = Double.doubleToLongBits(this.getMsgThroughputOut());
        result = result * 59 + (int)($msgThroughputOut >>> 32 ^ $msgThroughputOut);
        long $bytesOutCounter = this.getBytesOutCounter();
        result = result * 59 + (int)($bytesOutCounter >>> 32 ^ $bytesOutCounter);
        long $msgOutCounter = this.getMsgOutCounter();
        result = result * 59 + (int)($msgOutCounter >>> 32 ^ $msgOutCounter);
        long $msgRateRedeliver = Double.doubleToLongBits(this.getMsgRateRedeliver());
        result = result * 59 + (int)($msgRateRedeliver >>> 32 ^ $msgRateRedeliver);
        long $messageAckRate = Double.doubleToLongBits(this.getMessageAckRate());
        result = result * 59 + (int)($messageAckRate >>> 32 ^ $messageAckRate);
        long $chunkedMessageRate = Double.doubleToLongBits(this.getChunkedMessageRate());
        result = result * 59 + (int)($chunkedMessageRate >>> 32 ^ $chunkedMessageRate);
        result = result * 59 + this.getAvailablePermits();
        result = result * 59 + this.getUnackedMessages();
        result = result * 59 + this.getAvgMessagesPerEntry();
        result = result * 59 + (this.isBlockedConsumerOnUnackedMsgs() ? 79 : 97);
        result = result * 59 + this.getAddressOffset();
        result = result * 59 + this.getAddressLength();
        result = result * 59 + this.getConnectedSinceOffset();
        result = result * 59 + this.getConnectedSinceLength();
        result = result * 59 + this.getClientVersionOffset();
        result = result * 59 + this.getClientVersionLength();
        long $lastAckedTimestamp = this.getLastAckedTimestamp();
        result = result * 59 + (int)($lastAckedTimestamp >>> 32 ^ $lastAckedTimestamp);
        long $lastConsumedTimestamp = this.getLastConsumedTimestamp();
        result = result * 59 + (int)($lastConsumedTimestamp >>> 32 ^ $lastConsumedTimestamp);
        long $lastConsumedFlowTimestamp = this.getLastConsumedFlowTimestamp();
        result = result * 59 + (int)($lastConsumedFlowTimestamp >>> 32 ^ $lastConsumedFlowTimestamp);
        String $consumerName = this.getConsumerName();
        result = result * 59 + ($consumerName == null ? 43 : $consumerName.hashCode());
        String $readPositionWhenJoining = this.getReadPositionWhenJoining();
        result = result * 59 + ($readPositionWhenJoining == null ? 43 : $readPositionWhenJoining.hashCode());
        List<String> $keyHashRanges = this.getKeyHashRanges();
        result = result * 59 + ($keyHashRanges == null ? 43 : ((Object)$keyHashRanges).hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        StringBuilder $stringBuffer = this.getStringBuffer();
        result = result * 59 + ($stringBuffer == null ? 43 : $stringBuffer.hashCode());
        return result;
    }

    public String toString() {
        return "ConsumerStatsImpl(msgRateOut=" + this.getMsgRateOut() + ", msgThroughputOut=" + this.getMsgThroughputOut() + ", bytesOutCounter=" + this.getBytesOutCounter() + ", msgOutCounter=" + this.getMsgOutCounter() + ", msgRateRedeliver=" + this.getMsgRateRedeliver() + ", messageAckRate=" + this.getMessageAckRate() + ", chunkedMessageRate=" + this.getChunkedMessageRate() + ", consumerName=" + this.getConsumerName() + ", availablePermits=" + this.getAvailablePermits() + ", unackedMessages=" + this.getUnackedMessages() + ", avgMessagesPerEntry=" + this.getAvgMessagesPerEntry() + ", blockedConsumerOnUnackedMsgs=" + this.isBlockedConsumerOnUnackedMsgs() + ", readPositionWhenJoining=" + this.getReadPositionWhenJoining() + ", addressOffset=" + this.getAddressOffset() + ", addressLength=" + this.getAddressLength() + ", connectedSinceOffset=" + this.getConnectedSinceOffset() + ", connectedSinceLength=" + this.getConnectedSinceLength() + ", clientVersionOffset=" + this.getClientVersionOffset() + ", clientVersionLength=" + this.getClientVersionLength() + ", lastAckedTimestamp=" + this.getLastAckedTimestamp() + ", lastConsumedTimestamp=" + this.getLastConsumedTimestamp() + ", lastConsumedFlowTimestamp=" + this.getLastConsumedFlowTimestamp() + ", keyHashRanges=" + this.getKeyHashRanges() + ", metadata=" + this.getMetadata() + ", stringBuffer=" + this.getStringBuffer() + ")";
    }
}

