/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.values;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.plc4x.java.api.exceptions.PlcInvalidFieldException;
import org.apache.plc4x.java.spi.values.PlcIECValue;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, property="className")
public class PlcUSINT
extends PlcIECValue<Short> {
    static Short minValue = 0;
    static Short maxValue = 255;

    public static PlcUSINT of(Object value) {
        if (value instanceof Boolean) {
            return new PlcUSINT((Boolean)value);
        }
        if (value instanceof Byte) {
            return new PlcUSINT((Byte)value);
        }
        if (value instanceof Short) {
            return new PlcUSINT((Short)value);
        }
        if (value instanceof Integer) {
            return new PlcUSINT((Integer)value);
        }
        if (value instanceof Long) {
            return new PlcUSINT((Long)value);
        }
        if (value instanceof Float) {
            return new PlcUSINT((Float)value);
        }
        if (value instanceof Double) {
            return new PlcUSINT((Double)value);
        }
        if (value instanceof BigInteger) {
            return new PlcUSINT((BigInteger)value);
        }
        if (value instanceof BigDecimal) {
            return new PlcUSINT((BigDecimal)value);
        }
        return new PlcUSINT((String)value);
    }

    public PlcUSINT(Boolean value) {
        this.value = value != false ? Short.valueOf((short)1) : Short.valueOf((short)0);
        this.isNullable = false;
    }

    public PlcUSINT(Byte value) {
        if (value < minValue || value > maxValue) {
            throw new PlcInvalidFieldException("Value of type " + value + " is out of range " + minValue + " - " + maxValue + " for a " + this.getClass().getSimpleName() + " Value");
        }
        this.value = value.shortValue();
        this.isNullable = false;
    }

    public PlcUSINT(Short value) {
        if (value < minValue || value > maxValue) {
            throw new PlcInvalidFieldException("Value of type " + value + " is out of range " + minValue + " - " + maxValue + " for a " + this.getClass().getSimpleName() + " Value");
        }
        this.value = value;
        this.isNullable = false;
    }

    public PlcUSINT(Integer value) {
        if (value < minValue || value > maxValue) {
            throw new PlcInvalidFieldException("Value of type " + value + " is out of range " + minValue + " - " + maxValue + " for a " + this.getClass().getSimpleName() + " Value");
        }
        this.value = value.shortValue();
        this.isNullable = false;
    }

    public PlcUSINT(Long value) {
        if (value < (long)minValue.shortValue() || value > (long)maxValue.shortValue()) {
            throw new PlcInvalidFieldException("Value of type " + value + " is out of range " + minValue + " - " + maxValue + " for a " + this.getClass().getSimpleName() + " Value");
        }
        this.value = value.shortValue();
        this.isNullable = false;
    }

    public PlcUSINT(Float value) {
        if (!(value.floatValue() >= (float)minValue.shortValue()) || !(value.floatValue() <= (float)maxValue.shortValue()) || value.floatValue() % 1.0f != 0.0f) {
            throw new PlcInvalidFieldException("Value of type " + value + " is out of range " + minValue + " - " + maxValue + " or has decimal places for a " + this.getClass().getSimpleName() + " Value");
        }
        this.value = value.shortValue();
        this.isNullable = false;
    }

    public PlcUSINT(Double value) {
        if (!(value >= (double)minValue.shortValue()) || !(value <= (double)maxValue.shortValue()) || value % 1.0 != 0.0) {
            throw new PlcInvalidFieldException("Value of type " + value + " is out of range " + minValue + " - " + maxValue + " or has decimal places for a " + this.getClass().getSimpleName() + " Value");
        }
        this.value = value.shortValue();
        this.isNullable = false;
    }

    public PlcUSINT(BigInteger value) {
        if (value.compareTo(BigInteger.valueOf(minValue.shortValue())) < 0 || value.compareTo(BigInteger.valueOf(maxValue.shortValue())) > 0) {
            throw new PlcInvalidFieldException("Value of type " + value + " is out of range " + minValue + " - " + maxValue + " for a " + this.getClass().getSimpleName() + " Value");
        }
        this.value = value.shortValue();
        this.isNullable = true;
    }

    public PlcUSINT(BigDecimal value) {
        if (value.compareTo(BigDecimal.valueOf(minValue.shortValue())) < 0 || value.compareTo(BigDecimal.valueOf(maxValue.shortValue())) > 0 || value.scale() > 0) {
            throw new PlcInvalidFieldException("Value of type " + value + " is out of range " + minValue + " - " + maxValue + " for a " + this.getClass().getSimpleName() + " Value");
        }
        this.value = value.shortValue();
        this.isNullable = true;
    }

    public PlcUSINT(String value) {
        try {
            short val = Short.parseShort(value.trim());
            if (val < minValue || val > maxValue) {
                throw new PlcInvalidFieldException("Value of type " + value + " is out of range " + minValue + " - " + maxValue + " for a " + this.getClass().getSimpleName() + " Value");
            }
            this.value = val;
            this.isNullable = false;
        }
        catch (Exception e) {
            throw new PlcInvalidFieldException("Value of type " + value + " is out of range " + minValue + " - " + maxValue + " for a " + this.getClass().getSimpleName() + " Value");
        }
    }

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    public PlcUSINT(@JsonProperty(value="value") short value) {
        if (value < minValue || value > maxValue) {
            throw new PlcInvalidFieldException("Value of type " + value + " is out of range " + minValue + " - " + maxValue + " for a " + this.getClass().getSimpleName() + " Value");
        }
        this.value = value;
        this.isNullable = false;
    }

    @Override
    @JsonIgnore
    public boolean isBoolean() {
        return true;
    }

    @Override
    @JsonIgnore
    public boolean getBoolean() {
        return this.value != null && !((Short)this.value).equals(0);
    }

    @Override
    @JsonIgnore
    public boolean isByte() {
        return this.value != null && (Short)this.value <= 127 && (Short)this.value >= -128;
    }

    @Override
    @JsonIgnore
    public byte getByte() {
        return ((Short)this.value).byteValue();
    }

    @Override
    @JsonIgnore
    public boolean isShort() {
        return true;
    }

    @Override
    @JsonIgnore
    public short getShort() {
        return (Short)this.value;
    }

    @Override
    @JsonIgnore
    public boolean isInteger() {
        return true;
    }

    @Override
    @JsonIgnore
    public int getInteger() {
        return ((Short)this.value).intValue();
    }

    @Override
    @JsonIgnore
    public boolean isLong() {
        return true;
    }

    @Override
    @JsonIgnore
    public long getLong() {
        return ((Short)this.value).longValue();
    }

    @Override
    @JsonIgnore
    public boolean isBigInteger() {
        return true;
    }

    @Override
    @JsonIgnore
    public BigInteger getBigInteger() {
        return BigInteger.valueOf(this.getLong());
    }

    @Override
    @JsonIgnore
    public boolean isFloat() {
        return true;
    }

    @Override
    @JsonIgnore
    public float getFloat() {
        return ((Short)this.value).floatValue();
    }

    @Override
    @JsonIgnore
    public boolean isDouble() {
        return true;
    }

    @Override
    @JsonIgnore
    public double getDouble() {
        return ((Short)this.value).doubleValue();
    }

    @Override
    @JsonIgnore
    public boolean isBigDecimal() {
        return true;
    }

    @Override
    @JsonIgnore
    public BigDecimal getBigDecimal() {
        return BigDecimal.valueOf(this.getFloat());
    }

    @Override
    @JsonIgnore
    public boolean isString() {
        return true;
    }

    @Override
    @JsonIgnore
    public String getString() {
        return this.toString();
    }

    @JsonIgnore
    public String toString() {
        return Short.toString((Short)this.value);
    }

    @JsonIgnore
    public byte[] getBytes() {
        byte[] bytes = new byte[]{(byte)((Short)this.value & 0xFF)};
        return bytes;
    }
}

