/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.values;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.spi.values.PlcSimpleValue;
import org.w3c.dom.Element;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, property="className")
public class PlcTIME
extends PlcSimpleValue<Duration> {
    public static PlcTIME of(Object value) {
        if (value instanceof Duration) {
            return new PlcTIME((Duration)value);
        }
        if (value instanceof Integer) {
            return new PlcTIME(Duration.of((Long)value, ChronoUnit.MILLIS));
        }
        if (value instanceof Long) {
            return new PlcTIME(Duration.of((Long)value, ChronoUnit.MILLIS));
        }
        throw new PlcRuntimeException("Invalid value type");
    }

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    public PlcTIME(@JsonProperty(value="value") Duration value) {
        super(value, true);
    }

    public PlcTIME(@JsonProperty(value="value") Integer value) {
        super(Duration.of(value.intValue(), ChronoUnit.MILLIS), true);
    }

    public PlcTIME(@JsonProperty(value="value") Long value) {
        super(Duration.of(value, ChronoUnit.MILLIS), true);
    }

    @Override
    @JsonIgnore
    public boolean isString() {
        return true;
    }

    @Override
    public boolean isDuration() {
        return true;
    }

    @Override
    public Duration getDuration() {
        return (Duration)this.value;
    }

    @Override
    @JsonIgnore
    public String getString() {
        return ((Duration)this.value).toString();
    }

    @JsonIgnore
    public String toString() {
        return String.valueOf(this.value);
    }

    @Override
    public void xmlSerialize(Element parent) {
    }
}

